/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.apps.cdviewer.tools.shrinker;

import com.ge.med.cse.apps.cdviewer.tools.shrinker.AntFileSetCreator;
import com.ge.med.cse.apps.cdviewer.tools.shrinker.ResourceFileSniffer;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.lang.instrument.Instrumentation;

public class ClassLoaderInstrument {
    private static Instrumentation delegate = null;
    private static String agentArgs = null;
    private static BufferedWriter writer = null;
    public static final File toDumpInfo = new File(System.getProperty("user.home") + File.separatorChar + "LoadedResources.txt");

    public static void premain(String args, Instrumentation inst) {
        delegate = inst;
        agentArgs = args;
        try {
            writer = new BufferedWriter(new FileWriter(toDumpInfo));
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    ClassLoaderInstrument.generateInfoFile();
                    try {
                        writer.close();
                        AntFileSetCreator.createAntFileSet();
                    }
                    catch (Exception e2) {
                        e2.printStackTrace();
                    }
                }
            });
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        ResourceFileSniffer.startSniff();
    }

    protected static void generateInfoFile() {
        try {
            Class[] loadedClasses = delegate.getAllLoadedClasses();
            for (int i2 = 0; i2 < loadedClasses.length; ++i2) {
                if (!ClassLoaderInstrument.isValidClass(loadedClasses[i2].getName())) continue;
                ClassLoaderInstrument.writeLine(loadedClasses[i2].getName().trim());
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    protected static void writeLine(String strToWrite) {
        try {
            writer.write(strToWrite);
            writer.newLine();
            writer.flush();
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    protected static boolean isValidClass(String clsName) {
        return !clsName.startsWith("java") && !clsName.startsWith("sun") && !clsName.endsWith(";") && !clsName.startsWith("[");
    }
}

