/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.apps.cdviewer.treetable;

import com.ge.med.cse.apps.cdviewer.DataSelector;
import com.ge.med.cse.apps.cdviewer.MVAppConstants;
import com.ge.med.cse.apps.cdviewer.treetable.TreeTableCellRenderer;
import com.ge.med.ptk.laf.CuiTreeCellRenderer;
import java.awt.Component;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JTree;

public class MvTreeCellRenderer
extends CuiTreeCellRenderer {
    private DataSelector.MvTreeNode tnode = null;
    public static ImageIcon closePatIcon;
    public static ImageIcon openPatIcon;
    public static ImageIcon closeExamIcon;
    public static ImageIcon openExamIcon;
    public static ImageIcon closeSeriesIcon;
    public static ImageIcon openSeriesIcon;
    public static ImageIcon leafSeriesIcon;

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        if (value instanceof DataSelector.MvTreeNode) {
            this.tnode = (DataSelector.MvTreeNode)value;
            String type = this.tnode.getNodeType();
            super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            if (type.equals("patient")) {
                this.setToolTipText(MVAppConstants.I18N.PATIENT_ + this.tnode.getUserObject().toString());
            } else if (type.equals("study")) {
                this.setToolTipText(MVAppConstants.I18N.STUDY_ + this.tnode.getUserObject().toString());
            } else if (type.equals("series")) {
                this.setToolTipText(MVAppConstants.I18N.SERIES_ + this.tnode.getUserObject().toString());
            }
        }
        return this;
    }

    @Override
    public Icon getLeafIcon() {
        String type = this.tnode.getNodeType();
        if (type.equals("series")) {
            return leafSeriesIcon;
        }
        return super.getLeafIcon();
    }

    @Override
    public Icon getClosedIcon() {
        String type = this.tnode.getNodeType();
        if (type.equals("patient")) {
            return closePatIcon;
        }
        if (type.equals("study")) {
            return closeExamIcon;
        }
        if (type.equals("series")) {
            return closeSeriesIcon;
        }
        return super.getClosedIcon();
    }

    @Override
    public Icon getOpenIcon() {
        String type = this.tnode.getNodeType();
        if (type.equals("patient")) {
            return openPatIcon;
        }
        if (type.equals("study")) {
            return openExamIcon;
        }
        if (type.equals("series")) {
            return openSeriesIcon;
        }
        return super.getOpenIcon();
    }

    static {
        try {
            closePatIcon = new ImageIcon(TreeTableCellRenderer.class.getResource("icons/ico-patient-closed.png"));
            openPatIcon = new ImageIcon(TreeTableCellRenderer.class.getResource("icons/ico-patient-open.png"));
            closeExamIcon = new ImageIcon(TreeTableCellRenderer.class.getResource("icons/ico-exam-closed.png"));
            openExamIcon = new ImageIcon(TreeTableCellRenderer.class.getResource("icons/ico-exam-open.png"));
            closeSeriesIcon = new ImageIcon(TreeTableCellRenderer.class.getResource("icons/ico-series-closed.png"));
            openSeriesIcon = new ImageIcon(TreeTableCellRenderer.class.getResource("icons/ico-series-open.png"));
            leafSeriesIcon = new ImageIcon(TreeTableCellRenderer.class.getResource("icons/ico-series-leaf.png"));
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }
}

