/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.action;

import com.ge.med.cse.cvf.base.BaseAction;
import com.ge.med.cse.cvf.crossref.XPCrossRefLinesManager;
import com.ge.med.cse.cvf.log.UserMessageLevel;
import com.ge.med.cse.cvf.util.CvUtils;
import com.ge.med.terra.xpv.base.XPscreen;
import java.awt.event.ActionEvent;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class XpCrossReferenceAddAction
extends BaseAction {
    @Override
    protected String getName() {
        return "XP_CROSS_REFERENCE_ADD";
    }

    @Override
    public void actionPerformed(ActionEvent e2) {
        try {
            if (!this.addCrossReferenceLines()) {
                this.getLogger().log(Level.WARNING, "Unable to add the cross reference lines.");
            }
        }
        catch (Exception exp) {
            this.getLogger().log(Level.WARNING, "Exception during adding cross reference lines, stack trace {0}", new Object[]{exp});
        }
    }

    private boolean addCrossReferenceLines() {
        String[] params = this.getParams();
        this.setParams(null);
        if (params != null && params.length > 0) {
            if (this.getCapable() != null && this.getCapable() instanceof XPscreen) {
                XPCrossRefLinesManager.setScreen((XPscreen)this.getCapable());
            }
            int seriesNo = 0;
            switch (params.length) {
                case 1: {
                    String param = params[0];
                    String regexpr = "s?(\\d+)(\\/i?(\\d+))?";
                    if (!param.matches(regexpr)) {
                        this.getLogger().log(Level.INFO, "Regular expression not matched.");
                        this.getLogger().log(UserMessageLevel.USER_MSG, CvUtils.getResourceBundle().getString("INV_PARAM"));
                        return false;
                    }
                    Pattern p2 = Pattern.compile(regexpr, 2);
                    Matcher m2 = p2.matcher(param);
                    int imageNo = -1;
                    if (m2.matches()) {
                        try {
                            String series = m2.group(1);
                            seriesNo = Integer.parseInt(series);
                            if (m2.group(3) != null) {
                                String image = m2.group(3);
                                imageNo = Integer.parseInt(image);
                            }
                            return XPCrossRefLinesManager.putCrossReferenceLines(seriesNo, imageNo, imageNo, 1, false);
                        }
                        catch (Exception ex) {
                            this.getLogger().log(Level.INFO, "Series/Image no. is not integer, stack trace {0}", new Object[]{ex});
                            this.getLogger().log(UserMessageLevel.USER_MSG, CvUtils.getResourceBundle().getString("INV_PARAM"));
                            return false;
                        }
                    }
                }
                case 2: {
                    try {
                        if (params[0].startsWith("s")) {
                            String[] val = params[0].split("s");
                            seriesNo = Integer.parseInt(val[1]);
                        } else {
                            seriesNo = Integer.parseInt(params[0]);
                        }
                        if (params[1].startsWith(":")) {
                            String interval = params[1];
                            String[] val = interval.split(":");
                            int n2 = Integer.parseInt(val[1]);
                            return XPCrossRefLinesManager.putCrossReferenceLines(seriesNo, -1, -1, n2, false);
                        }
                        if (params[1].indexOf("-") != -1) {
                            String range = params[1];
                            int from = 0;
                            int to = 0;
                            String[] val = range.split("-");
                            from = val[0].equals("%") || val[0].equals("") ? -1 : Integer.parseInt(val[0]);
                            to = val[1].equals("%") || val[1].equals("") ? -1 : Integer.parseInt(val[1]);
                            return XPCrossRefLinesManager.putCrossReferenceLines(seriesNo, from, to, 1, false);
                        }
                        if (params[1].equalsIgnoreCase("extrema")) {
                            return XPCrossRefLinesManager.putCrossReferenceLines(seriesNo, -1, -1, -1, false);
                        }
                        int imgNo = -1;
                        if (params[1].startsWith("i")) {
                            String[] val = params[1].split("i");
                            imgNo = Integer.parseInt(val[1]);
                        } else {
                            imgNo = Integer.parseInt(params[1]);
                        }
                        return XPCrossRefLinesManager.putCrossReferenceLines(seriesNo, imgNo, imgNo, 1, false);
                    }
                    catch (NumberFormatException nfe) {
                        this.getLogger().log(Level.INFO, "Series/Image no. is not integer, stack trace {0}", new Object[]{nfe});
                        this.getLogger().log(UserMessageLevel.USER_MSG, CvUtils.getResourceBundle().getString("INV_PARAM"));
                        return false;
                    }
                }
                case 3: {
                    try {
                        String range = params[1];
                        int from = 0;
                        int to = 0;
                        seriesNo = Integer.parseInt(params[0]);
                        String[] val = range.split("-");
                        from = val[0].equals("%") || val[0].equals("") ? -1 : Integer.parseInt(val[0]);
                        to = val[1].equals("%") || val[1].equals("") || val[1].equalsIgnoreCase("extrema") ? -1 : Integer.parseInt(val[1]);
                        String interval = params[2];
                        if (interval.indexOf(":") == -1) {
                            this.getLogger().log(Level.INFO, "Invalid format.");
                            this.getLogger().log(UserMessageLevel.USER_MSG, CvUtils.getResourceBundle().getString("INV_PARAM"));
                            return false;
                        }
                        String[] val1 = interval.split(":");
                        int n3 = Integer.parseInt(val1[1]);
                        return XPCrossRefLinesManager.putCrossReferenceLines(seriesNo, from, to, n3, false);
                    }
                    catch (NumberFormatException nfe) {
                        this.getLogger().log(Level.INFO, "Series/Image no. is not integer, stack trace {0}", new Object[]{nfe});
                        this.getLogger().log(UserMessageLevel.USER_MSG, CvUtils.getResourceBundle().getString("INV_PARAM"));
                        return false;
                    }
                }
            }
            return false;
        }
        this.getLogger().log(UserMessageLevel.USER_MSG, CvUtils.getResourceBundle().getString("INSUFF_PARAM"));
        return false;
    }
}

