/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.action;

import com.ge.med.cse.cvf.base.BaseAction;
import com.ge.med.cse.cvf.util.CvTransferableGO;
import com.ge.med.idc.Selectable;
import com.ge.med.terra.jami.RoiActor;
import com.ge.med.terra.jami.XpUserAnnotationModel;
import com.ge.med.terra.jami.capable.ROICapable;
import com.ge.med.terra.jami.capable.Replicable;
import com.ge.med.terra.jami.capable.UserAnnoCapable;
import com.ge.med.terra.xpv.cuiPanels.TransactionLogName;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import javax.swing.SwingUtilities;

public abstract class XpCutCopyKeyAction
extends BaseAction {
    protected boolean isCutOperation = false;
    protected static TransactionLogName copytid = new TransactionLogName("XpROICopyAction");
    protected static TransactionLogName cuttid = new TransactionLogName("XpROICutAction");

    protected XpCutCopyKeyAction(boolean isCutOp) {
        this.isCutOperation = isCutOp;
    }

    @Override
    public void actionPerformed(ActionEvent e2) {
        int i2;
        this.getLogger().log(Level.INFO, "{0} begin XpCutCopyOperation ", this.getTID());
        final ROICapable roiCap = this.getROICapable();
        final UserAnnoCapable uaCap = this.getUserAnnotationCapable();
        List rois = roiCap.getRois();
        List uas = uaCap.getUserAnnos();
        ArrayList<Selectable> selGOs = new ArrayList<Selectable>();
        for (i2 = 0; i2 < rois.size(); ++i2) {
            final RoiActor actor = (RoiActor)rois.get(i2);
            if (!actor.isSelected() || !(actor instanceof Replicable)) continue;
            selGOs.add(actor);
            if (!this.isCutOperation) continue;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (!roiCap.remove(actor)) {
                        XpCutCopyKeyAction.this.getLogger().log(Level.SEVERE, "Failed to remove ROI " + XpCutCopyKeyAction.this.getTID());
                    }
                    roiCap.repaint();
                }
            });
        }
        for (i2 = 0; i2 < uas.size(); ++i2) {
            final XpUserAnnotationModel userAnnot = (XpUserAnnotationModel)uas.get(i2);
            if (!userAnnot.isSelected() || !(userAnnot instanceof Replicable)) continue;
            selGOs.add(userAnnot);
            if (!this.isCutOperation) continue;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (!uaCap.remove(userAnnot)) {
                        XpCutCopyKeyAction.this.getLogger().log(Level.SEVERE, "Failed to remove UserAnnot" + XpCutCopyKeyAction.this.getTID());
                    }
                    uaCap.repaint();
                }
            });
        }
        int size = selGOs.size();
        if (size > 0) {
            Clipboard clipBoard = Toolkit.getDefaultToolkit().getSystemClipboard();
            Object[] copy = new Object[size];
            for (int i3 = 0; i3 < copy.length; ++i3) {
                copy[i3] = ((Replicable)selGOs.get(i3)).clone();
            }
            Transferable trans = CvTransferableGO.getInstance().setContents(copy);
            clipBoard.setContents(trans, null);
        }
        this.getLogger().log(Level.INFO, "{0} end XpCutCopyOperation ", this.getTID());
    }

    protected TransactionLogName getTID() {
        return this.isCutOperation ? cuttid : copytid;
    }
}

