/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.action;

import com.ge.med.cse.cvf.base.BaseAction;
import com.ge.med.cse.cvf.log.UserMessageLevel;
import com.ge.med.cse.cvf.roi.CvImageGrid;
import com.ge.med.cse.cvf.util.CvUtils;
import com.ge.med.terra.jami.RoiActor;
import com.ge.med.terra.jami.XpUserAnnotationModel;
import java.awt.event.ActionEvent;
import java.util.logging.Level;

public class XpEraseSelected
extends BaseAction {
    @Override
    protected String getName() {
        return "XP_ERASE_SELECTED";
    }

    @Override
    public void actionPerformed(ActionEvent e2) {
        String[] params = this.getParams();
        try {
            Object ob = null;
            if (params != null && params.length > 0) {
                this.getLogger().log(UserMessageLevel.USER_MSG, CvUtils.getResourceBundle().getString("INV_PARAM"));
                this.setParams(null);
            } else {
                this.eraseROI();
                this.eraseUA();
                this.getCapable().repaint();
            }
        }
        catch (Exception exp) {
            this.getLogger().log(Level.WARNING, "Exception during erase selected graphics, {0}", exp);
        }
    }

    protected void eraseROI() {
        RoiActor[] rois = this.getROICapable().getRois().toArray(new RoiActor[0]);
        for (int i2 = 0; i2 < rois.length; ++i2) {
            if (rois[i2] instanceof CvImageGrid || !rois[i2].isSelected()) continue;
            this.getROICapable().remove(rois[i2]);
            this.getLogger().log(Level.FINE, "Removed the roi {0} sucessfully from the view port", rois[i2]);
        }
    }

    protected void eraseUA() {
        XpUserAnnotationModel[] uams = this.getUserAnnotationCapable().getUserAnnos().toArray(new XpUserAnnotationModel[0]);
        for (int i2 = 0; i2 < uams.length; ++i2) {
            if (!uams[i2].isSelected()) continue;
            this.getUserAnnotationCapable().remove(uams[i2]);
            this.getLogger().log(Level.FINE, "Removed the userannotation {0} sucessfully from the view port", uams[i2]);
        }
    }
}

