/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.action;

import com.ge.med.cse.cvf.base.BaseAction;
import com.ge.med.cse.cvf.cpanels.XPDisplayPrefsUtils;
import com.ge.med.cse.cvf.crossref.XpReferenceImageApp;
import com.ge.med.cse.cvf.log.CvGESyslogMessageCode;
import com.ge.med.cse.cvf.log.UserMessageLevel;
import com.ge.med.cse.cvf.print.MIDPrint;
import com.ge.med.cse.cvf.print.PrinterStatus;
import com.ge.med.cse.cvf.print.XpPrintJobListener;
import com.ge.med.cse.cvf.util.CvUtils;
import com.ge.med.cse.cvf.util.DicomPageablePort;
import com.ge.med.cse.cvf.util.DicomPrintablePort;
import com.ge.med.cse.cvf.util.DicomUtils;
import com.ge.med.idc.Capable;
import com.ge.med.idc.CineCapable;
import com.ge.med.idc.DicomPrintable;
import com.ge.med.idc.SelectionCapable;
import com.ge.med.terra.jami.XpCompositePort;
import com.ge.med.terra.jami.XpMedicalImage;
import com.ge.med.terra.jami.XpSingularPort;
import com.ge.med.terra.jami.XpViewport;
import com.ge.med.terra.jami.capable.FrameOwner;
import com.ge.med.terra.xpv.cuiPanels.TransactionLogName;
import java.awt.event.ActionEvent;
import java.awt.print.Printable;
import java.io.IOException;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.print.DocFlavor;
import javax.print.DocPrintJob;
import javax.print.PrintException;
import javax.print.PrintService;
import javax.print.SimpleDoc;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.swing.JComponent;

public class XpF3FilmAction
extends BaseAction {
    PrintService service_ = null;
    Logger logger = Logger.getLogger(this.getClass().getName());

    @Override
    protected String getName() {
        return "XP_F3_FILM";
    }

    @Override
    public void actionPerformed(ActionEvent e2) {
        DicomPrintable printable;
        TransactionLogName tln = new TransactionLogName("TID=CV_F3FilmAction");
        this.logger.log(Level.INFO, "{0} begin", tln);
        CineCapable cc = (CineCapable)this.getCapable().getCapable(CineCapable.class.getName());
        if (cc != null && cc.getCine()) {
            this.logger.log(Level.INFO, "F3 Film action failed as Cine is On.", tln);
        }
        this.service_ = CvUtils.getDefaultPrintService();
        if (this.service_ == null) {
            this.logger.log(Level.INFO, "{0} Sev5 No print services found !!", tln);
            this.logger.log(Level.SEVERE, CvGESyslogMessageCode.CV_PRINT_ERROR.getLocalizedMessage(), new Object[]{CvGESyslogMessageCode.CV_PRINT_ERROR, CvUtils.getResourceBundle().getString("FC_NOT_RUN")});
            return;
        }
        PrinterStatus attr = this.service_.getAttribute(PrinterStatus.class);
        boolean status = false;
        if (attr != null) {
            status = attr.getValue();
        }
        if (!status) {
            this.logger.log(UserMessageLevel.USER_MSG, CvUtils.getResourceBundle().getString("FC_NOT_RUN"));
            this.logger.log(Level.INFO, "{0} Sev5 Error in printing : Film Composer may not be running", tln);
            this.logger.log(Level.SEVERE, CvGESyslogMessageCode.CV_PRINT_ERROR.getLocalizedMessage(), new Object[]{CvGESyslogMessageCode.CV_PRINT_ERROR, CvUtils.getResourceBundle().getString("FC_NOT_RUN")});
            return;
        }
        SelectionCapable selcap = this.getSelectionCapable();
        JComponent comp = selcap.getViewportComponent(selcap.getComponentSelection());
        if (comp == null || !(comp instanceof Capable)) {
            this.logger.log(UserMessageLevel.USER_MSG, CvUtils.getResourceBundle().getString("FILM_NOT_SUPP"));
            this.logger.log(Level.INFO, "{0} Filming not supported ", tln);
            return;
        }
        DocPrintJob job = this.service_.createPrintJob();
        if (job == null) {
            this.logger.log(Level.INFO, "{0} Sev5 Error in printing : NULL Dicom Print Job ", tln);
            this.logger.log(Level.SEVERE, CvGESyslogMessageCode.CV_PRINT_ERROR.getLocalizedMessage(), new Object[]{CvGESyslogMessageCode.CV_PRINT_ERROR, CvUtils.getResourceBundle().getString("FC_NULL_JOB")});
            return;
        }
        if (CvUtils.isFilmPrintingInProgress(job)) {
            this.logger.log(Level.WARNING, "{0} Printing already in Progress", tln);
            return;
        }
        String filmAnnotLevel = XPDisplayPrefsUtils.getFilmAnnotationLevel();
        int filmCustAnnoMask = XPDisplayPrefsUtils.getFilmCustomAnnotationLevel();
        SimpleDoc doc = null;
        Capable cpb = (Capable)((Object)comp);
        int[] annotkey = null;
        String mod = null;
        if (cpb instanceof FrameOwner) {
            mod = DicomUtils.getModality((XpMedicalImage)((FrameOwner)((Object)cpb)).getFrame());
        }
        if (cpb instanceof XpCompositePort) {
            annotkey = XPDisplayPrefsUtils.getLargeFontAnnotationKeys(((XpCompositePort)cpb).getPort(0), mod, XPDisplayPrefsUtils.getFilmLargeFontAnnotationLevel());
            XpViewport compPort = DicomPrintablePort.cloneViewport((XpCompositePort)cpb, -1);
            if (compPort != null) {
                compPort.setSize(((XpCompositePort)cpb).getWidth(), ((XpCompositePort)cpb).getHeight());
                if (XpReferenceImageApp.isRefPortOn((XpCompositePort)cpb)) {
                    compPort.putClientProperty("reference_viewport", "true");
                }
                compPort.setAnnotationGenerator(((XpCompositePort)cpb).getAnnotationGenerator().getClass(), null);
                printable = CvUtils.getDicomPrintable(compPort);
                if (printable instanceof DicomPrintablePort) {
                    ((DicomPrintablePort)printable).setFilmAnnotationItems(filmAnnotLevel, filmCustAnnoMask);
                    if (annotkey != null) {
                        ((DicomPrintablePort)printable).setLargeFontAnnotation(annotkey);
                    }
                }
                doc = new SimpleDoc(printable, DocFlavor.SERVICE_FORMATTED.PRINTABLE, null);
            }
        } else if (cpb instanceof XpSingularPort) {
            annotkey = XPDisplayPrefsUtils.getLargeFontAnnotationKeys((XpSingularPort)cpb, mod, XPDisplayPrefsUtils.getFilmLargeFontAnnotationLevel());
            XpSingularPort vp = (XpSingularPort)DicomPrintablePort.cloneViewport((XpSingularPort)cpb, -1);
            if (vp != null) {
                vp.setSize(((XpSingularPort)cpb).getWidth(), ((XpSingularPort)cpb).getHeight());
                if (XpReferenceImageApp.isRefPortOn((XpSingularPort)cpb)) {
                    vp.putClientProperty("reference_viewport", "true");
                }
                vp.setAnnotationGenerator(((XpSingularPort)cpb).getAnnotationGenerator().getClass(), null);
                printable = CvUtils.getDicomPrintable(vp);
                if (printable instanceof DicomPrintablePort) {
                    ((DicomPrintablePort)printable).setFilmAnnotationItems(filmAnnotLevel, filmCustAnnoMask);
                    if (annotkey != null) {
                        ((DicomPrintablePort)printable).setLargeFontAnnotation(annotkey);
                    }
                }
                doc = new SimpleDoc(printable, DocFlavor.SERVICE_FORMATTED.PRINTABLE, null);
            }
        } else if (cpb instanceof Printable) {
            doc = new SimpleDoc((Printable)((Object)cpb), DocFlavor.SERVICE_FORMATTED.PRINTABLE, null);
        } else {
            this.logger.log(UserMessageLevel.USER_MSG, CvUtils.getResourceBundle().getString("FILM_NOT_SUPP"));
            this.logger.log(Level.INFO, "{0} Filming not supported ", tln);
            return;
        }
        if (doc == null) {
            this.logger.log(UserMessageLevel.USER_MSG, CvUtils.getResourceBundle().getString("FILM_NOT_SUPP"));
            this.logger.log(Level.INFO, "{0} Sev5 Error in printing : NULL Dicom Print doc", tln);
            this.logger.log(Level.SEVERE, CvGESyslogMessageCode.CV_PRINT_ERROR.getLocalizedMessage(), new Object[]{CvGESyslogMessageCode.CV_PRINT_ERROR, CvUtils.getResourceBundle().getString("FC_NULL_JOB")});
            return;
        }
        XpPrintJobListener lsnr = new XpPrintJobListener(doc);
        HashPrintRequestAttributeSet aset = new HashPrintRequestAttributeSet();
        aset.add(new MIDPrint("MIDPrint", new Locale("en")));
        try {
            job.addPrintJobListener(lsnr);
            job.print(doc, aset);
        }
        catch (PrintException pe) {
            this.logger.log(Level.INFO, "{0} Error in printing due to " + pe.getMessage(), tln);
            this.logger.log(Level.SEVERE, CvGESyslogMessageCode.CV_PRINT_ERROR.getLocalizedMessage(), new Object[]{CvGESyslogMessageCode.CV_PRINT_ERROR, pe.getMessage()});
            Object data = null;
            try {
                data = doc.getPrintData();
            }
            catch (IOException ioe) {
                // empty catch block
            }
            if (data instanceof DicomPrintablePort) {
                ((DicomPrintablePort)data).dispose();
            } else if (data instanceof DicomPageablePort) {
                ((DicomPageablePort)data).dispose();
            }
            job.removePrintJobListener(lsnr);
        }
        this.logger.log(Level.INFO, "{0} end", tln);
    }
}

