/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.action;

import com.ge.med.cse.cvf.base.BaseAction;
import com.ge.med.cse.cvf.cpanels.XPDisplayPrefsUtils;
import com.ge.med.cse.cvf.log.UserMessageLevel;
import com.ge.med.cse.cvf.util.CvUtils;
import com.ge.med.terra.jami.XpDicomElement;
import com.ge.med.terra.jami.XpMedicalImage;
import com.ge.med.terra.jami.capable.AnnotCapable;
import com.ge.med.terra.jami.capable.FrameCapable;
import com.ge.med.terra.xpv.cuiPanels.TransactionLogName;
import java.awt.event.ActionEvent;
import java.util.logging.Level;
import javax.swing.JComponent;

public class XpFilmAnnotGroupAction
extends BaseAction {
    @Override
    protected String getName() {
        return "XP_FILM_ANN_GROUP";
    }

    @Override
    public void actionPerformed(ActionEvent e2) {
        block18: {
            TransactionLogName tln = new TransactionLogName("TID=CV_filmannotationGroup_custom");
            try {
                String[] params = this.getParams();
                AnnotCapable annotCap = this.getAnnotCapable();
                if (params != null) {
                    int length = params.length;
                    if (length < 2) {
                        this.getLogger().log(UserMessageLevel.USER_MSG, CvUtils.getResourceBundle().getString("INSUFF_PARAM"));
                        this.getLogger().log(Level.WARNING, "Missing some argument");
                        break block18;
                    }
                    if (length > 2) {
                        this.getLogger().log(UserMessageLevel.USER_MSG, CvUtils.getResourceBundle().getString("TOO_MANY_PARAM"));
                        this.getLogger().log(Level.WARNING, "Too many argument");
                        break block18;
                    }
                    XpMedicalImage img = (XpMedicalImage)((FrameCapable)((Object)annotCap)).getFrame();
                    XpDicomElement mod = new XpDicomElement(8, 96);
                    String modality = null;
                    if (img.getValue(mod) != 0) {
                        this.getLogger().log(Level.WARNING, "{0} SEV5 modality could not be evaluated", tln);
                        return;
                    }
                    modality = "" + mod.value;
                    boolean onoff = false;
                    if (params[0].equalsIgnoreCase("on")) {
                        onoff = true;
                    } else if (params[0].equalsIgnoreCase("off")) {
                        onoff = false;
                    } else {
                        this.getLogger().log(UserMessageLevel.USER_MSG, CvUtils.getResourceBundle().getString("INV_PARAM"));
                        this.getLogger().log(Level.WARNING, "{0} SEV5 Invalid argument", tln);
                        return;
                    }
                    int index = 0;
                    try {
                        index = Integer.parseInt(params[1]);
                    }
                    catch (NumberFormatException nfe) {
                        if (params[1] != null && !params[1].equals("")) {
                            if (params[1].equalsIgnoreCase("w")) {
                                index = this.getIndex("Windowing", modality);
                            } else if (params[1].equalsIgnoreCase("g")) {
                                index = this.getIndex("Graphic_Results", modality);
                            } else {
                                this.getLogger().log(UserMessageLevel.USER_MSG, CvUtils.getResourceBundle().getString("INV_PARAM"));
                                this.getLogger().log(Level.WARNING, "{0} Invalid argument list :" + nfe.getLocalizedMessage(), tln);
                            }
                        }
                        this.getLogger().log(UserMessageLevel.USER_MSG, CvUtils.getResourceBundle().getString("INV_PARAM"));
                        this.getLogger().log(Level.WARNING, "{0} Invalid argument list :" + nfe.getLocalizedMessage(), tln);
                    }
                    String[] groups = XPDisplayPrefsUtils.getCustomAnnotationGroups(modality);
                    if (groups == null || index < 1 || index > groups.length) {
                        this.getLogger().log(UserMessageLevel.USER_MSG, CvUtils.getResourceBundle().getString("INV_PARAM"));
                        this.getLogger().log(Level.WARNING, "{0} SEV5 NULL Custom groups", tln);
                        return;
                    }
                    int mask = XPDisplayPrefsUtils.getFilmCustomAnnotationLevel();
                    mask = onoff ? (mask |= XPDisplayPrefsUtils.getCustomAnnotationGroupMask(index - 1)) : (mask &= ~XPDisplayPrefsUtils.getCustomAnnotationGroupMask(index - 1));
                    XPDisplayPrefsUtils.updateFilmCustomAnnotationLevel(mask);
                    ((JComponent)((Object)annotCap)).putClientProperty("film_custom_annotation_level", new Integer(mask));
                    break block18;
                }
                this.getLogger().log(UserMessageLevel.USER_MSG, CvUtils.getResourceBundle().getString("INSUFF_PARAM"));
                this.getLogger().log(Level.WARNING, "Argument missing");
            }
            catch (Exception ex) {
                this.getLogger().log(Level.WARNING, "Invalid argument", ex);
            }
        }
    }

    private int getIndex(String string, String modality) {
        String[] groupElemts = XPDisplayPrefsUtils.getCustomAnnotationGroups(modality);
        if (groupElemts != null) {
            int eleLength = groupElemts.length;
            for (int i2 = 0; i2 < eleLength; ++i2) {
                if (!groupElemts[i2].equalsIgnoreCase(string)) continue;
                return i2 + 1;
            }
        }
        return 0;
    }
}

