/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.action;

import com.ge.med.cse.cvf.base.BaseAction;
import com.ge.med.cse.cvf.cpanels.XPDisplayPrefsUtils;
import com.ge.med.cse.cvf.log.UserMessageLevel;
import com.ge.med.cse.cvf.roi.CvImageGrid;
import com.ge.med.cse.cvf.util.CvPropertiesManager;
import com.ge.med.cse.cvf.util.CvUtils;
import com.ge.med.idc.Capable;
import com.ge.med.idc.SelectionCapable;
import com.ge.med.terra.jami.RoiActor;
import com.ge.med.terra.jami.XpCompositePort;
import com.ge.med.terra.jami.XpImage;
import com.ge.med.terra.jami.capable.FrameCapable;
import com.ge.med.terra.jami.capable.ROICapable;
import com.ge.med.terra.jami.j3d.T3DViewport;
import java.awt.event.ActionEvent;
import java.util.List;
import java.util.logging.Level;

public class XpGridAction
extends BaseAction {
    private static final boolean grid_prefs_enabled = CvPropertiesManager.getBoolean("cvf.grid.prefs_enabled", true);
    private static final boolean show_move_handle = CvPropertiesManager.getBoolean("cvf.grid.show_move_handle", true);

    @Override
    protected String getName() {
        return "XP_GRID";
    }

    @Override
    public void actionPerformed(ActionEvent e2) {
        XpImage img;
        ROICapable cap = this.getROICapable();
        if (cap != null && cap instanceof FrameCapable && !CvUtils.measurementsValid(img = ((FrameCapable)((Object)cap)).getFrame())) {
            this.getLogger().log(UserMessageLevel.USER_MSG, CvUtils.getResourceBundle().getString("CMD_NOT_SUPPORTED"));
            return;
        }
        String[] params = this.getParams();
        if (params != null && params.length > 0) {
            if (params[0].toLowerCase().equals("on")) {
                this.addGrid();
            } else if (params[0].toLowerCase().equals("off")) {
                this.removeGrid();
            } else {
                this.getLogger().log(UserMessageLevel.USER_MSG, CvUtils.getResourceBundle().getString("INV_PARAM"));
                this.getLogger().log(Level.WARNING, "Invalid command argument");
            }
            this.setParams(null);
        } else {
            List roiList = this.getROICapable().getRois();
            for (int i2 = 0; i2 < roiList.size(); ++i2) {
                RoiActor ra = (RoiActor)roiList.get(i2);
                if (!(ra instanceof CvImageGrid)) continue;
                this.getROICapable().remove(ra);
                return;
            }
            this.addGrid();
        }
    }

    private void addGrid() {
        byte csystem = this.fetchCoordSystem(this.getCapable());
        if (this.getCapable() != null) {
            CvImageGrid grid = new CvImageGrid(show_move_handle, csystem);
            if (grid_prefs_enabled) {
                boolean glOn = XPDisplayPrefsUtils.getGridLinesOn();
                String ls = XPDisplayPrefsUtils.getLineStyle();
                double gs = XPDisplayPrefsUtils.getGridSpacing();
                double ts = XPDisplayPrefsUtils.getTickSpacing();
                double tl = XPDisplayPrefsUtils.getTickLength();
                CvImageGrid.setGridSpacing(gs);
                CvImageGrid.setTickSpacing(ts);
                CvImageGrid.setTickLength(tl);
                CvImageGrid.setLineStyle(ls);
                CvImageGrid.setGridLinesOn(glOn);
            }
            this.getROICapable().add(grid);
        } else {
            this.getLogger().log(Level.WARNING, "Unable to fetch the singular port");
        }
    }

    private void removeGrid() {
        List roiList = this.getROICapable().getRois();
        for (int i2 = 0; i2 < roiList.size(); ++i2) {
            RoiActor ra = (RoiActor)roiList.get(i2);
            if (!(ra instanceof CvImageGrid)) continue;
            this.getROICapable().remove(ra);
            return;
        }
    }

    protected byte fetchCoordSystem(Capable cap) {
        while (cap instanceof SelectionCapable) {
            if ((cap = (Capable)((Object)((SelectionCapable)cap).getViewportComponent(((SelectionCapable)cap).getComponentSelection()))) instanceof XpCompositePort) {
                return 0;
            }
            if (!(cap instanceof T3DViewport)) continue;
            return 5;
        }
        return 0;
    }
}

