/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.action;

import com.ge.med.cse.cvf.base.BaseAction;
import com.ge.med.cse.cvf.log.UserMessageLevel;
import com.ge.med.cse.cvf.util.CvUtils;
import com.ge.med.idc.PanZoomCapable;
import com.ge.med.terra.jami.capable.FrameCapable;
import com.ge.med.terra.xpv.base.XPscreen;
import java.awt.event.ActionEvent;
import java.util.logging.Level;
import javax.swing.JComponent;

public class XpPanAction
extends BaseAction {
    @Override
    protected String getName() {
        return "XP_PAN";
    }

    @Override
    public void actionPerformed(ActionEvent e2) {
        PanZoomCapable pz = this.getPanZoomCapable();
        try {
            String[] params = this.getParams();
            int imgWidth = 0;
            int imgHeight = 0;
            int portWidth = 0;
            int portHeight = 0;
            double panx = 0.0;
            double pany = 0.0;
            double initPanx = 0.0;
            double initPany = 0.0;
            if (params != null) {
                if (params.length == 2) {
                    panx = Integer.parseInt(params[0]);
                    pany = Integer.parseInt(params[1]);
                    initPanx = pz.getPanX();
                    initPany = pz.getPanY();
                    FrameCapable fc = (FrameCapable)((Object)this.getCapable().getCapable(FrameCapable.class.getName()));
                    if (fc == null) {
                        this.getLogger().log(Level.WARNING, "Not FrameCapable");
                        return;
                    }
                    if (fc != null && fc.getFrame() != null) {
                        imgWidth = fc.getFrame().getSlice().width;
                        imgHeight = fc.getFrame().getSlice().height;
                    }
                    if (!(this.getCapable() instanceof XPscreen)) {
                        return;
                    }
                    int idx = ((XPscreen)this.getCapable()).getSelectedPortNumber();
                    JComponent port = ((XPscreen)this.getCapable()).getPort(idx);
                    portWidth = port.getWidth();
                    portHeight = port.getHeight();
                    double zoom = pz.getZoom();
                    double dix = (double)imgWidth * panx / (double)portWidth;
                    double diy = (double)imgHeight * pany / (double)portHeight;
                    double panX = initPanx + dix / zoom;
                    double panY = initPany + diy / zoom;
                    double limPanx = 0.0;
                    double limPany = 0.0;
                    limPanx = imgWidth / 2;
                    limPany = imgHeight / 2;
                    double absPx = Math.abs(panX);
                    double absPy = Math.abs(panY);
                    if (absPx > limPanx) {
                        double d2 = panX = panX < 0.0 ? -limPanx : limPanx;
                    }
                    if (absPy > limPany) {
                        panY = panY < 0.0 ? -limPany : limPany;
                    }
                    pz.setPan(panX, panY);
                } else {
                    this.getLogger().log(Level.WARNING, "Invalid argument");
                    this.getLogger().log(UserMessageLevel.USER_MSG, CvUtils.getResourceBundle().getString("INV_PARAM"));
                }
            } else {
                this.getLogger().log(Level.WARNING, "Scroll command needs x, y arguments");
            }
        }
        catch (Exception ex) {
            this.getLogger().log(Level.WARNING, "Exception during command scroll", ex);
        }
    }
}

