/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.action;

import com.ge.med.cse.cvf.base.BaseAction;
import com.ge.med.cse.cvf.log.UserMessageLevel;
import com.ge.med.cse.cvf.util.CPIUtils;
import com.ge.med.cse.cvf.util.CvPropertiesManager;
import com.ge.med.cse.cvf.util.CvUtils;
import com.ge.med.idc.FramePositioningCapable;
import com.ge.med.idc.SelectionCapable;
import com.ge.med.terra.jami.XpCompositePort;
import com.ge.med.terra.jami.XpDicomElement;
import com.ge.med.terra.jami.XpMedicalImage;
import com.ge.med.terra.jami.XpViewport;
import com.ge.med.terra.jami.capable.CPICapable;
import com.ge.med.terra.jami.capable.FrameCapable;
import com.ge.med.terra.jami.render.XpImageRenderAttributes;
import com.ge.med.terra.tap.dm.DMObject;
import com.ge.med.terra.tap.dm.DMQuery;
import com.ge.med.terra.tap.util.dicom.UidGenerator;
import com.ge.med.terra.xpv.cuiPanels.TransactionLogName;
import java.awt.event.ActionEvent;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class XpSaveStateAction
extends BaseAction {
    private String seriesDescription = null;
    private static final int ALL_IMAGE_MODE = 0;
    private static final int ONLY_SEL_IMAGE_MODE = 1;
    private static final int SEL_IMAGES_MODE = 2;
    private static final int IMAGE_RANGE_MODE = 3;
    private int mode = 0;
    private static final int EXAMID = 0;
    private static final int EXAMUID = 1;
    private static final int IMGUID = 2;
    private static final int WINDOW_TAG_LEN_LIMIT = 16;
    private XpDicomElement[] dcm = null;
    private int[] imgRange = new int[2];
    private static final boolean enable_gsps;

    @Override
    protected String getName() {
        return "XP_SAVE_STATE";
    }

    @Override
    public void actionPerformed(ActionEvent e2) {
        TransactionLogName tln = new TransactionLogName("TID=CV_saveStateAction");
        this.getLogger().log(Level.INFO, "{0} begin", tln);
        FrameCapable fcap = (FrameCapable)((Object)this.getSelectionCapable().getViewportComponent(this.getSelectionCapable().getComponentSelection()));
        if (this.mode == 0 && fcap != null && fcap.getNumFrames() > CvUtils.getLargeSeriesSize()) {
            this.getLogger().log(UserMessageLevel.USER_MSG, CvUtils.getResourceBundle().getString("XP_SERIES_TOO_LAREG_FOR_CMD"));
            this.getLogger().log(Level.WARNING, "Save State not supported for series size > " + CvUtils.getLargeSeriesSize());
            return;
        }
        String status = "SST_FAIL";
        if (fcap != null) {
            XpMedicalImage dmImage = (XpMedicalImage)fcap.getFrame();
            status = this.doSaveState(dmImage);
        }
        this.getLogger().log(UserMessageLevel.USER_MSG, CvUtils.getResourceBundle().getString(status));
        this.getLogger().log(Level.INFO, "{0} end", tln);
    }

    private String doSaveState(XpMedicalImage refImage) {
        String[] params = this.getParams();
        if (params != null && params.length > 0) {
            boolean validarg = this.parseParams(params);
            this.setParams(null);
            if (!validarg) {
                return "INV_PARAM";
            }
        }
        DMObject dmObject = null;
        this.dcm = new XpDicomElement[3];
        this.dcm[0] = new XpDicomElement(32, 16);
        this.dcm[1] = new XpDicomElement(32, 13);
        this.dcm[2] = new XpDicomElement(8, 24);
        refImage.getValues(this.dcm);
        String query = "(0x0020, 0x000D) = " + this.dcm[1].getStringValue();
        String eid = this.dcm[0].getStringValue();
        if (eid != null && eid.trim().length() > 0) {
            query = query + " AND (0x0020, 0x0010) = " + eid;
        }
        query = query + " AND (0x0008, 0x0018) = " + this.dcm[2].getStringValue();
        DMObject[] dmo = CvUtils.getDMSystem().getLocalDB().getRelated("image", new DMQuery(query));
        dmObject = dmo != null && dmo.length > 0 ? dmo[0] : CvUtils.getDMSystem().getRepresentativeDMObjet();
        if (dmObject == null) {
            this.getLogger().log(Level.WARNING, "Representative DMObject is NULL !!!");
            return "SST_FAIL";
        }
        int gspsSeriesNo = CPIUtils.getGSPSSeriesNo(dmObject);
        XpDicomElement descTag = new XpDicomElement(112, 128, this.seriesDescription);
        XpDicomElement serNoTag = new XpDicomElement(32, 17, gspsSeriesNo);
        InputStream gspsInputStream = null;
        XpDicomElement[] overrideDicomElements = null;
        boolean gspsAuxFlag = CvPropertiesManager.getBoolean("GSPS_AUX_TAG", false);
        String gspsObjUID = UidGenerator.newInstanceUID();
        XpDicomElement gspsUID = new XpDicomElement(8, 24, gspsObjUID);
        String gspsSeriesUID = CPIUtils.getGSPSSeriesUID(dmObject);
        XpDicomElement seUIDTag = new XpDicomElement(32, 14, gspsSeriesUID);
        overrideDicomElements = new XpDicomElement[]{descTag, serNoTag, this.dcm[0], seUIDTag, gspsUID};
        XpViewport cpiViewport = this.findSelectedViewportByClass(CPICapable.class);
        if (cpiViewport == null) {
            this.getLogger().log(Level.WARNING, "Selected port not found or not CPICapable");
            return "SST_FAIL";
        }
        if (cpiViewport instanceof XpCompositePort) {
            int sceneLen = ((XpCompositePort)cpiViewport).getNumScenes();
            for (int i2 = 0; i2 < sceneLen; ++i2) {
                String precision;
                int index;
                Matcher matcher;
                XpImageRenderAttributes ira = ((XpCompositePort)cpiViewport).getScene(i2).getImageRenderAttributes();
                double ww = ira.getWindowWidth();
                double wl = ira.getWindowLevel();
                String wwString = new Double(ww).toString();
                String wlString = new Double(wl).toString();
                boolean isTruncated = false;
                if (wwString.length() > 16) {
                    matcher = Pattern.compile(Pattern.quote("E"), 2).matcher(wwString);
                    if (matcher.find()) {
                        index = matcher.start();
                        precision = wwString.substring(index);
                        wwString = wwString.substring(0, 16 - precision.length());
                        wwString = wwString + precision;
                        ww = Double.valueOf(wwString);
                    } else {
                        wwString = wwString.substring(0, 16);
                        ww = Double.valueOf(wwString);
                    }
                    isTruncated = true;
                }
                if (wlString.length() > 16) {
                    matcher = Pattern.compile(Pattern.quote("E"), 2).matcher(wlString);
                    if (matcher.find()) {
                        index = matcher.start();
                        precision = wlString.substring(index);
                        wlString = wlString.substring(0, 16 - precision.length());
                        wlString = wlString + precision;
                        wl = Double.valueOf(wlString);
                    } else {
                        wlString = wlString.substring(0, 16);
                        wl = Double.valueOf(wlString);
                    }
                    isTruncated = true;
                }
                if (!isTruncated) continue;
                ira.setWindowing(ww, wl);
            }
        }
        switch (this.mode) {
            case 0: {
                gspsInputStream = CPIUtils.doSaveState(cpiViewport, dmObject, overrideDicomElements);
                break;
            }
            case 1: {
                int imageIndex = 0;
                if (cpiViewport instanceof FramePositioningCapable) {
                    imageIndex = ((FramePositioningCapable)((Object)cpiViewport)).getFrameIndex();
                }
                if (cpiViewport instanceof SelectionCapable && ((SelectionCapable)((Object)cpiViewport)).getComponentSelection() != -1) {
                    imageIndex += ((SelectionCapable)((Object)cpiViewport)).getComponentSelection();
                }
                gspsInputStream = CPIUtils.doSaveState(cpiViewport, imageIndex, dmObject, overrideDicomElements);
                break;
            }
            case 3: {
                if (this.imgRange[0] > 0 && this.imgRange[1] <= this.getFrameCapable().getNumFrames() && this.imgRange[0] <= this.imgRange[1]) {
                    if (Math.abs(this.imgRange[1] - this.imgRange[0] + 1) > CvUtils.getLargeSeriesSize()) {
                        this.getLogger().log(Level.WARNING, "Save State not supported for series size > " + CvUtils.getLargeSeriesSize());
                        return "XP_SERIES_TOO_LAREG_FOR_CMD";
                    }
                } else {
                    this.getLogger().log(Level.WARNING, "Invalid image range params");
                    return "INV_PARAM";
                }
                gspsInputStream = CPIUtils.doSaveState(cpiViewport, this.imgRange[0], this.imgRange[1], dmObject, overrideDicomElements);
                break;
            }
        }
        if (gspsInputStream != null) {
            try {
                if (enable_gsps) {
                    String enable_gspsObjUID = "UID:" + gspsObjUID;
                    if (CvUtils.getDMSystem().getSystemName().equalsIgnoreCase("nuevo") && gspsAuxFlag) {
                        CPIUtils.setAuxTag(dmObject, enable_gspsObjUID);
                    }
                    CvUtils.getDMSystem().getLocalDB().install(gspsInputStream);
                } else {
                    String gspsFilePath = CPIUtils.saveGSPSToFile(gspsInputStream, dmObject);
                    String filePath = "PATH:" + gspsFilePath;
                    if (CvUtils.getDMSystem().getSystemName().equalsIgnoreCase("nuevo") && gspsAuxFlag) {
                        CPIUtils.setAuxTag(dmObject, filePath);
                    }
                }
                boolean status = CPIUtils.saveVignetteFiles(cpiViewport);
                if (!status) {
                    this.getLogger().log(Level.INFO, "Fail to create Vignette files");
                    return "SST_FAIL";
                }
                this.getLogger().log(Level.INFO, "Vignette files are created successfully");
                this.getLogger().log(Level.INFO, "GSPS Creation Successful");
                return "SST_DONE";
            }
            catch (Exception exp) {
                this.getLogger().log(Level.WARNING, "Exception during GSPS creation", new Object[]{exp});
                exp.printStackTrace();
            }
        }
        return "SST_FAIL";
    }

    private boolean parseParams(String[] st) {
        if (st[0].toLowerCase().equals("all")) {
            this.mode = 0;
            return true;
        }
        if (st[0].toLowerCase().equals("s")) {
            this.mode = 1;
            return true;
        }
        if (st.length == 2 && st[0].toLowerCase().equals("i")) {
            try {
                int length = st[1].length();
                int hyphenidx = st[1].indexOf("-");
                if (hyphenidx == -1 || hyphenidx == 0 || hyphenidx == length - 1) {
                    this.getLogger().log(Level.WARNING, "Invalid command argument");
                    return false;
                }
                int from = Integer.parseInt(st[0].substring(0, hyphenidx - 1).toLowerCase().trim());
                int to = Integer.parseInt(st[1].substring(hyphenidx + 1, length - 1).toLowerCase().trim());
                this.imgRange[0] = from;
                this.imgRange[1] = to;
                this.mode = 3;
                return true;
            }
            catch (Exception e2) {
                this.getLogger().log(Level.WARNING, "Argument parsing error", e2);
            }
        } else {
            this.getLogger().log(Level.WARNING, "Invalid save state command arguments");
        }
        return false;
    }

    public void setImageRange(int from, int to) {
        this.imgRange[0] = from;
        this.imgRange[1] = to;
    }

    public void setSeriesDescription(String presenLabelString) {
        this.seriesDescription = presenLabelString != null && presenLabelString.length() > 0 ? presenLabelString : "JAMI_GSPS";
    }

    public void setMode(int mode) {
        this.mode = mode;
    }

    static {
        String gsps_env = System.getenv("ENABLE_GSPS");
        if (gsps_env != null) {
            CvPropertiesManager.setProperty("cvf.enable_gsps", gsps_env.trim());
        }
        enable_gsps = CvPropertiesManager.getBoolean("cvf.enable_gsps", true);
    }
}

