/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.action;

import com.ge.med.cse.cvf.base.BaseAction;
import com.ge.med.cse.cvf.log.UserMessageLevel;
import com.ge.med.cse.cvf.util.CvUtils;
import com.ge.med.terra.jami.XpMedicalImage;
import java.awt.event.ActionEvent;
import java.util.logging.Level;

public class XpWindowLevelAction
extends BaseAction {
    protected double WL_MIN;
    protected double WL_MAX;

    @Override
    protected String getName() {
        return "XP_WINDOW_LEVEL";
    }

    @Override
    public void actionPerformed(ActionEvent e2) {
        XpMedicalImage dmImage = this.getFrame();
        this.WL_MIN = CvUtils.getMinWL(dmImage);
        this.WL_MAX = CvUtils.getMaxWL(dmImage);
        double ww = this.getWindowLevelCapable().getWinMax() - this.getWindowLevelCapable().getWinMin();
        String[] params = this.getParams();
        try {
            if (params != null && params.length > 0) {
                Double wl = Double.parseDouble(params[0]);
                this.setWindowing(wl, ww);
                this.setParams(null);
            } else {
                this.getLogger().log(Level.WARNING, "Missing WL argument");
                this.getLogger().log(UserMessageLevel.USER_MSG, CvUtils.getResourceBundle().getString("INSUFF_PARAM"));
            }
        }
        catch (Exception ex) {
            this.getLogger().log(Level.WARNING, "Parsing error for WL argument", ex);
        }
    }

    protected void setWindowing(double wl, double ww) {
        if (wl > this.WL_MAX) {
            wl = this.WL_MAX;
        } else if (wl < this.WL_MIN) {
            wl = this.WL_MIN;
        }
        double min = wl - ww / 2.0;
        double max = min + ww;
        this.getWindowLevelCapable().setWinMinMax(min, max);
        this.getWindowLevelCapable().repaint();
    }
}

