/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.action;

import com.ge.med.cse.cvf.base.BaseAction;
import com.ge.med.cse.cvf.model.WWWLModel;
import com.ge.med.idc.Capable;
import com.ge.med.terra.xpv.cuiPanels.TransactionLogName;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.logging.Level;
import javax.swing.JComponent;

public class XpWindowPresetAction
extends BaseAction {
    private static final long serialVersionUID = 1L;
    private WWWLModel model = null;
    private String presetKey = null;
    private String presetTitle = null;
    private TransactionLogName preset = null;
    private JComponent selectedComp = null;

    @Override
    protected String getName() {
        return "XpWindowPresetAction";
    }

    public void setPreset(String presetkey) {
        this.presetKey = presetkey;
        this.preset = new TransactionLogName(presetkey);
    }

    public void setPresetTitle() {
        String modality = this.getCurrentModality();
        if (modality != null && this.presetKey != null) {
            this.model = WWWLModel.getModel(modality);
            if (this.model != null) {
                this.presetTitle = this.model.getTitle(this.presetKey);
                String key = this.model.getShortCutKey(this.presetKey);
                this.presetTitle = this.presetTitle + " (" + key + ")";
                if (this.presetTitle != null) {
                    this.putValue("Name", this.presetTitle);
                }
            }
        }
    }

    protected void prepareModel() {
        String modality = this.getCurrentModality();
        if (modality != null) {
            this.model = WWWLModel.getModel(modality);
        }
    }

    protected void setLevels() {
        double[] setting = this.model.getWWWL(this.presetKey);
        if (setting == null || setting.length < 2) {
            return;
        }
        double min = setting[1] - setting[0] / 2.0;
        double max = min + setting[0];
        this.getWindowLevelCapable().setWinMinMax(min, max);
        this.getWindowLevelCapable().repaint();
    }

    @Override
    public void setCapable(Capable cap) {
        super.setCapable(cap);
        this.setPresetTitle();
        cap.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals("data_changed") || evt.getPropertyName().equals("CONTENT_CHANGED") || evt.getPropertyName().equalsIgnoreCase("ComponentSelection")) {
                    if (evt.getPropertyName().equalsIgnoreCase("ComponentSelection")) {
                        if (XpWindowPresetAction.this.getSelectedViewport() == XpWindowPresetAction.this.selectedComp) {
                            return;
                        }
                        XpWindowPresetAction.this.selectedComp = XpWindowPresetAction.this.getSelectedViewport();
                    }
                    XpWindowPresetAction.this.setPresetTitle();
                }
            }
        });
    }

    @Override
    public void actionPerformed(ActionEvent e2) {
        this.getLogger().log(Level.FINE, "{0} " + this.presetKey + "Key Action Begin " + this.preset);
        this.prepareModel();
        this.setLevels();
        this.getLogger().log(Level.FINE, "{0} " + this.presetKey + "Key Action END " + this.preset);
    }

    public static class Preset6
    extends XpWindowPresetAction {
        public Preset6() {
            this.setPreset(this.getName());
        }

        @Override
        protected String getName() {
            return "Predef6";
        }
    }

    public static class Preset5
    extends XpWindowPresetAction {
        public Preset5() {
            this.setPreset(this.getName());
        }

        @Override
        protected String getName() {
            return "Predef5";
        }
    }

    public static class Preset4
    extends XpWindowPresetAction {
        public Preset4() {
            this.setPreset(this.getName());
        }

        @Override
        protected String getName() {
            return "Predef4";
        }
    }

    public static class Preset3
    extends XpWindowPresetAction {
        public Preset3() {
            this.setPreset(this.getName());
        }

        @Override
        protected String getName() {
            return "Predef3";
        }
    }

    public static class Preset2
    extends XpWindowPresetAction {
        public Preset2() {
            this.setPreset(this.getName());
        }

        @Override
        protected String getName() {
            return "Predef2";
        }
    }

    public static class Preset1
    extends XpWindowPresetAction {
        public Preset1() {
            this.setPreset(this.getName());
        }

        @Override
        protected String getName() {
            return "Predef1";
        }
    }
}

