/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.annotation;

import com.ge.med.StdAnno.ApStyle;
import com.ge.med.cse.cvf.annotation.XpApdAnnotationGenerator;
import com.ge.med.cse.cvf.annotation.XpCVAnnotation;
import com.ge.med.terra.jami.XpDicomObject;
import com.ge.med.terra.jami.annotation.XpApdAnnotation;
import java.util.Properties;
import java.util.StringTokenizer;

public class XpCVAnnotationGenerator
extends XpApdAnnotationGenerator {
    private int[] annotKeys = null;
    private static String language = System.getProperty("user.language", "en");

    public XpCVAnnotationGenerator() {
        this.setLanguage(this.getLanguage(language));
    }

    public XpCVAnnotationGenerator(Object[] prop) {
        this();
    }

    @Override
    public void setProperties(Properties p2) {
        super.setProperties(p2);
        this.resetLargeFontAnnotKeys();
    }

    private void resetLargeFontAnnotKeys() {
        String largefontkeys = this.getProperty("LargeFontKeys");
        if (largefontkeys != null) {
            StringTokenizer st = new StringTokenizer(largefontkeys, ",");
            if (st.countTokens() > 0) {
                this.annotKeys = new int[st.countTokens()];
                for (int i2 = 0; i2 < this.annotKeys.length; ++i2) {
                    this.annotKeys[i2] = Integer.parseInt(st.nextToken());
                }
            } else {
                this.annotKeys = null;
            }
        } else {
            this.annotKeys = null;
        }
    }

    @Override
    protected XpApdAnnotation createApdAnnotation(XpDicomObject dobj, ApStyle aps) {
        XpCVAnnotation apdAnnot = new XpCVAnnotation(dobj, aps);
        apdAnnot.setProperty("lang", language);
        apdAnnot.setLargeFontRendering(this.annotKeys);
        return apdAnnot;
    }

    public int getLanguage(String lang) {
        if (lang.startsWith("en")) {
            language = "en_US";
            return 0;
        }
        if (lang.startsWith("es")) {
            language = "es_MX";
            return 1;
        }
        if (lang.startsWith("fr")) {
            language = "fr_FR";
            return 2;
        }
        if (lang.startsWith("de")) {
            language = "de_DE";
            return 4;
        }
        if (lang.startsWith("it")) {
            language = "it_IT";
            return 3;
        }
        if (lang.startsWith("pt")) {
            language = "pt_PT";
            return 5;
        }
        if (lang.startsWith("kr")) {
            language = "kr";
            return 8;
        }
        if (lang.startsWith("no") || lang.startsWith("nb") || lang.startsWith("nn")) {
            language = "nb_NO";
            return 6;
        }
        language = lang.startsWith("da") ? "da_DK" : (lang.startsWith("fi") ? "fi_FI" : (lang.startsWith("sv") ? "sv_SE" : (lang.startsWith("nl") ? "nl_NL" : "en_US")));
        return 0;
    }
}

