/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.base;

import com.ge.med.terra.jami.CPoint;
import com.ge.med.terra.jami.CTransform;
import com.ge.med.terra.jami.XpImage;
import com.ge.med.terra.jami.marker.XpMarker;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class LinkedCursorVc
extends XpMarker {
    private transient CPoint _cp0 = new CPoint();
    private transient CPoint tempImgPt = new CPoint(0);
    private CPoint img_pt = new CPoint(0);
    private CPoint disp_pt = new CPoint(1);
    private CPoint ras_pt = new CPoint(2);
    private int width = 0;
    private int height = 0;
    private Rectangle bounds = new Rectangle();
    private static final int DIM = 10;
    private int gap = 3;
    private BasicStroke stroke = new BasicStroke(2.0f);
    private Shape hotspot = null;
    private Color color = Color.RED.brighter();
    private Vector<ChangeListener> listeners = new Vector();

    public LinkedCursorVc() {
        this(-0.5, -0.5);
    }

    public LinkedCursorVc(double x2, double y2) {
        this.setForeground(this.color);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.img_pt.setPoint(x2, y2, 0.0, (byte)0);
        this.bounds.setBounds(-10, -10, 20, 20);
    }

    public LinkedCursorVc(double x2, double y2, Shape s2) {
        this(x2, y2);
        this.hotspot = s2;
        this.bounds.setBounds(s2.getBounds());
    }

    @Override
    public final void setImage(XpImage img) {
        super.setImage(img);
        if (img != null) {
            this.width = img.getSlice().width;
            this.height = img.getSlice().height;
        }
        if (this.img_pt.x < 0.0 && this.img_pt.y < 0.0) {
            this.img_pt.x *= (double)(-this.width);
            this.img_pt.y *= (double)(-this.height);
        }
    }

    @Override
    public boolean contains(int x2, int y2) {
        double posX = (double)x2 - this.disp_pt.x;
        double posY = (double)y2 - this.disp_pt.y;
        return this.bounds.contains(posX, posY);
    }

    @Override
    public void paintComponent(Graphics graphics) {
        Graphics2D g2 = (Graphics2D)graphics;
        CTransform ctc = this.getTransform((byte)0, (byte)1);
        ctc.transform(this.img_pt, this.disp_pt);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setColor(this.getForeground());
        if (this.hotspot != null) {
            g2.translate(this.disp_pt.x, this.disp_pt.y);
            g2.draw(this.hotspot);
            g2.translate(-this.disp_pt.x, -this.disp_pt.y);
        } else {
            int x2 = (int)this.disp_pt.x;
            int y2 = (int)this.disp_pt.y;
            int x1 = x2 - 10;
            int x22 = x2 + 10;
            int y1 = y2 - 10;
            int y22 = y2 + 10;
            g2.setStroke(this.stroke);
            g2.drawLine(x1, y1, x2 - this.gap, y2 - this.gap);
            g2.drawLine(x2 + this.gap, y2 + this.gap, x22, y22);
            g2.drawLine(x1, y22, x2 - this.gap, y2 + this.gap);
            g2.drawLine(x2 + this.gap, y2 - this.gap, x22, y1);
        }
    }

    @Override
    public void mouseDragged(MouseEvent me) {
        Point pt = me.getPoint();
        this._cp0.setPoint(pt.x, pt.y, 0.0, (byte)1);
        this.displayPtChanged(this._cp0);
    }

    private void displayPtChanged(CPoint cp) {
        CTransform display2img = this.getTransform((byte)1, (byte)0);
        display2img.transform(cp, this.tempImgPt);
        if (this.tempImgPt.x >= 0.0 && this.tempImgPt.x < (double)this.width && this.tempImgPt.y >= 0.0 && this.tempImgPt.y < (double)this.height) {
            this.img_pt.set(this.tempImgPt);
            this.repaint();
            CTransform image2ras = this.getTransform((byte)0, (byte)2);
            image2ras.transform(this.img_pt, this.ras_pt);
            this.notifyCursorChange();
        }
    }

    public synchronized void addChangeListener(ChangeListener ccl) {
        if (ccl == null) {
            throw new NullPointerException();
        }
        if (!this.listeners.contains(ccl)) {
            this.listeners.addElement(ccl);
        }
    }

    public synchronized void removeChangeListener(ChangeListener ccl) {
        this.listeners.removeElement(ccl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyCursorChange() {
        LinkedCursorVc linkedCursorVc = this;
        synchronized (linkedCursorVc) {
            ChangeListener[] list = this.listeners.toArray(new ChangeListener[0]);
            ChangeEvent event = new ChangeEvent(this);
            for (int i2 = 0; i2 < list.length; ++i2) {
                list[i2].stateChanged(event);
            }
        }
    }

    public CPoint getRASPoint() {
        return (CPoint)this.ras_pt.clone();
    }

    public void setRASPoint(CPoint rasPt) {
        CTransform ras2image = this.getTransform((byte)2, (byte)0);
        ras2image.transform(rasPt, this.img_pt);
        this.repaint();
        CTransform image2ras = this.getTransform((byte)0, (byte)2);
        image2ras.transform(this.img_pt, this.ras_pt);
    }
}

