/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.comparators;

import com.ge.med.terra.jami.XpDicomElement;
import com.ge.med.terra.tap.dm.DMObject;
import java.util.Arrays;
import java.util.Comparator;

public class SeriesNumberComparator
implements Comparator {
    public String name_ = "base_series_number";
    public boolean ascending = true;

    public int compare(Object o1, Object o2) {
        try {
            if (o1 instanceof DMObject && o2 instanceof DMObject) {
                DMObject obj1 = (DMObject)o1;
                DMObject obj2 = (DMObject)o2;
                if (obj1 == null) {
                    return -1;
                }
                if (obj2 == null) {
                    return 1;
                }
                int sn1 = 0;
                int sn2 = 0;
                if (obj1.getType().equalsIgnoreCase("series")) {
                    XpDicomElement dicomElem = new XpDicomElement(32, 17);
                    dicomElem.value = obj1.getValue(dicomElem.group, dicomElem.element);
                    sn1 = dicomElem.getIntValue();
                    dicomElem.value = obj2.getValue(dicomElem.group, dicomElem.element);
                    sn2 = dicomElem.getIntValue();
                    return SeriesNumberComparator.compareObject(sn1, sn2, this.ascending);
                }
                return 0;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 0;
    }

    private static int compareObject(int sn1, int sn2, boolean ascending) {
        int s2;
        int s1 = SeriesNumberComparator.getValToCompare(sn1);
        if (s1 == (s2 = SeriesNumberComparator.getValToCompare(sn2))) {
            s1 = sn1;
            s2 = sn2;
        }
        if (ascending) {
            if (s1 < s2) {
                return -1;
            }
            if (s1 > s2) {
                return 1;
            }
            return 0;
        }
        if (s1 > s2) {
            return -1;
        }
        if (s1 < s2) {
            return 1;
        }
        return 0;
    }

    private static int getValToCompare(int val) {
        if (val >= 0 && val < 100) {
            return val;
        }
        if (val > 99 && val < 10000) {
            return (int)Math.floor((double)val / 100.0);
        }
        if (val >= 10000) {
            while (val >= 10000) {
                val -= 10000;
            }
            return SeriesNumberComparator.getValToCompare(val);
        }
        return -1;
    }

    public static void main(String[] args) {
        int i2;
        String[] inputArray = new String[]{"4999", "1", "2", "90499", "3", "4", "100", "499", "190499", "5", "10003", "99", "99999", "98", "201", "50499", "400", "199999", "14999", "6", "10400", "401", "9999", "10499", "49", "29999", "10049", "511", "19999"};
        String[] expectedOutputArray = new String[]{"1", "100", "2", "201", "3", "10003", "4", "400", "401", "499", "10400", "10499", "50499", "90499", "190499", "5", "511", "6", "49", "4999", "10049", "14999", "98", "99", "9999", "19999", "29999", "99999", "199999"};
        Arrays.sort(inputArray, new Comparator(){

            public int compare(Object o1, Object o2) {
                if (o1 instanceof String && o2 instanceof String) {
                    String obj1 = (String)o1;
                    String obj2 = (String)o2;
                    if (obj1 == null) {
                        return -1;
                    }
                    if (obj2 == null) {
                        return 1;
                    }
                    int sn1 = 0;
                    int sn2 = 0;
                    try {
                        sn1 = Integer.parseInt(obj1);
                        sn2 = Integer.parseInt(obj2);
                        return SeriesNumberComparator.compareObject(sn1, sn2, true);
                    }
                    catch (NumberFormatException ex) {
                        return 0;
                    }
                }
                return 0;
            }
        });
        System.err.println("------------- Input vs Expected Output -----------");
        for (i2 = 0; i2 < inputArray.length; ++i2) {
            System.err.println(inputArray[i2] + " - " + expectedOutputArray[i2]);
        }
        for (i2 = 0; i2 < inputArray.length; ++i2) {
            if (inputArray[i2].equals(expectedOutputArray[i2])) continue;
            System.err.println("----------- Test Failed ---------");
            return;
        }
        System.err.println("----------- Test Passed ---------");
    }
}

