/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.controls;

import com.ge.med.terra.jami.XpMouseController;
import com.ge.med.terra.xpv.mouseController.LeftMouseButtonController;
import com.ge.med.terra.xpv.mouseController.LeftMouseButtonModeCapable;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MouseInputAdapter;

public class CvConfigurableMouseController
extends LeftMouseButtonController {
    HashMap<Integer, AbstractButton> modeMap = new HashMap();
    protected HashMap<Integer, Boolean> componentVisibleMap = new HashMap();
    private ArrayList<ChangeListener> changeListeners = new ArrayList();
    protected JPopupMenu popup_ = new JPopupMenu();
    private ChangeEvent changeEvent;
    List actionsList = new ArrayList();

    public CvConfigurableMouseController() {
        this.impl_.addMouseController(new MenuController(), 4096);
    }

    @Override
    public void addChangeListener(ChangeListener l2) {
        this.changeListeners.add(l2);
    }

    @Override
    public void removeChangeListener(ChangeListener l2) {
        this.changeListeners.remove(l2);
    }

    @Override
    protected void fireStateChanged() {
        ListIterator<ChangeListener> iter = this.changeListeners.listIterator();
        while (iter.hasNext()) {
            ChangeListener l2 = (ChangeListener)iter.next();
            if (this.changeEvent == null) {
                this.changeEvent = new ChangeEvent(this);
            }
            l2.stateChanged(this.changeEvent);
        }
    }

    @Override
    public void installController(XpMouseController controller, int mode) {
        super.installController(controller, mode);
        this.refreshMenu();
    }

    protected void refreshMenu() {
        this.popup_.setName(CvConfigurableMouseController.class.getName() + "popup_");
        Component[] allComp = this.popup_.getComponents();
        int size = allComp.length;
        for (int i2 = 0; i2 < size; ++i2) {
            if (!(allComp[i2] instanceof AbstractButton)) continue;
            AbstractButton abstractButton = (AbstractButton)allComp[i2];
            ActionListener[] allListener = abstractButton.getActionListeners();
            for (int j2 = 0; j2 < allListener.length; ++j2) {
                abstractButton.removeActionListener(allListener[j2]);
            }
            this.componentVisibleMap.put(i2, allComp[i2].isEnabled());
        }
        this.changeListeners.clear();
        this.modeMap.clear();
        this.popup_.removeAll();
        int[] modes = this.getSupportedModes();
        ButtonGroup bg = new ButtonGroup();
        int selected = this.getLeftMouseButtonMode();
        for (int i3 = 0; i3 < modes.length; ++i3) {
            String name = (String)this.getModeProperty(modes[i3], "name_property");
            Icon ico = (Icon)this.getModeProperty(modes[i3], "icon_property");
            if (name == null) {
                name = "Unknown mode";
            }
            JRadioButtonMenuItem btn = new JRadioButtonMenuItem(name, ico);
            if (selected == modes[i3]) {
                btn.setSelected(true);
            }
            this.popup_.add(btn);
            bg.add(btn);
            final int modesi = modes[i3];
            btn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e2) {
                    CvConfigurableMouseController.this.setLeftMouseButtonMode(modesi);
                }
            });
            this.modeMap.put(modesi, btn);
            ChangeListener changeListener = new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e2) {
                    if (((LeftMouseButtonModeCapable)e2.getSource()).getLeftMouseButtonMode() == modesi) {
                        CvConfigurableMouseController.this.modeMap.get(modesi).setSelected(true);
                    }
                }
            };
            this.addChangeListener(changeListener);
        }
        ListIterator iter = this.actionsList.listIterator();
        while (iter.hasNext()) {
            this.popup_.addSeparator();
            List element = (List)iter.next();
            for (Action action : element) {
                this.popup_.add(action);
            }
        }
        this.actionsList.clear();
        allComp = this.popup_.getComponents();
        size = allComp.length;
        for (int i4 = 0; i4 < size; ++i4) {
            if (!(allComp[i4] instanceof AbstractButton)) continue;
            AbstractButton button = (AbstractButton)allComp[i4];
            if (this.componentVisibleMap.get(i4) == null) continue;
            button.setEnabled(this.componentVisibleMap.get(i4));
        }
    }

    public void addActionGroup(List actions) {
        this.actionsList.add(actions);
        this.refreshMenu();
    }

    public void addActionRadioGroup(List actions, int defaultIndex) {
    }

    public void addActionCheckGroup(List actions, List defaults) {
    }

    protected class MenuController
    extends MouseInputAdapter
    implements XpMouseController {
        protected MenuController() {
        }

        @Override
        public void setTarget(JComponent jc) {
        }

        @Override
        public void mousePressed(MouseEvent e2) {
            this.showMenu(e2);
        }

        private void showMenu(MouseEvent e2) {
            if (!CvConfigurableMouseController.this.popup_.isShowing()) {
                CvConfigurableMouseController.this.popup_.show(e2.getComponent(), e2.getX(), e2.getY());
            }
        }

        @Override
        public void mouseReleased(MouseEvent e2) {
            this.showMenu(e2);
        }

        @Override
        public void mouseClicked(MouseEvent e2) {
            this.showMenu(e2);
        }
    }
}

