/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.controls;

import com.ge.med.cse.cvf.commands.CommandControl;
import com.ge.med.cse.cvf.controls.CvConfigurableMouseController;
import com.ge.med.cse.cvf.controls.CvMouseControlManager;
import com.ge.med.cse.cvf.util.CvPropertiesManager;
import com.ge.med.cse.cvf.util.CvResourceBundle;
import com.ge.med.cse.cvf.util.CvUtils;
import com.ge.med.idc.Capable;
import com.ge.med.terra.jami.XpMouseController;
import com.ge.med.terra.xpv.base.PlasmaControl;
import com.ge.med.terra.xpv.base.XPscreen;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;

public class CvMouseController
extends CvConfigurableMouseController {
    private JComponent target = null;
    public List<Action> actonList = new ArrayList<Action>();
    public List<JMenuItem> menuItemList = new ArrayList<JMenuItem>();
    public Vector<Action> subMenuActionList = new Vector();
    private XPscreen screen = null;
    private Logger logger = Logger.getLogger(this.getClass().getName());
    String modality = "";
    boolean propAdded = false;
    private static int prevMode = 0;
    private static boolean cinePropAdded = false;
    private Properties prop = null;
    private List<Integer> mouseControllerModes = new ArrayList<Integer>();
    private String name_prefix = null;
    private static final String mouseMenuControllerPrefix = "MouseMenu.Controller.";
    private static final String leftMouseBindingCountSuffix = "count";
    private static final String mouseModeSuffix = ".mode";
    private static final String mouseModeOverwriteSuffix = ".overwrite";
    private static final String mouseControllerNameSuffix = ".name";
    private static final String mouseControllerTooltipSuffix = ".tooltip";
    private static final String mouseControllerShortDescSuffix = ".shortdesc";
    private static final String mouseControllerIconSuffix = ".icon";
    private static final String mouseControllerSelectedIconSuffix = ".selectedicon";
    private static final String mouseMiddleButtonModeSuffix = "MouseMiddleButtonMode";
    private static final String mouseMenuPrefix = "MouseMenu.";
    private PropertyChangeListener mouseModeChangeListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            int newMode = CvMouseControlManager.getInstance().getMouseMode();
            if (CvMouseController.this.getLeftMouseButtonMode() != newMode) {
                CvMouseController.this.setLeftMouseButtonMode(newMode);
            }
        }
    };
    private AncestorListener alistner = new AncestorListener(){

        @Override
        public void ancestorAdded(AncestorEvent event) {
            JComponent ancestor = event.getComponent();
            CvMouseController.this.setScreen((XPscreen)SwingUtilities.getAncestorOfClass(XPscreen.class, ancestor));
        }

        @Override
        public void ancestorMoved(AncestorEvent event) {
        }

        @Override
        public void ancestorRemoved(AncestorEvent event) {
        }
    };
    PropertyChangeListener cineListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equalsIgnoreCase("Cine")) {
                CvMouseControlManager manager = CvMouseControlManager.getInstance();
                boolean isCineOn = (Boolean)evt.getNewValue();
                String modesOnCine = CvMouseController.this.prop.getProperty("MouseModesEnabledDuringCineOn");
                if (modesOnCine == null) {
                    return;
                }
                String[] modesOnDuringCine = modesOnCine.split(",");
                ArrayList<Integer> modesOnDrngCine = new ArrayList<Integer>();
                for (int i2 = 0; i2 < modesOnDuringCine.length; ++i2) {
                    modesOnDrngCine.add(Integer.valueOf(modesOnDuringCine[i2].trim()));
                }
                if (modesOnDrngCine.size() > 0) {
                    if (isCineOn) {
                        prevMode = manager.getMouseMode();
                        if (!modesOnDrngCine.contains(prevMode)) {
                            CvMouseController.this.setLeftMouseButtonMode(Integer.parseInt(CvMouseController.this.prop.getProperty("DefaultMouseModeDuringCineOn", "3")));
                        }
                    } else {
                        CvMouseController.this.setLeftMouseButtonMode(prevMode);
                    }
                }
            }
        }
    };

    public CvMouseController() {
        this.prop = CvPropertiesManager.getProperties();
    }

    public CvMouseController(Properties properties) {
        this.prop = properties == null ? CvPropertiesManager.getProperties() : properties;
    }

    public CvMouseController(String name, Properties properties) {
        this.prop = properties == null ? CvPropertiesManager.getProperties() : properties;
        this.name_prefix = name;
    }

    public void setPropreties(Properties properties) {
        this.prop.clear();
        this.prop.putAll((Map<?, ?>)properties);
    }

    public void setName(String name) {
        this.name_prefix = name;
        if (this.target != null) {
            this.updatemenu(null);
        }
    }

    private void updatemenu(String mod) {
        CvMouseControlManager mcManager;
        block31: {
            this.modality = CvUtils.getCurrentModality((Capable)((Object)this.target));
            if (this.modality != null) {
                this.modality = this.modality.toLowerCase();
            }
            String menuprefix = "";
            if (this.name_prefix != null && !this.name_prefix.equals("")) {
                menuprefix = this.name_prefix + ".";
            }
            String prefix = menuprefix + mouseMenuControllerPrefix;
            try {
                this.mouseControllerModes.clear();
                String p2 = prefix + leftMouseBindingCountSuffix + "." + this.modality;
                String mouseActionCountString = this.prop.getProperty(p2, this.prop.getProperty(prefix + leftMouseBindingCountSuffix));
                if (mouseActionCountString != null) {
                    int count = Integer.parseInt(mouseActionCountString);
                    XpMouseController contoller = null;
                    for (int i2 = 0; i2 < count; ++i2) {
                        String compName = this.prop.getProperty(prefix + String.valueOf(i2));
                        while (compName == null || compName == "") {
                            ++count;
                            compName = this.prop.getProperty(prefix + String.valueOf(++i2));
                        }
                        Class<?> compClsass = Class.forName(compName);
                        contoller = (XpMouseController)compClsass.newInstance();
                        String modeString = this.prop.getProperty(prefix + String.valueOf(i2) + mouseModeSuffix);
                        int mode = Integer.parseInt(modeString.trim());
                        String overwriteString = this.prop.getProperty(prefix + String.valueOf(i2) + mouseModeOverwriteSuffix);
                        boolean isOverwrite = Boolean.valueOf(overwriteString);
                        if (isOverwrite) {
                            String name = this.prop.getProperty(prefix + String.valueOf(i2) + mouseControllerNameSuffix);
                            String tooltip = CvUtils.getResourceBundle().getString(prefix + name + mouseControllerTooltipSuffix);
                            this.putModeProperty(mode, "name_property", tooltip);
                            String shortDesc = CvUtils.getResourceBundle().getString(prefix + name + mouseControllerShortDescSuffix);
                            this.putModeProperty(mode, "short_description_property", shortDesc);
                            ImageIcon icon = (ImageIcon)CvUtils.getIcon(prefix + name + mouseControllerIconSuffix);
                            this.putModeProperty(mode, "icon_property", icon);
                            Icon selectedIcon = CvUtils.getIcon(prefix + name + mouseControllerSelectedIconSuffix);
                            this.putModeProperty(mode, "selected_icon_property", selectedIcon);
                            if (icon != null) {
                                Cursor cursor = Toolkit.getDefaultToolkit().createCustomCursor(icon.getImage(), new Point(icon.getIconWidth() / 2, icon.getIconHeight() / 2), name);
                                this.putModeProperty(mode, "cursor_property", cursor);
                            }
                        } else if (this.getModeProperty(mode, "name_property") == null && CvMouseController.getMouseModeProperty(mode, "name_property") != null) {
                            this.putModeProperty(mode, "name_property", CvMouseController.getMouseModeProperty(mode, "name_property"));
                            this.putModeProperty(mode, "short_description_property", CvMouseController.getMouseModeProperty(mode, "short_description_property"));
                            this.putModeProperty(mode, "icon_property", CvMouseController.getMouseModeProperty(mode, "icon_property"));
                            this.putModeProperty(mode, "selected_icon_property", CvMouseController.getMouseModeProperty(mode, "selected_icon_property"));
                            this.putModeProperty(mode, "cursor_property", CvMouseController.getMouseModeProperty(mode, "cursor_property"));
                        } else if (this.getModeProperty(mode, "name_property") == null) {
                            this.putModeProperty(mode, "name_property", CvMouseController.getMouseModeProperty(mode, "name_property"));
                        }
                        this.setMouseControllerModes(mode);
                        this.installController(contoller, mode);
                    }
                }
            }
            catch (Exception e2) {
                this.logger.log(Level.WARNING, "Unable to install Mouse Controllers. " + e2.getLocalizedMessage());
            }
            mcManager = CvMouseControlManager.getInstance();
            if (mcManager.getMouseMode() != -1) {
                this.setLeftMouseButtonMode(mcManager.getMouseMode());
            } else {
                int defaultSelectionMode = Integer.parseInt(this.prop.getProperty(prefix + "defaultMode"));
                this.setLeftMouseButtonMode(defaultSelectionMode);
                mcManager.setMouseMode(defaultSelectionMode);
            }
            int middleBtnMode = Integer.parseInt(this.prop.getProperty(menuprefix + mouseMiddleButtonModeSuffix));
            this.setMiddleButtonMode(middleBtnMode);
            try {
                String mouseActionCountStirng = this.prop.getProperty(menuprefix + mouseMenuPrefix + "group.count." + this.modality, this.prop.getProperty(menuprefix + mouseMenuPrefix + "group.count"));
                if (mouseActionCountStirng == null) break block31;
                int groupCount = Integer.parseInt(mouseActionCountStirng);
                Action act = null;
                JPopupMenu popmenu = this.popup_;
                popmenu.setName("CvMouseControllerPopupMenu");
                this.subMenuActionList.clear();
                for (int i3 = 0; i3 < groupCount; ++i3) {
                    ArrayList<Action> list = new ArrayList<Action>();
                    int count = Integer.parseInt(this.prop.getProperty(menuprefix + mouseMenuPrefix + String.valueOf(i3) + ".count" + "." + this.modality, this.prop.getProperty(menuprefix + mouseMenuPrefix + String.valueOf(i3) + ".count")));
                    if (count != 0) {
                        popmenu.addSeparator();
                    }
                    for (int j2 = 0; j2 < count; ++j2) {
                        String subCountStr = this.prop.getProperty(menuprefix + mouseMenuPrefix + String.valueOf(i3) + "." + String.valueOf(j2) + ".count." + this.modality, this.prop.getProperty(menuprefix + mouseMenuPrefix + String.valueOf(i3) + "." + String.valueOf(j2) + ".count"));
                        if (subCountStr != null) {
                            String templabel;
                            int subCount = Integer.parseInt(subCountStr);
                            String label = templabel = this.prop.getProperty(menuprefix + mouseMenuPrefix + String.valueOf(i3) + "." + String.valueOf(j2) + ".label");
                            CvResourceBundle bundle = new CvResourceBundle();
                            try {
                                label = bundle.getString(templabel);
                            }
                            catch (Exception e3) {
                                // empty catch block
                            }
                            JMenu menu = new JMenu(label);
                            for (int k2 = 0; k2 < subCount; ++k2) {
                                String subSubStr = this.prop.getProperty(menuprefix + mouseMenuPrefix + String.valueOf(i3) + "." + String.valueOf(j2) + "." + String.valueOf(k2) + ".count." + this.modality, this.prop.getProperty(menuprefix + mouseMenuPrefix + String.valueOf(i3) + "." + String.valueOf(j2) + "." + String.valueOf(k2) + ".count"));
                                if (subSubStr != null) {
                                    String tempsubMenuTitile;
                                    int subsubCount = Integer.parseInt(subSubStr);
                                    label = tempsubMenuTitile = this.prop.getProperty(menuprefix + mouseMenuPrefix + String.valueOf(i3) + "." + String.valueOf(j2) + "." + String.valueOf(k2) + ".label");
                                    try {
                                        label = bundle.getString(tempsubMenuTitile);
                                    }
                                    catch (Exception e4) {
                                        // empty catch block
                                    }
                                    JMenu subMenu = new JMenu(label);
                                    menu.add(subMenu);
                                    for (int l2 = 0; l2 < subsubCount; ++l2) {
                                        String classname = this.prop.getProperty(menuprefix + mouseMenuPrefix + String.valueOf(i3) + "." + String.valueOf(j2) + "." + String.valueOf(k2) + "." + String.valueOf(l2));
                                        Action subAct = (Action)Class.forName(classname).newInstance();
                                        String param = this.prop.getProperty(menuprefix + mouseMenuPrefix + String.valueOf(i3) + "." + String.valueOf(j2) + "." + String.valueOf(k2) + "." + String.valueOf(l2) + ".param");
                                        if (subAct instanceof CommandControl && param != null) {
                                            CommandControl ctrl = (CommandControl)((Object)subAct);
                                            String[] params = param.split(",");
                                            ctrl.setParams(params);
                                        }
                                        subMenu.add(new JMenuItem(subAct));
                                        this.subMenuActionList.add(subAct);
                                        popmenu.add(menu);
                                    }
                                    continue;
                                }
                                String classname = this.prop.getProperty(menuprefix + mouseMenuPrefix + String.valueOf(i3) + "." + String.valueOf(j2) + "." + String.valueOf(k2));
                                String param = this.prop.getProperty(menuprefix + mouseMenuPrefix + String.valueOf(i3) + "." + String.valueOf(j2) + "." + String.valueOf(k2) + ".param");
                                Action subAct = (Action)Class.forName(classname).newInstance();
                                if (subAct instanceof CommandControl && param != null) {
                                    CommandControl ctrl = (CommandControl)((Object)subAct);
                                    String[] params = param.split(",");
                                    ctrl.setParams(params);
                                }
                                JMenuItem item = new JMenuItem(subAct);
                                menu.add(item);
                                this.subMenuActionList.add(subAct);
                                popmenu.add(menu);
                            }
                            continue;
                        }
                        String compName = this.prop.getProperty(menuprefix + mouseMenuPrefix + String.valueOf(i3) + "." + String.valueOf(j2));
                        Class<?> compClsass = Class.forName(compName);
                        act = (Action)compClsass.newInstance();
                        list.add(act);
                    }
                    this.addActionGroup(list);
                    this.actonList.addAll(list);
                }
            }
            catch (Exception e5) {
                e5.printStackTrace();
                this.logger.log(Level.WARNING, "Unable to install Mouse Actions. " + e5.getLocalizedMessage());
            }
        }
        if (Boolean.valueOf(this.prop.getProperty("EnableMouseModeSetting", "true")).booleanValue()) {
            mcManager.removePropertyChangeListener(this.mouseModeChangeListener);
            mcManager.addPropertyChangeListener(this.mouseModeChangeListener);
        }
    }

    private void setScreen(XPscreen scr) {
        if (scr != null && this.screen != scr) {
            this.screen = scr;
            this.modality = CvUtils.getCurrentModality(scr);
        }
        if (this.screen == null) {
            this.screen = (XPscreen)SwingUtilities.getAncestorOfClass(XPscreen.class, this.target);
            this.modality = CvUtils.getCurrentModality((Capable)((Object)this.target));
        }
        if (this.screen != null) {
            for (int i2 = 0; i2 < this.actonList.size(); ++i2) {
                Action act = this.actonList.get(i2);
                if (!(act instanceof PlasmaControl)) continue;
                ((PlasmaControl)((Object)act)).setCapable(this.screen);
            }
            int submenuActionCount = this.subMenuActionList.size();
            for (int i3 = 0; i3 < submenuActionCount; ++i3) {
                Action act = this.subMenuActionList.get(i3);
                if (!(act instanceof PlasmaControl)) continue;
                ((PlasmaControl)((Object)act)).setCapable(this.screen);
            }
        }
        if (!cinePropAdded && this.screen != null) {
            this.screen.addPropertyChangeListener("Cine", this.cineListener);
            cinePropAdded = true;
        }
    }

    @Override
    public void addActionGroup(List actions) {
        if (actions.size() == 0) {
            return;
        }
        ListIterator iter = actions.listIterator();
        while (iter.hasNext()) {
            this.menuItemList.add(this.popup_.add((Action)iter.next()));
        }
    }

    @Override
    public void setTarget(JComponent vc) {
        this.screen = (XPscreen)SwingUtilities.getAncestorOfClass(XPscreen.class, vc);
        this.updatemenu(this.modality);
        this.setScreen(this.screen);
        CvMouseControlManager mcManager = CvMouseControlManager.getInstance();
        mcManager.removePropertyChangeListener(this.mouseModeChangeListener);
        if (this.target != null) {
            this.target.removeAncestorListener(this.alistner);
        }
        this.target = vc;
        super.setTarget(vc);
        if (this.target != null) {
            vc.addAncestorListener(this.alistner);
            mcManager.addPropertyChangeListener(this.mouseModeChangeListener);
            if (mcManager.getMouseMode() != -1) {
                this.setLeftMouseButtonMode(mcManager.getMouseMode());
            }
        }
    }

    @Override
    public void setLeftMouseButtonMode(int mode) {
        if (this.impl_ != null) {
            this.impl_.setTarget(null);
            super.setLeftMouseButtonMode(mode);
            this.impl_.setTarget(this.target);
            CvMouseControlManager.getInstance().setMouseMode(mode);
        }
    }

    @Override
    public void mousePressed(MouseEvent e2) {
        if (e2.getModifiersEx() == 1024 || e2.getModifiersEx() == 2048 || e2.getModifiersEx() == 4096) {
            String currentModality;
            if (!this.isMouseMenuShown(e2)) {
                return;
            }
            if (this.target instanceof Capable && (currentModality = CvUtils.getCurrentModality((Capable)((Object)this.target))) != null && !currentModality.equalsIgnoreCase(this.modality)) {
                this.updatemenu(currentModality);
                this.setScreen(this.screen);
                this.modality = currentModality;
            }
            super.mousePressed(e2);
        }
    }

    @Override
    public void mouseClicked(MouseEvent e2) {
        if (e2.getModifiersEx() == 1024 || e2.getModifiersEx() == 2048 || e2.getModifiersEx() == 4096) {
            if (!this.isMouseMenuShown(e2)) {
                return;
            }
            super.mouseClicked(e2);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e2) {
        if (!this.isMouseMenuShown(e2)) {
            return;
        }
        super.mouseReleased(e2);
    }

    private void setMouseControllerModes(int mode) {
        if (mode >= 0) {
            this.mouseControllerModes.add(mode);
        }
    }

    @Override
    public int[] getSupportedModes() {
        int[] res = new int[this.mouseControllerModes.size()];
        if (res.length > 0) {
            int i2 = 0;
            for (Integer type : this.mouseControllerModes) {
                res[i2++] = type;
            }
        }
        return res;
    }

    private boolean isMouseMenuShown(MouseEvent e2) {
        if (this.screen != null) {
            return !CvUtils.isCinePlaying(this.screen) || e2.getButton() != 3;
        }
        return true;
    }
}

