/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.cpanels;

import com.ge.med.ptk.laf.CuiSliderUI;
import com.ge.med.terra.xpv.autoControls.XPwCineRateSlider2;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;

class XPwCineRateSlider3
extends XPwCineRateSlider2 {
    private int noSkipFrameRate;
    private boolean isCineOn = false;

    public XPwCineRateSlider3() {
        this.setMaximum(50);
    }

    public void setNoSkipFrameRate(int rate) {
        this.noSkipFrameRate = rate;
        this.repaint();
    }

    public void setCineOn(boolean onOff) {
        this.isCineOn = onOff;
        this.repaint();
    }

    @Override
    public void updateUI() {
        this.setUI(new NumberedThumbSliderUI2());
        this.updateLabelUIs();
    }

    @Override
    public void paintComponent(Graphics g2) {
        super.paintComponent(g2);
        if (this.isCineOn && this.noSkipFrameRate > 0) {
            Graphics2D g22 = (Graphics2D)g2;
            Rectangle rect = this.getThumbRect();
            g22.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            FontMetrics fm = g22.getFontMetrics();
            String valString = "" + this.noSkipFrameRate;
            int sw = fm.stringWidth(valString);
            Rectangle track = this.getTrackRect();
            int x2 = track.x + (int)((double)(track.width * this.noSkipFrameRate) / (double)(this.getMaximum() - this.getMinimum()));
            g22.setColor(new Color(0.1f, 0.1f, 0.1f, 0.7f));
            g22.drawString(valString, x2 - sw / 2, rect.y);
            g22.setColor(new Color(1.0f, 0.5f, 0.1f, 1.0f));
            g22.fillRect(x2, rect.y + (rect.height - 4) / 2, 3, 5);
        }
    }

    public Rectangle getTrackRect() {
        return ((NumberedThumbSliderUI2)this.getUI()).getTrackRect();
    }

    @Override
    public Rectangle getThumbRect() {
        return ((NumberedThumbSliderUI2)this.getUI()).getThumbRect();
    }

    class NumberedThumbSliderUI2
    extends CuiSliderUI {
        NumberedThumbSliderUI2() {
        }

        public Rectangle getTrackRect() {
            return this.trackRect;
        }

        public Rectangle getThumbRect() {
            return this.thumbRect;
        }
    }
}

