/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.cpanels;

import com.ge.med.cse.cvf.util.CvPropertiesManager;
import com.ge.med.cse.cvf.util.CvUtils;
import com.ge.med.idc.ColorMapCapable;
import com.ge.med.idc.WindowLevelCapable;
import com.ge.med.terra.jami.capable.FrameCapable;
import com.ge.med.terra.xpv.autoControls.XPcaAutoControlPanel;
import com.ge.med.terra.xpv.base.XPscreen;
import com.ge.med.terra.xpv.base.XPscreenLayout;
import com.ge.med.terra.xpv.cuiPanels.TransactionLogName;
import com.ge.med.terra.xpv.ui.SubTitlePanel;
import com.ge.med.terra.xpv.util.XPutil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.SwingConstants;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class XpColorMapPanel
extends XPcaAutoControlPanel {
    static ResourceBundle res = CvUtils.getResourceBundle();
    private HashMap cmapIndex1 = new HashMap();
    private HashMap cmapIndex2 = new HashMap();
    SubTitlePanel subTitlePanel = new SubTitlePanel();
    JList cmapList = new JList();
    DefaultListModel model = new DefaultListModel();
    boolean flipflop = true;
    int preIndex = 0;
    Logger logger = Logger.getLogger("com.ge.med.cse.cvf.cpanels");
    boolean uiIntiated = false;
    PropertyChangeListener vpListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            block5: {
                block4: {
                    if (!evt.getPropertyName().equals("ComponentSelection")) break block4;
                    XPscreenLayout layout = XpColorMapPanel.this.getScreen().getScreenLayout();
                    if (layout.getNoOfPorts() <= 1) break block5;
                    XpColorMapPanel.this.updateColorMap();
                    break block5;
                }
                if (evt.getPropertyName().equals("COLOR_MAP")) {
                    XpColorMapPanel.this.updateColorMap();
                } else if (evt.getPropertyName().equalsIgnoreCase("gse") && !evt.getNewValue().equals("None")) {
                    for (int i2 = 0; i2 < XpColorMapPanel.this.cmapList.getModel().getSize(); ++i2) {
                        if (!((ColorMapLabel)XpColorMapPanel.this.cmapList.getModel().getElementAt(i2)).getColor().equalsIgnoreCase("gray")) continue;
                        XpColorMapPanel.this.cmapList.setSelectedIndex(i2);
                        break;
                    }
                }
            }
        }
    };

    public XpColorMapPanel() {
        TransactionLogName tln = new TransactionLogName("TID=CreateColorMapPanel");
        this.logger.log(Level.FINE, "{0} begin Creating ColorMap Panel", tln);
        this.setName("XpColorMapPanel");
        this.setIcon(CvUtils.getIcon("XP_COLOR_MAP_ICON"));
        this.cmapList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e2) {
                if (!e2.getValueIsAdjusting()) {
                    XpColorMapPanel.this.this_valueChanged(e2);
                }
            }
        });
        if (!CvPropertiesManager.getBoolean("isLazyLoading", false)) {
            try {
                this.jbInit();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            this.uiIntiated = true;
        }
        this.logger.log(Level.FINE, "{0} end Creating ColorMap Panel", tln);
    }

    @Override
    public void panelStart() {
        super.panelStart();
        if (CvPropertiesManager.getBoolean("isLazyLoading", false) && !this.uiIntiated) {
            try {
                this.jbInit();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            CvUtils.updateBackground(this, UIManager.getColor("P9"));
            this.uiIntiated = true;
        }
    }

    void this_valueChanged(ListSelectionEvent e2) {
        FrameCapable fc;
        ColorMapCapable cmc = (ColorMapCapable)this.getScreen().getCapable(ColorMapCapable.class.getName());
        if (cmc == null) {
            return;
        }
        String cname = (String)this.cmapIndex2.get(this.cmapList.getSelectedValue());
        if (cname.equalsIgnoreCase("inverse gray")) {
            WindowLevelCapable wlc = (WindowLevelCapable)this.getScreen().getCapable(WindowLevelCapable.class.getName());
            if (wlc != null) {
                wlc.setVideoInverted(!wlc.isVideoInverted());
            }
        } else if (cname.equalsIgnoreCase("gray") || cname.equalsIgnoreCase("none")) {
            cmc.setColorMap(null);
        } else if (cmc instanceof FrameCapable && (fc = (FrameCapable)((Object)cmc)).getFrame() != null && CvUtils.measurementsValid(fc.getFrame())) {
            cmc.setColorMap(XPutil.getColorTable(cname));
        }
    }

    private void jbInit() throws Exception {
        this.setBackground(null);
        this.cmapList.setCellRenderer(new JListRenderer());
        this.cmapList.setSelectionMode(0);
        this.cmapList.setSelectedIndex(0);
        this.cmapList.setName("COLOR_MAP_LIST");
        this.setLayout(new BorderLayout());
        JScrollPane JSPane = new JScrollPane(this.cmapList, 20, 31);
        JSPane.setPreferredSize(new Dimension(200, 222));
        JPanel pane = new JPanel(new FlowLayout());
        pane.add(JSPane);
        this.add((Component)pane, "North");
    }

    private void updateColorMap() {
        ColorMapCapable cmapcp = (ColorMapCapable)this.screen_.getCapable(ColorMapCapable.class.getName());
        if (cmapcp != null) {
            String[] toLookup = CvPropertiesManager.getProperty("colorMaps", "").split(",");
            int[] appliedCmap = cmapcp.getColorMap();
            if (appliedCmap != null) {
                String colorName = null;
                for (String cmap : toLookup) {
                    if (!Arrays.equals(appliedCmap, XPutil.getColorTable(cmap))) continue;
                    colorName = cmap;
                    break;
                }
                for (int i2 = 0; i2 < this.model.getSize(); ++i2) {
                    if (!((ColorMapLabel)this.model.getElementAt(i2)).getColor().trim().equalsIgnoreCase(colorName)) continue;
                    this.cmapList.setSelectedIndex(i2);
                }
            } else {
                this.cmapList.setSelectedIndex(0);
            }
        }
    }

    @Override
    public void setScreen(XPscreen screen) {
        super.setScreen(screen);
        screen.removePropertyChangeListener(this.vpListener);
        screen.addPropertyChangeListener(this.vpListener);
    }

    @Override
    public void setProperties(Properties properties) {
        String color_eng = properties.getProperty("colorMaps");
        String color = res.getString("ColorMapPanel.colorMaps");
        StringTokenizer st = new StringTokenizer(color, ",");
        StringTokenizer st_eng = new StringTokenizer(color_eng, ",");
        this.model.clear();
        while (st.hasMoreTokens()) {
            String colorText = st.nextToken();
            String colorText_eng = st_eng.nextToken();
            ColorMapLabel colorVal = new ColorMapLabel(colorText_eng);
            this.cmapIndex1.put(colorText_eng, colorText);
            this.cmapIndex2.put(colorVal, colorText_eng);
            this.model.addElement(colorVal);
        }
        this.cmapList.setModel(this.model);
    }

    @Override
    public String getTitle() {
        return CvUtils.getResourceBundle().getString("XP_COLOR_MAP_TITLE");
    }

    @Override
    public String getName() {
        return CvUtils.getResourceBundle().getString("XP_COLOR_MAP_TITLE");
    }

    public class ColorMapLabel
    implements Icon,
    SwingConstants {
        int[] cmap;
        String color;
        int[] cmap1;

        public ColorMapLabel(String color) {
            this.cmap = XPutil.getColorTable(color);
            this.color = color;
            if (color.equalsIgnoreCase("inverse gray")) {
                this.cmap = XPutil.getColorTable("gray");
                this.cmap1 = new int[this.cmap.length];
                int j2 = this.cmap.length - 1;
                for (int i2 = 0; i2 < this.cmap.length; ++i2) {
                    this.cmap1[j2] = this.cmap[i2];
                    --j2;
                }
            }
        }

        public String getColor() {
            return this.color;
        }

        @Override
        public int getIconWidth() {
            return 50;
        }

        @Override
        public int getIconHeight() {
            return 20;
        }

        @Override
        public void paintIcon(Component c2, Graphics g2, int x2, int y2) {
            if (this.cmap == null || this.cmap.length == 0) {
                return;
            }
            Graphics2D g22 = (Graphics2D)g2;
            g22.setColor(Color.black);
            g22.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.translate(x2 + 5, y2);
            int w2 = this.getIconWidth();
            int h2 = this.getIconHeight() - 7;
            if (this.color.equalsIgnoreCase("inverse gray")) {
                for (int i2 = 0; i2 < w2; ++i2) {
                    int cc = 1000 * (w2 - i2 - 1) / w2;
                    g2.setColor(new Color(this.cmap1[this.cmap1.length * cc / 1000]));
                    g2.fillRect(i2, 3, 1, h2);
                }
            } else {
                for (int i3 = 0; i3 < w2; ++i3) {
                    int cc = 1000 * (w2 - i3 - 1) / w2;
                    g2.setColor(new Color(this.cmap[this.cmap.length * cc / 1000]));
                    g2.fillRect(i3, 3, 1, h2);
                }
            }
        }

        public String toString() {
            return this.getColor().trim();
        }
    }

    public class JListRenderer
    extends JLabel
    implements ListCellRenderer {
        public JListRenderer() {
            this.setOpaque(true);
            this.setIconTextGap(10);
            this.setHorizontalAlignment(2);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (isSelected) {
                this.setBackground(UIManager.getColor("P8"));
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(UIManager.getColor("P7"));
                this.setForeground(list.getForeground());
            }
            if (value instanceof ColorMapLabel) {
                ColorMapLabel label = (ColorMapLabel)value;
                String strColor = label.getColor();
                String strColor_other_lang = (String)XpColorMapPanel.this.cmapIndex1.get(strColor);
                String firstLetter = strColor_other_lang.substring(0, 1);
                String remainder = strColor_other_lang.substring(1);
                String capitalized = firstLetter.toUpperCase() + remainder.toLowerCase();
                this.setText(capitalized);
                if (label.getColor().equalsIgnoreCase("gray")) {
                    this.setText(capitalized + "(" + res.getString("ColorMapPanel.none") + ")");
                }
                this.setIcon(label);
            } else if (value instanceof String) {
                this.setText((String)value);
                this.setIcon(null);
            }
            return this;
        }
    }
}

