/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.cpanels;

import com.ge.med.cse.cvf.cpanels.XPDisplayPrefsUtils;
import com.ge.med.cse.cvf.cpanels.XpAnnotationSettingPanel;
import com.ge.med.cse.cvf.util.CvUtils;
import com.ge.med.terra.jami.capable.AnnotCapable;
import com.ge.med.terra.xpv.autoControls.XPcaAutoControlPanel;
import com.ge.med.terra.xpv.base.XPscreen;
import com.ge.med.terra.xpv.cuiPanels.TransactionLogName;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.UIManager;

public class XpCustomAnnotPanel
extends XPcaAutoControlPanel {
    JLabel label;
    JButton ok;
    JButton cancel;
    JCheckBox[] annotList;
    JPanel buttonPanel;
    JPanel listPanel;
    JPanel labelPanel;
    String[] groupElemts;
    String modality_;
    XpAnnotationSettingPanel parent;
    Logger logger = Logger.getLogger("com.ge.med.cse.cvf.cpanels");
    PropertyChangeListener vpListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals("data_changed")) {
                XpCustomAnnotPanel.this.annotList = null;
                XpCustomAnnotPanel.this.updateAnnotList();
            } else if (evt.getPropertyName().equalsIgnoreCase("screen_custom_annotation_level")) {
                Object o2 = evt.getNewValue();
                if (o2 != null && o2 instanceof Integer) {
                    int mask = (Integer)o2;
                    for (int i2 = 0; i2 < XpCustomAnnotPanel.this.annotList.length; ++i2) {
                        int gmask = XPDisplayPrefsUtils.getCustomAnnotationGroupMask(i2);
                        boolean isSelected = (mask & gmask) != 0;
                        XpCustomAnnotPanel.this.annotList[i2].setSelected(isSelected);
                    }
                }
                XpCustomAnnotPanel.this.screen_.putClientProperty("screen_custom_annotation_level", null);
            }
        }
    };

    public XpCustomAnnotPanel(XpAnnotationSettingPanel parent) {
        TransactionLogName tln = new TransactionLogName("TID=CreateCustomAnnotPanel");
        this.logger.log(Level.FINE, "{0} begin,Creating CustomAnnotPanel", tln);
        this.parent = parent;
        this.initUI();
        this.logger.log(Level.FINE, "{0} end,Creating CustomAnnotPanel", tln);
    }

    private void initUI() {
        this.setBackground(null);
        this.setLayout(new BorderLayout());
        this.label = new JLabel();
        this.label.setText(CvUtils.getResourceBundle().getString("XP_ANNOT_CUSTOM_PA_LB"));
        this.labelPanel = new JPanel();
        this.labelPanel.setLayout(new GridBagLayout());
        this.labelPanel.setBackground(null);
        this.labelPanel.add((Component)this.label, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 22, 0, 0), 0, 0));
        this.label.setName(XpCustomAnnotPanel.class.getName() + "label");
        this.labelPanel.setName(XpCustomAnnotPanel.class.getName() + "labelPanel");
        JPanel topLabel = new JPanel();
        topLabel.setLayout(new BorderLayout());
        topLabel.setBackground(null);
        topLabel.add((Component)this.labelPanel, "West");
        topLabel.setName(XpCustomAnnotPanel.class.getName() + "topLabel");
        this.listPanel = new JPanel();
        this.listPanel.setName("custmAnnotsPnl");
        this.listPanel.setLayout(new GridLayout(0, 1));
        this.listPanel.setBackground(UIManager.getColor("P9"));
        JPanel panel = new JPanel(new FlowLayout());
        panel.setBackground(null);
        JScrollPane pane = new JScrollPane(this.listPanel, 20, 30);
        pane.setPreferredSize(new Dimension(300, 200));
        panel.add(pane);
        this.ok = new JButton();
        this.ok.setText(CvUtils.getResourceBundle().getString("XP_BUT_OK"));
        this.ok.setFocusable(false);
        this.ok.setName("custmOkBtn");
        this.ok.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                XpCustomAnnotPanel.this.ok_button_actionPerformed(e2);
            }
        });
        this.cancel = new JButton();
        this.cancel.setText(CvUtils.getResourceBundle().getString("XP_BUT_CANCEL"));
        this.cancel.setFocusable(false);
        this.cancel.setName("custmCancelBtn");
        this.cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                XpCustomAnnotPanel.this.cancel_but_actionPerformed(e2);
            }
        });
        this.buttonPanel = new JPanel();
        this.buttonPanel.setBackground(null);
        this.buttonPanel.setLayout(new GridBagLayout());
        this.buttonPanel.add((Component)this.ok, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 11, 2, new Insets(0, 0, 100, 20), 0, 0));
        this.buttonPanel.add((Component)this.cancel, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 11, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.buttonPanel.setName(XpCustomAnnotPanel.class.getName() + "buttonPanel");
        this.add((Component)topLabel, "North");
        this.add((Component)panel, "Center");
        this.add((Component)this.buttonPanel, "South");
    }

    @Override
    public void setScreen(XPscreen screen) {
        super.setScreen(screen);
        this.updateAnnotList();
        screen.removePropertyChangeListener(this.vpListener);
        screen.addPropertyChangeListener(this.vpListener);
    }

    public void updateAnnotList() {
        if (this.annotList != null) {
            return;
        }
        this.modality_ = this.parent.getModality();
        this.groupElemts = XPDisplayPrefsUtils.getCustomAnnotationGroups(this.modality_);
        if (this.groupElemts != null) {
            this.annotList = new JCheckBox[this.groupElemts.length];
            for (int i2 = 0; i2 < this.groupElemts.length; ++i2) {
                String text = this.groupElemts[i2];
                try {
                    text = CvUtils.getResourceBundle().getString(this.modality_.toLowerCase() + "." + this.groupElemts[i2]);
                }
                catch (Exception ex) {
                    // empty catch block
                }
                this.annotList[i2] = new JCheckBox(i2 + 1 + "." + text.replace('_', ' '));
                this.annotList[i2].setActionCommand(this.groupElemts[i2]);
                boolean isSelected = XPDisplayPrefsUtils.queryScreenCustomAnnotationGroup(i2);
                this.annotList[i2].setFocusable(false);
                this.annotList[i2].setSelected(isSelected);
                this.listPanel.add(this.annotList[i2]);
            }
        }
    }

    private void ok_button_actionPerformed(ActionEvent e2) {
        int custmmask = 0;
        for (int i2 = 0; i2 < this.annotList.length; ++i2) {
            if (!this.annotList[i2].isSelected()) continue;
            int grMask = XPDisplayPrefsUtils.getCustomAnnotationGroupMask(i2);
            custmmask |= grMask;
        }
        XPDisplayPrefsUtils.updateScreenCustomAnnotationLevel(custmmask);
        if (this.parent.custmAnnot.isSelected()) {
            XPDisplayPrefsUtils.setCustomAnnotItems((AnnotCapable)this.parent.getScreen().getCapable(AnnotCapable.class.getName()), this.parent.modality, XPDisplayPrefsUtils.getScreenCustomAnnotationLevel());
        }
        this.parent.topPanel.removeAll();
        this.parent.topPanel.add(this.parent.mainPanel);
        this.parent.topPanel.updateUI();
    }

    private void cancel_but_actionPerformed(ActionEvent e2) {
        this.parent.topPanel.remove(this.parent.custmPanel);
        this.parent.topPanel.add((Component)this.parent.mainPanel, "Center");
        this.parent.topPanel.updateUI();
        AnnotCapable annot = (AnnotCapable)this.parent.getScreen().getCapable(AnnotCapable.class.getName());
        if (annot != null & this.annotList != null) {
            for (int i2 = 0; i2 < this.annotList.length; ++i2) {
                boolean isSelect = XPDisplayPrefsUtils.queryScreenCustomAnnotationGroup(i2);
                this.annotList[i2].setSelected(isSelect);
            }
        }
    }
}

