/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.cpanels;

import com.ge.med.cse.cvf.action.XpF1FilmAction;
import com.ge.med.cse.cvf.action.XpF2FilmAction;
import com.ge.med.cse.cvf.action.XpF3FilmAction;
import com.ge.med.cse.cvf.cpanels.XPDisplayPrefsUtils;
import com.ge.med.cse.cvf.crossref.XpReferenceImageApp;
import com.ge.med.cse.cvf.log.CvGESyslogMessageCode;
import com.ge.med.cse.cvf.log.UserMessageLevel;
import com.ge.med.cse.cvf.model.XpRangeModel;
import com.ge.med.cse.cvf.print.ForcePrint;
import com.ge.med.cse.cvf.print.PrintProgress;
import com.ge.med.cse.cvf.print.PrintRowColFormat;
import com.ge.med.cse.cvf.print.PrinterStatus;
import com.ge.med.cse.cvf.print.SeriesPrint;
import com.ge.med.cse.cvf.print.XpFilmErrorLookup;
import com.ge.med.cse.cvf.util.CvPropertiesManager;
import com.ge.med.cse.cvf.util.CvUtils;
import com.ge.med.cse.cvf.util.DicomPageablePort;
import com.ge.med.cse.cvf.util.DicomUtils;
import com.ge.med.idc.Capable;
import com.ge.med.idc.FramePositioningCapable;
import com.ge.med.idc.SelectionCapable;
import com.ge.med.terra.jami.XpCompositePort;
import com.ge.med.terra.jami.XpDicomElement;
import com.ge.med.terra.jami.XpDicomObject;
import com.ge.med.terra.jami.XpFrameVisualizer;
import com.ge.med.terra.jami.XpImageViewport;
import com.ge.med.terra.jami.XpMedicalImage;
import com.ge.med.terra.jami.XpViewport;
import com.ge.med.terra.jami.capable.FrameCapable;
import com.ge.med.terra.jami.capable.FrameOwner;
import com.ge.med.terra.xpv.autoControls.XPcaAutoControlPanel;
import com.ge.med.terra.xpv.base.PlasmaControl;
import com.ge.med.terra.xpv.base.XPscreen;
import com.ge.med.terra.xpv.cuiPanels.TransactionLogName;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.print.PrinterJob;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.print.DocFlavor;
import javax.print.DocPrintJob;
import javax.print.PrintException;
import javax.print.PrintService;
import javax.print.SimpleDoc;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.event.PrintJobAttributeEvent;
import javax.print.event.PrintJobAttributeListener;
import javax.print.event.PrintJobEvent;
import javax.print.event.PrintJobListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.JTextArea;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.AncestorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public class XpFilmPanel
extends XPcaAutoControlPanel {
    private JButton flmImg;
    private JButton flmPage;
    private JButton flmMid;
    private JButton flmsers;
    private JButton flm_cancel;
    private JLabel format;
    private JLabel interval;
    private JLabel tolbl;
    private JCheckBox lastPageCheckBox;
    private JTextArea text;
    private JComboBox combox;
    private JRadioButton all;
    private JRadioButton range;
    private JSpinner imgInterval;
    private JSpinner from;
    private JSpinner to;
    private JTextArea statusArea;
    private JPanel sersPanel;
    private static String use_fc_format = "As_is";
    private static String FILM_IMAGE = "FilmImage";
    private static String FILM_PAGE = "FilmPage";
    private static String FILM_MID = "FilmMid";
    private static String FILM_SERIES = "FilmSeries";
    private static String CANCEL_FILM = "CancelFilm";
    private static String FILM_ALL = "AllFilm";
    private static String FILM_RANGE = "FilmRange";
    private static String FILM_FROM = "FilmFrom";
    private static String FILM_TO = "FilmTo";
    private static String FILM_INTERVAL = "FilmInterval";
    private int totalimgs;
    private PrintService service;
    private DocPrintJob job;
    private XpDicomElement exNo = new XpDicomElement(32, 16);
    private XpDicomElement seNo = new XpDicomElement(32, 17);
    private Logger logger = Logger.getLogger("com.ge.med.cse.cvf.cpanels");
    private boolean uiIntiated = false;
    private SpinnerKeyListener kl = new SpinnerKeyListener();
    private PropertyChangeListener vpListn = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals("ComponentSelection") || evt.getPropertyName().equals("CONTENT_CHANGED")) {
                if (XpFilmPanel.this.uiIntiated) {
                    boolean xsportdifferent = true;
                    if (evt.getPropertyName().equalsIgnoreCase("ComponentSelection") && evt.getOldValue() instanceof Integer && evt.getNewValue() instanceof Integer) {
                        boolean bl = xsportdifferent = (Integer)evt.getOldValue() > -1 && evt.getOldValue() != evt.getNewValue();
                    }
                    if (XpFilmPanel.this.imageLeft <= 0 && xsportdifferent) {
                        XpFilmPanel.this.updatePanel(XpFilmPanel.this.screen_.getSelectedPort());
                    }
                }
            } else if (evt.getPropertyName().equals("reference_vp_selection")) {
                FrameCapable fcp;
                XpFrameVisualizer fv;
                SelectionCapable slcCap = (SelectionCapable)XpFilmPanel.this.screen_.getCapable(SelectionCapable.class.getName());
                JComponent port = slcCap.getViewportComponent(slcCap.getComponentSelection());
                int portIndex = XpReferenceImageApp.getSelectedRefPortIndex((XpCompositePort)port);
                if (portIndex < 0) {
                    portIndex = ((XpCompositePort)port).getComponentSelection();
                }
                if ((fv = ((XpCompositePort)port).getPort(portIndex)) != null && (fcp = (FrameCapable)((Object)fv.getCapable(FrameCapable.class.getName()))) != null) {
                    CvUtils.setEnabled(XpFilmPanel.this.sersPanel, fcp.getNumFrames() <= CvUtils.getLargeSeriesSize());
                }
            }
        }
    };
    int imageLeft = -1;
    DicomPageablePort pageable = null;
    private long prsStartTime = 0L;
    private int numCount = -1;
    PrintJobListener pjl = new PrintJobListener(){

        @Override
        public void printDataTransferCompleted(PrintJobEvent pje) {
            XpFilmPanel.this.logger.log(Level.INFO, "{0} Print Data Transfer Completed");
        }

        @Override
        public void printJobCanceled(PrintJobEvent pje) {
            XpFilmPanel.this.logger.log(Level.INFO, "Printjob canceled");
            if (XpFilmPanel.this.imageLeft > 0) {
                XpFilmPanel.this.seriesPrintComplete();
            }
            XpFilmPanel.this.statusArea.setText(CvUtils.getResourceBundle().getString("FILM_USER_CANCEL"));
        }

        @Override
        public void printJobCompleted(PrintJobEvent pje) {
            XpFilmPanel.this.logger.log(Level.INFO, "job is completed");
            if (XpFilmPanel.this.imageLeft > 0) {
                XpFilmPanel.this.seriesPrintComplete();
            }
        }

        @Override
        public void printJobFailed(final PrintJobEvent pje) {
            XpFilmPanel.this.logger.log(Level.INFO, "Printjob failed");
            XpFilmPanel.this.statusArea.setText(CvUtils.getResourceBundle().getString("FILM_JOB_FAILED"));
            final int imgLeft = XpFilmPanel.this.imageLeft;
            if (XpFilmPanel.this.imageLeft > 0) {
                XpFilmPanel.this.seriesPrintComplete();
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (pje.getPrintEventType() == 201) {
                        String esi = "Ex:" + XpFilmPanel.this.exNo.getStringValue() + "  Se:" + XpFilmPanel.this.seNo.getStringValue() + "  " + imgLeft + " " + CvUtils.getResourceBundle().getString("FC_IMG_LEFT");
                        String error = XpFilmErrorLookup.getErrorString(pje.getPrintEventType());
                        XpFilmPanel.this.statusArea.setText(error);
                        XpFilmPanel.this.logger.log(Level.SEVERE, CvGESyslogMessageCode.CV_PRINT_JOB_ERROR.getLocalizedMessage(), new Object[]{CvGESyslogMessageCode.CV_PRINT_JOB_ERROR, esi, error});
                    } else if (pje.getPrintEventType() == 202) {
                        String esi = "Ex:" + XpFilmPanel.this.exNo.getStringValue() + "  Se:" + XpFilmPanel.this.seNo.getStringValue() + "  " + imgLeft + " " + CvUtils.getResourceBundle().getString("FC_IMG_LEFT");
                        String error = XpFilmErrorLookup.getErrorString(pje.getPrintEventType());
                        XpFilmPanel.this.statusArea.setText(error);
                        XpFilmPanel.this.logger.log(Level.SEVERE, CvGESyslogMessageCode.CV_PRINT_JOB_ERROR.getLocalizedMessage(), new Object[]{CvGESyslogMessageCode.CV_PRINT_JOB_ERROR, esi, error});
                    } else if (pje.getPrintEventType() == 203) {
                        String esi = "Ex:" + XpFilmPanel.this.exNo.getStringValue() + "  Se:" + XpFilmPanel.this.seNo.getStringValue() + "  " + imgLeft + " " + CvUtils.getResourceBundle().getString("FC_IMG_LEFT");
                        String error = XpFilmErrorLookup.getErrorString(pje.getPrintEventType());
                        XpFilmPanel.this.statusArea.setText(error);
                        XpFilmPanel.this.logger.log(Level.SEVERE, CvGESyslogMessageCode.CV_PRINT_JOB_ERROR.getLocalizedMessage(), new Object[]{CvGESyslogMessageCode.CV_PRINT_JOB_ERROR, esi, error});
                    } else if (pje.getPrintEventType() == 204) {
                        String esi = "Ex:" + XpFilmPanel.this.exNo.getStringValue() + "  Se:" + XpFilmPanel.this.seNo.getStringValue() + "  " + imgLeft + " " + CvUtils.getResourceBundle().getString("FC_IMG_LEFT");
                        String error = XpFilmErrorLookup.getErrorString(pje.getPrintEventType());
                        XpFilmPanel.this.statusArea.setText(error);
                        XpFilmPanel.this.logger.log(Level.SEVERE, CvGESyslogMessageCode.CV_PRINT_JOB_ERROR.getLocalizedMessage(), new Object[]{CvGESyslogMessageCode.CV_PRINT_JOB_ERROR, esi, error});
                    } else if (pje.getPrintEventType() == 205) {
                        String esi = "Ex:" + XpFilmPanel.this.exNo.getStringValue() + "  Se:" + XpFilmPanel.this.seNo.getStringValue() + "  " + imgLeft + " " + CvUtils.getResourceBundle().getString("FC_IMG_LEFT");
                        String error = XpFilmErrorLookup.getErrorString(pje.getPrintEventType());
                        XpFilmPanel.this.statusArea.setText(error);
                        XpFilmPanel.this.logger.log(Level.SEVERE, CvGESyslogMessageCode.CV_PRINT_JOB_ERROR.getLocalizedMessage(), new Object[]{CvGESyslogMessageCode.CV_PRINT_JOB_ERROR, esi, error});
                    } else if (pje.getPrintEventType() == 206) {
                        String esi = "Ex:" + XpFilmPanel.this.exNo.getStringValue() + "  Se:" + XpFilmPanel.this.seNo.getStringValue() + "  " + imgLeft + " " + CvUtils.getResourceBundle().getString("FC_IMG_LEFT");
                        String error = XpFilmErrorLookup.getErrorString(pje.getPrintEventType());
                        XpFilmPanel.this.statusArea.setText(error);
                        XpFilmPanel.this.logger.log(Level.SEVERE, CvGESyslogMessageCode.CV_PRINT_JOB_ERROR.getLocalizedMessage(), new Object[]{CvGESyslogMessageCode.CV_PRINT_JOB_ERROR, esi, error});
                    } else if (pje.getPrintEventType() == 207) {
                        String esi = "Ex:" + XpFilmPanel.this.exNo.getStringValue() + "  Se:" + XpFilmPanel.this.seNo.getStringValue() + "  " + imgLeft + " " + CvUtils.getResourceBundle().getString("FC_IMG_LEFT");
                        String error = XpFilmErrorLookup.getErrorString(pje.getPrintEventType());
                        XpFilmPanel.this.statusArea.setText(error);
                        XpFilmPanel.this.logger.log(Level.SEVERE, CvGESyslogMessageCode.CV_PRINT_JOB_ERROR.getLocalizedMessage(), new Object[]{CvGESyslogMessageCode.CV_PRINT_JOB_ERROR, esi, error});
                    } else if (pje.getPrintEventType() == 103) {
                        String esi = "Ex:" + XpFilmPanel.this.exNo.getStringValue() + "  Se:" + XpFilmPanel.this.seNo.getStringValue() + "  " + imgLeft + " " + CvUtils.getResourceBundle().getString("FC_IMG_LEFT");
                        String error = CvUtils.getResourceBundle().getString("FILM_JOB_FAILED");
                        XpFilmPanel.this.statusArea.setText(error);
                        XpFilmPanel.this.logger.log(Level.SEVERE, CvGESyslogMessageCode.CV_PRINT_JOB_ERROR.getLocalizedMessage(), new Object[]{CvGESyslogMessageCode.CV_PRINT_JOB_ERROR, esi, error});
                    } else {
                        String esi = "Ex:" + XpFilmPanel.this.exNo.getStringValue() + "  Se:" + XpFilmPanel.this.seNo.getStringValue() + "  " + imgLeft + " " + CvUtils.getResourceBundle().getString("FC_IMG_LEFT");
                        String error = CvUtils.getResourceBundle().getString("FILM_ERROR");
                        XpFilmPanel.this.statusArea.setText(error);
                        XpFilmPanel.this.logger.log(Level.SEVERE, CvGESyslogMessageCode.CV_PRINT_JOB_ERROR.getLocalizedMessage(), new Object[]{CvGESyslogMessageCode.CV_PRINT_JOB_ERROR, esi, error + pje.getPrintEventType()});
                    }
                }
            });
        }

        @Override
        public void printJobNoMoreEvents(PrintJobEvent pje) {
            XpFilmPanel.this.logger.log(Level.INFO, "{0} Print Job No More Events");
        }

        @Override
        public void printJobRequiresAttention(PrintJobEvent pje) {
            XpFilmPanel.this.logger.log(Level.INFO, "{0} Print Job Requires Attention");
        }
    };
    PrintJobAttributeListener pjal = new PrintJobAttributeListener(){

        @Override
        public void attributeUpdate(PrintJobAttributeEvent pjae) {
            final PrintProgress pp = (PrintProgress)pjae.getAttributes().get(PrintProgress.class);
            XpFilmPanel.this.logger.log(Level.FINEST, "{0} printProgress=" + pp.toString());
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    --XpFilmPanel.this.imageLeft;
                    XpFilmPanel.this.numCount++;
                    if (XpFilmPanel.this.pageable != null) {
                        XpFilmPanel.this.pageable.disposePrintable(pp.getValue() - 1);
                    }
                    if (XpFilmPanel.this.imageLeft < 0) {
                        return;
                    }
                    if (XpFilmPanel.this.imageLeft == 0) {
                        XpFilmPanel.this.seriesPrintComplete();
                    } else {
                        XpFilmPanel.this.statusArea.setForeground(Color.BLACK);
                        XpFilmPanel.this.statusArea.setText("Ex:" + XpFilmPanel.this.exNo.getStringValue() + "  Se:" + XpFilmPanel.this.seNo.getStringValue() + "      " + XpFilmPanel.this.imageLeft + " " + CvUtils.getResourceBundle().getString("FC_IMG_LEFT"));
                    }
                }
            });
        }
    };
    private SPINNER lastModifiedSpinner = SPINNER.NONE;

    public XpFilmPanel() {
        this.setIcon(CvUtils.getIcon("XP_FILM_ICON"));
        this.setBackground(null);
        this.setName("XpFilmControlPanel");
        TransactionLogName tln = new TransactionLogName("TID=CreateFilmPanel");
        this.logger.log(Level.FINE, "{0} begin Creating Film Panel", tln);
        if (!CvPropertiesManager.getBoolean("isLazyLoading", false)) {
            this.initUI();
            this.uiIntiated = true;
        }
        this.logger.log(Level.FINE, "{0} end Creating Film Panel", tln);
    }

    @Override
    public void panelStart() {
        super.panelStart();
        if (CvPropertiesManager.getBoolean("isLazyLoading", false) && !this.uiIntiated) {
            this.initUI();
            CvUtils.updateBackground(this, UIManager.getColor("P9"));
            this.updatePanel(this.screen_.getSelectedPort());
            this.setActionCapable(this.flmImg);
            this.setActionCapable(this.flmPage);
            this.setActionCapable(this.flmMid);
            this.uiIntiated = true;
        }
        if (this.service == null) {
            this.service = CvUtils.getDefaultPrintService();
            if (this.service == null) {
                this.logger.log(Level.INFO, "{0} No service found");
                this.logger.log(UserMessageLevel.USER_MSG, CvUtils.getResourceBundle().getString("FC_NOT_RUN"));
                this.statusArea.setText(CvUtils.getResourceBundle().getString("FC_NOT_RUN"));
                this.logger.log(Level.SEVERE, CvGESyslogMessageCode.CV_NO_PRINT_SERVICE_ERROR.getLocalizedMessage(), new Object[]{CvGESyslogMessageCode.CV_NO_PRINT_SERVICE_ERROR});
                return;
            }
        }
        this.job = this.service.createPrintJob();
        if (this.job == null) {
            this.logger.log(Level.INFO, "Printjob can not be created");
            return;
        }
        this.updateFormatList(this.service);
        this.job.addPrintJobListener(this.pjl);
        this.job.addPrintJobAttributeListener(this.pjal, null);
    }

    private void updateFormatList(final PrintService pservice) {
        new Thread(){

            @Override
            public void run() {
                if (pservice != null) {
                    final String formats = (String)pservice.getSupportedAttributeValues(PrintRowColFormat.class, null, null);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            if (formats != null && !formats.equalsIgnoreCase("")) {
                                String token;
                                StringTokenizer stt = new StringTokenizer(formats, "|");
                                stt.nextToken();
                                String format = stt.nextToken();
                                StringTokenizer stt1 = new StringTokenizer(format, ":");
                                XpFilmPanel.this.combox.removeAllItems();
                                XpFilmPanel.this.combox.addItem(use_fc_format);
                                while (stt1.hasMoreTokens() && !format.equalsIgnoreCase(token = stt1.nextToken())) {
                                    XpFilmPanel.this.combox.addItem(token.substring(0, token.indexOf(95)));
                                }
                            }
                        }
                    });
                }
            }
        }.start();
    }

    private void initUI() {
        this.setLayout(new BorderLayout());
        this.flmImg = new JButton();
        this.flmImg.setName(FILM_IMAGE);
        this.flmImg.setAction(new XpF1FilmAction());
        this.flmImg.setFocusable(false);
        this.flmPage = new JButton();
        this.flmPage.setName(FILM_PAGE);
        this.flmPage.setAction(new XpF2FilmAction());
        this.flmPage.setFocusable(false);
        this.flmMid = new JButton();
        this.flmMid.setName(FILM_MID);
        this.flmMid.setAction(new XpF3FilmAction());
        this.flmMid.setFocusable(false);
        this.flmsers = new JButton();
        this.flmsers.setName(FILM_SERIES);
        this.flmsers.setFocusable(false);
        this.flmsers.setText(CvUtils.getResourceBundle().getString("XP_FILM_SERS"));
        this.flmsers.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                XpFilmPanel.this.btPrintSeries_actionPerformed(e2);
            }
        });
        this.flm_cancel = new JButton();
        this.flm_cancel.setName(CANCEL_FILM);
        this.flm_cancel.setFocusable(false);
        this.flm_cancel.setText(CvUtils.getResourceBundle().getString("XP_FILM_CANCEL"));
        this.flm_cancel.setEnabled(false);
        this.flm_cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                XpFilmPanel.this.btflmcancel_actionPerformed(e2);
            }
        });
        this.statusArea = new JTextArea(2, 0);
        this.statusArea.setText("");
        this.statusArea.setForeground(Color.BLACK);
        this.statusArea.setLineWrap(true);
        this.statusArea.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.statusArea.setBackground(UIManager.getColor("P3"));
        this.statusArea.setEditable(false);
        this.statusArea.setFocusable(false);
        this.statusArea.setName(XpFilmPanel.class.getName() + "statusArea");
        JPanel statusPanel = new JPanel();
        statusPanel.setLayout(new BorderLayout());
        statusPanel.add((Component)this.statusArea, "Center");
        statusPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.black), CvUtils.getResourceBundle().getString("XP_FILM_STATUS_TITLE")));
        statusPanel.setName(XpFilmPanel.class.getName() + "statusPanel");
        this.format = new JLabel(CvUtils.getResourceBundle().getString("XP_FILM_FRMAT"));
        this.format.setName(XpFilmPanel.class.getName() + "format");
        this.combox = new JComboBox();
        AncestorListener[] ancListener = this.combox.getAncestorListeners();
        for (int i2 = 0; i2 < ancListener.length; ++i2) {
            this.combox.removeAncestorListener(ancListener[i2]);
        }
        this.combox.setName(XpFilmPanel.class.getName() + "combox");
        this.combox.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuCanceled(PopupMenuEvent e2) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e2) {
            }

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e2) {
                if (XpFilmPanel.this.service == null) {
                    XpFilmPanel.this.service = CvUtils.getDefaultPrintService();
                    if (XpFilmPanel.this.service == null) {
                        XpFilmPanel.this.logger.log(Level.INFO, "{0} No service found");
                        XpFilmPanel.this.logger.log(UserMessageLevel.USER_MSG, CvUtils.getResourceBundle().getString("FC_NOT_RUN"));
                        XpFilmPanel.this.statusArea.setText(CvUtils.getResourceBundle().getString("FC_NOT_RUN"));
                        XpFilmPanel.this.logger.log(Level.SEVERE, CvGESyslogMessageCode.CV_NO_PRINT_SERVICE_ERROR.getLocalizedMessage(), new Object[]{CvGESyslogMessageCode.CV_NO_PRINT_SERVICE_ERROR});
                        return;
                    }
                }
                XpFilmPanel.this.updateFormatList(XpFilmPanel.this.service);
            }
        });
        this.combox.setPreferredSize(new Dimension(120, 30));
        this.combox.setFocusable(false);
        this.combox.addItem(use_fc_format);
        this.lastPageCheckBox = new JCheckBox();
        this.lastPageCheckBox.setFocusable(false);
        this.lastPageCheckBox.setSelected(true);
        this.lastPageCheckBox.setName(XpFilmPanel.class.getName() + "lastPageCheckBox");
        this.text = new JTextArea(CvUtils.getResourceBundle().getString("XP_FILM_LPAGE"));
        this.text.setEditable(false);
        this.text.setLineWrap(true);
        this.text.setWrapStyleWord(true);
        this.text.setFocusable(false);
        this.text.setName(XpFilmPanel.class.getName() + "text");
        this.all = new JRadioButton();
        this.all.setName(FILM_ALL);
        this.all.setText(CvUtils.getResourceBundle().getString("XP_FILM_ALL"));
        this.all.setFocusable(false);
        this.all.setSelected(true);
        this.interval = new JLabel();
        this.interval.setText(CvUtils.getResourceBundle().getString("XP_FILM_INTERVAL"));
        this.interval.setName(XpFilmPanel.class.getName() + "interval");
        this.imgInterval = new JSpinner();
        this.imgInterval.setName(FILM_INTERVAL);
        this.imgInterval.setPreferredSize(new Dimension(80, 25));
        this.imgInterval.setFocusable(false);
        this.imgInterval.setModel(new SpinnerNumberModel(1, 1, 1, 1));
        ((JSpinner.NumberEditor)this.imgInterval.getEditor()).getTextField().addKeyListener(this.kl);
        this.from = new JSpinner();
        this.from.setName(FILM_FROM);
        this.from.setFocusable(false);
        this.from.setEnabled(false);
        this.from.setPreferredSize(new Dimension(80, 25));
        ((JSpinner.NumberEditor)this.from.getEditor()).getTextField().addKeyListener(this.kl);
        this.tolbl = new JLabel();
        this.tolbl.setEnabled(false);
        this.tolbl.setText(CvUtils.getResourceBundle().getString("ROI_PROP_TO_LABEL"));
        this.tolbl.setName(XpFilmPanel.class.getName() + "tolbl");
        this.to = new JSpinner();
        this.to.setName(FILM_TO);
        this.to.setFocusable(false);
        this.to.setEnabled(false);
        this.to.setPreferredSize(new Dimension(80, 25));
        ((JSpinner.NumberEditor)this.to.getEditor()).getTextField().addKeyListener(this.kl);
        this.to.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e2) {
            }
        });
        this.range = new JRadioButton();
        this.range.setName(FILM_RANGE);
        this.range.setText(CvUtils.getResourceBundle().getString("XP_FILM_RANGE"));
        this.range.setFocusable(false);
        this.range.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                XpFilmPanel.this.range.setSelected(true);
                XpFilmPanel.this.from.setEnabled(true);
                XpFilmPanel.this.tolbl.setEnabled(true);
                XpFilmPanel.this.to.setEnabled(true);
            }
        });
        this.all.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                XpFilmPanel.this.all.setSelected(true);
                XpFilmPanel.this.from.setEnabled(false);
                XpFilmPanel.this.tolbl.setEnabled(false);
                XpFilmPanel.this.to.setEnabled(false);
            }
        });
        ButtonGroup gp = new ButtonGroup();
        gp.add(this.all);
        gp.add(this.range);
        JPanel topbpanel = new JPanel();
        topbpanel.setLayout(new GridBagLayout());
        topbpanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.black), CvUtils.getResourceBundle().getString("XP_FILM_NOW")));
        topbpanel.add((Component)this.flmImg, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 11, 2, new Insets(0, 0, 10, 20), 0, 0));
        topbpanel.add((Component)this.flmPage, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 11, 2, new Insets(0, 0, 10, 20), 0, 0));
        topbpanel.add((Component)this.flmMid, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 11, 2, new Insets(0, 0, 10, 20), 0, 0));
        topbpanel.setName(XpFilmPanel.class.getName() + "topbpanel");
        this.sersPanel = new JPanel();
        this.sersPanel.setLayout(new GridBagLayout());
        this.sersPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.black), CvUtils.getResourceBundle().getString("XP_FILM_SERS")));
        this.sersPanel.setName(XpFilmPanel.class.getName() + "sersPanel");
        JPanel formtpanel = new JPanel();
        formtpanel.setLayout(new GridBagLayout());
        formtpanel.add((Component)this.format, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 5, 5), 0, 0));
        formtpanel.add((Component)this.combox, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 5, 5), 0, 0));
        formtpanel.add((Component)this.lastPageCheckBox, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 10, 5, 5), 0, 0));
        formtpanel.add((Component)this.text, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 5, 0), 0, 0));
        formtpanel.setName(XpFilmPanel.class.getName() + "formtpanel");
        JPanel allPanel = new JPanel();
        allPanel.setLayout(new GridBagLayout());
        allPanel.add((Component)this.all, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        allPanel.add((Component)this.range, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 5, 5), 0, 0));
        allPanel.add((Component)this.from, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 5, 5), 0, 0));
        allPanel.add((Component)this.tolbl, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 5, 5), 0, 0));
        allPanel.add((Component)this.to, new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 5, 0), 0, 0));
        allPanel.add((Component)this.interval, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 5, 5), 0, 0));
        allPanel.add((Component)this.imgInterval, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 5, 0), 0, 0));
        allPanel.add((Component)statusPanel, new GridBagConstraints(0, 3, 5, 1, 0.0, 0.0, 17, 2, new Insets(5, 0, 5, 5), 0, 0));
        allPanel.setName(XpFilmPanel.class.getName() + "allPanel");
        JPanel btmbpanel = new JPanel();
        btmbpanel.setLayout(new GridBagLayout());
        btmbpanel.add((Component)this.flm_cancel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 5), 0, 0));
        btmbpanel.add((Component)this.flmsers, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 5, 0, 5), 0, 0));
        btmbpanel.setName(XpFilmPanel.class.getName() + "btmbpanel");
        allPanel.add((Component)btmbpanel, new GridBagConstraints(0, 4, 5, 1, 0.0, 0.0, 17, 2, new Insets(5, 0, 0, 5), 0, 0));
        this.sersPanel.add((Component)formtpanel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 11, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.sersPanel.add((Component)allPanel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 15, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)topbpanel, "North");
        this.add((Component)this.sersPanel, "Center");
    }

    private void updatePanel(final JComponent comp) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (comp instanceof SelectionCapable) {
                    FramePositioningCapable fpcap = (FramePositioningCapable)((Object)comp);
                    XpFilmPanel.this.totalimgs = fpcap.getNumFrames();
                    if (XpFilmPanel.this.totalimgs < 1) {
                        return;
                    }
                    int value = Integer.parseInt(((JSpinner.NumberEditor)XpFilmPanel.this.imgInterval.getEditor()).getTextField().getText());
                    SpinnerNumberModel spmodel = value > XpFilmPanel.this.totalimgs ? new SpinnerNumberModel(XpFilmPanel.this.totalimgs, 1, XpFilmPanel.this.totalimgs, 1) : new SpinnerNumberModel(value, 1, XpFilmPanel.this.totalimgs, 1);
                    XpFilmPanel.this.imgInterval.setModel(spmodel);
                    XpRangeModel model = new XpRangeModel();
                    XpFilmPanel.this.from.setModel(model.getMinRangeSpinnerModel(fpcap));
                    XpFilmPanel.this.to.setModel(model.getMaxRangeSpinnerModel(fpcap));
                    ((JSpinner.NumberEditor)XpFilmPanel.this.from.getEditor()).getTextField().removeKeyListener(XpFilmPanel.this.kl);
                    ((JSpinner.NumberEditor)XpFilmPanel.this.from.getEditor()).getTextField().addKeyListener(XpFilmPanel.this.kl);
                    ((JSpinner.NumberEditor)XpFilmPanel.this.to.getEditor()).getTextField().removeKeyListener(XpFilmPanel.this.kl);
                    ((JSpinner.NumberEditor)XpFilmPanel.this.to.getEditor()).getTextField().addKeyListener(XpFilmPanel.this.kl);
                    ((JSpinner.NumberEditor)XpFilmPanel.this.imgInterval.getEditor()).getTextField().removeKeyListener(XpFilmPanel.this.kl);
                    ((JSpinner.NumberEditor)XpFilmPanel.this.imgInterval.getEditor()).getTextField().addKeyListener(XpFilmPanel.this.kl);
                    XpFilmPanel.this.lastModifiedSpinner = SPINNER.NONE;
                    CvUtils.setEnabled(XpFilmPanel.this.sersPanel, XpFilmPanel.this.totalimgs <= CvUtils.getLargeSeriesSize());
                    if (!XpFilmPanel.this.range.isSelected()) {
                        XpFilmPanel.this.from.setEnabled(false);
                        XpFilmPanel.this.to.setEnabled(false);
                    } else {
                        XpFilmPanel.this.from.setEnabled(true);
                        XpFilmPanel.this.to.setEnabled(true);
                    }
                    if (XpFilmPanel.this.totalimgs <= CvUtils.getLargeSeriesSize()) {
                        XpFilmPanel.this.flm_cancel.setEnabled(false);
                    }
                }
            }
        });
    }

    @Override
    public void setScreen(XPscreen screen) {
        super.setScreen(screen);
        this.screen_.removePropertyChangeListener(this.vpListn);
        this.screen_.addPropertyChangeListener(this.vpListn);
        if (this.uiIntiated) {
            this.setActionCapable(this.flmImg);
            this.setActionCapable(this.flmPage);
            this.setActionCapable(this.flmMid);
            this.updatePanel(this.screen_.getSelectedPort());
        }
    }

    private void setActionCapable(JButton flmPage2) {
        if (flmPage2.getAction() instanceof PlasmaControl) {
            ((PlasmaControl)((Object)flmPage2.getAction())).setCapable(this.screen_);
        }
    }

    public void btPrintSeries_actionPerformed(ActionEvent e2) {
        final TransactionLogName tln = new TransactionLogName("TID=CV_printSeries");
        this.validateInput();
        if (this.imageLeft > 0 || CvUtils.isFilmPrintingInProgress(this.job)) {
            this.logger.log(Level.WARNING, "{0} Series Printing already in Progress", tln);
            return;
        }
        if (this.service == null) {
            this.logger.log(UserMessageLevel.USER_MSG, CvUtils.getResourceBundle().getString("FC_NOT_RUN"));
            this.logger.log(Level.SEVERE, CvGESyslogMessageCode.CV_NO_PRINT_SERVICE_ERROR.getLocalizedMessage(), new Object[]{CvGESyslogMessageCode.CV_NO_PRINT_SERVICE_ERROR});
            return;
        }
        PrinterStatus ps = this.service.getAttribute(PrinterStatus.class);
        boolean status = false;
        if (ps != null) {
            status = ps.getValue();
        }
        if (!status) {
            this.logger.log(Level.INFO, "{0} Sev5 Error in printing : Film Composer may not be running", tln);
            this.statusArea.setText(CvUtils.getResourceBundle().getString("FC_NOT_RUN"));
            this.logger.log(Level.SEVERE, CvGESyslogMessageCode.CV_PRINT_ERROR.getLocalizedMessage(), new Object[]{CvGESyslogMessageCode.CV_PRINT_ERROR, CvUtils.getResourceBundle().getString("FC_NOT_RUN")});
            return;
        }
        int index = this.screen_.getSelectedPortNumber();
        JComponent comp = this.screen_.getPort(index);
        if (comp == null || !(comp instanceof Capable) || !(comp instanceof XpViewport)) {
            this.logger.log(Level.WARNING, "{0} Filming not supported", tln);
            this.logger.log(UserMessageLevel.USER_MSG, CvUtils.getResourceBundle().getString("FILM_NOT_SUPP"));
            return;
        }
        if (comp instanceof FrameCapable && ((FrameCapable)((Object)comp)).getNumFrames() > CvUtils.getLargeSeriesSize()) {
            this.logger.log(Level.WARNING, "{0} Print series not supported for series size > " + CvUtils.getLargeSeriesSize());
            this.logger.log(UserMessageLevel.USER_MSG, CvUtils.getResourceBundle().getString("XP_SERIES_TOO_LAREG_FOR_CMD"));
            return;
        }
        Capable cpb = (Capable)((Object)comp);
        final XpViewport port = (XpViewport)((XpViewport)cpb).clone();
        final Dimension portSize_ = port instanceof XpCompositePort ? new Dimension(((XpCompositePort)cpb).getPort(0).getWidth(), ((XpCompositePort)cpb).getPort(0).getHeight()) : new Dimension(((XpViewport)cpb).getWidth(), ((XpViewport)cpb).getHeight());
        int[] annotkey = null;
        String mod = null;
        if (cpb instanceof FrameOwner) {
            mod = DicomUtils.getModality((XpMedicalImage)((FrameOwner)((Object)cpb)).getFrame());
        }
        boolean isRefAllOn = false;
        if (cpb instanceof XpCompositePort) {
            annotkey = XPDisplayPrefsUtils.getLargeFontAnnotationKeys(((XpCompositePort)cpb).getPort(0), mod, XPDisplayPrefsUtils.getFilmLargeFontAnnotationLevel());
            isRefAllOn = XpReferenceImageApp.isRefPortAllOn((XpCompositePort)cpb);
            if (isRefAllOn && XpReferenceImageApp.copyInstance((XpCompositePort)cpb, port, true) == null) {
                this.logger.log(Level.SEVERE, "{0} Sev5 Error in printing: Failed to copy Ref image app instance");
                this.logger.log(Level.SEVERE, CvGESyslogMessageCode.CV_PRINT_ERROR.getLocalizedMessage(), new Object[]{CvGESyslogMessageCode.CV_PRINT_ERROR, CvUtils.getResourceBundle().getString("FILM_ERROR")});
                return;
            }
        } else if (cpb instanceof XpImageViewport) {
            annotkey = XPDisplayPrefsUtils.getLargeFontAnnotationKeys((XpImageViewport)cpb, mod, XPDisplayPrefsUtils.getFilmLargeFontAnnotationLevel());
            isRefAllOn = XpReferenceImageApp.isRefPortAllOn((XpImageViewport)cpb);
            if (isRefAllOn && XpReferenceImageApp.copyInstance((XpImageViewport)cpb, port, true) == null) {
                this.logger.log(Level.SEVERE, "{0} Sev5 Error in printing: Failed to copy Ref image app instance");
                this.logger.log(Level.SEVERE, CvGESyslogMessageCode.CV_PRINT_ERROR.getLocalizedMessage(), new Object[]{CvGESyslogMessageCode.CV_PRINT_ERROR, CvUtils.getResourceBundle().getString("FILM_ERROR")});
                return;
            }
        } else {
            this.logger.log(Level.WARNING, "{0} Filming not supported", tln);
            this.logger.log(UserMessageLevel.USER_MSG, CvUtils.getResourceBundle().getString("FILM_NOT_SUPP"));
            return;
        }
        final boolean refon = isRefAllOn;
        final String filmAnnotLevel = XPDisplayPrefsUtils.getFilmAnnotationLevel();
        final int filmCustAnnoMask = XPDisplayPrefsUtils.getFilmCustomAnnotationLevel();
        final int[] aKey = annotkey;
        Thread spt = new Thread(){

            @Override
            public void run() {
                block15: {
                    String format;
                    SimpleDoc doc = null;
                    HashPrintRequestAttributeSet aset = null;
                    aset = new HashPrintRequestAttributeSet();
                    aset.add(new SeriesPrint("SeriesPrint", new Locale("en")));
                    if (XpFilmPanel.this.lastPageCheckBox.isSelected()) {
                        aset.add(new ForcePrint("ForcePrint", new Locale("en")));
                    }
                    if (!(format = (String)XpFilmPanel.this.combox.getSelectedItem()).equals(use_fc_format)) {
                        try {
                            int format_row = Integer.parseInt(format.substring(0, format.indexOf(120)));
                            int format_cols = Integer.parseInt(format.substring(format.indexOf(120) + 1));
                            System.err.println("format_row==" + format_row + "format_cols==" + format_cols);
                            aset.add(new PrintRowColFormat(format_row, format_cols));
                        }
                        catch (NumberFormatException nex) {
                            // empty catch block
                        }
                    }
                    int numFrames = 0;
                    if (port != null && port instanceof FramePositioningCapable) {
                        numFrames = ((FramePositioningCapable)((Object)port)).getNumFrames();
                    }
                    int i2 = 1;
                    int inc = 1;
                    int maxImage = numFrames;
                    try {
                        inc = Integer.parseInt(((JSpinner.NumberEditor)XpFilmPanel.this.imgInterval.getEditor()).getTextField().getText());
                        if (XpFilmPanel.this.range.isSelected()) {
                            i2 = Integer.parseInt(((JSpinner.NumberEditor)XpFilmPanel.this.from.getEditor()).getTextField().getText());
                            maxImage = Integer.parseInt(((JSpinner.NumberEditor)XpFilmPanel.this.to.getEditor()).getTextField().getText());
                        }
                    }
                    catch (NumberFormatException e2) {
                        XpFilmPanel.this.logger.log(Level.WARNING, "Values are non integers : " + e2.getMessage());
                    }
                    XpFilmPanel.this.imageLeft = numFrames = (maxImage - i2) / inc + 1;
                    if (XpFilmPanel.this.flmsers.isEnabled()) {
                        XpFilmPanel.this.flmsers.setEnabled(false);
                        XpFilmPanel.this.flm_cancel.setEnabled(true);
                    }
                    try {
                        if (port != null) {
                            double width = port.getImageAt((int)0).getSlice().width;
                            double height = port.getImageAt((int)0).getSlice().height;
                            XpFilmPanel.this.logger.log(Level.INFO, "{0} begin NUMIMAGES=" + XpFilmPanel.this.imageLeft + " IMAGESIZE=" + width + " x " + height, tln);
                            XpFilmPanel.this.prsStartTime = System.currentTimeMillis();
                            XpFilmPanel.this.numCount = 0;
                            XpDicomObject img = (XpDicomObject)((Object)port.getImageAt(i2 - 1));
                            img.getValues(new XpDicomElement[]{XpFilmPanel.this.exNo, XpFilmPanel.this.seNo});
                            XpFilmPanel.this.pageable = new DicomPageablePort(port, i2 - 1, maxImage - 1, inc);
                            XpFilmPanel.this.pageable.setSize(portSize_);
                            XpFilmPanel.this.pageable.setReferenceOn(refon);
                            XpFilmPanel.this.pageable.setLargeFontKeys(aKey);
                            XpFilmPanel.this.pageable.setFilmAnnotationSetting(filmAnnotLevel, filmCustAnnoMask);
                            doc = new SimpleDoc(XpFilmPanel.this.pageable, DocFlavor.SERVICE_FORMATTED.PAGEABLE, null);
                            XpFilmPanel.this.job.print(doc, aset);
                        } else {
                            XpFilmPanel.this.logger.log(Level.WARNING, "Viewport is null", tln);
                        }
                    }
                    catch (PrintException pe) {
                        XpFilmPanel.this.logger.log(Level.SEVERE, "{0} Error in printing due to " + pe.getMessage(), tln);
                        XpFilmPanel.this.logger.log(Level.SEVERE, CvGESyslogMessageCode.CV_PRINT_ERROR.getLocalizedMessage(), new Object[]{CvGESyslogMessageCode.CV_PRINT_ERROR, pe.getMessage()});
                        XpFilmPanel.this.imageLeft = -1;
                        if (!XpFilmPanel.this.flmsers.isEnabled()) {
                            XpFilmPanel.this.flmsers.setEnabled(true);
                            XpFilmPanel.this.flm_cancel.setEnabled(false);
                        }
                    }
                    catch (Exception ex) {
                        XpFilmPanel.this.logger.log(Level.SEVERE, "{0} Error in printing due to " + ex.getMessage(), tln);
                        XpFilmPanel.this.logger.log(Level.SEVERE, CvGESyslogMessageCode.CV_PRINT_ERROR.getLocalizedMessage(), new Object[]{CvGESyslogMessageCode.CV_PRINT_ERROR, ex.getMessage()});
                        XpFilmPanel.this.imageLeft = -1;
                        if (XpFilmPanel.this.flmsers.isEnabled()) break block15;
                        XpFilmPanel.this.flmsers.setEnabled(true);
                        XpFilmPanel.this.flm_cancel.setEnabled(false);
                    }
                }
                XpFilmPanel.this.logger.log(Level.INFO, "{0} end", tln);
            }
        };
        spt.start();
    }

    private void btflmcancel_actionPerformed(ActionEvent e2) {
        PrinterJob pjob = (PrinterJob)((Object)this.job);
        pjob.cancel();
    }

    @Override
    public String getTitle() {
        return CvUtils.getResourceBundle().getString("XP_FILM_PA_TOOLTIP");
    }

    @Override
    public String getName() {
        return CvUtils.getResourceBundle().getString("XP_FILM_PA_NAME");
    }

    private void seriesPrintComplete() {
        this.logger.log(Level.INFO, "seriesPrintComplete called.");
        if (this.pageable != null) {
            this.pageable.dispose();
            this.pageable = null;
        }
        if (this.prsStartTime > 0L) {
            long endTime = System.currentTimeMillis();
            if ((endTime - this.prsStartTime) / 1000L > 0L) {
                long prsRate = (long)this.numCount / ((endTime - this.prsStartTime) / 1000L);
                this.logger.log(Level.INFO, "FILMRATE = {0} images/sec", prsRate);
            }
            this.prsStartTime = 0L;
            this.numCount = -1;
        }
        this.imageLeft = -1;
        this.lastModifiedSpinner = SPINNER.NONE;
        this.statusArea.setText("");
        if (!this.flmsers.isEnabled()) {
            this.flmsers.setEnabled(true);
            this.flm_cancel.setEnabled(false);
        }
    }

    private void validateInput() {
        int toInt;
        int fromInt;
        String fromStrVal = ((JSpinner.NumberEditor)this.from.getEditor()).getTextField().getText();
        String toStrVal = ((JSpinner.NumberEditor)this.to.getEditor()).getTextField().getText();
        String imgIntervalStrVal = ((JSpinner.NumberEditor)this.imgInterval.getEditor()).getTextField().getText();
        if (fromStrVal == null || fromStrVal.equals("")) {
            ((JSpinner.NumberEditor)this.from.getEditor()).getTextField().setText(String.valueOf(((SpinnerNumberModel)this.from.getModel()).getMinimum()));
        }
        if (toStrVal == null || toStrVal.equals("")) {
            ((JSpinner.NumberEditor)this.to.getEditor()).getTextField().setText(String.valueOf(((SpinnerNumberModel)this.to.getModel()).getMaximum()));
        }
        if (imgIntervalStrVal == null || imgIntervalStrVal.equals("")) {
            ((JSpinner.NumberEditor)this.imgInterval.getEditor()).getTextField().setText(String.valueOf(((SpinnerNumberModel)this.imgInterval.getModel()).getMinimum()));
        }
        int min = Integer.parseInt(String.valueOf(((SpinnerNumberModel)this.from.getModel()).getMinimum()));
        int max = Integer.parseInt(String.valueOf(((SpinnerNumberModel)this.to.getModel()).getMaximum()));
        try {
            fromStrVal = ((JSpinner.DefaultEditor)this.from.getEditor()).getTextField().getText();
            fromInt = Integer.parseInt(fromStrVal);
            if (fromInt < min || fromInt > CvUtils.getLargeSeriesSize()) {
                ((JSpinner.NumberEditor)this.from.getEditor()).getTextField().setText(String.valueOf(((SpinnerNumberModel)this.from.getModel()).getMinimum()));
            }
        }
        catch (NumberFormatException nfe) {
            ((JSpinner.NumberEditor)this.from.getEditor()).getTextField().setText(String.valueOf(((SpinnerNumberModel)this.from.getModel()).getMinimum()));
        }
        try {
            toStrVal = ((JSpinner.DefaultEditor)this.to.getEditor()).getTextField().getText();
            toInt = Integer.parseInt(toStrVal);
            if (toInt > max || toInt > CvUtils.getLargeSeriesSize()) {
                ((JSpinner.NumberEditor)this.to.getEditor()).getTextField().setText(String.valueOf(((SpinnerNumberModel)this.to.getModel()).getMaximum()));
            }
        }
        catch (NumberFormatException nfe) {
            ((JSpinner.NumberEditor)this.to.getEditor()).getTextField().setText(String.valueOf(((SpinnerNumberModel)this.to.getModel()).getMaximum()));
        }
        try {
            imgIntervalStrVal = ((JSpinner.DefaultEditor)this.imgInterval.getEditor()).getTextField().getText();
            int imgIntervalInt = Integer.parseInt(imgIntervalStrVal);
            if (imgIntervalInt <= 0) {
                ((JSpinner.NumberEditor)this.imgInterval.getEditor()).getTextField().setText(String.valueOf(((SpinnerNumberModel)this.imgInterval.getModel()).getMinimum()));
            }
            if (imgIntervalInt > max || imgIntervalInt > CvUtils.getLargeSeriesSize()) {
                ((JSpinner.NumberEditor)this.imgInterval.getEditor()).getTextField().setText(String.valueOf(((SpinnerNumberModel)this.imgInterval.getModel()).getMaximum()));
            }
        }
        catch (NumberFormatException nfe) {
            ((JSpinner.NumberEditor)this.imgInterval.getEditor()).getTextField().setText(String.valueOf(((SpinnerNumberModel)this.imgInterval.getModel()).getMinimum()));
        }
        fromStrVal = ((JSpinner.NumberEditor)this.from.getEditor()).getTextField().getText();
        toStrVal = ((JSpinner.NumberEditor)this.to.getEditor()).getTextField().getText();
        imgIntervalStrVal = ((JSpinner.NumberEditor)this.imgInterval.getEditor()).getTextField().getText();
        try {
            fromInt = Integer.parseInt(fromStrVal);
            toInt = Integer.parseInt(toStrVal);
            if (fromInt > toInt) {
                if (this.lastModifiedSpinner == SPINNER.FROM) {
                    ((JSpinner.NumberEditor)this.from.getEditor()).getTextField().setText(String.valueOf(((SpinnerNumberModel)this.from.getModel()).getMinimum()));
                } else if (this.lastModifiedSpinner == SPINNER.TO) {
                    ((JSpinner.NumberEditor)this.to.getEditor()).getTextField().setText(String.valueOf(((SpinnerNumberModel)this.to.getModel()).getMaximum()));
                }
            }
            this.lastModifiedSpinner = SPINNER.NONE;
        }
        catch (Exception e2) {
            this.lastModifiedSpinner = SPINNER.NONE;
        }
    }

    private class SpinnerKeyListener
    implements KeyListener {
        private SpinnerKeyListener() {
        }

        @Override
        public void keyPressed(KeyEvent e2) {
        }

        @Override
        public void keyReleased(KeyEvent e2) {
            String componentName = ((JFormattedTextField)e2.getSource()).getParent().getParent().getName();
            if (componentName.equalsIgnoreCase(FILM_FROM)) {
                XpFilmPanel.this.lastModifiedSpinner = SPINNER.FROM;
            } else if (componentName.equalsIgnoreCase(FILM_TO)) {
                XpFilmPanel.this.lastModifiedSpinner = SPINNER.TO;
            }
        }

        @Override
        public void keyTyped(KeyEvent e2) {
            char c2 = e2.getKeyChar();
            if ((c2 < '0' || c2 > '9') && c2 != '\b' && c2 != '\u007f') {
                XpFilmPanel.this.getToolkit().beep();
                e2.consume();
            }
        }
    }

    private static enum SPINNER {
        NONE,
        FROM,
        TO;

    }
}

