/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.cpanels;

import com.ge.med.cse.cvf.log.UserMessageLevel;
import com.ge.med.cse.cvf.model.XpFilterModel;
import com.ge.med.cse.cvf.util.CvPropertiesManager;
import com.ge.med.cse.cvf.util.CvUtils;
import com.ge.med.idc.ColorMapCapable;
import com.ge.med.terra.jami.capable.FrameCapable;
import com.ge.med.terra.jami.capable.ImageOpCapable;
import com.ge.med.terra.jami.filter.XpImageConvolution;
import com.ge.med.terra.jami.render.XpImageRenderAttributes;
import com.ge.med.terra.jami.render.XpImageRenderAttributesOwner;
import com.ge.med.terra.xpv.autoControls.XPcaAutoControlPanel;
import com.ge.med.terra.xpv.base.XPscreen;
import com.ge.med.terra.xpv.cuiPanels.DisplayColorModelUtils;
import com.ge.med.terra.xpv.cuiPanels.ImageFilter;
import com.ge.med.terra.xpv.cuiPanels.TransactionLogName;
import com.ge.med.terra.xpv.util.XPutil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.IndexColorModel;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class XpFilterPanel
extends XPcaAutoControlPanel {
    protected static ResourceBundle res = CvUtils.getResourceBundle();
    JTextArea esFilterLabel;
    JTextArea gsFilterLabel;
    JList esFiltersList;
    JList gsFiltersList;
    JComboBox escombox;
    JComboBox gscombox;
    JPanel content;
    JPanel esPanel;
    JPanel gsPanel;
    String ui = null;
    protected XpFilterModel esFiltersModel = new XpFilterModel(XpFilterModel.FILTER_TYPE.ES_FILTER);
    protected XpFilterModel gsFiltersModel = new XpFilterModel(XpFilterModel.FILTER_TYPE.GS_FILTER);
    protected ActionListener actList = new FilterChangeListener();
    Logger logger = Logger.getLogger("com.ge.med.cse.cvf.cpanels");
    boolean uiIntiated = false;
    static final String G1 = "g1";
    static final String G2 = "g2";
    static final String G3 = "g3";
    private FilterChangeListener selectionListener = new FilterChangeListener();
    PropertyChangeListener vpListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals("parent_port_changed")) {
                XpFilterPanel.this.updateESList();
                XpFilterPanel.this.updateGSList();
            } else if (evt.getPropertyName().equals("CONTENT_CHANGED")) {
                int i2;
                for (i2 = 0; i2 < XpFilterPanel.this.esFiltersList.getModel().getSize(); ++i2) {
                    if (!XpFilterPanel.this.esFiltersList.getModel().getElementAt(i2).equals("NONE")) continue;
                    XpFilterPanel.this.esFiltersList.setSelectedIndex(i2);
                    break;
                }
                for (i2 = 0; i2 < XpFilterPanel.this.gsFiltersList.getModel().getSize(); ++i2) {
                    if (!XpFilterPanel.this.gsFiltersList.getModel().getElementAt(i2).toString().trim().equalsIgnoreCase("NONE")) continue;
                    XpFilterPanel.this.gsFiltersList.setSelectedIndex(i2);
                    break;
                }
            } else if (evt.getPropertyName().equals("filter")) {
                System.out.println("property is changed");
                XpFilterPanel.this.updateESList();
            } else if (evt.getPropertyName().equalsIgnoreCase("COLOR_MAP")) {
                if (XpFilterPanel.this.uiIntiated) {
                    ColorMapCapable cmap;
                    XpFilterPanel.this.gsFiltersList.removeListSelectionListener(XpFilterPanel.this.selectionListener);
                    JComponent selectedPort = XpFilterPanel.this.screen_.getSelectedPort();
                    if (selectedPort != null && (cmap = (ColorMapCapable)XpFilterPanel.this.screen_.getCapable(ColorMapCapable.class.getName())) != null) {
                        String colorName = null;
                        String[] toLookup = CvPropertiesManager.getProperty("colorMaps", "").split(",");
                        int[] appliedCmap = cmap.getColorMap();
                        if (appliedCmap != null) {
                            for (String cmp : toLookup) {
                                if (!Arrays.equals(appliedCmap, XPutil.getColorTable(cmp))) continue;
                                colorName = cmp;
                                break;
                            }
                            if (colorName != null && !colorName.equalsIgnoreCase("none")) {
                                for (int i3 = 0; i3 < XpFilterPanel.this.gsFiltersList.getModel().getSize(); ++i3) {
                                    if (!XpFilterPanel.this.esFiltersList.getModel().getElementAt(i3).toString().trim().equalsIgnoreCase("none")) continue;
                                    XpFilterPanel.this.gsFiltersList.setSelectedIndex(i3);
                                    break;
                                }
                            }
                        }
                    }
                    XpFilterPanel.this.gsFiltersList.addListSelectionListener(XpFilterPanel.this.selectionListener);
                }
            } else if (evt.getPropertyName().equalsIgnoreCase("gse")) {
                System.out.println("property is changed");
                XpFilterPanel.this.updateGSList();
            }
        }
    };

    public XpFilterPanel() {
        this.setName("XpFilterPanel");
        this.setIcon(CvUtils.getIcon("XP_FILTER_ICON"));
        TransactionLogName tln = new TransactionLogName("TID=CreateFilterPanel");
        this.logger.log(Level.FINE, "{0} begin,Creating Filter Panel", tln);
        if (!CvPropertiesManager.getBoolean("isLazyLoading", false)) {
            try {
                this.jbInit();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            this.uiIntiated = true;
        }
        this.logger.log(Level.FINE, "{0} end,Creating Filter Panel", tln);
    }

    @Override
    public void panelStart() {
        super.panelStart();
        if (CvPropertiesManager.getBoolean("isLazyLoading", false) && !this.uiIntiated) {
            try {
                this.jbInit();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            CvUtils.updateBackground(this, UIManager.getColor("P9"));
            this.uiIntiated = true;
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(new BorderLayout());
        this.ui = CvPropertiesManager.getProperty("cvf.filterPanel.UI", "list");
        this.initUI();
        if (this.ui.equals("list")) {
            this.initListUI();
        } else {
            this.initComboxUI();
        }
        this.setBackground(null);
        this.esFilterLabel.setLineWrap(true);
        this.esFilterLabel.setEditable(false);
        this.esFilterLabel.setOpaque(false);
        this.esFilterLabel.setText(CvUtils.getResourceBundle().getString("XP_EDGE_SMOOTH_TEXT"));
        this.esFilterLabel.setFocusable(false);
        this.gsFilterLabel.setLineWrap(true);
        this.gsFilterLabel.setEditable(false);
        this.gsFilterLabel.setOpaque(false);
        this.gsFilterLabel.setFocusable(false);
        this.gsFilterLabel.setText(CvUtils.getResourceBundle().getString("XP_GRAY_SCALE_TEXT"));
        this.esFilterLabel.setName("esFilterLabel");
        this.gsFilterLabel.setName("gsFilterLabel");
    }

    private void initUI() {
        this.esFilterLabel = new JTextArea();
        this.gsFilterLabel = new JTextArea();
    }

    private void initComboxUI() {
        this.escombox = new JComboBox(this.esFiltersModel);
        this.gscombox = new JComboBox(this.gsFiltersModel);
        this.escombox.setName("esFilters");
        this.gscombox.setName("gsFilters");
        this.escombox.addActionListener(this.actList);
        this.gscombox.addActionListener(this.actList);
        this.content = new JPanel(new GridLayout(1, 2, 20, 10));
        this.content.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.content.setName(XpFilterPanel.class.getName() + "content");
        this.esPanel = new JPanel(new BorderLayout(0, 5));
        this.esPanel.setName(XpFilterPanel.class.getName() + "esPanel");
        this.gsPanel = new JPanel(new BorderLayout(0, 5));
        this.gsPanel.setName(XpFilterPanel.class.getName() + "gsPanel");
        this.content.add(this.esPanel);
        this.content.add(this.gsPanel);
        this.add(this.content);
        this.esPanel.add((Component)this.esFilterLabel, "North");
        this.gsPanel.add((Component)this.gsFilterLabel, "North");
        JPanel p2 = new JPanel(new BorderLayout());
        p2.add((Component)this.escombox, "North");
        this.esPanel.add(p2);
        p2 = new JPanel(new BorderLayout(0, 30));
        p2.add((Component)this.gscombox, "North");
        p2.setName(XpFilterPanel.class.getName() + "p");
        this.gsPanel.add(p2);
    }

    private void initListUI() {
        this.esFiltersList = new JList(this.esFiltersModel);
        this.gsFiltersList = new JList(this.gsFiltersModel);
        this.esFiltersList.setSelectedIndex(0);
        this.gsFiltersList.setSelectedIndex(0);
        this.esFiltersList.setName("esFilters");
        this.gsFiltersList.setName("gsFilters");
        this.esFiltersList.addListSelectionListener(this.selectionListener);
        this.gsFiltersList.addListSelectionListener(this.selectionListener);
        this.content = new JPanel(new GridLayout(1, 2, 0, 10));
        this.content.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.esPanel = new JPanel(new BorderLayout(0, 5));
        this.gsPanel = new JPanel(new BorderLayout(0, 5));
        this.content.setName(XpFilterPanel.class.getName() + "content");
        this.esPanel.setName(XpFilterPanel.class.getName() + "esPanel");
        this.gsPanel.setName(XpFilterPanel.class.getName() + "gsPanel");
        this.content.add(this.esPanel);
        this.content.add(this.gsPanel);
        this.add(this.content);
        this.esPanel.add((Component)this.esFilterLabel, "North");
        this.gsPanel.add((Component)this.gsFilterLabel, "North");
        JScrollPane esPane = new JScrollPane(this.esFiltersList, 20, 31);
        esPane.setPreferredSize(new Dimension(150, 262));
        esPane.setBackground(null);
        JPanel p2 = new JPanel(new FlowLayout());
        p2.add(esPane);
        this.esPanel.add((Component)p2, "West");
        JScrollPane gsPane = new JScrollPane(this.gsFiltersList, 20, 31);
        gsPane.setPreferredSize(new Dimension(150, 100));
        gsPane.setBackground(null);
        p2 = new JPanel(new FlowLayout());
        p2.add(gsPane);
        this.gsPanel.add((Component)p2, "West");
    }

    private void updateESList() {
        ImageOpCapable opcap = (ImageOpCapable)this.screen_.getCapable(ImageOpCapable.class.getName());
        boolean selected = false;
        if (opcap != null) {
            int i2;
            this.esFiltersList.removeListSelectionListener(this.selectionListener);
            List opList = opcap.getImageOps();
            String filtName = null;
            if (opList != null && opList.size() > 0) {
                for (i2 = 0; i2 < opList.size(); ++i2) {
                    filtName = ((XpImageConvolution)opList.get(i2)).getImageOpName();
                }
                if (filtName != null && !filtName.equalsIgnoreCase("None")) {
                    for (i2 = 0; i2 < this.esFiltersList.getModel().getSize(); ++i2) {
                        if (!this.esFiltersList.getModel().getElementAt(i2).toString().trim().equalsIgnoreCase(filtName)) continue;
                        this.esFiltersList.setSelectedIndex(i2);
                        selected = true;
                        break;
                    }
                }
            }
            if (!selected) {
                for (i2 = 0; i2 < this.esFiltersList.getModel().getSize(); ++i2) {
                    if (!this.esFiltersList.getModel().getElementAt(i2).toString().trim().equalsIgnoreCase("NONE")) continue;
                    this.esFiltersList.setSelectedIndex(i2);
                    break;
                }
            }
            this.esFiltersList.addListSelectionListener(this.selectionListener);
        }
    }

    private void updateGSList() {
        XpImageRenderAttributesOwner iraow = (XpImageRenderAttributesOwner)((Object)this.screen_.getCapable(XpImageRenderAttributesOwner.class.getName()));
        boolean selectedfil = false;
        if (iraow != null) {
            XpImageRenderAttributes ira = iraow.getImageRenderAttributes();
            this.gsFiltersList.removeListSelectionListener(this.selectionListener);
            if (ira != null) {
                String filter = null;
                IndexColorModel filName = ira.getColormap();
                if (filName != null) {
                    String filterName = filName.toString();
                    if (filterName.equals(G1)) {
                        filter = G1;
                    } else if (filterName.equals(G2)) {
                        filter = G2;
                    } else if (filterName.equals(G3)) {
                        filter = G3;
                    }
                    if (filter != null) {
                        for (int i2 = 0; i2 < this.gsFiltersList.getModel().getSize(); ++i2) {
                            if (!this.gsFiltersList.getModel().getElementAt(i2).toString().trim().equalsIgnoreCase(filter)) continue;
                            this.gsFiltersList.setSelectedIndex(i2);
                            selectedfil = true;
                            break;
                        }
                    }
                }
                if (!selectedfil) {
                    for (int i3 = 0; i3 < this.gsFiltersList.getModel().getSize(); ++i3) {
                        if (!this.gsFiltersList.getModel().getElementAt(i3).toString().trim().equalsIgnoreCase("None")) continue;
                        this.gsFiltersList.setSelectedIndex(i3);
                        break;
                    }
                }
            }
            this.gsFiltersList.addListSelectionListener(this.selectionListener);
        }
    }

    @Override
    public void setScreen(XPscreen screen) {
        super.setScreen(screen);
        screen.removePropertyChangeListener(this.vpListener);
        screen.addPropertyChangeListener(this.vpListener);
        if (this.uiIntiated) {
            this.updateESList();
            this.updateGSList();
        }
    }

    public String getGSFilter() {
        return this.ui.equals("list") ? (String)this.gsFiltersList.getSelectedValue() : (String)this.gscombox.getSelectedItem();
    }

    public String getESFilter() {
        return this.ui.equals("list") ? (String)this.esFiltersList.getSelectedValue() : (String)this.escombox.getSelectedItem();
    }

    public void setESFilter(String strESFilter) {
        if (this.ui.equals("list")) {
            this.esFiltersList.setSelectedValue(strESFilter, false);
        } else {
            this.escombox.setSelectedItem(strESFilter);
        }
        this.setESFilter2(strESFilter);
    }

    public void setGSFilter(String strGSFilter) {
        if (this.ui.equals("list")) {
            this.gsFiltersList.setSelectedValue(strGSFilter, false);
        } else {
            this.gscombox.setSelectedItem(strGSFilter);
        }
        this.setGSFilter2(strGSFilter);
    }

    private void setESFilter2(String filter) {
        TransactionLogName tln = new TransactionLogName("TID=Cv_filter_" + filter);
        this.logger.log(Level.FINEST, "{0} begin", tln);
        ImageOpCapable imageOp = (ImageOpCapable)this.screen_.getCapable(ImageOpCapable.class.getName());
        if (imageOp == null) {
            this.logger.log(Level.INFO, "{0}SEV5 not ImageOpCapable", tln);
            return;
        }
        if (!this.isValidImage()) {
            return;
        }
        imageOp.clearImageOps();
        if (filter.equals(res.getString("FilterPanel.E1"))) {
            imageOp.addImageOp(ImageFilter.E1());
        } else if (filter.equals(res.getString("FilterPanel.E2"))) {
            imageOp.addImageOp(ImageFilter.E2());
        } else if (filter.equals(res.getString("FilterPanel.E21"))) {
            imageOp.addImageOp(ImageFilter.E21());
        } else if (filter.equals(res.getString("FilterPanel.E22"))) {
            imageOp.addImageOp(ImageFilter.E22());
        } else if (filter.equals(res.getString("FilterPanel.E23"))) {
            imageOp.addImageOp(ImageFilter.E23());
        } else if (filter.equals(res.getString("FilterPanel.E3"))) {
            imageOp.addImageOp(ImageFilter.E3());
        } else if (filter.equals(res.getString("FilterPanel.S1"))) {
            imageOp.addImageOp(ImageFilter.S1());
        } else if (filter.equals(res.getString("FilterPanel.S11"))) {
            imageOp.addImageOp(ImageFilter.S11());
        } else if (filter.equals(res.getString("FilterPanel.S2"))) {
            imageOp.addImageOp(ImageFilter.S2());
        } else if (filter.equals(res.getString("FilterPanel.S21"))) {
            imageOp.addImageOp(ImageFilter.S21());
        } else if (filter.equals(res.getString("FilterPanel.S3"))) {
            imageOp.addImageOp(ImageFilter.S3());
        } else if (filter.equals(res.getString("FilterPanel.Lung"))) {
            imageOp.addImageOp(ImageFilter.lung());
        }
        this.logger.log(Level.FINEST, "{0} end", tln);
    }

    private void setGSFilter2(String selFilter) {
        TransactionLogName tln = new TransactionLogName("TID=Cv_filter_gse");
        this.logger.log(Level.FINEST, "{0} begin", tln);
        if (!this.isValidImage()) {
            return;
        }
        JComponent selectedPort = this.screen_.getSelectedPort();
        if (selectedPort instanceof XpImageRenderAttributesOwner) {
            if ("none".equalsIgnoreCase(selFilter)) {
                DisplayColorModelUtils.unapplyGSE((XpImageRenderAttributesOwner)((Object)selectedPort));
            } else if (G1.equalsIgnoreCase(selFilter)) {
                DisplayColorModelUtils.applyGSE_G1((XpImageRenderAttributesOwner)((Object)selectedPort));
            } else if (G2.equalsIgnoreCase(selFilter)) {
                DisplayColorModelUtils.applyGSE_G2((XpImageRenderAttributesOwner)((Object)selectedPort));
            } else if (G3.equalsIgnoreCase(selFilter)) {
                DisplayColorModelUtils.applyGSE_G3((XpImageRenderAttributesOwner)((Object)selectedPort));
            }
            selectedPort.repaint();
        }
        this.logger.log(Level.FINEST, "{0} end", tln);
    }

    @Override
    public String getTitle() {
        return CvUtils.getResourceBundle().getString("XP_FILTER_TITLE");
    }

    @Override
    public String getName() {
        return CvUtils.getResourceBundle().getString("XP_FILTER_NAME");
    }

    private boolean isValidImage() {
        FrameCapable fc = (FrameCapable)((Object)this.screen_.getCapable(FrameCapable.class.getName()));
        if (!(fc.getFrame() == null || CvUtils.measurementsValid(fc.getFrame()) && CvUtils.isGSEFilterValid(fc.getFrame()))) {
            this.logger.log(Level.INFO, "unsupported image type");
            this.logger.log(UserMessageLevel.USER_MSG, CvUtils.getResourceBundle().getString("CMD_NOT_SUPPORTED"));
            return false;
        }
        return true;
    }

    class FilterChangeListener
    implements ActionListener,
    ListSelectionListener {
        FilterChangeListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e2) {
            String selFilter = (String)((JComboBox)e2.getSource()).getSelectedItem();
            String name = ((JComboBox)e2.getSource()).getName();
            this.applyFilter(selFilter, name);
        }

        @Override
        public void valueChanged(ListSelectionEvent e2) {
            String selected = (String)((JList)e2.getSource()).getSelectedValue();
            String name = ((JList)e2.getSource()).getName();
            if (!e2.getValueIsAdjusting()) {
                this.applyFilter(selected, name);
            }
        }

        private void applyFilter(String selected, String name) {
            if (name.equals("esFilters")) {
                XpFilterPanel.this.setESFilter(selected);
            } else {
                XpFilterPanel.this.setGSFilter(selected);
            }
        }
    }
}

