/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.cpanels;

import com.ge.med.cse.cvf.cpanels.XPDisplayPrefsUtils;
import com.ge.med.cse.cvf.prefs.XpIPrefsCallBack;
import com.ge.med.cse.cvf.prefs.XpSavePrefsAction;
import com.ge.med.cse.cvf.util.CvUtils;
import com.ge.med.terra.xpv.autoControls.XPcaAutoControlPanel;
import com.ge.med.terra.xpv.base.XPscreen;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class XpGridPanel
extends XPcaAutoControlPanel
implements ActionListener,
XpIPrefsCallBack {
    private JLabel lineStyle;
    private JLabel gdSpacing;
    private JLabel tkSpacing;
    private JLabel tkLength;
    private JLabel matxLines;
    private JRadioButton dotted;
    private JRadioButton solid;
    private JRadioButton on;
    private JRadioButton off;
    private JTextField gdspc;
    private JTextField tkspc;
    private JTextField tklen;
    private ButtonGroup bg1;
    private ButtonGroup bg2;
    private JPanel panel1;
    private JPanel panel2;
    private JButton apply;
    private JButton save;
    private String DOTTEDSTYLE = "DOTTED";
    private String SOLIDSTYLE = "SOLID";
    public static final String REGEX = "[0-9]+\\.?[0-9]?";
    public static final double GRID_MIN_VALUE = 1.0;
    public static final double GRID_MAX_VALUE = 2000.0;

    public XpGridPanel() {
        this.initUI();
    }

    private void initUI() {
        this.setIcon(CvUtils.getIcon("XP_GRID_ICON"));
        this.setBackground(null);
        this.setName("XpGridPanel");
        this.matxLines = new JLabel(CvUtils.getResourceBundle().getString("XP_GRID_MATRIXLINES"));
        this.lineStyle = new JLabel(CvUtils.getResourceBundle().getString("XP_GRID_LINESTYLE"));
        this.gdSpacing = new JLabel(CvUtils.getResourceBundle().getString("XP_GRID_GRIDSPACING"));
        this.tkSpacing = new JLabel(CvUtils.getResourceBundle().getString("XP_GRID_TICKSPACING"));
        this.tkLength = new JLabel(CvUtils.getResourceBundle().getString("XP_GRID_TICKLENGTH"));
        this.lineStyle.setName(XpGridPanel.class.getName() + "LineStyle");
        this.matxLines.setName(XpGridPanel.class.getName() + "MatxLines");
        this.gdSpacing.setName(XpGridPanel.class.getName() + "GdSpacing");
        this.tkSpacing.setName(XpGridPanel.class.getName() + "TkSpacing");
        this.tkLength.setName(XpGridPanel.class.getName() + "TkLength");
        this.bg1 = new ButtonGroup();
        this.on = new JRadioButton(CvUtils.getResourceBundle().getString("XP_GRID_MATRIXON"));
        this.on.setName("MatrixOn");
        this.on.setFocusable(false);
        this.off = new JRadioButton(CvUtils.getResourceBundle().getString("XP_GRID_MATRIXOFF"));
        this.off.setName("MatrixOff");
        this.off.setFocusable(false);
        this.bg1.add(this.on);
        this.bg1.add(this.off);
        this.bg2 = new ButtonGroup();
        this.dotted = new JRadioButton(CvUtils.getResourceBundle().getString("XP_GRID_LINEDOTTED"));
        this.dotted.setName("LineDotted");
        this.dotted.setFocusable(false);
        this.solid = new JRadioButton(CvUtils.getResourceBundle().getString("XP_GRID_LINESOLID"));
        this.solid.setName("LineSolid");
        this.solid.setFocusable(false);
        this.bg2.add(this.dotted);
        this.bg2.add(this.solid);
        this.gdspc = new JTextField();
        this.gdspc.setName("GridSpacing");
        this.gdspc.setPreferredSize(new Dimension(60, 30));
        this.tkspc = new JTextField();
        this.tkspc.setName("TickSpacing");
        this.tkspc.setPreferredSize(new Dimension(60, 30));
        this.tklen = new JTextField();
        this.tklen.setName("TickLength");
        this.tklen.setPreferredSize(new Dimension(60, 30));
        this.apply = new JButton(CvUtils.getResourceBundle().getString("XP_GRID_APPLY"));
        this.apply.setName("GridApply");
        this.apply.setFocusable(false);
        this.apply.addActionListener(this);
        this.apply.setActionCommand("APPLY");
        this.save = new JButton(new XpSavePrefsAction(this));
        this.save.setName("GridSave");
        this.save.setText(CvUtils.getResourceBundle().getString("XP_SAVE_PREFS_NAME"));
        this.save.setFocusable(false);
        JPanel panl = new JPanel();
        panl.setLayout(new GridBagLayout());
        panl.add((Component)this.on, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        panl.add((Component)this.off, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        JPanel pan = new JPanel();
        pan.setLayout(new GridBagLayout());
        pan.add((Component)this.matxLines, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 5, 10), 0, 0));
        pan.add((Component)panl, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 10, 0, 0), 0, 0));
        pan.setName(XpGridPanel.class.getName() + "pan");
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        panel.add((Component)this.dotted, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)this.solid, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        panel.setName(XpGridPanel.class.getName() + "panel");
        panel.setName(XpGridPanel.class.getName() + "panel");
        this.panel1 = new JPanel();
        this.panel1.setLayout(new GridBagLayout());
        this.panel1.add((Component)this.lineStyle, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 5, 0), 0, 0));
        this.panel1.add((Component)panel, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 10, 0, 0), 0, 0));
        this.panel1.setName(XpGridPanel.class.getName() + "panel1");
        this.panel2 = new JPanel();
        this.panel2.setLayout(new GridBagLayout());
        this.panel2.add((Component)this.gdSpacing, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 10, 10), 0, 0));
        this.panel2.add((Component)this.gdspc, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 10, 10), 0, 0));
        this.panel2.add((Component)this.tkSpacing, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 10, 10), 0, 0));
        this.panel2.add((Component)this.tkspc, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 10, 10), 0, 0));
        this.panel2.add((Component)this.tkLength, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 10, 10), 0, 0));
        this.panel2.add((Component)this.tklen, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 10, 10), 0, 0));
        this.panel2.setName(XpGridPanel.class.getName() + "panel2");
        JPanel panel3 = new JPanel();
        panel3.setLayout(new GridBagLayout());
        panel3.add((Component)this.save, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(15, 0, 10, 30), 0, 0));
        panel3.add((Component)this.apply, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(15, 0, 10, 10), 0, 0));
        panel3.setName(XpGridPanel.class.getName() + "panel3");
        JPanel panel4 = new JPanel();
        panel4.setLayout(new GridBagLayout());
        panel4.add((Component)pan, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(20, 0, 10, 0), 0, 0));
        panel4.add((Component)this.panel1, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 10, 0), 0, 0));
        panel4.add((Component)this.panel2, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 10, 10), 0, 0));
        panel4.add((Component)panel3, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 10, 10), 0, 0));
        panel4.setName(XpGridPanel.class.getName() + "panel4");
        this.add((Component)panel4, "West");
        this.updateGridSettings();
    }

    @Override
    public void setScreen(XPscreen screen) {
        super.setScreen(screen);
        this.screen_ = screen;
    }

    @Override
    public String getTitle() {
        return CvUtils.getResourceBundle().getString("XP_GRID_SETTINGS_TITLE");
    }

    @Override
    public void actionPerformed(ActionEvent e2) {
        if (e2.getActionCommand().equalsIgnoreCase("APPLY")) {
            String tspacing = this.tkspc.getText().trim();
            String tlen = this.tklen.getText().trim();
            String gspacing = this.gdspc.getText().trim();
            if (this.isInputValid(tspacing)) {
                XPDisplayPrefsUtils.updateTickSpacing(this.getBoundedValue(Double.parseDouble(tspacing)));
            } else {
                this.tkspc.setText("" + XPDisplayPrefsUtils.getTickSpacing());
            }
            if (this.isInputValid(tlen)) {
                XPDisplayPrefsUtils.updateTickLength(this.getBoundedValue(Double.parseDouble(tlen)));
            } else {
                this.tklen.setText("" + XPDisplayPrefsUtils.getTickLength());
            }
            if (this.isInputValid(gspacing)) {
                XPDisplayPrefsUtils.updateGridSpacing(this.getBoundedValue(Double.parseDouble(gspacing)));
            } else {
                this.gdspc.setText("" + XPDisplayPrefsUtils.getGridSpacing());
            }
            if (this.dotted.isSelected()) {
                XPDisplayPrefsUtils.updateLineStyle(this.DOTTEDSTYLE);
            } else if (this.solid.isSelected()) {
                XPDisplayPrefsUtils.updateLineStyle(this.SOLIDSTYLE);
            }
            if (this.on.isSelected()) {
                XPDisplayPrefsUtils.updateGridLinesOn(true);
            } else {
                XPDisplayPrefsUtils.updateGridLinesOn(false);
            }
            this.screen_.updateUI();
        }
    }

    private void updateGridSettings() {
        boolean gdLines_on = XPDisplayPrefsUtils.getGridLinesOn();
        if (gdLines_on) {
            this.on.setSelected(gdLines_on);
        } else {
            this.off.setSelected(!gdLines_on);
        }
        String styleSelected = XPDisplayPrefsUtils.getLineStyle();
        if (styleSelected.equalsIgnoreCase(this.DOTTEDSTYLE)) {
            this.dotted.setSelected(true);
        } else {
            this.solid.setSelected(true);
        }
        double gdspValue = XPDisplayPrefsUtils.getGridSpacing();
        this.gdspc.setText(Double.toString(gdspValue));
        double tkspValue = XPDisplayPrefsUtils.getTickSpacing();
        this.tkspc.setText(Double.toString(tkspValue));
        double tklenValue = XPDisplayPrefsUtils.getTickLength();
        this.tklen.setText(Double.toString(tklenValue));
    }

    @Override
    public void sync() {
        String tspacing = this.tkspc.getText().trim();
        String tlen = this.tklen.getText().trim();
        String gspacing = this.gdspc.getText().trim();
        if (this.isInputValid(tspacing)) {
            XPDisplayPrefsUtils.updateTickSpacing(this.getBoundedValue(Double.parseDouble(tspacing)));
            XPDisplayPrefsUtils.saveTickSpacing(Double.parseDouble(tspacing));
        } else {
            this.tkspc.setText("" + XPDisplayPrefsUtils.getTickSpacing());
        }
        if (this.isInputValid(tlen)) {
            XPDisplayPrefsUtils.updateTickLength(this.getBoundedValue(Double.parseDouble(tlen)));
            XPDisplayPrefsUtils.saveTickLength(Double.parseDouble(tlen));
        } else {
            this.tklen.setText("" + XPDisplayPrefsUtils.getTickLength());
        }
        if (this.isInputValid(gspacing)) {
            XPDisplayPrefsUtils.updateGridSpacing(this.getBoundedValue(Double.parseDouble(gspacing)));
            XPDisplayPrefsUtils.saveGridSpacing(Double.parseDouble(gspacing));
        } else {
            this.gdspc.setText("" + XPDisplayPrefsUtils.getGridSpacing());
        }
        if (this.dotted.isSelected()) {
            XPDisplayPrefsUtils.saveLineStyle(this.DOTTEDSTYLE);
        } else if (this.solid.isSelected()) {
            XPDisplayPrefsUtils.saveLineStyle(this.SOLIDSTYLE);
        }
        if (this.on.isSelected()) {
            XPDisplayPrefsUtils.saveGridLinesOn(true);
        } else {
            XPDisplayPrefsUtils.saveGridLinesOn(false);
        }
        this.screen_.updateUI();
    }

    private boolean isInputValid(String val) {
        return val != null && !val.equalsIgnoreCase("") && val.matches(REGEX);
    }

    private double getBoundedValue(double val) {
        if (val < 1.0) {
            return 1.0;
        }
        if (val > 2000.0) {
            return 2000.0;
        }
        return val;
    }
}

