/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.cpanels;

import com.ge.med.cse.cvf.util.CvUtils;
import com.ge.med.cse.cvf.util.ScreenLayoutHelper;
import com.ge.med.terra.xpv.autoControls.XPcaAutoControlPanel;
import com.ge.med.terra.xpv.base.XPscreen;
import com.ge.med.terra.xpv.base.XPscreenLayout;
import com.ge.med.terra.xpv.cuiPanels.TransactionLogName;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ButtonGroup;
import javax.swing.JToggleButton;

public class XpScreenLayoutPanel
extends XPcaAutoControlPanel {
    private final Logger logger = Logger.getLogger("com.ge.med.cse.cvf.cpanels");
    public static final String LOAD_DATA = "load_data";
    private JToggleButton[] layoutBtn = null;
    PropertyChangeListener vpListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equalsIgnoreCase("layout_changed") && XpScreenLayoutPanel.this.getScreen().getScreenLayout() instanceof XPscreenLayout) {
                XPscreenLayout scrnLayout = XpScreenLayoutPanel.this.getScreen().getScreenLayout();
                String layout = XPscreenLayout.getLayoutName(scrnLayout.getLayoutString());
                for (int i2 = 0; i2 < XpScreenLayoutPanel.this.layoutBtn.length; ++i2) {
                    if (!XpScreenLayoutPanel.this.layoutBtn[i2].getName().equalsIgnoreCase(layout)) continue;
                    XpScreenLayoutPanel.this.logger.log(Level.INFO, "Screen layout changed to:" + layout);
                    if (XpScreenLayoutPanel.this.layoutBtn[i2].isSelected()) break;
                    XpScreenLayoutPanel.this.layoutBtn[i2].setSelected(true);
                    break;
                }
            }
        }
    };

    public XpScreenLayoutPanel() {
        TransactionLogName tid = new TransactionLogName("TID=ScreenLayoutPanel");
        this.logger.log(Level.FINE, "{0} begin, Creating ScreenLayout panel", tid);
        this.initUI();
        this.logger.log(Level.FINE, "{0} end, Creating ScreenLayout panel", tid);
    }

    private void initUI() {
        final HashMap<String, XPscreenLayout> layouts = ScreenLayoutHelper.getInstance().getConfiguredLayouts();
        this.setIcon(CvUtils.getIcon("XP_LAYOUT_ICON"));
        this.setTitle(CvUtils.getResourceBundle().getString("XP_SCREEN_LAYOUT_TITLE"));
        this.setOpaque(false);
        this.setName("screenLayoutPanel");
        this.setLayout(new GridBagLayout());
        ButtonGroup bg = new ButtonGroup();
        String[] names = layouts.keySet().toArray(new String[layouts.size()]);
        this.layoutBtn = new JToggleButton[names.length];
        for (int i2 = 0; i2 < names.length; ++i2) {
            this.layoutBtn[i2] = new JToggleButton(CvUtils.getIcon("XP_" + names[i2].trim() + "_ICON"));
            this.layoutBtn[i2].setName(names[i2].trim());
            this.layoutBtn[i2].setPreferredSize(new Dimension(60, 40));
            this.layoutBtn[i2].setMargin(new Insets(0, 0, 0, 0));
            bg.add(this.layoutBtn[i2]);
            this.add((Component)this.layoutBtn[i2], new GridBagConstraints(i2 + 1, 0, 1, 1, 1.0, 1.0, 11, 0, new Insets(20, 0, 0, 0), 0, 0));
            this.layoutBtn[i2].addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e2) {
                    JToggleButton button = (JToggleButton)e2.getSource();
                    XpScreenLayoutPanel.this.getScreen().setLayout((XPscreenLayout)layouts.get(button.getName()));
                }
            });
        }
        this.layoutBtn[0].setSelected(true);
    }

    @Override
    public void setScreen(XPscreen screen) {
        super.setScreen(screen);
        screen.removePropertyChangeListener("layout_changed", this.vpListener);
        screen.addPropertyChangeListener("layout_changed", this.vpListener);
        if (this.getScreen().getLayout() instanceof XPscreenLayout) {
            XPscreenLayout scrnLayout = (XPscreenLayout)this.getScreen().getLayout();
            String layout = XPscreenLayout.getLayoutName(scrnLayout.getLayoutString());
            for (int i2 = 0; i2 < this.layoutBtn.length; ++i2) {
                if (!this.layoutBtn[i2].getName().equalsIgnoreCase(layout)) continue;
                this.logger.log(Level.INFO, "Screen layout changed to:" + layout);
                if (this.layoutBtn[i2].isSelected()) break;
                this.layoutBtn[i2].setSelected(true);
                break;
            }
        }
    }

    @Override
    public String getName() {
        return CvUtils.getResourceBundle().getString("XP_SCREEN_LAYOUT_TITLE");
    }
}

