/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.cpanels;

import com.ge.med.cse.cvf.cpanels.XPDisplayPrefsUtils;
import com.ge.med.cse.cvf.prefs.XpIPrefsCallBack;
import com.ge.med.cse.cvf.prefs.XpSavePrefsAction;
import com.ge.med.cse.cvf.util.CvUtils;
import com.ge.med.terra.xpv.autoControls.XPcaAutoControlPanel;
import com.ge.med.terra.xpv.base.XPscreen;
import com.ge.med.terra.xpv.cuiPanels.TransactionLogName;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextArea;

public class XpSeriesBindingPanel
extends XPcaAutoControlPanel
implements XpIPrefsCallBack,
ActionListener {
    private JLabel sbLabel = null;
    private JTextArea sbDescLabel = null;
    private JPanel buttonPanel = null;
    private JTextArea ontext = null;
    private JTextArea offtext = null;
    private ButtonGroup group = null;
    private JRadioButton onRadioBtn = null;
    private JRadioButton offRadioBtn = null;
    private JButton saveBtn = null;
    Logger logger = Logger.getLogger("com.ge.med.cse.cvf.cpanels");
    PropertyChangeListener vpListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equalsIgnoreCase("Series_binding")) {
                boolean sbStatus = (Boolean)evt.getNewValue();
                if (sbStatus) {
                    XpSeriesBindingPanel.this.onRadioBtn.setSelected(true);
                } else {
                    XpSeriesBindingPanel.this.offRadioBtn.setSelected(true);
                }
            } else if (evt.getPropertyName().equals("CONTENT_CHANGED") || evt.getPropertyName().equals("data_changed")) {
                XpSeriesBindingPanel.this.updateSBSettings();
            }
        }
    };

    public XpSeriesBindingPanel() {
        TransactionLogName tln = new TransactionLogName("TID=CreateSeriesBindingPanel");
        this.logger.log(Level.FINE, "{0} begin,Creating SeriesBindingPanel", tln);
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.setBackground(null);
        this.logger.log(Level.FINE, "{0} end,Creating SeriesBindingPanel", tln);
    }

    private void jbInit() throws Exception {
        this.initUI();
        this.setLayout(new BorderLayout());
        this.group.add(this.onRadioBtn);
        this.group.add(this.offRadioBtn);
        JPanel mainPanel = new JPanel(new GridBagLayout());
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setName(XpSeriesBindingPanel.class.getName() + "panel");
        mainPanel.add((Component)this.sbLabel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 11, 2, new Insets(15, 20, 10, 0), 0, 0));
        mainPanel.add((Component)this.sbDescLabel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 11, 2, new Insets(0, 30, 0, 0), 0, 0));
        panel.add((Component)this.onRadioBtn, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 11, 2, new Insets(20, 0, 20, 0), 0, 0));
        panel.add((Component)this.ontext, new GridBagConstraints(5, 0, 1, 1, 1.0, 1.0, 11, 2, new Insets(20, 0, 20, 0), 0, 0));
        panel.add((Component)this.offRadioBtn, new GridBagConstraints(0, 1, 1, 1, 0.5, 1.0, 11, 2, new Insets(0, 0, 30, 0), 0, 0));
        panel.add((Component)this.offtext, new GridBagConstraints(5, 1, 1, 1, 1.0, 1.0, 11, 2, new Insets(0, 0, 30, 0), 0, 0));
        JPanel panel1 = new JPanel();
        panel1.setLayout(new GridBagLayout());
        panel1.add((Component)mainPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 11, 2, new Insets(0, 0, 0, 0), 0, 0));
        panel1.add((Component)panel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 11, 2, new Insets(0, 30, 0, 0), 0, 0));
        panel1.setName(XpSeriesBindingPanel.class.getName() + "panel1");
        this.buttonPanel.add((Component)this.saveBtn, "Center");
        this.add((Component)panel1, "North");
        this.add((Component)this.buttonPanel, "Center");
    }

    private void initUI() {
        this.setTitle(CvUtils.getResourceBundle().getString("XP_SERIES_BINDING_TITLE"));
        this.sbLabel = new JLabel(CvUtils.getResourceBundle().getString("XP_SERIES_BINDING_LABEL"));
        this.sbLabel.setName(XpSeriesBindingPanel.class.getName() + "sbLabel");
        this.sbDescLabel = new JTextArea(CvUtils.getResourceBundle().getString("XP_SB_DESC_TEXT"));
        this.buttonPanel = new JPanel();
        this.buttonPanel.setName(XpSeriesBindingPanel.class.getName() + "buttonPanel");
        this.ontext = new JTextArea(CvUtils.getResourceBundle().getString("XP_SB_ON_TEXT"));
        this.offtext = new JTextArea(CvUtils.getResourceBundle().getString("XP_SB_OFF_TEXT"));
        this.group = new ButtonGroup();
        this.onRadioBtn = new JRadioButton();
        this.offRadioBtn = new JRadioButton();
        this.offRadioBtn.setName(XpSeriesBindingPanel.class.getName() + "offRadioBtn");
        this.onRadioBtn.setName(XpSeriesBindingPanel.class.getName() + "onRadioBtn");
        this.saveBtn = new JButton(new XpSavePrefsAction(this));
        this.onRadioBtn.setName("SB_ON");
        this.offRadioBtn.setName("SB_OFF");
        this.onRadioBtn.setFocusable(false);
        this.offRadioBtn.setFocusable(false);
        this.onRadioBtn.addActionListener(this);
        this.offRadioBtn.addActionListener(this);
        this.saveBtn.setFocusable(false);
        this.saveBtn.setName("SAVE_DEF");
        this.ontext.setEditable(false);
        this.ontext.setLineWrap(true);
        this.ontext.setWrapStyleWord(true);
        this.ontext.setFocusable(false);
        this.ontext.setName(XpSeriesBindingPanel.class.getName() + "ontext");
        this.offtext.setEditable(false);
        this.offtext.setLineWrap(true);
        this.offtext.setWrapStyleWord(true);
        this.offtext.setFocusable(false);
        this.offtext.setName(XpSeriesBindingPanel.class.getName() + "offtext");
        this.sbDescLabel.setEditable(false);
        this.sbDescLabel.setLineWrap(true);
        this.sbDescLabel.setWrapStyleWord(true);
        this.sbDescLabel.setFocusable(false);
        this.sbDescLabel.setName(XpSeriesBindingPanel.class.getName() + "sbDescLabel");
        this.updateSBSettings();
    }

    @Override
    public void setScreen(XPscreen screen) {
        super.setScreen(screen);
        if (screen == null) {
            return;
        }
        this.screen_ = screen;
        this.screen_.addPropertyChangeListener(this.vpListener);
    }

    @Override
    public void sync() {
        XPDisplayPrefsUtils.saveSeriesBindingStatus(this.onRadioBtn.isSelected());
    }

    @Override
    public void actionPerformed(ActionEvent e2) {
        if (this.onRadioBtn.isSelected()) {
            XPDisplayPrefsUtils.updateSeriesBindingStatus(true);
        } else if (this.offRadioBtn.isSelected()) {
            XPDisplayPrefsUtils.updateSeriesBindingStatus(false);
        }
    }

    private void updateSBSettings() {
        boolean sb = XPDisplayPrefsUtils.getSeriesBindingStatus();
        this.onRadioBtn.setSelected(sb);
        this.offRadioBtn.setSelected(!sb);
    }
}

