/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.crossref;

import com.ge.med.cse.cvf.comparators.DefaultImComparator;
import com.ge.med.cse.cvf.comparators.SeriesNumberComparator;
import com.ge.med.cse.cvf.util.DicomUtils;
import com.ge.med.terra.jami.XpSlice;
import com.ge.med.terra.jami.platform.dm.XpMedicalDmImage;
import com.ge.med.terra.tap.dm.DMImage;
import com.ge.med.terra.tap.dm.DMObject;
import com.ge.med.terra.tap.dm.DMQuery;
import com.ge.med.terra.tap.dm.DMSequence;
import com.ge.med.terra.tap.dm.DMSession;
import com.ge.med.terra.tap.dm.DMTag;
import java.awt.geom.Point2D;
import java.util.Arrays;

public class CvCrossRefUtils {
    public static final int VALID_SERIES = -1;
    public static final int INVALID_SERIES_TYPE = 0;
    public static final int INVALID_EXAM = 1;
    public static final int INVALID_SERIES = 2;
    public static final int INVALID_PAT_POS = 3;
    public static final int INVALID_PAT_ORIENTATION = 4;
    public static final int INVALID_LANDMARK = 5;
    public static final int INVALID_SCAN_PLANE = 6;
    public static final int REF_SERIES_NOT_FOUND = 7;
    public static final int UNKNOWN_ERROR = 8;
    public static final int REF_SERIES_TOO_LARGE = 9;
    public static final int INVALID_INTERSECTION = 10;
    private static final DMTag refImageSeqTag = new DMTag(8, 4416);
    private static final DMTag refImageUIDTag = new DMTag(8, 4437);
    private static final DMTag landmarkTag = new DMTag(32, 82);
    private static final DMTag patPosTag = new DMTag(24, 20736);
    private static final DMTag patEntryTag = new DMTag(32, 32);
    private static final DMTag mrScanPlane = new DMTag(39, 4149);
    private static final DMTag examidtag = new DMTag(32, 16);
    private static final DMTag examuidtag = new DMTag(32, 13);
    private static final DMTag seriesidtag = new DMTag(32, 17);
    private static final DMTag seriesuidtag = new DMTag(32, 14);
    private static final DMTag refSerNumTag = new DMTag(33, 4149);
    private static final DMTag refImNumTag = new DMTag(33, 4150);

    private static int isSeriesTypeValidforReference(DMObject series) {
        int status = -1;
        String imgType = DicomUtils.getImageType(series, false);
        if (imgType == null || "SSAVE".equals(imgType) || imgType.startsWith("3D") || "PJN".equals(imgType) || "GSPS".equals(imgType) || "SR".equals(imgType) || "UNKNOWN".equals(imgType)) {
            status = 0;
            return status;
        }
        String modality = DicomUtils.getModality(series);
        if (!(!"CT".equalsIgnoreCase(modality) || "SCOUT".equals(imgType) || "REFMT".equals(imgType) || "PROSP".equals(imgType) || "RETRO".equals(imgType))) {
            status = 0;
            return status;
        }
        return status;
    }

    private static int isSeriesTypeValidforReference(DMImage image) {
        int status = -1;
        String imgType = DicomUtils.getImageType(image, false);
        if (imgType == null || "SSAVE".equals(imgType) || imgType.startsWith("3D") || "PJN".equals(imgType) || "GSPS".equals(imgType) || "SR".equals(imgType) || "UNKNOWN".equals(imgType)) {
            status = 0;
            return status;
        }
        String modality = DicomUtils.getModality(image);
        if (!(!"CT".equalsIgnoreCase(modality) || "SCOUT".equals(imgType) || "REFMT".equals(imgType) || "PROSP".equals(imgType) || "RETRO".equals(imgType))) {
            status = 0;
            return status;
        }
        return status;
    }

    private static int isReferenceImageValid(DMObject image, DMImage target) {
        int status = -1;
        Object landmark = target.getValue(landmarkTag);
        Object val1 = image.getValue(landmarkTag);
        if (val1 != null && !val1.equals(landmark)) {
            status = 5;
            return status;
        }
        val1 = null;
        Object patpos = target.getValue(patPosTag);
        val1 = image.getValue(patPosTag);
        if (val1 != null && !val1.equals(patpos)) {
            status = 3;
            return status;
        }
        val1 = null;
        Object patentry = target.getValue(patEntryTag);
        val1 = image.getValue(patEntryTag);
        if (val1 != null && !val1.equals(patentry)) {
            status = 4;
            return status;
        }
        val1 = null;
        String modality = DicomUtils.getModality(target);
        if ("MR".equalsIgnoreCase(modality)) {
            val1 = target.getValue(mrScanPlane);
            Object val2 = image.getValue(mrScanPlane);
            int plane = -1;
            int refplane = -1;
            if (val1 != null) {
                plane = (Integer)val1;
                if (val2 != null) {
                    refplane = (Integer)val2;
                }
                if (plane == refplane && refplane < 16) {
                    status = 6;
                    return status;
                }
            }
        }
        XpMedicalDmImage refmedimg = new XpMedicalDmImage(image.getImages(null)[0]);
        XpSlice refSlice = refmedimg.getSlice();
        XpMedicalDmImage targetmedimg = new XpMedicalDmImage(target);
        XpSlice targetSlice = targetmedimg.getSlice();
        Point2D[] pts = targetSlice.getIntersection(refSlice);
        if (pts[0].getX() == pts[1].getX() && pts[0].getY() == pts[1].getY() && (pts = targetSlice.getIntersectionWithInfinite(refSlice))[0].getX() == pts[1].getX() && pts[0].getY() == pts[1].getY()) {
            status = 10;
            return status;
        }
        return status;
    }

    public static CrossRefResult isSeriesValidForCrossReference(DMObject series, DMImage target) {
        CrossRefResult result = new CrossRefResult();
        result.status = -1;
        String modality = DicomUtils.getModality(target);
        result.status = CvCrossRefUtils.isSeriesTypeValidforReference(target);
        if (result.status != -1) {
            return result;
        }
        result.status = CvCrossRefUtils.isSeriesTypeValidforReference(series);
        if (result.status != -1) {
            return result;
        }
        result = CvCrossRefUtils.isSeriesValidForReference(series, target);
        if (result.status != -1) {
            return result;
        }
        return result;
    }

    private static CrossRefResult isSeriesValidForReference(DMObject refObj, DMImage target) {
        Object sn;
        CrossRefResult result = new CrossRefResult();
        result.status = -1;
        String examid = (String)target.getValue(examidtag);
        String examuid = (String)target.getValue(examuidtag);
        Object val1 = refObj.getValue(examidtag);
        Object val2 = refObj.getValue(examuidtag);
        if (val1 != null && !val1.equals(examid) || val2 != null && !val2.equals(examuid)) {
            result.status = 1;
            return result;
        }
        val1 = null;
        val2 = null;
        Object serid = target.getValue(seriesidtag);
        Object sersuid = target.getValue(seriesuidtag);
        val1 = refObj.getValue(seriesidtag);
        val2 = refObj.getValue(seriesuidtag);
        if ((val1 == null || val1.equals(serid)) && (val2 == null || val2.equals(sersuid))) {
            result.status = 2;
            return result;
        }
        val1 = null;
        val2 = null;
        DMObject[] imgs = null;
        Object seq = target.getValue(refImageSeqTag);
        if (seq != null && seq instanceof DMSequence && ((DMSequence)seq).getNumberOfItems() > 0) {
            DMSequence refSeq = (DMSequence)seq;
            int nimgs = refSeq.getNumberOfItems();
            for (int i2 = 0; i2 < nimgs; ++i2) {
                String imgUID = (String)refSeq.getItem(i2).getValue(refImageUIDTag);
                if (imgUID == null) continue;
                if ("image".equalsIgnoreCase(refObj.getType())) {
                    String uid = (String)refObj.getValue(8, 24);
                    if (!imgUID.equals(uid)) continue;
                    result.status = CvCrossRefUtils.isReferenceImageValid(refObj, target);
                    if (result.status != -1) continue;
                    result.refImage = refObj;
                    result.refSeries = refObj.getRelated("series")[0];
                    return result;
                }
                DMObject[] ims = refObj.getRelated("image", new DMQuery("(0x0008,0x0018) = " + imgUID));
                if (ims == null || ims.length <= 0) continue;
                result.status = CvCrossRefUtils.isReferenceImageValid(ims[0], target);
                if (result.status != -1) continue;
                result.refImage = ims[0];
                result.refSeries = refObj;
                return result;
            }
        }
        if ((sn = target.getValue(refSerNumTag)) != null) {
            int seno = -1;
            try {
                if (sn instanceof Integer) {
                    seno = (Integer)sn;
                } else if (sn instanceof String) {
                    seno = Integer.parseInt((String)sn);
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
            Object val = refObj.getValue(seriesidtag);
            if (seno != -1 && val != null) {
                Object im;
                int seno2 = -1;
                try {
                    if (val instanceof Integer) {
                        seno2 = (Integer)val;
                    } else if (val instanceof String) {
                        seno2 = Integer.parseInt((String)val);
                    }
                }
                catch (Exception ex) {
                    // empty catch block
                }
                if (seno2 != -1 && seno == seno2 && (im = target.getValue(refImNumTag)) != null && im instanceof Integer && (Integer)im > 0 && (imgs = refObj.getRelated("image", new DMQuery("(0x0020,0x0013) = " + (Integer)im))) != null && imgs.length > 0) {
                    result.status = CvCrossRefUtils.isReferenceImageValid(imgs[0], target);
                    if (result.status == -1) {
                        result.refImage = imgs[0];
                        result.refSeries = refObj;
                        return result;
                    }
                }
            }
        }
        if ("image".equalsIgnoreCase(refObj.getType())) {
            result.status = CvCrossRefUtils.isReferenceImageValid(refObj, target);
            if (result.status == -1) {
                result.refImage = refObj;
                result.refSeries = refObj.getRelated("series")[0];
                return result;
            }
        } else {
            imgs = null;
            imgs = refObj.getRelated("image");
            if (imgs == null || imgs.length == 0) {
                result.status = 0;
                return result;
            }
            Arrays.sort(imgs, new DefaultImComparator());
            for (int i3 = 0; i3 < imgs.length; ++i3) {
                result.status = CvCrossRefUtils.isReferenceImageValid(imgs[i3], target);
                if (result.status != -1) continue;
                result.refImage = imgs[i3];
                result.refSeries = refObj;
                return result;
            }
        }
        return result;
    }

    public static CrossRefResult fetchValidReferenceSeries(DMSession session, DMImage target) {
        int i2;
        DMObject[] dmos;
        CrossRefResult result = new CrossRefResult();
        result.status = -1;
        result.status = CvCrossRefUtils.isSeriesTypeValidforReference(target);
        if (result.status != -1) {
            return result;
        }
        if (session == null) {
            result.status = 7;
            return result;
        }
        String examid = (String)target.getValue(examidtag);
        String examuid = (String)target.getValue(examuidtag);
        String query = "(0x0020, 0x000D) = " + examuid;
        if (examid != null && examid.trim().length() > 0) {
            query = query + " AND (0x0020, 0x0010) = " + examid;
        }
        if ((dmos = session.getRelated("study", new DMQuery(query))) == null || dmos.length == 0) {
            result.status = 7;
            return result;
        }
        DMObject exam = dmos[0];
        Object o2 = target.getValue(refImageSeqTag);
        if (o2 != null && o2 instanceof DMSequence && ((DMSequence)o2).getNumberOfItems() > 0) {
            DMSequence refSeq = (DMSequence)o2;
            int nimgs = refSeq.getNumberOfItems();
            for (int i3 = 0; i3 < nimgs; ++i3) {
                DMObject[] refimgs;
                String imgUID = (String)refSeq.getItem(i3).getValue(refImageUIDTag);
                if (imgUID == null) continue;
                query = "(0x0020, 0x000D) = " + examuid;
                if (examid != null && examid.trim().length() > 0) {
                    query = query + " AND (0x0020, 0x0010) = " + examid;
                }
                if ((refimgs = exam.getRelated("image", new DMQuery(query = query + " AND (0x0008,0x0018) = " + imgUID))) == null || refimgs.length == 0) continue;
                result = CvCrossRefUtils.isSeriesValidForCrossReference(refimgs[0], target);
                if (result.status != -1) continue;
                return result;
            }
        }
        boolean useRxSeries = false;
        DMObject[] series = null;
        Object sn = target.getValue(refSerNumTag);
        if (sn == null || !(sn instanceof Integer) || (Integer)sn == 0) {
            query = "(0x0020, 0x000D) = " + examuid;
            if (examid != null && examid.trim().length() > 0) {
                query = query + " AND (0x0020, 0x0010) = " + examid;
            }
            series = exam.getRelated("series", new DMQuery(query));
        } else {
            query = "(0x0020, 0x000D) = " + examuid;
            if (examid != null && examid.trim().length() > 0) {
                query = query + " AND (0x0020, 0x0010) = " + examid;
            }
            query = query + " AND (0x0020, 0x0011) = " + (Integer)sn;
            series = exam.getRelated("series", new DMQuery(query));
            useRxSeries = true;
        }
        if (series == null || series.length == 0) {
            result.status = 7;
            return result;
        }
        if (!useRxSeries && series.length == 1) {
            result.status = 7;
            return result;
        }
        Arrays.sort(series, new SeriesNumberComparator());
        String modality = DicomUtils.getModality(target);
        String targetimgType = DicomUtils.getImageType(target, false);
        if ("CT".equalsIgnoreCase(modality) && !"SCOUT".equalsIgnoreCase(targetimgType)) {
            for (i2 = 0; i2 < series.length; ++i2) {
                String imgType = DicomUtils.getImageType(series[i2], false);
                if (!"SCOUT".equalsIgnoreCase(imgType)) continue;
                result = CvCrossRefUtils.isSeriesValidForCrossReference(series[i2], target);
                if (result.status == -1) break;
            }
        }
        if (result.refSeries == null) {
            for (i2 = 0; i2 < series.length; ++i2) {
                result = CvCrossRefUtils.isSeriesValidForCrossReference(series[i2], target);
                if (result.status == -1) break;
            }
        }
        if (result.refSeries == null) {
            result.refImage = null;
            result.status = 7;
        }
        return result;
    }

    public static class CrossRefResult {
        public int status = -1;
        public DMObject refSeries = null;
        public DMObject refImage = null;
    }
}

