/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.crossref;

import com.ge.med.cse.cvf.cpanels.XPDisplayPrefsUtils;
import com.ge.med.cse.cvf.crossref.XpReferenceImageViewport;
import com.ge.med.cse.cvf.crossref.XpReferenceVpContentPane;
import com.ge.med.cse.cvf.util.CvPropertiesManager;
import com.ge.med.cse.cvf.util.CvUtils;
import com.ge.med.cse.cvf.util.DicomUtils;
import com.ge.med.idc.Capable;
import com.ge.med.idc.FramePositioningCapable;
import com.ge.med.idc.PanZoomCapable;
import com.ge.med.idc.Selectable;
import com.ge.med.idc.SelectionCapable;
import com.ge.med.idc.WfPresetCapable;
import com.ge.med.idc.WindowLevelCapable;
import com.ge.med.terra.jami.CPoint;
import com.ge.med.terra.jami.XpCompositePort;
import com.ge.med.terra.jami.XpDicomObject;
import com.ge.med.terra.jami.XpImage;
import com.ge.med.terra.jami.XpMedicalImage;
import com.ge.med.terra.jami.XpMouseController;
import com.ge.med.terra.jami.XpSingularPort;
import com.ge.med.terra.jami.XpSlice;
import com.ge.med.terra.jami.XpViewport;
import com.ge.med.terra.jami.annotation.XpAnnotationGenerator;
import com.ge.med.terra.jami.capable.AnnotCapable;
import com.ge.med.terra.jami.capable.FrameCapable;
import com.ge.med.terra.jami.capable.FrameOwner;
import com.ge.med.terra.jami.capable.SliceControlledCapable;
import com.ge.med.terra.jami.capable.SliceListener;
import com.ge.med.terra.jami.capable.SliceSourceCapable;
import com.ge.med.terra.jami.render.XpImageRenderAttributes;
import com.ge.med.terra.jami.render.XpImageRenderAttributesOwner;
import com.ge.med.terra.xpv.base.XPscreen;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;

public class XpReferenceImageDirector
extends JComponent
implements PanZoomCapable,
WindowLevelCapable,
FrameCapable,
FramePositioningCapable,
WfPresetCapable,
XpImageRenderAttributesOwner,
AnnotCapable {
    private XpViewport mainvpRef = null;
    private HashMap refvpMap = new HashMap();
    private int visualizercount = 1;
    private int refindex = 0;
    private List sliceListenerList = new ArrayList();
    private XpMedicalImage[] refimglist = null;
    private boolean selectedMode = false;
    private int subselection = -1;
    protected boolean init = false;
    private static final Logger logger = Logger.getLogger(XpReferenceImageDirector.class.getName());
    PropertyChangeListener mainvpListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent e2) {
            if (e2.getPropertyName().equals("FrameIndex")) {
                if (!XpReferenceImageDirector.this.selectedMode) {
                    XpReferenceImageDirector.this.postReferenceImage(false);
                }
                Integer newIndex = (Integer)e2.getNewValue();
                int index = newIndex;
                if (XpReferenceImageDirector.this.mainvpRef instanceof FrameCapable) {
                    FrameCapable fpc = (FrameCapable)((Object)XpReferenceImageDirector.this.mainvpRef);
                    for (int i2 = 0; i2 < XpReferenceImageDirector.this.sliceListenerList.size(); ++i2) {
                        if (index + i2 >= fpc.getNumFrames()) continue;
                        XpImage img = fpc.getFrame(index + i2);
                        XpSlice slice = img.getSlice();
                        SliceListener sl = (SliceListener)XpReferenceImageDirector.this.sliceListenerList.get(i2);
                        if (sl == null) continue;
                        sl.setActiveSlice(this, slice);
                    }
                }
            }
        }
    };
    PropertyChangeListener selectionListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            XpReferenceImageDirector.this.clearRefVpSelection();
        }
    };
    PropertyChangeListener contentListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            Iterator it = XpReferenceImageDirector.this.refvpMap.keySet().iterator();
            while (it.hasNext()) {
                ReferenceViewportWrapper r2 = (ReferenceViewportWrapper)XpReferenceImageDirector.this.refvpMap.get(it.next());
                if (r2 == null) continue;
                ((XpReferenceImageViewport)r2.getPort()).setSliceSourceCapable(r2.getSourceViewport());
            }
        }
    };
    boolean refresh = false;
    private XpImageRenderAttributes oldIRA = new XpImageRenderAttributes();
    PropertyChangeListener riaPropListsner = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            XpViewport selPort;
            if ((evt.getPropertyName().equals("winMax") || evt.getPropertyName().equals("winMin") || evt.getPropertyName().equals("videoInverted") || evt.getPropertyName().equals("pan") || evt.getPropertyName().equals("zoom")) && (selPort = XpReferenceImageDirector.this.getSelectedRefPort()) instanceof XpImageRenderAttributesOwner) {
                XpReferenceImageDirector.this.updatePropRenderAttributes(((XpImageRenderAttributesOwner)((Object)selPort)).getImageRenderAttributes());
            }
        }
    };

    public XpReferenceImageDirector(XpViewport vp, boolean selected) throws IllegalArgumentException {
        if (!(vp instanceof SelectionCapable)) {
            throw new IllegalArgumentException("Viewport is not Selection Capable.");
        }
        this.mainvpRef = vp;
        this.selectedMode = selected;
        this.visualizercount = ((SelectionCapable)((Object)vp)).getNumComponents();
        this.initListeners();
    }

    private void initListeners() {
        if (!this.init) {
            this.mainvpRef.addPropertyChangeListener("FrameIndex", this.mainvpListener);
            this.mainvpRef.addPropertyChangeListener("CONTENT_UPDATED", this.contentListener);
            this.mainvpRef.addPropertyChangeListener("ComponentSelection", this.selectionListener);
            this.init = true;
        }
    }

    public void clearRefVpSelection() {
        Iterator it = this.refvpMap.keySet().iterator();
        while (it.hasNext()) {
            ReferenceViewportWrapper r2 = (ReferenceViewportWrapper)this.refvpMap.get(it.next());
            r2.setSelected(false);
        }
        this.mainvpRef.firePropertyChange("reference_vp_selection", true, false);
    }

    public void setReferenceImageList(XpMedicalImage[] rlist) {
        if (this.refimglist != null) {
            this.refresh = true;
        }
        this.refimglist = rlist;
    }

    public void setReferenceFrameIndex(int index) {
        this.refindex = index;
    }

    public int getReferenceFrameIndex() {
        return this.refindex;
    }

    public boolean getCurrentMode() {
        return this.selectedMode;
    }

    public void updateMode(boolean selected) {
        if (!this.selectedMode) {
            this.subselection = selected ? 1 : 0;
        } else {
            this.selectedMode = selected;
            this.subselection = 0;
        }
    }

    public XpViewport getSelectedRefPort() {
        Iterator it = this.refvpMap.keySet().iterator();
        while (it.hasNext()) {
            ReferenceViewportWrapper r2 = (ReferenceViewportWrapper)this.refvpMap.get(it.next());
            if (!r2.isSelected()) continue;
            return r2.getPort();
        }
        return null;
    }

    public int getSelectedRefPortIndex() {
        Iterator it = this.refvpMap.keySet().iterator();
        while (it.hasNext()) {
            ReferenceViewportWrapper r2 = (ReferenceViewportWrapper)this.refvpMap.get(it.next());
            if (!r2.isSelected()) continue;
            return r2.getParentPortIndex();
        }
        return -1;
    }

    public XpViewport[] getRefPorts() {
        XpViewport[] rports = new XpViewport[this.refvpMap.size()];
        int i2 = 0;
        Iterator it = this.refvpMap.keySet().iterator();
        while (it.hasNext()) {
            ReferenceViewportWrapper r2 = (ReferenceViewportWrapper)this.refvpMap.get(it.next());
            if (r2 == null) continue;
            rports[i2] = r2.getPort();
            ++i2;
        }
        return rports;
    }

    public XpViewport getRefPort(int index) {
        return this.refvpMap.get(Integer.toString(index)) != null ? ((ReferenceViewportWrapper)this.refvpMap.get(Integer.toString(index))).getPort() : null;
    }

    public Component cloneRefPort(int index) {
        ReferenceViewportWrapper r2 = (ReferenceViewportWrapper)this.refvpMap.get(Integer.toString(index));
        if (r2 != null && r2.added) {
            return (Component)((XpReferenceVpContentPane)r2.getContentPane()).clone();
        }
        return null;
    }

    public Component copyRefPortTo(XpViewport destvp, int portindex) {
        if (destvp == null) {
            logger.log(Level.WARNING, "Destination viewport is null.");
            return null;
        }
        ReferenceViewportWrapper rvw = (ReferenceViewportWrapper)this.refvpMap.get(Integer.toString(portindex));
        if (rvw == null || !rvw.isAdded()) {
            return null;
        }
        XpReferenceImageViewport rvp = (XpReferenceImageViewport)rvw.getPort().clone();
        XpSingularPort port = null;
        if (destvp instanceof SelectionCapable) {
            port = (XpSingularPort)((SelectionCapable)((Object)destvp)).getViewportComponent(portindex);
        } else if (destvp instanceof XpSingularPort) {
            port = (XpSingularPort)destvp;
        } else {
            return null;
        }
        rvp.setSliceSourceCapable(port);
        XpReferenceVpContentPane contentpane = new XpReferenceVpContentPane();
        port.getMedicalImageVc().add((Component)contentpane, 0);
        contentpane.add(rvp);
        return contentpane;
    }

    public boolean isRefPortAllOn() {
        Iterator it = this.refvpMap.keySet().iterator();
        while (it.hasNext()) {
            ReferenceViewportWrapper r2 = (ReferenceViewportWrapper)this.refvpMap.get(it.next());
            if (r2.isAdded()) continue;
            return false;
        }
        return true;
    }

    public boolean isRefPortOn(int portindex) {
        ReferenceViewportWrapper r2 = (ReferenceViewportWrapper)this.refvpMap.get(Integer.toString(portindex));
        return r2 != null && r2.isAdded();
    }

    public void setRefVpSelection(int portindex) {
        Iterator it = this.refvpMap.keySet().iterator();
        while (it.hasNext()) {
            ReferenceViewportWrapper r2 = (ReferenceViewportWrapper)this.refvpMap.get(it.next());
            if (r2.getParentPortIndex() == portindex && r2.isAdded()) {
                r2.setSelected(true);
                continue;
            }
            r2.setSelected(false);
        }
    }

    public void postReferenceImage(boolean force) {
        XPscreen screen;
        if (!force && !this.canPostRefImage(this.mainvpRef)) {
            return;
        }
        this.visualizercount = ((SelectionCapable)((Object)this.mainvpRef)).getNumComponents();
        for (int i2 = 0; i2 < this.visualizercount; ++i2) {
            JComponent comp;
            if (this.selectedMode && i2 != ((SelectionCapable)((Object)this.mainvpRef)).getComponentSelection() && (!(this.mainvpRef instanceof XpCompositePort) || ((XpCompositePort)this.mainvpRef).getPortSelection(i2) != 1) || (comp = ((SelectionCapable)((Object)this.mainvpRef)).getViewportComponent(i2)) != null && comp instanceof FrameOwner && ((FrameOwner)((Object)comp)).getFrame() == null) continue;
            ReferenceViewportWrapper rvw = (ReferenceViewportWrapper)this.refvpMap.get(Integer.toString(i2));
            if (rvw == null) {
                SourceViewportWrapper s2 = new SourceViewportWrapper(i2);
                ReferenceViewportWrapper r2 = new ReferenceViewportWrapper(s2);
                this.refvpMap.put(Integer.toString(i2), r2);
                r2.addPort();
                continue;
            }
            if (this.subselection == 1 && (i2 == ((SelectionCapable)((Object)this.mainvpRef)).getComponentSelection() || this.mainvpRef instanceof XpCompositePort && ((XpCompositePort)this.mainvpRef).getPortSelection(i2) == 1)) {
                rvw.addPort();
                continue;
            }
            if (this.subselection != 0) continue;
            rvw.addPort();
        }
        this.subselection = -1;
        if (this.refresh) {
            Iterator it = this.refvpMap.keySet().iterator();
            while (it.hasNext()) {
                ReferenceViewportWrapper r3 = (ReferenceViewportWrapper)this.refvpMap.get(it.next());
                r3.refreshImage();
            }
            this.refresh = false;
        }
        if ((screen = (XPscreen)SwingUtilities.getAncestorOfClass(XPscreen.class, this.mainvpRef)) != null) {
            screen.firePropertyChange("reference_viewport", false, true);
        }
        this.mainvpRef.validate();
        this.mainvpRef.repaint();
    }

    public boolean canPostRefImage(XpViewport vp) {
        if (vp instanceof FrameOwner) {
            if (((FrameOwner)((Object)vp)).getFrame() == null) {
                return false;
            }
        } else {
            return false;
        }
        return ((SelectionCapable)((Object)vp)).getViewportComponent(0).getWidth() >= 256 && ((SelectionCapable)((Object)vp)).getViewportComponent(0).getHeight() >= 256;
    }

    public void disconnectViewport(boolean selected) {
        ReferenceViewportWrapper r2;
        int index = -1;
        for (int i2 = 0; i2 < this.visualizercount; ++i2) {
            ReferenceViewportWrapper rvw;
            if (!selected || i2 == ((SelectionCapable)((Object)this.mainvpRef)).getComponentSelection() || this.mainvpRef instanceof XpCompositePort && ((XpCompositePort)this.mainvpRef).getPortSelection(i2) == 1) {
                rvw = (ReferenceViewportWrapper)this.refvpMap.get(Integer.toString(i2));
                if (rvw == null || !rvw.isAdded()) continue;
                rvw.removePort();
            }
            if (!selected || !this.isRefPortSelected() || i2 != (index = this.getSelectedRefPortIndex()) || (rvw = (ReferenceViewportWrapper)this.refvpMap.get(Integer.toString(i2))) == null || !rvw.isAdded()) continue;
            rvw.removePort();
        }
        boolean clear = true;
        Iterator it = this.refvpMap.keySet().iterator();
        while (it.hasNext()) {
            r2 = (ReferenceViewportWrapper)this.refvpMap.get(it.next());
            if (!r2.isAdded()) continue;
            clear = false;
            break;
        }
        if (!selected || clear) {
            it = this.refvpMap.keySet().iterator();
            while (it.hasNext()) {
                r2 = (ReferenceViewportWrapper)this.refvpMap.get(it.next());
                r2.dispose();
            }
            this.refvpMap.clear();
            this.removeListeners();
            this.mainvpRef.putClientProperty("reference_viewport", "false");
            XPscreen screen = (XPscreen)SwingUtilities.getAncestorOfClass(XPscreen.class, this.mainvpRef);
            if (screen != null) {
                screen.firePropertyChange("reference_viewport", true, false);
            }
            this.refimglist = null;
        }
        this.refresh = false;
        this.mainvpRef.validate();
        this.mainvpRef.repaint();
        if (this.refvpMap.size() == 0) {
            this.mainvpRef = null;
        }
    }

    public boolean isRefPortSelected() {
        Iterator it = this.refvpMap.keySet().iterator();
        while (it.hasNext()) {
            ReferenceViewportWrapper r2 = (ReferenceViewportWrapper)this.refvpMap.get(it.next());
            if (!r2.isSelected()) continue;
            return true;
        }
        return false;
    }

    private void removeListeners() {
        this.mainvpRef.removePropertyChangeListener("FrameIndex", this.mainvpListener);
        this.mainvpRef.removePropertyChangeListener("CONTENT_UPDATED", this.contentListener);
        this.mainvpRef.removePropertyChangeListener("ComponentSelection", this.selectionListener);
        this.sliceListenerList.clear();
        this.init = false;
    }

    public int getReferencePortCount() {
        return this.refvpMap.size();
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener arg0) {
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener arg0) {
    }

    @Override
    public void addPropertyChangeListener(String arg0, PropertyChangeListener arg1) {
    }

    @Override
    public void repaint() {
        Iterator it = this.refvpMap.keySet().iterator();
        while (it.hasNext()) {
            ReferenceViewportWrapper r2 = (ReferenceViewportWrapper)this.refvpMap.get(it.next());
            r2.getPort().repaint();
        }
    }

    @Override
    public boolean isAutoRepaint() {
        XpViewport p2 = this.getSelectedRefPort();
        if (p2 instanceof Capable) {
            return p2.isAutoRepaint();
        }
        return false;
    }

    @Override
    public void setAutoRepaint(boolean arg0) {
        Iterator it = this.refvpMap.keySet().iterator();
        while (it.hasNext()) {
            ReferenceViewportWrapper r2 = (ReferenceViewportWrapper)this.refvpMap.get(it.next());
            r2.getPort().setAutoRepaint(arg0);
        }
    }

    @Override
    public Capable getCapable(String capableIFName) {
        try {
            Class<?> cap = this.getClass();
            Class<?> cl = Class.forName(capableIFName);
            if (cl.isAssignableFrom(cap) && cl.isInstance(this)) {
                return this;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return null;
    }

    @Override
    public void setZoom(double zoom) {
        XpViewport p2 = this.getSelectedRefPort();
        if (p2 instanceof PanZoomCapable) {
            ((PanZoomCapable)((Object)p2)).setZoom(zoom);
            p2.repaint();
        }
    }

    @Override
    public double getZoom() {
        XpViewport p2 = this.getSelectedRefPort();
        if (p2 instanceof PanZoomCapable) {
            return ((PanZoomCapable)((Object)p2)).getZoom();
        }
        return 1.0;
    }

    @Override
    public void setRotate(double rot) {
        Iterator it = this.refvpMap.keySet().iterator();
        while (it.hasNext()) {
            ReferenceViewportWrapper r2 = (ReferenceViewportWrapper)this.refvpMap.get(it.next());
            ((PanZoomCapable)((Object)r2.getPort())).setRotate(rot);
            r2.getPort().repaint();
        }
    }

    @Override
    public double getRotate() {
        XpViewport p2 = this.getSelectedRefPort();
        if (p2 instanceof PanZoomCapable) {
            return ((PanZoomCapable)((Object)p2)).getRotate();
        }
        return 0.0;
    }

    @Override
    public void setPan(double x2, double y2) {
        XpViewport p2 = this.getSelectedRefPort();
        if (p2 instanceof PanZoomCapable) {
            ((PanZoomCapable)((Object)p2)).setPan(x2, y2);
            p2.repaint();
        }
    }

    @Override
    public void setPanY(double y2) {
        XpViewport p2 = this.getSelectedRefPort();
        if (p2 instanceof PanZoomCapable) {
            ((PanZoomCapable)((Object)p2)).setPanY(y2);
            p2.repaint();
        }
    }

    @Override
    public double getPanY() {
        XpViewport p2 = this.getSelectedRefPort();
        if (p2 instanceof PanZoomCapable) {
            return ((PanZoomCapable)((Object)p2)).getPanY();
        }
        return 0.0;
    }

    @Override
    public void setPanX(double x2) {
        XpViewport p2 = this.getSelectedRefPort();
        if (p2 instanceof PanZoomCapable) {
            ((PanZoomCapable)((Object)p2)).setPanX(x2);
            p2.repaint();
        }
    }

    @Override
    public double getPanX() {
        XpViewport p2 = this.getSelectedRefPort();
        if (p2 instanceof PanZoomCapable) {
            return ((PanZoomCapable)((Object)p2)).getPanX();
        }
        return 0.0;
    }

    @Override
    public void flipVertical() {
        Iterator it = this.refvpMap.keySet().iterator();
        while (it.hasNext()) {
            ReferenceViewportWrapper r2 = (ReferenceViewportWrapper)this.refvpMap.get(it.next());
            ((PanZoomCapable)((Object)r2.getPort())).flipVertical();
            r2.getPort().repaint();
        }
    }

    @Override
    public void flipHorizontal() {
        Iterator it = this.refvpMap.keySet().iterator();
        while (it.hasNext()) {
            ReferenceViewportWrapper r2 = (ReferenceViewportWrapper)this.refvpMap.get(it.next());
            ((PanZoomCapable)((Object)r2.getPort())).flipHorizontal();
            r2.getPort().repaint();
        }
    }

    @Override
    public void resetPanZoom() {
        XpViewport p2 = this.getSelectedRefPort();
        if (p2 instanceof XpImageRenderAttributesOwner) {
            XpImageRenderAttributes ira = ((XpImageRenderAttributesOwner)((Object)p2)).getImageRenderAttributes();
            ira.resetAffine();
            this.setImageRenderAttributes(ira);
        }
    }

    @Override
    public double[] getRange() {
        XpViewport p2 = this.getSelectedRefPort();
        if (p2 instanceof WindowLevelCapable) {
            return ((WindowLevelCapable)((Object)p2)).getRange();
        }
        return null;
    }

    @Override
    public void setWinMinMax(double min, double max) {
        XpViewport p2 = this.getSelectedRefPort();
        if (p2 instanceof WindowLevelCapable) {
            ((WindowLevelCapable)((Object)p2)).setWinMinMax(min, max);
            p2.repaint();
        }
    }

    @Override
    public double getWinMin() {
        XpViewport p2 = this.getSelectedRefPort();
        if (p2 instanceof WindowLevelCapable) {
            return ((WindowLevelCapable)((Object)p2)).getWinMin();
        }
        return 0.0;
    }

    @Override
    public void setWinMin(double min) {
        XpViewport p2 = this.getSelectedRefPort();
        if (p2 instanceof WindowLevelCapable) {
            ((WindowLevelCapable)((Object)p2)).setWinMin(min);
            p2.repaint();
        }
    }

    @Override
    public double getWinMax() {
        XpViewport p2 = this.getSelectedRefPort();
        if (p2 instanceof WindowLevelCapable) {
            return ((WindowLevelCapable)((Object)p2)).getWinMax();
        }
        return 0.0;
    }

    @Override
    public void setWinMax(double max) {
        XpViewport p2 = this.getSelectedRefPort();
        if (p2 instanceof WindowLevelCapable) {
            ((WindowLevelCapable)((Object)p2)).setWinMax(max);
            p2.repaint();
        }
    }

    @Override
    public void setVideoInverted(boolean arg0) {
        Iterator it = this.refvpMap.keySet().iterator();
        while (it.hasNext()) {
            ReferenceViewportWrapper r2 = (ReferenceViewportWrapper)this.refvpMap.get(it.next());
            ((WindowLevelCapable)((Object)r2.getPort())).setVideoInverted(arg0);
            r2.getPort().repaint();
        }
    }

    @Override
    public boolean isVideoInverted() {
        ReferenceViewportWrapper r2;
        Iterator it = this.refvpMap.keySet().iterator();
        if (it.hasNext() && (r2 = (ReferenceViewportWrapper)this.refvpMap.get(it.next())).isAdded()) {
            return ((WindowLevelCapable)((Object)r2.getPort())).isVideoInverted();
        }
        return false;
    }

    @Override
    public void resetWindowing() {
        Iterator it = this.refvpMap.keySet().iterator();
        while (it.hasNext()) {
            ReferenceViewportWrapper r2 = (ReferenceViewportWrapper)this.refvpMap.get(it.next());
            ((WindowLevelCapable)((Object)r2.getPort())).resetWindowing();
            r2.getPort().repaint();
        }
    }

    @Override
    public void setWinUpperLimit(double arg0) {
        XpViewport p2 = this.getSelectedRefPort();
        if (p2 instanceof WindowLevelCapable) {
            ((WindowLevelCapable)((Object)p2)).setWinUpperLimit(arg0);
            p2.repaint();
        }
    }

    @Override
    public double getWinUpperLimit() {
        XpViewport p2 = this.getSelectedRefPort();
        if (p2 instanceof WindowLevelCapable) {
            return ((WindowLevelCapable)((Object)p2)).getWinUpperLimit();
        }
        return 0.0;
    }

    @Override
    public void setWinLowerLimit(double arg0) {
        XpViewport p2 = this.getSelectedRefPort();
        if (p2 instanceof WindowLevelCapable) {
            ((WindowLevelCapable)((Object)p2)).setWinLowerLimit(arg0);
            p2.repaint();
        }
    }

    @Override
    public double getWinLowerLimit() {
        XpViewport p2 = this.getSelectedRefPort();
        if (p2 instanceof WindowLevelCapable) {
            return ((WindowLevelCapable)((Object)p2)).getWinLowerLimit();
        }
        return 0.0;
    }

    @Override
    public int getNumFrames() {
        return this.refimglist != null ? this.refimglist.length : 0;
    }

    @Override
    public void setFrameIndex(int index) {
        if (index < 0) {
            index = this.refimglist.length - 1;
        } else if (index >= this.refimglist.length) {
            index = 0;
        }
        this.refindex = index;
        XpImageRenderAttributes attr = null;
        XpViewport selPort = this.getSelectedRefPort();
        if (selPort instanceof XpImageRenderAttributesOwner) {
            attr = ((XpImageRenderAttributesOwner)((Object)selPort)).getImageRenderAttributes();
        }
        Iterator it = this.refvpMap.keySet().iterator();
        while (it.hasNext()) {
            ReferenceViewportWrapper r2 = (ReferenceViewportWrapper)this.refvpMap.get(it.next());
            r2.refreshImage();
            r2.getPort().repaint();
        }
        if (attr != null) {
            this.updatePropRenderAttributes(attr);
        }
    }

    @Override
    public int getFrameIndex() {
        return this.refindex;
    }

    private void updatePropRenderAttributes(XpImageRenderAttributes attr) {
        String mod = this.getModality();
        XpMedicalImage img = this.getDmImage();
        if (attr.getWindowLevel() < CvUtils.getMinWL(img)) {
            attr.setWindowLevel(CvUtils.getMinWL(img));
        }
        if (attr.getWindowLevel() > CvUtils.getMaxWL(img)) {
            attr.setWindowLevel(CvUtils.getMaxWL(img));
        }
        if (attr.getWindowWidth() > CvUtils.getMaxWW(img)) {
            attr.setWindowWidth(CvUtils.getMaxWW(img));
        }
        if (attr.getWindowWidth() < CvUtils.getMinWW(img)) {
            attr.setWindowWidth(CvUtils.getMinWW(img));
        }
        if (attr.getZoom() < CvUtils.getMinZoom()) {
            attr.setZoom(CvUtils.getMinZoom());
        }
        if (attr.getZoom() > CvUtils.getMaxZoom()) {
            attr.setZoom(CvUtils.getMaxZoom());
        }
        Iterator it = this.refvpMap.keySet().iterator();
        while (it.hasNext()) {
            ReferenceViewportWrapper r2 = (ReferenceViewportWrapper)this.refvpMap.get(it.next());
            XpImageRenderAttributes ira = ((XpImageRenderAttributesOwner)((Object)r2.getPort())).getImageRenderAttributes();
            ira.set(attr);
            ((XpImageRenderAttributesOwner)((Object)r2.getPort())).setImageRenderAttributes(ira);
            ((XpSingularPort)r2.getPort()).getMedicalImageVc().refreshImageRenderAttributes();
            r2.getPort().repaint();
        }
        double oldWMAX = this.oldIRA.getWindowMax();
        double oldWMIN = this.oldIRA.getWindowMin();
        boolean oldInv = this.oldIRA.isVideoInverted();
        double newWMAX = attr.getWindowMax();
        double newWMIN = attr.getWindowMin();
        boolean newInv = attr.isVideoInverted();
        if (this.oldIRA.getPanX() != attr.getPanX() || this.oldIRA.getPanY() != attr.getPanY()) {
            this.mainvpRef.firePropertyChange("pan", false, true);
        }
        if (this.oldIRA.getZoom() != attr.getZoom()) {
            this.mainvpRef.firePropertyChange("zoom", this.oldIRA.getZoom(), attr.getZoom());
        }
        if (oldWMAX != newWMAX) {
            this.mainvpRef.firePropertyChange("winMax", oldWMAX, newWMAX);
        }
        if (oldWMIN != newWMIN) {
            this.mainvpRef.firePropertyChange("winMin", oldWMIN, newWMIN);
        }
        if (oldInv != newInv) {
            this.mainvpRef.firePropertyChange("videoInverted", oldInv, newInv);
        }
        this.oldIRA.set(attr);
    }

    @Override
    public String getModality() {
        XpViewport p2 = this.getSelectedRefPort();
        if (p2 instanceof FrameOwner && ((FrameOwner)((Object)p2)).getFrame() instanceof XpDicomObject) {
            DicomUtils.getModality((XpDicomObject)((Object)((FrameOwner)((Object)p2)).getFrame()));
        }
        return null;
    }

    private XpMedicalImage getDmImage() {
        XpViewport p2 = this.getSelectedRefPort();
        XpMedicalImage img = null;
        if (p2 instanceof FrameOwner && ((FrameOwner)((Object)p2)).getFrame() instanceof XpDicomObject) {
            img = (XpMedicalImage)((FrameOwner)((Object)p2)).getFrame();
            return img;
        }
        return img;
    }

    @Override
    public void setImageRenderAttributes(XpImageRenderAttributes attr) {
        this.updatePropRenderAttributes(attr);
    }

    @Override
    public XpImageRenderAttributes getImageRenderAttributes() {
        XpViewport p2 = this.getSelectedRefPort();
        if (p2 instanceof XpImageRenderAttributesOwner) {
            return ((XpImageRenderAttributesOwner)((Object)p2)).getImageRenderAttributes();
        }
        return null;
    }

    @Override
    public XpImage getFrame(int idx) {
        if (idx >= 0 && idx < this.refimglist.length) {
            return this.refimglist[idx];
        }
        return null;
    }

    @Override
    public XpImage getFrame() {
        XpViewport r2 = this.getSelectedRefPort();
        if (r2 != null && r2 instanceof FrameOwner) {
            return ((FrameOwner)((Object)r2)).getFrame();
        }
        return null;
    }

    @Override
    public String[] getAnnotationGroups() {
        Iterator it = this.refvpMap.keySet().iterator();
        if (it.hasNext()) {
            ReferenceViewportWrapper r2 = (ReferenceViewportWrapper)this.refvpMap.get(it.next());
            return r2.getPort().getAnnotationGroups();
        }
        return null;
    }

    @Override
    public String[] getAnnotationItems() {
        Iterator it = this.refvpMap.keySet().iterator();
        if (it.hasNext()) {
            ReferenceViewportWrapper r2 = (ReferenceViewportWrapper)this.refvpMap.get(it.next());
            return r2.getPort().getAnnotationItems();
        }
        return null;
    }

    @Override
    public void setAnnotationGroup(String agName, boolean activate) {
        Iterator it = this.refvpMap.keySet().iterator();
        while (it.hasNext()) {
            ReferenceViewportWrapper r2 = (ReferenceViewportWrapper)this.refvpMap.get(it.next());
            r2.getPort().setAnnotationGroup(agName, activate);
        }
    }

    @Override
    public void setAnnotationItems(String[] annoItems, boolean activate) {
        Iterator it = this.refvpMap.keySet().iterator();
        while (it.hasNext()) {
            ReferenceViewportWrapper r2 = (ReferenceViewportWrapper)this.refvpMap.get(it.next());
            r2.getPort().setAnnotationItems(annoItems, activate);
        }
    }

    @Override
    public void queryAnnotationItems(String[] annoItems, boolean[] queryRes) {
        Iterator it = this.refvpMap.keySet().iterator();
        if (it.hasNext()) {
            ReferenceViewportWrapper r2 = (ReferenceViewportWrapper)this.refvpMap.get(it.next());
            r2.getPort().queryAnnotationItems(annoItems, queryRes);
        }
    }

    @Override
    public boolean queryAnnotationItem(String aiName) {
        Iterator it = this.refvpMap.keySet().iterator();
        if (it.hasNext()) {
            ReferenceViewportWrapper r2 = (ReferenceViewportWrapper)this.refvpMap.get(it.next());
            return r2.getPort().queryAnnotationItem(aiName);
        }
        return false;
    }

    @Override
    public String[] getAnnotationItems(String agName) {
        Iterator it = this.refvpMap.keySet().iterator();
        if (it.hasNext()) {
            ReferenceViewportWrapper r2 = (ReferenceViewportWrapper)this.refvpMap.get(it.next());
            return r2.getPort().getAnnotationItems(agName);
        }
        return null;
    }

    @Override
    public void setAnnotationColor(Color c2) {
        Iterator it = this.refvpMap.keySet().iterator();
        while (it.hasNext()) {
            ReferenceViewportWrapper r2 = (ReferenceViewportWrapper)this.refvpMap.get(it.next());
            r2.getPort().setAnnotationColor(c2);
        }
    }

    @Override
    public Color getAnnotationColor() {
        Iterator it = this.refvpMap.keySet().iterator();
        if (it.hasNext()) {
            ReferenceViewportWrapper r2 = (ReferenceViewportWrapper)this.refvpMap.get(it.next());
            return r2.getPort().getAnnotationColor();
        }
        return null;
    }

    @Override
    public void setAnnotationVisible(boolean annotVisible) {
        Iterator it = this.refvpMap.keySet().iterator();
        while (it.hasNext()) {
            ReferenceViewportWrapper r2 = (ReferenceViewportWrapper)this.refvpMap.get(it.next());
            r2.getPort().setAnnotationVisible(annotVisible);
        }
    }

    @Override
    public boolean isAnnotationVisible() {
        Iterator it = this.refvpMap.keySet().iterator();
        if (it.hasNext()) {
            ReferenceViewportWrapper r2 = (ReferenceViewportWrapper)this.refvpMap.get(it.next());
            return r2.getPort().isAnnotationVisible();
        }
        return false;
    }

    @Override
    public void setAnnotationGenerator(Class agClass, Properties props) {
        Iterator it = this.refvpMap.keySet().iterator();
        while (it.hasNext()) {
            ReferenceViewportWrapper r2 = (ReferenceViewportWrapper)this.refvpMap.get(it.next());
            r2.getPort().setAnnotationGenerator(agClass, props);
        }
    }

    @Override
    public XpAnnotationGenerator getAnnotationGenerator() {
        Iterator it = this.refvpMap.keySet().iterator();
        if (it.hasNext()) {
            ReferenceViewportWrapper r2 = (ReferenceViewportWrapper)this.refvpMap.get(it.next());
            return r2.getPort().getAnnotationGenerator();
        }
        return null;
    }

    class ReferenceViewportWrapper
    extends MouseAdapter
    implements Selectable {
        SourceViewportWrapper svp = null;
        XpReferenceImageViewport refvp = null;
        Border sb = BorderFactory.createLineBorder(Color.green, 1);
        Border db = BorderFactory.createLineBorder(Color.black, 1);
        XpSingularPort parentcomp = null;
        boolean isSelected = false;
        XpReferenceVpContentPane contentpane = null;
        XpMouseController mouseController = null;
        boolean added = false;

        public ReferenceViewportWrapper(SourceViewportWrapper svp) {
            this.svp = svp;
            this.refvp = new XpReferenceImageViewport();
            this.parentcomp = (XpSingularPort)((SelectionCapable)((Object)XpReferenceImageDirector.this.mainvpRef)).getViewportComponent(svp.getPortIndex());
            this.mouseController = this.createMouseController();
            this.refvp.setMouseController(this.mouseController);
            this.refvp.setBorder(this.db);
            if (XpReferenceImageDirector.this.refindex < 0 || XpReferenceImageDirector.this.refindex >= XpReferenceImageDirector.this.refimglist.length) {
                XpReferenceImageDirector.this.refindex = 0;
            }
            this.refvp.setImage(XpReferenceImageDirector.this.refimglist[XpReferenceImageDirector.this.refindex]);
            this.refvp.addSliceMarker();
            this.refvp.setSliceSourceCapable(this.svp);
            this.setRefViewportAnnotation();
            this.refvp.repaint();
        }

        protected XpMouseController createMouseController() {
            String strMouseController = CvPropertiesManager.getProperty("RefMouseController");
            try {
                if (strMouseController != null) {
                    return (XpMouseController)Class.forName(strMouseController).newInstance();
                }
            }
            catch (Exception e2) {
                e2.printStackTrace();
                logger.log(Level.SEVERE, "Exception in mouse controller creation", e2);
            }
            return null;
        }

        public void dispose() {
            if (this.refvp != null && !this.added) {
                CvUtils.dispose(this.refvp);
                this.svp.dispose();
                this.refvp = null;
                this.svp = null;
                this.parentcomp = null;
            }
        }

        private void setRefViewportAnnotation() {
            this.refvp.setAnnotationVisible(true);
            String annotLevel = XPDisplayPrefsUtils.getScreenAnnotationLevel();
            if (annotLevel.equals("none")) {
                this.refvp.setAnnotationGroup(annotLevel, true);
                this.refvp.setAnnotationItems(new String[0], true);
            } else if (annotLevel.equals("custom")) {
                this.refvp.setAnnotationGroup("none", true);
                this.refvp.setAnnotationItems(new String[]{"ESI_Information", "Windowing"}, true);
                String mod = DicomUtils.getModality((XpMedicalImage)this.refvp.getFrame());
                int mask = XPDisplayPrefsUtils.getScreenCustomAnnotationLevel();
                XPDisplayPrefsUtils.setCustomAnnotItems(this.refvp, mod, mask);
            } else {
                this.refvp.setAnnotationGroup(annotLevel, true);
                this.refvp.setAnnotationItems(new String[]{"ESI_Information", "Windowing"}, true);
            }
        }

        public void addPort() {
            if (!this.added) {
                this.contentpane = new XpReferenceVpContentPane();
                this.parentcomp.getMedicalImageVc().add((Component)this.contentpane, 0);
                this.contentpane.add(this.refvp);
                this.refvp.addMouseListener(this);
                this.refvp.getSliceMarker().addMouseListener(this);
                this.refvp.getMedicalImageVc().getAnnotationVc().addMouseListener(this);
                this.refvp.addPropertyChangeListener(XpReferenceImageDirector.this.riaPropListsner);
                this.added = true;
                this.parentcomp.getMedicalImageVc().repaint();
            }
        }

        public void removePort() {
            this.refvp.removeMouseListener(this);
            this.refvp.getSliceMarker().removeMouseListener(this);
            this.refvp.getMedicalImageVc().getAnnotationVc().removeMouseListener(this);
            this.refvp.removePropertyChangeListener(XpReferenceImageDirector.this.riaPropListsner);
            this.parentcomp = (XpSingularPort)((SelectionCapable)((Object)XpReferenceImageDirector.this.mainvpRef)).getViewportComponent(this.svp.getPortIndex());
            this.contentpane.removeAll();
            this.parentcomp.getMedicalImageVc().remove(this.contentpane);
            this.added = false;
            if (this.isSelected()) {
                ((SelectionCapable)((Object)XpReferenceImageDirector.this.mainvpRef)).setComponentSelection(this.getParentPortIndex());
                this.setSelected(false);
            }
            this.parentcomp.getMedicalImageVc().repaint();
        }

        public XpViewport getPort() {
            return this.refvp;
        }

        public JComponent getContentPane() {
            return this.contentpane;
        }

        public XpSingularPort getParentPort() {
            return this.parentcomp;
        }

        public SourceViewportWrapper getSourceViewport() {
            return this.svp;
        }

        public int getParentPortIndex() {
            return this.getSourceViewport().getPortIndex();
        }

        public void refreshImage() {
            this.setRefViewportAnnotation();
            if (XpReferenceImageDirector.this.refindex < 0 || XpReferenceImageDirector.this.refindex >= XpReferenceImageDirector.this.refimglist.length) {
                XpReferenceImageDirector.this.refindex = 0;
            }
            this.refvp.setImage(XpReferenceImageDirector.this.refimglist[XpReferenceImageDirector.this.refindex]);
            this.setSelected(this.isSelected);
        }

        @Override
        public void removePropertyChangeListener(String arg0, PropertyChangeListener arg1) {
            this.refvp.removePropertyChangeListener(arg0, arg1);
        }

        @Override
        public void addPropertyChangeListener(String arg0, PropertyChangeListener arg1) {
            this.refvp.addPropertyChangeListener(arg0, arg1);
        }

        @Override
        public void setSelected(boolean selected) {
            if (selected) {
                this.refvp.setBorder(this.sb);
                this.refvp.firePropertyChange("COMPONENT_SELECTED", this.isSelected, selected);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ReferenceViewportWrapper.this.refvp.getMedicalImageVc().getImageVc().requestFocusInWindow();
                    }
                });
            } else {
                this.refvp.setBorder(this.db);
                this.refvp.firePropertyChange("COMPONENT_UNSELECTED", this.isSelected, selected);
            }
            this.isSelected = selected;
        }

        @Override
        public boolean isSelected() {
            return this.isSelected;
        }

        public boolean isAdded() {
            return this.added;
        }

        @Override
        public void mouseClicked(MouseEvent e2) {
            if (!this.isSelected()) {
                XpReferenceImageDirector.this.mainvpRef.firePropertyChange("ComponentSelection", -1, this.getParentPortIndex());
                if (((SelectionCapable)((Object)XpReferenceImageDirector.this.mainvpRef)).getComponentSelection() >= 0) {
                    ((SelectionCapable)((Object)XpReferenceImageDirector.this.mainvpRef)).setComponentSelection(-1);
                }
                XpReferenceImageDirector.this.setRefVpSelection(this.getParentPortIndex());
                XpReferenceImageDirector.this.mainvpRef.firePropertyChange("reference_vp_selection", false, true);
            }
        }

        @Override
        public void mousePressed(MouseEvent e2) {
            if (!this.isSelected()) {
                XpReferenceImageDirector.this.setRefVpSelection(this.getParentPortIndex());
                XpReferenceImageDirector.this.mainvpRef.firePropertyChange("ComponentSelection", -1, this.getParentPortIndex());
                if (((SelectionCapable)((Object)XpReferenceImageDirector.this.mainvpRef)).getComponentSelection() >= 0) {
                    ((SelectionCapable)((Object)XpReferenceImageDirector.this.mainvpRef)).setComponentSelection(-1);
                }
                XpReferenceImageDirector.this.setRefVpSelection(this.getParentPortIndex());
                XpReferenceImageDirector.this.mainvpRef.firePropertyChange("reference_vp_selection", false, true);
            }
        }
    }

    class SourceViewportWrapper
    implements SliceControlledCapable {
        int index = 0;
        private List slList = new ArrayList();
        SliceListener svwsl = new SliceListener(){

            @Override
            public void setActiveSlice(Object arg0, XpSlice slice) {
                try {
                    for (int i2 = 0; i2 < SourceViewportWrapper.this.slList.size(); ++i2) {
                        if ((SliceListener)SourceViewportWrapper.this.slList.get(i2) == null) continue;
                        ((SliceListener)SourceViewportWrapper.this.slList.get(i2)).setActiveSlice(arg0, slice);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };

        public SourceViewportWrapper(int idx) {
            this.index = idx;
        }

        public int getPortIndex() {
            return this.index;
        }

        @Override
        public int getNumSlices() {
            return XpReferenceImageDirector.this.mainvpRef instanceof FrameCapable ? ((FrameCapable)((Object)XpReferenceImageDirector.this.mainvpRef)).getNumFrames() : 0;
        }

        @Override
        public XpSlice getSlice(int idx) {
            return XpReferenceImageDirector.this.mainvpRef instanceof FrameCapable ? ((FrameCapable)((Object)XpReferenceImageDirector.this.mainvpRef)).getFrame(idx).getSlice() : null;
        }

        @Override
        public XpSlice[] getSlices() {
            if (XpReferenceImageDirector.this.mainvpRef instanceof FrameCapable) {
                FrameCapable fpc = (FrameCapable)((Object)XpReferenceImageDirector.this.mainvpRef);
                int num = fpc.getNumFrames();
                XpSlice[] slices = new XpSlice[num];
                for (int i2 = 0; i2 < num; ++i2) {
                    slices[i2] = fpc.getFrame(i2).getSlice();
                }
                return slices;
            }
            return null;
        }

        @Override
        public XpSlice getActiveSlice() {
            int idx;
            XpSlice slice = null;
            if (XpReferenceImageDirector.this.mainvpRef != null && XpReferenceImageDirector.this.mainvpRef instanceof FrameCapable && XpReferenceImageDirector.this.mainvpRef instanceof FramePositioningCapable && (idx = this.getActiveSliceIndex()) != -1) {
                XpImage img = ((FrameCapable)((Object)XpReferenceImageDirector.this.mainvpRef)).getFrame(idx);
                slice = img.getSlice();
            }
            return slice;
        }

        @Override
        public void setActiveSlice(XpSlice slice) {
            if (XpReferenceImageDirector.this.mainvpRef != null) {
                if (XpReferenceImageDirector.this.mainvpRef instanceof FrameCapable && XpReferenceImageDirector.this.mainvpRef instanceof FramePositioningCapable) {
                    int closestIdx = 0;
                    double closestDist = Double.MAX_VALUE;
                    CPoint ul = slice.ul;
                    int nFrames = ((FrameCapable)((Object)XpReferenceImageDirector.this.mainvpRef)).getNumFrames();
                    for (int i2 = 0; i2 < nFrames; ++i2) {
                        XpImage image = ((FrameCapable)((Object)XpReferenceImageDirector.this.mainvpRef)).getFrame(i2);
                        XpSlice miSlice = image.getSlice();
                        double dist = miSlice.getPointToSliceDistance(ul);
                        if (!(dist < closestDist)) continue;
                        closestDist = dist;
                        closestIdx = i2;
                    }
                    this.setActiveSliceIndex(closestIdx);
                }
                XpReferenceImageDirector.this.mainvpRef.repaint();
            }
        }

        @Override
        public int getActiveSliceIndex() {
            FramePositioningCapable fpc;
            int idx;
            if (XpReferenceImageDirector.this.mainvpRef != null && XpReferenceImageDirector.this.mainvpRef instanceof FramePositioningCapable && (idx = (fpc = (FramePositioningCapable)((Object)XpReferenceImageDirector.this.mainvpRef)).getFrameIndex()) + this.index < fpc.getNumFrames()) {
                return idx + this.index;
            }
            return -1;
        }

        @Override
        public void setActiveSliceIndex(int sliceIndex) {
            if (XpReferenceImageDirector.this.mainvpRef instanceof FramePositioningCapable) {
                ((FramePositioningCapable)((Object)XpReferenceImageDirector.this.mainvpRef)).setFrameIndex(sliceIndex - this.index);
            }
            XpReferenceImageDirector.this.mainvpRef.repaint();
        }

        @Override
        public void addSliceListener(SliceListener sl) {
            try {
                if (!XpReferenceImageDirector.this.sliceListenerList.contains(this.svwsl)) {
                    if (XpReferenceImageDirector.this.sliceListenerList.size() < this.index) {
                        for (int i2 = 0; i2 < this.index; ++i2) {
                            XpReferenceImageDirector.this.sliceListenerList.add(i2, null);
                        }
                    }
                    XpReferenceImageDirector.this.sliceListenerList.add(this.index, this.svwsl);
                }
                this.slList.add(sl);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        @Override
        public void removeSliceListener(SliceListener sl) {
            if (XpReferenceImageDirector.this.mainvpRef != null && XpReferenceImageDirector.this.mainvpRef instanceof SliceSourceCapable) {
                ((SliceSourceCapable)((Object)XpReferenceImageDirector.this.mainvpRef)).removeSliceListener(sl);
            }
            this.slList.remove(sl);
            if (this.slList.size() == 0) {
                XpReferenceImageDirector.this.sliceListenerList.remove(this.svwsl);
            }
        }

        public void dispose() {
            for (int i2 = 0; i2 < this.slList.size(); ++i2) {
                this.removeSliceListener((SliceListener)this.slList.get(i2));
            }
        }
    }
}

