/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.crossref;

import com.ge.med.cse.cvf.crossref.XPCrossRefLinesManager;
import com.ge.med.terra.jami.CTransform;
import com.ge.med.terra.jami.GSPSGraphic;
import com.ge.med.terra.jami.RoiActor;
import com.ge.med.terra.jami.XpDicomElement;
import com.ge.med.terra.jami.XpImage;
import com.ge.med.terra.jami.XpMedicalImage;
import com.ge.med.terra.jami.XpSlice;
import com.ge.med.terra.jami.XpVisualComponent;
import com.ge.med.terra.jami.annotation.XpAnnotationModel;
import com.ge.med.terra.jami.annotation.XpAnnotationPolicy;
import com.ge.med.terra.jami.capable.GrayScaleCapable;
import com.ge.med.terra.jami.capable.Replicable;
import com.ge.med.terra.jami.capable.Visible;
import com.ge.med.terra.jami.roi.XpRoiEvent;
import com.ge.med.terra.jami.roi.XpRoiEventListener;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import javax.swing.event.MouseInputListener;

public class XpSliceCollectionRoi
implements RoiActor,
Replicable,
Visible,
GrayScaleCapable {
    private ArrayList slices = new ArrayList();
    private ArrayList atualSlicesDrawn = null;
    private XpImage image = null;
    private Point2D[] segments = null;
    private String lineStyle = "DOTTED";
    private Color lineColor = Color.cyan;
    private boolean validate = false;
    private boolean visible = true;
    private PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private XpDicomElement ser = new XpDicomElement(32, 17);
    private XpDicomElement img = new XpDicomElement(32, 19);
    private XpDicomElement imguid = new XpDicomElement(8, 24);
    private int largestAnnotationLen = 0;
    private int numIntersections = 0;
    private boolean grayscaleMode = false;
    private final int iterationTolerance = 2;
    private final int proximityTolerance = 8;
    private final int offsetXY = 4;
    private XpAnnotationModel annotModel = null;
    Line2D.Double vcLeft = new Line2D.Double();
    Line2D.Double vcTop = new Line2D.Double();
    Line2D.Double vcRight = new Line2D.Double();
    Line2D.Double vcBot = new Line2D.Double();
    double x;
    double y;
    double w;
    double h;
    private ArrayList roilistener = new ArrayList();
    private XpRoiEvent roiEvent = new XpRoiEvent(this);
    MouseInputListener listener = new MouseInputListener(){

        @Override
        public void mouseClicked(MouseEvent e2) {
        }

        @Override
        public void mouseEntered(MouseEvent e2) {
        }

        @Override
        public void mouseExited(MouseEvent e2) {
        }

        @Override
        public void mousePressed(MouseEvent e2) {
            XpSliceCollectionRoi.this.roiEvent.setHintMask(0);
            for (int i2 = 0; i2 < XpSliceCollectionRoi.this.roilistener.size(); ++i2) {
                XpRoiEventListener rel = (XpRoiEventListener)XpSliceCollectionRoi.this.roilistener.get(i2);
                rel.roiPressed(XpSliceCollectionRoi.this.roiEvent);
            }
        }

        @Override
        public void mouseReleased(MouseEvent e2) {
        }

        @Override
        public void mouseDragged(MouseEvent e2) {
        }

        @Override
        public void mouseMoved(MouseEvent e2) {
        }
    };

    public XpSliceCollectionRoi() {
    }

    public XpSliceCollectionRoi(XpAnnotationModel annotModel) {
        this.annotModel = annotModel;
    }

    @Override
    public Object clone() {
        XpSliceCollectionRoi slroi = new XpSliceCollectionRoi(this.annotModel);
        slroi.setImage(this.image);
        for (int i2 = 0; i2 < this.slices.size(); ++i2) {
            myXpSlice sl = (myXpSlice)((myXpSlice)this.slices.get(i2)).clone();
            slroi.slices.add(sl);
            slroi.largestAnnotationLen = this.largestAnnotationLen;
        }
        slroi.validate = true;
        slroi.setVisible(this.isVisible());
        return slroi;
    }

    public void addSlice(XpMedicalImage image) {
        if (image == null) {
            return;
        }
        image.getValue(this.imguid);
        image.getValue(this.img);
        image.getValue(this.ser);
        myXpSlice sl = new myXpSlice(new XpSlice(image), this.ser.getIntValue(), this.img.getIntValue(), this.imguid.getStringValue());
        if (this.slices.contains(sl)) {
            return;
        }
        this.slices.add(sl);
        int len = this.getSliceStringLen(this.slices.size() - 1);
        if (len > this.largestAnnotationLen) {
            this.largestAnnotationLen = len;
        }
        this.validate = true;
    }

    public void addSlices(XpMedicalImage[] images) {
        if (images == null || images.length == 0) {
            return;
        }
        for (int i2 = 0; i2 < images.length; ++i2) {
            images[i2].getValue(this.imguid);
            images[i2].getValue(this.img);
            images[i2].getValue(this.ser);
            myXpSlice sl = new myXpSlice(new XpSlice(images[i2]), this.ser.getIntValue(), this.img.getIntValue(), this.imguid.getStringValue());
            if (this.slices.contains(sl)) continue;
            this.slices.add(sl);
            int len = this.getSliceStringLen(this.slices.size() - 1);
            if (len <= this.largestAnnotationLen) continue;
            this.largestAnnotationLen = len;
        }
        this.validate = true;
    }

    public void removeAllSlices() {
        this.slices.clear();
        this.largestAnnotationLen = 0;
    }

    public final int getNumberOfSlices() {
        return this.slices.size();
    }

    private void postCrossReference() {
        this.numIntersections = 0;
        if (this.validate && this.image != null) {
            if (this.slices.size() > 0) {
                this.segments = new Point2D[2 * this.slices.size()];
                for (int i2 = 0; i2 < this.slices.size(); ++i2) {
                    myXpSlice s2 = (myXpSlice)this.slices.get(i2);
                    Point2D[] p2 = this.image.getSlice().getIntersection(s2.getSlice());
                    if (p2[0].equals(p2[1])) {
                        p2 = this.image.getSlice().getIntersectionWithInfinite(s2.getSlice());
                    }
                    this.segments[2 * i2] = p2[0];
                    this.segments[2 * i2 + 1] = p2[1];
                    if (p2[0].equals(p2[1])) continue;
                    ++this.numIntersections;
                }
            } else {
                this.segments = null;
            }
            this.validate = false;
            if (this.numIntersections == 0) {
                XPCrossRefLinesManager.logUserMessage(6);
            }
        }
    }

    final void line(Graphics g2, Point2D p0, Point2D p1, int offset) {
        g2.drawLine(offset + (int)p0.getX(), offset + (int)p0.getY(), offset + (int)p1.getX(), offset + (int)p1.getY());
    }

    private Point2D intersect(Line2D.Double line1, Line2D.Double line2) {
        Line2D.Double l2;
        Line2D.Double l1 = new Line2D.Double(line1.getP1(), line1.getP2());
        if (l1.intersectsLine(l2 = new Line2D.Double(line2.getP1(), line2.getP2()))) {
            if (l1.x2 == l1.x1) {
                l1.x2 += 1.0;
            }
            double m1 = (l1.y2 - l1.y1) / (l1.x2 - l1.x1);
            double c1 = l1.y1 - m1 * l1.x1;
            if (l2.x2 == l2.x1) {
                l2.x2 += 1.0;
            }
            double m2 = (l2.y2 - l2.y1) / (l2.x2 - l2.x1);
            double c2 = l2.y1 - m2 * l2.x1;
            double x2 = (c2 - c1) / (m1 - m2);
            double y2 = m1 * x2 + c1;
            return new Point2D.Double(x2, y2);
        }
        return null;
    }

    private void getValidPoints(Point2D[] points, XpVisualComponent vc) {
        boolean yinside;
        boolean xinside;
        Line2D.Double line = new Line2D.Double(points[0], points[1]);
        boolean bl = points[0].getX() <= points[1].getX() ? points[0].getX() >= this.x && points[1].getX() <= this.x + this.w : (xinside = points[1].getX() >= this.x && points[0].getX() <= this.x + this.w);
        boolean bl2 = points[0].getY() <= points[1].getY() ? points[0].getY() >= this.y && points[1].getY() <= this.y + this.h : (yinside = points[1].getY() >= this.y && points[0].getY() <= this.y + this.h);
        if (xinside && yinside) {
            if (null != this.annotModel) {
                this.checkAnnotationInterference(points, vc);
            }
            return;
        }
        boolean intersects = false;
        if (this.vcLeft.intersectsLine(line)) {
            if (points[0].getX() < this.x) {
                points[0] = this.intersect(this.vcLeft, line);
            }
            if (points[1].getX() < this.x) {
                points[1] = this.intersect(this.vcLeft, line);
            }
            intersects = true;
        }
        if (this.vcTop.intersectsLine(line)) {
            if (points[0].getY() < this.y) {
                points[0] = this.intersect(this.vcTop, line);
            }
            if (points[1].getY() < this.y) {
                points[1] = this.intersect(this.vcTop, line);
            }
            intersects = true;
        }
        if (this.vcRight.intersectsLine(line)) {
            if (points[0].getX() > this.x + this.w) {
                points[0] = this.intersect(this.vcRight, line);
            }
            if (points[1].getX() > this.x + this.w) {
                points[1] = this.intersect(this.vcRight, line);
            }
            intersects = true;
        }
        if (this.vcBot.intersectsLine(line)) {
            if (points[0].getY() > this.y + this.h) {
                points[0] = this.intersect(this.vcBot, line);
            }
            if (points[1].getY() > this.y + this.h) {
                points[1] = this.intersect(this.vcBot, line);
            }
            intersects = true;
        }
        if (!intersects) {
            points[0] = new Point2D.Double(0.0, 0.0);
            points[1] = new Point2D.Double(0.0, 0.0);
        }
        if (null != this.annotModel) {
            this.checkAnnotationInterference(points, vc);
        }
    }

    public void initialize(XpVisualComponent vc, Graphics2D g2) {
        Font prevfont = g2.getFont();
        XpAnnotationPolicy ap = XpAnnotationModel.getAnnotationPolicy();
        Font afont = ap.getAnnotationFont(vc.getWidth(), vc.getHeight());
        g2.setFont(afont);
        g2.setFont(prevfont);
        this.x = vc.getX();
        this.y = vc.getY();
        this.w = vc.getWidth();
        this.h = vc.getHeight();
        this.vcLeft.setLine(this.x, this.y, this.x, this.y + this.h);
        this.vcTop.setLine(this.x, this.y, this.x + this.w, this.y);
        this.vcRight.setLine(this.x + this.w, this.y, this.x + this.w, this.y + this.h);
        this.vcBot.setLine(this.x, this.y + this.h, this.x + this.w, this.y + this.h);
    }

    @Override
    public void paintRoi(XpVisualComponent vc, Graphics2D g2) {
        if (!this.visible) {
            return;
        }
        CTransform t2 = vc.getTransform((byte)0, (byte)1);
        AffineTransform at = t2.getTransform2D();
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (this.validate && this.image != null) {
            this.postCrossReference();
            this.validate = false;
        }
        this.initialize(vc, g2);
        int numberingPos = 0;
        if (null != this.annotModel) {
            this.annotModel.drawAnnotation(g2, vc.getBounds());
        }
        this.atualSlicesDrawn = new ArrayList();
        if (this.segments != null) {
            for (int i2 = 0; i2 < this.slices.size(); ++i2) {
                boolean vertical;
                Point2D[] dp;
                Point2D p1 = this.segments[2 * i2];
                Point2D p2 = this.segments[2 * i2 + 1];
                dp = new Point2D.Double[]{at.transform(p1, dp[0]), at.transform(p2, dp[1])};
                Point2D.Double[] dp_hV = new Point2D.Double[2];
                Font prevfont = g2.getFont();
                XpAnnotationPolicy ap = XpAnnotationModel.getAnnotationPolicy();
                Font afont = ap.getAnnotationFont(vc.getWidth(), vc.getHeight());
                g2.setFont(afont);
                String sliceStr = this.getSliceString(i2);
                double sliceNumberLength = g2.getFontMetrics().charWidth('m') * sliceStr.length() + sliceStr.length() * 4;
                g2.setFont(prevfont);
                if (p1.getX() == p2.getX() && p1.getY() == p2.getY()) continue;
                if (this.isGrayScaleMode()) {
                    g2.setColor(Color.WHITE);
                } else {
                    g2.setColor(this.lineColor);
                }
                double ang = Math.abs(Math.atan2(Math.abs(((Point2D)dp[1]).getY() - ((Point2D)dp[0]).getY()), Math.abs(((Point2D)dp[1]).getX() - ((Point2D)dp[0]).getX())));
                boolean bl = vertical = Math.toDegrees(ang) > 45.0;
                int dir = vertical ? (((Point2D)dp[0]).getY() < ((Point2D)dp[1]).getY() ? 1 : -1) : (((Point2D)dp[0]).getX() < ((Point2D)dp[1]).getX() ? 1 : -1);
                boolean reverse = numberingPos == 0 && dir == 1 || numberingPos == 1 && dir == -1;
                this.getValidPoints(dp, vc);
                if (dp[0].getY() == dp[1].getY() && dp[0].getX() != dp[1].getX()) {
                    if (numberingPos == 0) {
                        dp_hV[0] = new Point2D.Double(dp[0].getX() + sliceNumberLength, dp[0].getY());
                        dp_hV[1] = new Point2D.Double(dp[1].getX(), dp[0].getY());
                    } else {
                        dp_hV[0] = new Point2D.Double(dp[0].getX(), dp[0].getY());
                        dp_hV[1] = new Point2D.Double(dp[1].getX() - sliceNumberLength, dp[0].getY());
                    }
                } else if (dp[0].getY() != dp[1].getY() && dp[0].getX() == dp[1].getX()) {
                    if (numberingPos == 0) {
                        dp_hV[0] = new Point2D.Double(dp[0].getX(), dp[0].getY() + sliceNumberLength);
                        dp_hV[1] = new Point2D.Double(dp[1].getX(), dp[1].getY());
                    } else {
                        dp_hV[0] = new Point2D.Double(dp[0].getX(), dp[0].getY());
                        dp_hV[1] = new Point2D.Double(dp[1].getX(), dp[1].getY() - sliceNumberLength);
                    }
                }
                g2.setFont(afont);
                this.drawsliceNumber(g2, i2, (int)dp[numberingPos].getX(), (int)dp[numberingPos].getY(), vertical, reverse, sliceNumberLength, vc, dp, dir, numberingPos);
                if (this.lineStyle != null) {
                    if (dp[0].getX() != 0.0 && dp[0].getY() != 0.0 && dp[1].getX() != 0.0 && dp[1].getY() != 0.0) {
                        this.atualSlicesDrawn.add(((myXpSlice)this.slices.get(i2)).imgNum);
                    }
                    if (dp[1].getY() != 0.0 || dp[0].getY() != 0.0 || dp[1].getX() != 0.0 || dp[0].getX() != 0.0) {
                        if (this.lineStyle.compareTo("SOLID") == 0) {
                            if (dp[0].getY() != dp[1].getY() && dp[0].getX() != dp[1].getX()) {
                                this.drawDottedLine(g2, dp[0], dp[1], 0);
                            } else {
                                this.drawDottedLine(g2, dp_hV[0], dp_hV[1], 0);
                            }
                        } else if (this.lineStyle.compareTo("DOTTED") == 0) {
                            if (dp[0].getY() != dp[1].getY() && dp[0].getX() != dp[1].getX()) {
                                this.drawDottedLine(g2, dp[0], dp[1], 0);
                            } else {
                                this.drawDottedLine(g2, dp_hV[0], dp_hV[1], 0);
                            }
                        }
                    }
                }
                numberingPos = numberingPos == 0 ? 1 : 0;
            }
        }
    }

    private String getSliceString(int index) {
        if (this.slices == null || this.slices.size() == 0 || index >= this.slices.size() || index > 0 && index >= this.slices.size()) {
            return null;
        }
        myXpSlice s2 = (myXpSlice)this.slices.get(index);
        String num = s2.getSeriesNumber() + "/" + s2.getImageNumber();
        return num;
    }

    private int getSliceStringLen(int index) {
        if (this.slices == null || this.slices.size() == 0 || index >= this.slices.size()) {
            return 0;
        }
        myXpSlice s2 = (myXpSlice)this.slices.get(index);
        String sliceNo = this.getSliceString(index);
        return sliceNo != null ? sliceNo.length() : 0;
    }

    private void drawsliceNumber(Graphics2D g2, int index, int xPos, int yPos, boolean vertical, boolean reverse, double sliceNumberLength, XpVisualComponent vc, Point2D[] points, int dir, int numberingPos) {
        boolean sliceNumberContainsAnnotation = false;
        myXpSlice sl = (myXpSlice)this.slices.get(index);
        char[] chars = (sl.getSeriesNumber() + "/" + sl.getImageNumber()).toCharArray();
        if (null != this.annotModel) {
            sliceNumberContainsAnnotation = this.ifSNoContainsAnnotationAndExceedingMaxLimitOfVc(sliceNumberLength, vc, points);
        }
        if (reverse) {
            if (sliceNumberContainsAnnotation) {
                this.drawSliceNumberForward(g2, index, xPos, yPos, vertical, chars);
            } else {
                this.drawSliceNumberReverse(g2, index, xPos, yPos, vertical, chars);
            }
        } else if (sliceNumberContainsAnnotation) {
            this.drawSliceNumberReverse(g2, index, xPos, yPos, vertical, chars);
        } else {
            this.drawSliceNumberForward(g2, index, xPos, yPos, vertical, chars);
        }
    }

    public void drawSliceNumberReverse(Graphics2D g2, int index, int xPos, int yPos, boolean vertical, char[] chars) {
        int offset = 0;
        for (int j2 = 0; j2 <= chars.length; ++j2) {
            offset = g2.getFontMetrics().charWidth(j2) + 4;
        }
        int xoffset = vertical ? 0 : offset;
        int yoffset = vertical ? offset : 0;
        int y2 = vertical ? yPos + 10 : yPos;
        int x2 = vertical ? xPos : xPos;
        for (int i2 = chars.length - 1; i2 >= 0; --i2) {
            g2.drawChars(chars, i2, 1, x2 -= xoffset, y2 -= yoffset);
        }
    }

    public void drawSliceNumberForward(Graphics2D g2, int index, int xPos, int yPos, boolean vertical, char[] chars) {
        int offset = 0;
        for (int j2 = 0; j2 <= chars.length; ++j2) {
            offset = g2.getFontMetrics().charWidth(j2) + 4;
        }
        int xoffset = vertical ? 0 : offset;
        int yoffset = vertical ? offset : 0;
        int y2 = vertical ? yPos + 7 : yPos;
        int x2 = vertical ? xPos : xPos + 7;
        for (int i2 = 0; i2 < chars.length; ++i2) {
            g2.drawChars(chars, i2, 1, x2, y2);
            y2 += yoffset;
            x2 += xoffset;
        }
    }

    private boolean ifSNoContainsAnnotationAndExceedingMaxLimitOfVc(double sliceNumberLength, XpVisualComponent vc, Point2D[] points) {
        boolean snContainsSliceNumber = false;
        double slope = (points[1].getY() - points[0].getY()) / (points[1].getX() - points[0].getX());
        double height = vc.getHeight() - 4;
        double width = vc.getWidth() - 4;
        double x1Iterator = points[0].getX();
        double y1Iterator = points[0].getY();
        double x2Iterator = points[1].getX();
        double y2Iterator = points[1].getY();
        if (Math.abs(slope) >= 1.0) {
            if (y1Iterator < y2Iterator) {
                double snyIterator;
                for (snyIterator = y1Iterator; snyIterator >= y1Iterator - sliceNumberLength; snyIterator -= 1.0) {
                    if (this.annotModel.insideAnnotation((int)x1Iterator, (int)snyIterator) == -1 && !(snyIterator < 0.0)) continue;
                    snContainsSliceNumber = true;
                    break;
                }
                for (snyIterator = y2Iterator; snyIterator <= y2Iterator + sliceNumberLength; snyIterator += 1.0) {
                    if (this.annotModel.insideAnnotation((int)x2Iterator, (int)snyIterator) == -1 && !(snyIterator >= height)) continue;
                    snContainsSliceNumber = true;
                    break;
                }
            } else {
                double snyIterator;
                for (snyIterator = y1Iterator; snyIterator <= y1Iterator + sliceNumberLength; snyIterator += 1.0) {
                    if (this.annotModel.insideAnnotation((int)x1Iterator, (int)snyIterator) == -1 && !(snyIterator >= height)) continue;
                    snContainsSliceNumber = true;
                    break;
                }
                for (snyIterator = y2Iterator; snyIterator >= y2Iterator - sliceNumberLength; snyIterator -= 1.0) {
                    if (this.annotModel.insideAnnotation((int)x2Iterator, (int)snyIterator) == -1 && !(snyIterator <= 0.0)) continue;
                    snContainsSliceNumber = true;
                    break;
                }
            }
        } else if (x1Iterator < x2Iterator) {
            double snxIterator;
            for (snxIterator = x1Iterator; snxIterator >= x1Iterator - sliceNumberLength; snxIterator -= 1.0) {
                if (this.annotModel.insideAnnotation((int)snxIterator, (int)y1Iterator) == -1 && !(snxIterator < 0.0)) continue;
                snContainsSliceNumber = true;
                break;
            }
            for (snxIterator = x2Iterator; snxIterator <= x2Iterator + sliceNumberLength; snxIterator += 1.0) {
                if (this.annotModel.insideAnnotation((int)snxIterator, (int)y2Iterator) == -1 && !(snxIterator >= width)) continue;
                snContainsSliceNumber = true;
                break;
            }
        } else {
            double snxIterator;
            for (snxIterator = x1Iterator; snxIterator >= x1Iterator - sliceNumberLength; snxIterator -= 1.0) {
                if (this.annotModel.insideAnnotation((int)snxIterator, (int)y1Iterator) == -1 && !(snxIterator >= width)) continue;
                snContainsSliceNumber = true;
                break;
            }
            for (snxIterator = x2Iterator; snxIterator <= x2Iterator + sliceNumberLength; snxIterator += 1.0) {
                if (this.annotModel.insideAnnotation((int)snxIterator, (int)y2Iterator) == -1 && !(snxIterator < 0.0)) continue;
                snContainsSliceNumber = true;
                break;
            }
        }
        return snContainsSliceNumber;
    }

    private void drawDottedLine(Graphics2D g2, Point2D p0, Point2D p1, int offset) {
        float[] dashPattern = new float[]{2.0f, 1.0f, 2.0f, 1.0f};
        g2.setStroke(new BasicStroke(1.0f, 0, 0, 10.0f, dashPattern, 0.0f));
        g2.drawLine(offset + (int)p0.getX(), offset + (int)p0.getY(), offset + (int)p1.getX(), offset + (int)p1.getY());
    }

    private void checkAnnotationInterference(Point2D[] points, XpVisualComponent vc) {
        double x1 = points[0].getX();
        double y1 = points[0].getY();
        double x2 = points[1].getX();
        double y2 = points[1].getY();
        double slope = (y2 - y1) / (x2 - x1);
        if (x1 == x2) {
            if (y1 != y2) {
                this.checkVerticalLineInterference(points, vc, false);
            }
        } else if (y1 == y2) {
            this.checkHorizontalLineInterference(points, vc, false);
        } else if (Math.abs(slope) >= 1.0) {
            this.checkVerticalLineInterference(points, vc, true);
        } else {
            this.checkHorizontalLineInterference(points, vc, true);
        }
    }

    private void checkHorizontalLineInterference(Point2D[] points, XpVisualComponent vc, boolean isInclined) {
        double vIterator;
        double mX = 0.0;
        double mY = 0.0;
        double upperXIterator = 0.0;
        double lowerXIterator = 0.0;
        double upperYIterator = 0.0;
        double lowerYIterator = 0.0;
        boolean lowerContains = false;
        boolean upperContains = false;
        double x1 = points[0].getX();
        double y1 = points[0].getY();
        double x2 = points[1].getX();
        double y2 = points[1].getY();
        double slope = (y2 - y1) / (x2 - x1);
        double yIntercept = y1 - slope * x1;
        mX = (points[0].getX() + points[1].getX()) / 2.0;
        mY = (points[0].getY() + points[1].getY()) / 2.0;
        upperXIterator = mX;
        upperYIterator = mY;
        lowerXIterator = mX;
        lowerYIterator = mY;
        double height = vc.getHeight() - 4;
        while (upperXIterator >= x1) {
            upperYIterator = isInclined ? slope * (upperXIterator -= 2.0) + yIntercept : upperYIterator;
            for (vIterator = upperYIterator - 8.0; vIterator <= upperYIterator + 8.0; vIterator += 1.0) {
                if (this.annotModel.insideAnnotation((int)upperXIterator, (int)vIterator) == -1 && !(vIterator < 0.0)) continue;
                upperContains = true;
                break;
            }
            if (!upperContains) continue;
        }
        while (lowerXIterator <= x2) {
            lowerYIterator = isInclined ? slope * (lowerXIterator += 2.0) + yIntercept : lowerYIterator;
            for (vIterator = lowerYIterator - 8.0; vIterator <= lowerYIterator + 8.0; vIterator += 1.0) {
                if (this.annotModel.insideAnnotation((int)lowerXIterator, (int)vIterator) == -1 && !(vIterator > height)) continue;
                lowerContains = true;
                break;
            }
            if (!lowerContains) continue;
        }
        if (lowerContains) {
            points[1].setLocation(lowerXIterator, lowerYIterator);
        }
        if (upperContains) {
            points[0].setLocation(upperXIterator, upperYIterator);
        }
    }

    private void checkVerticalLineInterference(Point2D[] points, XpVisualComponent vc, boolean isInclined) {
        double hIterator;
        double mX = 0.0;
        double mY = 0.0;
        double upperXIterator = 0.0;
        double lowerXIterator = 0.0;
        double upperYIterator = 0.0;
        double lowerYIterator = 0.0;
        double width = vc.getWidth() - 4;
        double height = vc.getHeight() - 4;
        boolean lowerContains = false;
        boolean upperContains = false;
        double x1 = points[0].getX();
        double y1 = points[0].getY();
        double x2 = points[1].getX();
        double y2 = points[1].getY();
        double slope = (y2 - y1) / (x2 - x1);
        double yIntercept = y1 - slope * x1;
        mX = (points[0].getX() + points[1].getX()) / 2.0;
        mY = (points[0].getY() + points[1].getY()) / 2.0;
        upperXIterator = mX;
        upperYIterator = mY;
        lowerXIterator = mX;
        lowerYIterator = mY;
        while (upperYIterator >= y1) {
            upperXIterator = isInclined ? ((upperYIterator -= 2.0) - yIntercept) / slope : upperXIterator;
            for (hIterator = upperXIterator - 8.0; hIterator <= upperXIterator + 8.0; hIterator += 1.0) {
                if (this.annotModel.insideAnnotation((int)hIterator, (int)upperYIterator) == -1 && !(hIterator > width)) continue;
                upperContains = true;
                break;
            }
            if (!upperContains) continue;
        }
        while (lowerYIterator <= y2) {
            lowerXIterator = isInclined ? ((lowerYIterator += 2.0) - yIntercept) / slope : lowerXIterator;
            for (hIterator = lowerXIterator - 8.0; hIterator <= lowerXIterator + 8.0; hIterator += 1.0) {
                if (this.annotModel.insideAnnotation((int)hIterator, (int)lowerYIterator) == -1 && !(hIterator < 0.0) && !(lowerYIterator > height)) continue;
                lowerContains = true;
                break;
            }
            if (!lowerContains) continue;
        }
        if (y2 < y1) {
            upperXIterator = mX;
            upperYIterator = mY;
            while (upperYIterator <= y1) {
                upperXIterator = isInclined ? ((upperYIterator += 2.0) - yIntercept) / slope : upperXIterator;
                for (hIterator = upperXIterator - 8.0; hIterator <= upperXIterator + 8.0; hIterator += 1.0) {
                    if (this.annotModel.insideAnnotation((int)hIterator, (int)upperYIterator) == -1 && !(upperYIterator >= height)) continue;
                    upperContains = true;
                    break;
                }
                if (!upperContains) continue;
            }
            lowerXIterator = mX;
            lowerYIterator = mY;
            while (lowerYIterator >= y2) {
                lowerXIterator = isInclined ? ((lowerYIterator -= 2.0) - yIntercept) / slope : lowerXIterator;
                for (hIterator = lowerXIterator - 8.0; hIterator <= lowerXIterator + 8.0; hIterator += 1.0) {
                    if (this.annotModel.insideAnnotation((int)hIterator, (int)lowerYIterator) == -1 && !(lowerYIterator < 0.0)) continue;
                    lowerContains = true;
                    break;
                }
                if (!lowerContains) continue;
            }
        }
        if (lowerContains) {
            points[1].setLocation(lowerXIterator, lowerYIterator);
        }
        if (upperContains) {
            points[0].setLocation(upperXIterator, upperYIterator);
        }
    }

    @Override
    public boolean contains(XpVisualComponent vc, int x2, int y2) {
        return false;
    }

    public void setlineStyle(String Style2) {
        this.lineStyle = Style2;
    }

    public void setlineColor(Color c2) {
        this.lineColor = c2;
    }

    @Override
    public MouseInputListener getMouseInputListener() {
        return this.listener;
    }

    @Override
    public void setImage(XpImage image) {
        this.image = image;
        this.postCrossReference();
    }

    @Override
    public XpImage getImage() {
        return this.image;
    }

    @Override
    public GSPSGraphic gspsDescription() {
        return null;
    }

    @Override
    public void addRoiEventListener(XpRoiEventListener rel) {
        this.roilistener.add(rel);
    }

    @Override
    public void removeRoiEventListener(XpRoiEventListener rel) {
        this.roilistener.remove(rel);
    }

    @Override
    public void setSelected(boolean arg0) {
    }

    @Override
    public boolean isSelected() {
        return false;
    }

    @Override
    public void removePropertyChangeListener(String propName, PropertyChangeListener pcl) {
        this.pcs.removePropertyChangeListener(propName, pcl);
    }

    @Override
    public void addPropertyChangeListener(String propName, PropertyChangeListener pcl) {
        this.pcs.addPropertyChangeListener(propName, pcl);
    }

    protected final void firePropertyChange(String property, Object value) {
        PropertyChangeEvent e2 = new PropertyChangeEvent(this, property, null, value);
        this.pcs.firePropertyChange(e2);
    }

    @Override
    public void setVisible(boolean visible) {
        this.visible = visible;
        this.firePropertyChange("ROI_MODEL", this);
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    public final ArrayList getActualSlicesDrawn() {
        return this.atualSlicesDrawn;
    }

    @Override
    public boolean isGrayScaleMode() {
        return this.grayscaleMode;
    }

    @Override
    public void setGrayScaleMode(boolean g2) {
        this.grayscaleMode = g2;
    }

    private class myXpSlice {
        private XpSlice slice = null;
        private int serNum = -1;
        private int imgNum = -1;
        private String imgUID = null;

        public myXpSlice(XpSlice sl, int ser, int img, String imguid) {
            this.slice = sl;
            this.serNum = ser;
            this.imgNum = img;
            this.imgUID = imguid;
        }

        public XpSlice getSlice() {
            return this.slice;
        }

        public int getSeriesNumber() {
            return this.serNum;
        }

        public int getImageNumber() {
            return this.imgNum;
        }

        public String getImageUID() {
            return this.imgUID;
        }

        public boolean equals(Object obj) {
            return obj instanceof myXpSlice && this.imgUID.equals(((myXpSlice)obj).getImageUID());
        }

        public Object clone() {
            myXpSlice sl = new myXpSlice((XpSlice)this.slice.clone(), this.serNum, this.imgNum, this.imgUID);
            return sl;
        }
    }
}

