/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.dataloader.adv;

import com.ge.med.cse.cvf.dataloader.DatasetValidator;
import com.ge.med.cse.cvf.idc.ImageValidator;
import com.ge.med.cse.cvf.log.UserMessageLevel;
import com.ge.med.cse.cvf.util.CvPropertiesManager;
import com.ge.med.cse.cvf.util.CvUtils;
import com.ge.med.cse.cvf.util.DicomUtils;
import com.ge.med.terra.tap.dm.DMTag;
import com.ge.med.terra.tap.dm.DMTagValueInterface;
import java.util.logging.Level;
import java.util.logging.Logger;

public class XpImageDataSetValidator
implements DatasetValidator {
    private static final Logger logger = Logger.getLogger(ImageValidator.class.getName());
    private static final String[] modalities = CvPropertiesManager.getProperty("cvf.modalities", "ct,mr,pr").split(",");
    private static final String[] unsupportedImgTypes = CvPropertiesManager.getProperty("cvf.imagetypes.unsupported", "3D,3DMOD").split(",");
    private DMTag sopClassUID = new DMTag(8, 22);

    @Override
    public String validateImages(DMTagValueInterface[] imgs) {
        if (imgs == null || imgs.length == 0) {
            logger.log(Level.INFO, "image list is empty");
            return "NO_IMAGE_PRESENT";
        }
        boolean supported = false;
        String modality = DicomUtils.getModality(imgs[0]);
        if (modality != null && modality.trim().length() > 0) {
            for (int i2 = 0; i2 < modalities.length; ++i2) {
                if (!modalities[i2].equalsIgnoreCase(modality)) continue;
                supported = true;
                break;
            }
        }
        if (supported && "OT".equalsIgnoreCase(modality)) {
            supported = false;
            String sopUID = (String)imgs[0].getValue(this.sopClassUID);
            if (sopUID != null && ("1.2.840.10008.5.1.4.1.1.12.1".equals(sopUID) || "1.2.840.10008.5.1.4.1.1.7".equals(sopUID))) {
                supported = true;
            }
        }
        if (!supported) {
            logger.log(Level.INFO, "{0} Unsupported modality " + modality);
            logger.log(UserMessageLevel.USER_MSG, CvUtils.getResourceBundle().getString("SE_NOT_SUPPORTED") + " " + modality);
            return "INVALID_MODALITY";
        }
        String imageType = DicomUtils.getImageType(imgs[0], false);
        supported = true;
        if (imageType != null && imageType.trim().length() > 0) {
            for (int i3 = 0; i3 < unsupportedImgTypes.length; ++i3) {
                if (!unsupportedImgTypes[i3].equalsIgnoreCase(imageType)) continue;
                supported = false;
                break;
            }
        }
        if (!supported) {
            logger.log(Level.INFO, "{0} Unsupported image type " + imageType);
            logger.log(UserMessageLevel.USER_MSG, CvUtils.getResourceBundle().getString("SE_NOT_SUPPORTED") + " " + imageType);
            return "INVALID_IMAGETYPE";
        }
        return "SUPPORTED_MODALITY";
    }
}

