/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.formatter;

import com.ge.hc.cse.commons.interfaces.Formatter;
import com.ge.med.terra.tap.dm.DMObject;
import com.ge.med.terra.tap.dm.DMQuery;
import java.util.StringTokenizer;

public class ContrastFormatter
implements Formatter {
    static final int MAXCONTRASTCHARS = 16;
    private String result = null;
    private boolean gotIV = false;
    private boolean gotOral = false;
    private String[] contsummary = new String[]{"", ""};

    public Object format(DMObject objToformat) {
        String query = null;
        if (objToformat != null) {
            if (objToformat.getType().equalsIgnoreCase("series")) {
                String examid = (String)objToformat.getValue(32, 16);
                String examuid = (String)objToformat.getValue(32, 13);
                if (examid != null && examid.length() != 0 && examuid != null && examuid.length() != 0) {
                    query = "(0x0020, 0x000d) = " + examuid + " AND (0x0020, 0x0010) = " + examid;
                }
                DMObject[] dmo = objToformat.getRelated("study", new DMQuery(query));
                this.createExamContrastSummary(dmo[0]);
                this.result = "     IV:" + this.contsummary[0] + "     GI:" + this.contsummary[1];
            } else if (objToformat.getType().equalsIgnoreCase("image")) {
                String seriesid = (String)objToformat.getValue(32, 17);
                String seriesuid = (String)objToformat.getValue(32, 14);
                if (seriesid != null && seriesid.length() != 0 && seriesuid != null && seriesuid.length() != 0) {
                    query = "(0x0020, 0x000e) = " + seriesuid + " AND (0x0020, 0x0011) = " + seriesid;
                }
                DMObject[] dmo = objToformat.getRelated("series", new DMQuery(query));
                this.createSeriesContrastSummary(dmo[0]);
                this.result = "     IV:" + this.contsummary[0] + "     GI:" + this.contsummary[1];
            }
        }
        return this.result;
    }

    private void createSeriesContrastSummary(DMObject dmobj) {
        DMObject[] imgobj = dmobj.getRelated("image");
        if (imgobj != null) {
            for (int i2 = 0; !(this.gotIV && this.gotOral || i2 >= imgobj.length); ++i2) {
                String contrast = (String)imgobj[i2].getValue(24, 16);
                String contrast_value = (String)imgobj[i2].getValue(24, 4160);
                if (contrast_value == null || contrast_value.length() == 0 || contrast_value.equals(" \n\t")) continue;
                if (contrast_value.equals("IV")) {
                    this.gotIV = true;
                    if (contrast == null || contrast.length() <= " \n\t".length()) continue;
                    if (contrast.length() > 16) {
                        this.contsummary[0] = contrast.substring(0, 16);
                        continue;
                    }
                    this.contsummary[0] = contrast;
                    continue;
                }
                if (contrast_value.equals("Oral")) {
                    this.gotOral = true;
                    if (contrast == null || contrast.length() <= " \n\t".length()) continue;
                    if (contrast.length() > 16) {
                        this.contsummary[1] = contrast.substring(0, 16);
                        continue;
                    }
                    this.contsummary[1] = contrast;
                    continue;
                }
                if (!contrast_value.contains("Oral") || !contrast_value.contains("IV")) continue;
                this.gotIV = true;
                this.gotOral = true;
                if (contrast == null || contrast.length() <= " \n\t".length()) continue;
                StringTokenizer sttok = new StringTokenizer(contrast, "&");
                int j2 = 1;
                while (sttok.hasMoreTokens() && j2 >= 0) {
                    String tok = sttok.nextToken();
                    if (tok.length() > 16) {
                        this.contsummary[j2--] = tok.substring(0, 16);
                        continue;
                    }
                    this.contsummary[j2--] = tok;
                }
            }
        }
    }

    private void createExamContrastSummary(DMObject dmobj) {
        DMObject[] seriesobj = dmobj.getRelated("series");
        if (seriesobj != null) {
            for (int i2 = 0; !(this.gotIV && this.gotOral || i2 >= seriesobj.length); ++i2) {
                this.createSeriesContrastSummary(seriesobj[i2]);
            }
        }
    }
}

