/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.formatter;

import com.ge.hc.cse.commons.interfaces.Formatter;
import com.ge.med.terra.tap.dm.DMObject;
import java.text.NumberFormat;
import java.util.StringTokenizer;

public class RLFormatter
implements Formatter {
    private String result;

    public Object format(DMObject obj) {
        this.result = "";
        if (obj != null) {
            String ULHC = (String)obj.getValue(32, 50);
            String URBRHC = (String)obj.getValue(32, 55);
            String pixelSpacing = (String)obj.getValue(40, 48);
            Integer imageHeight = (Integer)obj.getValue(40, 16);
            Integer imageWidth = (Integer)obj.getValue(40, 17);
            if (ULHC == null || URBRHC == null || pixelSpacing == null || imageHeight == null || imageWidth == null) {
                this.result = " ";
                return this.result;
            }
            try {
                StringTokenizer st = new StringTokenizer(pixelSpacing, "\\");
                float pixelY = Float.parseFloat(st.nextToken());
                float pixelX = Float.parseFloat(st.nextToken());
                float norm_row = pixelX * (float)imageWidth.intValue();
                float norm_col = pixelY * (float)imageHeight.intValue();
                st = new StringTokenizer(URBRHC, "\\");
                Float[] dir_cos = new Float[st.countTokens()];
                int i2 = 0;
                while (st.hasMoreTokens()) {
                    dir_cos[i2] = new Float(st.nextToken());
                    ++i2;
                }
                float rowL = dir_cos[0].floatValue();
                float colL = dir_cos[3].floatValue();
                st = new StringTokenizer(ULHC, "\\");
                float ulhc_R = -1.0f * Float.parseFloat(st.nextToken());
                float urhc_R = ulhc_R - rowL * norm_row;
                float brhc_R = urhc_R - colL * norm_col;
                float ctr_R = (brhc_R + ulhc_R) / 2.0f;
                float EPSILON = 0.001f;
                this.result = (double)ctr_R >= 0.0 || Math.abs(ctr_R) < 0.001f ? "R " : "L ";
                NumberFormat nmFormat = NumberFormat.getInstance();
                nmFormat.setMinimumFractionDigits(1);
                this.result = this.result + nmFormat.format(Math.abs(ctr_R));
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        return this.result;
    }
}

