/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.formatter;

import com.ge.hc.cse.commons.interfaces.Formatter;
import com.ge.med.cse.cvf.util.DicomUtils;
import com.ge.med.terra.tap.dm.DMObject;
import java.text.NumberFormat;
import java.util.StringTokenizer;

public class SliceLocationFormatter
implements Formatter {
    private String result = null;
    final float Epsilon = 0.001f;

    public Object format(DMObject objToformat) {
        String mod = DicomUtils.getModality(objToformat);
        if (mod != null && mod.equals("CT")) {
            String setype = DicomUtils.getImageType(objToformat, false);
            if (setype == null || setype.equalsIgnoreCase("UNKNOWN")) {
                return this.result;
            }
            if (setype.equals("CTINT")) {
                this.result = " ";
            } else {
                StringTokenizer st;
                Float imprecise_loc = (Float)objToformat.getValue(41, 4098);
                Float GEMS_imprecise_loc = null;
                if (imprecise_loc != null && DicomUtils.getGEMS_signature_29(objToformat)) {
                    GEMS_imprecise_loc = imprecise_loc;
                }
                String sloc = (String)objToformat.getValue(32, 4161);
                String URBRHC = (String)objToformat.getValue(32, 55);
                String ULHC = (String)objToformat.getValue(32, 50);
                String pixelSpacing = (String)objToformat.getValue(40, 48);
                String deriveDescr = (String)objToformat.getValue(8, 8465);
                Integer imageHeight = (Integer)objToformat.getValue(40, 16);
                Integer imageWidth = (Integer)objToformat.getValue(40, 17);
                boolean combinedImg = setype != null && setype.equals("COMB");
                String gcomb = null;
                String[] ddstr = null;
                if (deriveDescr != null) {
                    StringTokenizer st2 = new StringTokenizer(deriveDescr, "\\");
                    ddstr = new String[st2.countTokens()];
                    int i2 = 0;
                    while (st2.hasMoreTokens()) {
                        ddstr[i2] = st2.nextToken();
                        ++i2;
                    }
                    if (ddstr != null) {
                        gcomb = ddstr[0];
                    }
                }
                boolean GEMScombined = combinedImg && deriveDescr != null && gcomb != null && gcomb.equals("COMBINED");
                float pixelSizeX = 0.0f;
                float pixelSizeY = 0.0f;
                if (!combinedImg) {
                    st = new StringTokenizer(pixelSpacing, "\\");
                    if (st != null && st.countTokens() > 1) {
                        pixelSizeY = Float.parseFloat(st.nextToken());
                        pixelSizeX = Float.parseFloat(st.nextToken());
                    }
                } else if (GEMScombined) {
                    pixelSizeY = Float.parseFloat(ddstr[1]);
                    pixelSizeX = Float.parseFloat(ddstr[2]);
                }
                st = new StringTokenizer(ULHC, "\\");
                Float[] ulhc = new Float[st.countTokens()];
                int i3 = 0;
                while (st.hasMoreTokens()) {
                    ulhc[i3] = new Float(st.nextToken());
                    ++i3;
                }
                st = new StringTokenizer(URBRHC, "\\");
                Float[] urbhc = new Float[st.countTokens()];
                int i4 = 0;
                while (st.hasMoreTokens()) {
                    urbhc[i4] = new Float(st.nextToken());
                    ++i4;
                }
                Float[] urhc = new Float[]{Float.valueOf(ulhc[0].floatValue() - pixelSizeX * (float)imageWidth.intValue() * urbhc[0].floatValue()), Float.valueOf(ulhc[1].floatValue() - pixelSizeX * (float)imageWidth.intValue() * urbhc[1].floatValue()), Float.valueOf(ulhc[2].floatValue() + pixelSizeX * (float)imageWidth.intValue() * urbhc[2].floatValue())};
                Float[] brhc = new Float[]{Float.valueOf(urhc[0].floatValue() - pixelSizeY * (float)imageHeight.intValue() * urbhc[3].floatValue()), Float.valueOf(urhc[1].floatValue() - pixelSizeY * (float)imageHeight.intValue() * urbhc[4].floatValue()), Float.valueOf(urhc[2].floatValue() + pixelSizeY * (float)imageHeight.intValue() * urbhc[5].floatValue())};
                float slicenormal_r = Math.abs(urbhc[1].floatValue() * urbhc[5].floatValue() - urbhc[2].floatValue() * urbhc[4].floatValue());
                float slicenormal_a = Math.abs(urbhc[3].floatValue() * urbhc[2].floatValue() - urbhc[5].floatValue() * urbhc[0].floatValue());
                float slicenormal_s = Math.abs(urbhc[0].floatValue() * urbhc[4].floatValue() - urbhc[1].floatValue() * urbhc[3].floatValue());
                float ctr_R = (float)((double)(ulhc[0].floatValue() + brhc[0].floatValue()) / 2.0);
                float ctr_A = (float)((double)(ulhc[1].floatValue() + brhc[1].floatValue()) / 2.0);
                float ctr_S = (float)((double)(ulhc[2].floatValue() + brhc[2].floatValue()) / 2.0);
                int slicenormal_axis = slicenormal_r < slicenormal_a ? (slicenormal_a < slicenormal_s ? 2 : 1) : (slicenormal_r < slicenormal_s ? 2 : 0);
                float slicelocation = 0.0f;
                slicelocation = setype.equals("REFMT") || setype.equals("REFORMAT") || setype.equals("COMB") || setype.equals("PROC") ? (slicenormal_axis == 0 ? ctr_R : (slicenormal_axis == 1 ? ctr_A : ctr_S)) : (GEMS_imprecise_loc != null ? GEMS_imprecise_loc.floatValue() : Float.parseFloat(sloc));
                boolean secondarycapture = setype.equals("SSAVE") || setype.equals("3D") || setype.equals("COMB");
                String rl_ras = "";
                if (!secondarycapture) {
                    rl_ras = (double)ctr_R >= 0.0 || Math.abs(ctr_R) < 0.001f ? "R" : "L";
                }
                String ap_ras = "";
                if (!secondarycapture) {
                    ap_ras = (double)ctr_A >= 0.0 || Math.abs(ctr_A) < 0.001f ? "A" : "P";
                }
                String si_ras = "";
                if (!secondarycapture) {
                    si_ras = (double)ctr_S >= 0.0 || Math.abs(ctr_S) < 0.001f ? "S" : "I";
                }
                NumberFormat fmt = NumberFormat.getInstance();
                if (GEMS_imprecise_loc != null) {
                    fmt.setMinimumFractionDigits(1);
                    fmt.setMaximumFractionDigits(1);
                    this.result = si_ras + fmt.format(slicelocation) + "~";
                } else {
                    fmt.setMinimumFractionDigits(2);
                    fmt.setMaximumFractionDigits(2);
                    this.result = si_ras + fmt.format(slicelocation);
                }
            }
        }
        return this.result;
    }
}

