/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.j3d;

import com.ge.med.cse.cvf.idc.MultiSelectionCapable;
import com.ge.med.cse.cvf.j3d.J3DViewport;
import com.ge.med.cse.cvf.util.CvPropertiesManager;
import com.ge.med.idc.T3DCapable;
import com.ge.med.terra.jami.XpViewport;
import com.ge.med.terra.jami.XpViewportDirector;
import com.ge.med.terra.jami.j3d.T3DViewport;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.swing.SwingUtilities;

public class J3DPANLinkedDirector
implements XpViewportDirector {
    private ArrayList<J3DViewport> portList = new ArrayList();
    private PANPropertyChangeListener listener = new PANPropertyChangeListener(this);
    private Map<String, String> psValidation = new HashMap<String, String>();

    public J3DPANLinkedDirector() {
        this.init();
    }

    private void init() {
        String validation = CvPropertiesManager.getProperty("PRIMARY.SECONDARY.J3DPANLinkedDirector", "AXIAL:AXIAL;CORONAL:CORONAL;SAGITTAL:SAGITTAL;OBLIQUE:OBLIQUE;3D:3D");
        if (validation != null) {
            String[] primarySecondary_pair;
            for (String ps : primarySecondary_pair = validation.split(";")) {
                String[] psKeypair = ps.split(":");
                this.psValidation.put(psKeypair[0], psKeypair[1]);
            }
        }
    }

    @Override
    public void connectViewport(XpViewport viewport) {
        if (!this.portList.contains(viewport) && viewport instanceof T3DCapable) {
            this.portList.add((J3DViewport)viewport);
            ((T3DViewport)viewport).addPropertyChangeListener("camera", this.listener);
        }
    }

    @Override
    public void disconnectAllViewports() {
        for (int i2 = 0; i2 < this.portList.size(); ++i2) {
            T3DCapable port = this.portList.get(i2);
            port.removePropertyChangeListener(this.listener);
        }
        this.portList.clear();
    }

    @Override
    public void disconnectViewport(XpViewport viewport) {
        if (this.portList.contains(viewport)) {
            this.portList.remove(viewport);
            viewport.removePropertyChangeListener(this.listener);
        }
    }

    private void notifyPAN(Object src) {
        J3DViewport source = (J3DViewport)src;
        if (this.portList.isEmpty()) {
            return;
        }
        if (!this.isPrimaryViewPort(source)) {
            return;
        }
        double[] refEyePoint = new double[3];
        double[] refLookupPoint = new double[3];
        double[] refUpPoint = new double[3];
        source.getEyePoint(refEyePoint);
        source.getLookPoint(refLookupPoint);
        source.getUp(refUpPoint);
        String primary_ViewType = source.getViewType();
        String suppportedViewTypes = this.psValidation.get(primary_ViewType);
        if (suppportedViewTypes != null) {
            suppportedViewTypes = suppportedViewTypes.trim().toLowerCase();
        }
        for (int i2 = 0; i2 < this.portList.size(); ++i2) {
            J3DViewport port;
            if (this.portList.get(i2).equals(source) || !this.portList.get(i2).isSelected() || (port = this.portList.get(i2)).equals(source) || suppportedViewTypes == null || !suppportedViewTypes.contains(port.getViewType().toLowerCase())) continue;
            double[] eyePoint = port.getEyePoint(null);
            double[] lookupPoint = port.getLookPoint(null);
            double[] upPoint = port.getUp(null);
            if (Arrays.equals(refEyePoint, eyePoint) && Arrays.equals(refLookupPoint, lookupPoint) && Arrays.equals(refUpPoint, upPoint)) continue;
            port.setCamera(refEyePoint, refLookupPoint, refUpPoint);
        }
    }

    private boolean isPrimaryViewPort(J3DViewport source) {
        MultiSelectionCapable basescreen = (MultiSelectionCapable)((Object)SwingUtilities.getAncestorOfClass(MultiSelectionCapable.class, source));
        if (basescreen == null) {
            return false;
        }
        for (int i2 = 0; i2 < basescreen.getNumComponents(); ++i2) {
            if (source != basescreen.getViewportComponent(i2) || basescreen.getComponentSelectionState(i2) != 0) continue;
            return true;
        }
        return false;
    }

    private static class PANPropertyChangeListener
    implements PropertyChangeListener {
        J3DPANLinkedDirector adaptee;

        public PANPropertyChangeListener(J3DPANLinkedDirector adaptee) {
            this.adaptee = adaptee;
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            this.adaptee.notifyPAN(evt.getSource());
        }
    }
}

