/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.j3d;

import com.ge.med.cse.cvf.j3d.J3DViewport;
import com.ge.med.cse.cvf.screenbuilder.ScreenLoader;
import com.ge.med.cse.cvf.screenbuilder.VScreen;
import com.ge.med.cse.cvf.util.CvPropertiesManager;
import com.ge.med.idc.T3DCapable;
import com.ge.med.terra.jami.XpViewport;
import com.ge.med.terra.jami.XpViewportDirector;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;

public class J3DPortLinkingManager {
    private static ScreenDisplayedListener screenDisplayedListener = null;
    private List<XpViewportDirector> linkDirectors = new ArrayList<XpViewportDirector>();
    private List<XpViewportDirector> permanentlyLinkedDirectors = new ArrayList<XpViewportDirector>();
    private static J3DPortLinkingManager portlinkmgr = null;
    private static boolean _linked;
    private J3DViewport[] ports3D = null;
    private ViewTypeListener viewListener = new ViewTypeListener();
    private ScreenLoader sc;

    private J3DPortLinkingManager() {
        this.init();
    }

    private void init() {
        Object o2;
        Class<?> c2;
        int i2;
        String[] lpdirs;
        Properties properties = CvPropertiesManager.getProperties();
        String val = properties.getProperty("DMPR_LinkedPortDirectors");
        if (val != null) {
            lpdirs = val.split(",");
            for (i2 = 0; i2 < lpdirs.length; ++i2) {
                try {
                    c2 = Class.forName(lpdirs[i2]);
                    o2 = c2.newInstance();
                    if (!(o2 instanceof XpViewportDirector)) continue;
                    this.linkDirectors.add((XpViewportDirector)o2);
                    continue;
                }
                catch (ClassNotFoundException e2) {
                    e2.printStackTrace();
                    continue;
                }
                catch (InstantiationException e3) {
                    e3.printStackTrace();
                    continue;
                }
                catch (IllegalAccessException e4) {
                    e4.printStackTrace();
                }
            }
        }
        if ((val = properties.getProperty("DMPR_Permanently_LinkedPortDirectors")) != null) {
            lpdirs = val.split(",");
            for (i2 = 0; i2 < lpdirs.length; ++i2) {
                try {
                    c2 = Class.forName(lpdirs[i2]);
                    o2 = c2.newInstance();
                    if (!(o2 instanceof XpViewportDirector)) continue;
                    this.permanentlyLinkedDirectors.add((XpViewportDirector)o2);
                    continue;
                }
                catch (ClassNotFoundException e5) {
                    e5.printStackTrace();
                    continue;
                }
                catch (InstantiationException e6) {
                    e6.printStackTrace();
                    continue;
                }
                catch (IllegalAccessException e7) {
                    e7.printStackTrace();
                }
            }
        }
    }

    private void connectViewport(XpViewport viewport, Class c2) {
        for (XpViewportDirector xpdir : this.linkDirectors) {
            if (!c2.isInstance(xpdir)) continue;
            xpdir.connectViewport(viewport);
            return;
        }
        for (XpViewportDirector xpdir : this.permanentlyLinkedDirectors) {
            if (!c2.isInstance(xpdir)) continue;
            xpdir.connectViewport(viewport);
            return;
        }
    }

    private void disconnectViewport(XpViewport viewport, Class c2) {
        for (XpViewportDirector xpdir : this.linkDirectors) {
            if (!c2.isInstance(xpdir)) continue;
            xpdir.disconnectViewport(viewport);
            return;
        }
        for (XpViewportDirector xpdir : this.permanentlyLinkedDirectors) {
            if (!c2.isInstance(xpdir)) continue;
            xpdir.disconnectViewport(viewport);
            return;
        }
    }

    private void disconnectAllViewports(Class c2) {
        for (XpViewportDirector xpdir : this.linkDirectors) {
            if (!c2.isInstance(xpdir)) continue;
            xpdir.disconnectAllViewports();
            return;
        }
        for (XpViewportDirector xpdir : this.permanentlyLinkedDirectors) {
            if (!c2.isInstance(xpdir)) continue;
            xpdir.disconnectAllViewports();
            return;
        }
    }

    public static J3DPortLinkingManager getInstance() {
        if (portlinkmgr == null) {
            portlinkmgr = new J3DPortLinkingManager();
        }
        return portlinkmgr;
    }

    public void setScreenLoader(ScreenLoader screenLoader) {
        if (this.sc != null) {
            this.sc.removePropertyChangeListener("ScreenDisplayed", screenDisplayedListener);
        }
        this.sc = screenLoader;
        screenDisplayedListener = new ScreenDisplayedListener();
        this.sc.addPropertyChangeListener("ScreenDisplayed", screenDisplayedListener);
    }

    public void setPortsLinked(boolean link) throws ClassNotFoundException {
        block5: {
            block4: {
                _linked = link;
                if (!_linked) break block4;
                VScreen currentScreen = this.sc.getVScreen();
                if (!(currentScreen.getPorts()[0] instanceof T3DCapable)) break block5;
                for (int i2 = 0; i2 < this.linkDirectors.size(); ++i2) {
                    int j2;
                    String supportedPorts = CvPropertiesManager.getProperty(this.linkDirectors.get(i2).getClass().getName() + ".supportedViewTypes");
                    String[] portsArray = supportedPorts.split(",");
                    ArrayList<String> supportedPorttsList = new ArrayList<String>();
                    for (j2 = 0; j2 < portsArray.length; ++j2) {
                        supportedPorttsList.add(portsArray[j2]);
                    }
                    for (j2 = 0; j2 < currentScreen.getPorts().length; ++j2) {
                        String viewtype = ((J3DViewport)currentScreen.getPorts()[j2]).getViewType();
                        if (!supportedPorttsList.contains(viewtype)) continue;
                        this.connectViewport((XpViewport)currentScreen.getPorts()[j2], Class.forName(this.linkDirectors.get(i2).getClass().getName()));
                    }
                }
                break block5;
            }
            for (int i3 = 0; i3 < this.linkDirectors.size(); ++i3) {
                this.disconnectAllViewports(Class.forName(this.linkDirectors.get(i3).getClass().getName()));
            }
        }
    }

    public void setPermanentPortsLinked(boolean link) throws ClassNotFoundException {
        if (link) {
            VScreen currentScreen = this.sc.getVScreen();
            for (int i2 = 0; i2 < this.permanentlyLinkedDirectors.size(); ++i2) {
                int j2;
                String supportedPorts = CvPropertiesManager.getProperty(this.permanentlyLinkedDirectors.get(i2).getClass().getName() + ".supportedViewTypes");
                String[] portsArray = supportedPorts.split(",");
                ArrayList<String> supportedPorttsList = new ArrayList<String>();
                for (j2 = 0; j2 < portsArray.length; ++j2) {
                    supportedPorttsList.add(portsArray[j2]);
                }
                for (j2 = 0; j2 < currentScreen.getPorts().length; ++j2) {
                    String viewtype = ((J3DViewport)currentScreen.getPorts()[j2]).getViewType();
                    if (!supportedPorttsList.contains(viewtype)) continue;
                    this.connectViewport((XpViewport)currentScreen.getPorts()[j2], Class.forName(this.permanentlyLinkedDirectors.get(i2).getClass().getName()));
                }
            }
        } else {
            for (int i3 = 0; i3 < this.permanentlyLinkedDirectors.size(); ++i3) {
                this.disconnectAllViewports(Class.forName(this.permanentlyLinkedDirectors.get(i3).getClass().getName()));
            }
        }
    }

    public boolean getPortsLinked() {
        return _linked;
    }

    static /* synthetic */ J3DViewport[] access$302(J3DPortLinkingManager x0, J3DViewport[] x1) {
        x0.ports3D = x1;
        return x1;
    }

    private class ViewTypeListener
    implements PropertyChangeListener {
        private ViewTypeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            int j2;
            ArrayList<String> supportedPorttsList;
            String[] portsArray;
            String supportedPorts;
            Class<?> cl;
            J3DViewport port = (J3DViewport)evt.getSource();
            String viewtype = port.getViewType();
            Iterator iter = J3DPortLinkingManager.this.permanentlyLinkedDirectors.iterator();
            while (iter.hasNext()) {
                cl = ((XpViewportDirector)iter.next()).getClass();
                supportedPorts = CvPropertiesManager.getProperty(cl.getName() + ".supportedViewTypes");
                portsArray = supportedPorts.split(",");
                supportedPorttsList = new ArrayList<String>();
                for (j2 = 0; j2 < portsArray.length; ++j2) {
                    supportedPorttsList.add(portsArray[j2]);
                }
                if (supportedPorttsList.contains(viewtype)) {
                    J3DPortLinkingManager.this.connectViewport(port, cl);
                    continue;
                }
                J3DPortLinkingManager.this.disconnectViewport(port, cl);
            }
            iter = J3DPortLinkingManager.this.linkDirectors.iterator();
            while (iter.hasNext()) {
                cl = ((XpViewportDirector)iter.next()).getClass();
                supportedPorts = CvPropertiesManager.getProperty(cl.getName() + ".supportedViewTypes");
                portsArray = supportedPorts.split(",");
                supportedPorttsList = new ArrayList();
                for (j2 = 0; j2 < portsArray.length; ++j2) {
                    supportedPorttsList.add(portsArray[j2]);
                }
                if (supportedPorttsList.contains(viewtype)) {
                    J3DPortLinkingManager.this.connectViewport(port, cl);
                    continue;
                }
                J3DPortLinkingManager.this.disconnectViewport(port, cl);
            }
        }
    }

    private class ScreenDisplayedListener
    implements PropertyChangeListener {
        private ScreenDisplayedListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            String newScreen = (String)evt.getNewValue();
            VScreen newVScreen = J3DPortLinkingManager.this.sc.getScreen(newScreen);
            J3DPortLinkingManager.access$302(J3DPortLinkingManager.this, new J3DViewport[newVScreen.getPorts().length]);
        }
    }
}

