/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.j3d;

import com.ge.med.cse.cvf.annotation.XpCVAnnotation;
import com.ge.med.cse.cvf.idc.ViewTypeCapable;
import com.ge.med.cse.cvf.idc.XjDicomSupport;
import com.ge.med.cse.cvf.idc.XjVolumeCapable;
import com.ge.med.cse.cvf.idc.XpCineCapable;
import com.ge.med.cse.cvf.idc.XpSelection;
import com.ge.med.cse.cvf.idc.XpTickMarkCapable;
import com.ge.med.cse.cvf.j3d.DynamicVolume;
import com.ge.med.cse.cvf.j3d.J3DDefaultPagingViewCalculator;
import com.ge.med.cse.cvf.j3d.J3DTickMarkRuler;
import com.ge.med.cse.cvf.j3d.ViewCalculator;
import com.ge.med.cse.cvf.j3d.utils.J3DGeomUtils;
import com.ge.med.cse.cvf.util.CvPropertiesManager;
import com.ge.med.cse.cvf.util.CvUtils;
import com.ge.med.cse.cvf.util.DicomUtils;
import com.ge.med.idc.Capable;
import com.ge.med.idc.FramePositioningCapable;
import com.ge.med.idc.Fusion3DCapable;
import com.ge.med.idc.T3DRenderEngine;
import com.ge.med.idc.XjDicomObject;
import com.ge.med.idc.XjDynamicVolume;
import com.ge.med.idc.XjVolumeInfo;
import com.ge.med.idc.XjVolumeModel;
import com.ge.med.terra.jami.RoiActor;
import com.ge.med.terra.jami.XpImageRoiVc;
import com.ge.med.terra.jami.XpMedicalImage;
import com.ge.med.terra.jami.XpPropertiesManager;
import com.ge.med.terra.jami.XpUserAnnotationModel;
import com.ge.med.terra.jami.XpViewport;
import com.ge.med.terra.jami.capable.ImageOpCapable;
import com.ge.med.terra.jami.filter.XpImageOp;
import com.ge.med.terra.jami.j3d.J3DVolumeModel;
import com.ge.med.terra.jami.j3d.OrientationCubeVc;
import com.ge.med.terra.jami.j3d.T3DComponent;
import com.ge.med.terra.jami.j3d.T3DViewport;
import com.ge.med.terra.jami.j3d.XjVolumeUtils;
import com.ge.med.terra.jami.remote.RmRenderSession;
import com.ge.med.terra.jami.render.XpImageRenderAttributes;
import com.ge.med.terra.jami.roi.XpStatisticsRoi;
import com.ge.med.terra.xpv.base.XPscreen;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Properties;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public class J3DViewport
extends T3DViewport
implements FramePositioningCapable,
ViewTypeCapable,
XpCineCapable,
XjVolumeCapable,
XjDicomSupport,
ImageOpCapable,
XpTickMarkCapable,
XpSelection {
    private boolean currentcine;
    private int currentrate;
    private boolean cinePaused = false;
    private static Map<String, String> supportedViews = new LinkedHashMap<String, String>();
    private static String annotGenerator = null;
    private J3DTickMarkRuler horTickMarkComp;
    private J3DTickMarkRuler verTickMarkComp;
    private static Properties annotprops = new Properties();
    private String[] supportedViewTypes = new String[]{"CORONAL", "AXIAL", "SAGITTAL", "OBLIQUE", "3D"};
    private Map<String, ViewTypeCapable.ViewTypeActor> views = new HashMap<String, ViewTypeCapable.ViewTypeActor>();
    private ViewTypeCapable.ViewTypeActor currentView = null;
    private boolean vtypelock = false;
    private ViewCalculator viewCalculator = null;
    private XpViewport.IntValueDispatcher framedispatcher = new XpViewport.IntValueDispatcher("FrameIndex");
    private int startOffset = 0;
    private int endOffset = 0;
    private int cineSkip = 1;
    private int cineMode = 0;
    private ContainerListener clstr = new ContainerListener(){

        @Override
        public void componentRemoved(ContainerEvent e2) {
            e2.getChild().removeMouseListener(J3DViewport.this.getSelectionListener());
        }

        @Override
        public void componentAdded(ContainerEvent e2) {
            e2.getChild().removeMouseListener(J3DViewport.this.getSelectionListener());
            e2.getChild().addMouseListener(J3DViewport.this.getSelectionListener());
        }
    };
    private MouseListener defaultSelectionLsnr = new MouseAdapter(){

        @Override
        public void mousePressed(MouseEvent e2) {
            J3DViewport.this.setSelected(true);
        }
    };
    private boolean selected_ = false;
    MouseListener selectionLsnr = null;
    private PropertyChangeListener frameIndexListner = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            J3DViewport.this.framedispatcher.setValues(J3DViewport.this, J3DViewport.this.viewCalculator.getFrameIndex());
            SwingUtilities.invokeLater(J3DViewport.this.framedispatcher);
        }
    };
    private HashMap<String, Capable> capableImplementations = new HashMap();
    private boolean rotate = true;
    private PropertyChangeListener graphicListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            List rois;
            Object roiactor;
            if ("ROI_ADDED".equals(evt.getPropertyName())) {
                Object roiactor2 = evt.getNewValue();
                if (roiactor2 instanceof RoiActor) {
                    List rois2 = J3DViewport.this.getRois();
                    int idx = 0;
                    if (rois2 != null && rois2.contains(roiactor2)) {
                        for (int i2 = 0; i2 < rois2.size(); ++i2) {
                            Object roi = rois2.get(i2);
                            if (!(roi instanceof XpStatisticsRoi)) continue;
                            ((XpStatisticsRoi)roi).setRoiLabel(Integer.toString(++idx));
                        }
                    }
                    ((RoiActor)roiactor2).setSelected(true);
                }
            } else if ("ROI_REMOVED".equals(evt.getPropertyName()) && (roiactor = evt.getNewValue()) instanceof RoiActor && (rois = J3DViewport.this.getRois()) != null && rois.size() > 0) {
                int idx = 0;
                for (int i3 = 0; i3 < rois.size(); ++i3) {
                    Object roi = rois.get(i3);
                    if (!(roi instanceof XpStatisticsRoi)) continue;
                    ((XpStatisticsRoi)roi).setRoiLabel(Integer.toString(++idx));
                }
            }
        }
    };

    public J3DViewport() {
        this(new J3DComponent());
    }

    public J3DViewport(T3DComponent tc) {
        super(tc);
        this.init();
    }

    public J3DViewport(T3DRenderEngine engine) {
        this(new J3DComponent(engine));
    }

    public J3DViewport(RmRenderSession serverSession, String remoteRenderEngineClass) {
        super(serverSession, remoteRenderEngineClass);
        this.init();
    }

    protected void init() {
        String[] vs;
        String val = CvPropertiesManager.getProperty("j3d.supportedViewTypes");
        if (val != null && val.length() > 0 && (vs = val.split(",")) != null && vs.length > 0) {
            supportedViews.clear();
            for (int i2 = 0; i2 < vs.length; ++i2) {
                String[] view = vs[i2].split("#");
                supportedViews.put(view[0], view[1]);
            }
        }
        this.supportedViewTypes = supportedViews.keySet().toArray(new String[supportedViews.size()]);
        try {
            this.setAnnotationGenerator(Class.forName(annotGenerator, true, this.getClass().getClassLoader()), annotprops);
        }
        catch (ClassNotFoundException e2) {
            e2.printStackTrace();
        }
        this.getAnnotationGenerator().reset();
        this.getT3DComponent().getT3DRenderEngine().addPropertyChangeListener("VOLUME_PROPERTY", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (J3DViewport.this.getT3DComponent().getNumVolumeLayers() > 1) {
                    CvUtils.setT3DRenderStyle(J3DViewport.this, "REFORMAT");
                    J3DViewport.this.setViewClip(new double[]{0.0, 0.0});
                } else if (!(J3DViewport.this.getT3DComponent().getNumVolumeLayers() != 1 || J3DViewport.this.getViewType(J3DViewport.this.getViewType()).is3DViewType() || J3DViewport.this.getRenderStyle().equals(CvUtils.getT3DRenderStyle("MAJOR_AXIS_MIP")) || J3DViewport.this.getRenderStyle().equals(CvUtils.getT3DRenderStyle("MAJOR_AXIS_MINIP")) || J3DViewport.this.getRenderStyle().equals(CvUtils.getT3DRenderStyle("MAJOR_AXIS_AVERAGE")))) {
                    CvUtils.setT3DRenderStyle(J3DViewport.this, "MAJOR_AXIS_MIP");
                }
                J3DViewport.this.fireVolumeLoadedProperty();
            }
        });
        this.attachSelectionListener(this.getSelectionListener());
        this.createViews();
        this.setViewType(this.supportedViewTypes[0]);
        this.showOrientationCube();
        this.getT3DComponent().addMouseListener(new CineController(this));
        this.addPropertyChangeListener("ROI_ADDED", this.graphicListener);
        this.addPropertyChangeListener("ROI_REMOVED", this.graphicListener);
    }

    @Override
    public void dispose() {
        int layer;
        Component[] comps = this.getT3DComponent().getComponents();
        for (int i2 = 0; i2 < comps.length; ++i2) {
            comps[i2].removeMouseListener(this.getSelectionListener());
        }
        this.getT3DComponent().removeContainerListener(this.clstr);
        this.removePropertyChangeListener("ROI_ADDED", this.graphicListener);
        this.removePropertyChangeListener("ROI_REMOVED", this.graphicListener);
        T3DComponent fcCap = this.getT3DComponent();
        for (int i3 = layer = fcCap.getNumVolumeLayers(); i3 >= 0; --i3) {
            fcCap.removeVolumeLayer(i3);
        }
        this.setVolume(null);
        super.dispose();
    }

    private void createViews() {
        for (String vtype : supportedViews.keySet()) {
            ViewTypeCapable.ViewTypeActor vta = this.createView(vtype);
            if (vta == null) continue;
            this.views.put(vtype, vta);
        }
    }

    private static void configureAnnotations() {
        String[] modalities;
        String id = "cvf.annotation.3d";
        String mods = CvPropertiesManager.getProperty("cvf.j3d.modalities", "mr,ct");
        if (mods != null && (modalities = mods.split(",")) != null && modalities.length > 0) {
            for (int i2 = 0; i2 < modalities.length; ++i2) {
                String[] imgTypes;
                String mod = modalities[i2].trim().toLowerCase();
                String imT = CvPropertiesManager.getProperty(id + ".apstyle." + mod + ".imagetype");
                if (imT == null || (imgTypes = imT.split(",")) == null || imgTypes.length <= 0) continue;
                for (int j2 = 0; j2 < imgTypes.length; ++j2) {
                    String apstyleclass = CvPropertiesManager.getProperty(id + ".apstyle." + mod + "." + imgTypes[j2] + ".apstyleclass");
                    String configclass = CvPropertiesManager.getProperty(id + ".apstyle." + mod + "." + imgTypes[j2] + ".configclass");
                    if (apstyleclass == null || configclass == null) continue;
                    try {
                        XpCVAnnotation.registerAnnotationConfig(Class.forName(apstyleclass, true, Thread.currentThread().getContextClassLoader()), configclass);
                        annotprops.setProperty(imgTypes[j2], apstyleclass);
                        continue;
                    }
                    catch (ClassNotFoundException e2) {
                        e2.printStackTrace();
                    }
                }
            }
        }
        annotGenerator = CvPropertiesManager.getProperty(id + ".generator", "com.ge.med.cse.cvf.annotation.MRCT3DApdAnnotationConfig$J3DAnnotationGenerator");
    }

    @Override
    public void setVolume(XjVolumeInfo volume) {
        if (this.getCine()) {
            return;
        }
        if (volume == null) {
            int layer;
            T3DComponent fcCap = this.getT3DComponent();
            for (int i2 = layer = fcCap.getNumVolumeLayers(); i2 >= 0; --i2) {
                fcCap.removeVolumeLayer(i2);
            }
        }
        super.setVolume(volume);
        this.setViewType(this.currentView.getName());
        if (volume != null) {
            this.setInitialWindowing();
            this.clearallGraphcs();
        }
        this.fireVolumeLoadedProperty();
        this.repaint();
    }

    private void clearallGraphcs() {
        List lst = this.getRois();
        ListIterator it = lst.listIterator();
        while (it.hasNext()) {
            RoiActor actor = (RoiActor)it.next();
            it.remove();
            this.remove(actor);
        }
        List ualist = this.getUserAnnos();
        ListIterator it2 = ualist.listIterator();
        while (it2.hasNext()) {
            XpUserAnnotationModel model = (XpUserAnnotationModel)it2.next();
            it2.remove();
            this.remove(model);
        }
    }

    @Override
    public void setVolumeModel(XjVolumeModel vm) {
        if (this.getCine()) {
            return;
        }
        if (vm == null) {
            int layer;
            T3DComponent fcCap = this.getT3DComponent();
            for (int i2 = layer = fcCap.getNumVolumeLayers(); i2 >= 0; --i2) {
                fcCap.removeVolumeLayer(i2);
            }
        }
        super.setVolumeModel(vm);
        this.setViewType(this.currentView.getName());
        if (vm != null) {
            XjVolumeInfo vol = vm.getVolume();
            if (vm.getVolume() instanceof DynamicVolume) {
                final DynamicVolume dvol = (DynamicVolume)vm.getVolume();
                dvol.addPropertyChangeListener("LOADING_COMPLETE", new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent evt) {
                        J3DViewport.this.setInitialWindowing();
                        dvol.removePropertyChangeListener(this);
                    }
                });
            }
            this.setInitialWindowing();
            this.clearallGraphcs();
        }
        this.fireVolumeLoadedProperty();
        this.repaint();
    }

    private void fireVolumeLoadedProperty() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                J3DViewport.this.firePropertyChange("VOLUME_PROPERTY", null, J3DViewport.this.getVolumeModel());
            }
        });
    }

    protected void showOrientationCube() {
        Component[] comps = this.getT3DComponent().getComponents();
        JComponent orienVc = null;
        for (int i2 = 0; i2 < comps.length; ++i2) {
            if (!(comps[i2] instanceof OrientationCubeVc)) continue;
            orienVc = (OrientationCubeVc)comps[i2];
            break;
        }
        if (orienVc == null) {
            orienVc = new OrientationCubeVc(this);
            this.getT3DComponent().add(orienVc);
        } else {
            orienVc.setVisible(true);
        }
        ((OrientationCubeVc)orienVc).setTrackballEnabled(this.currentView.isObliqueControllable());
        this.repaint();
        this.validate();
    }

    @Override
    public boolean isSelected() {
        return this.selected_;
    }

    @Override
    public void setSelected(boolean selection) {
        boolean old = this.selected_;
        this.selected_ = selection;
        this.firePropertyChange("COMPONENT_SELECTED", old, this.selected_);
    }

    @Override
    public void setSelectionListener(XpSelection.SelectionListener selectionListener) {
        MouseListener selLsnr = this.getSelectionListener();
        if (selLsnr != null) {
            this.detachSelectionListener(selLsnr);
            if (selectionListener instanceof XpSelection.SelectionListener) {
                selectionListener.setTarget(null);
            }
        }
        this.selectionLsnr = selectionListener;
        if (selectionListener != null) {
            selectionListener.setTarget(this);
            this.attachSelectionListener(this.selectionLsnr);
        }
    }

    @Override
    public MouseListener getSelectionListener() {
        if (this.selectionLsnr == null) {
            return this.defaultSelectionLsnr;
        }
        return this.selectionLsnr;
    }

    private void attachSelectionListener(MouseListener lsnr) {
        this.getT3DComponent().addMouseListener(lsnr);
        this.getAnnotationVc().addMouseListener(lsnr);
        Component[] comps = this.getT3DComponent().getComponents();
        for (int i2 = 0; i2 < comps.length; ++i2) {
            comps[i2].addMouseListener(lsnr);
        }
        this.getT3DComponent().addContainerListener(this.clstr);
    }

    private void detachSelectionListener(MouseListener lsnr) {
        this.getT3DComponent().removeMouseListener(lsnr);
        this.getAnnotationVc().removeMouseListener(lsnr);
        Component[] comps = this.getT3DComponent().getComponents();
        for (int i2 = 0; i2 < comps.length; ++i2) {
            comps[i2].removeMouseListener(lsnr);
        }
        this.getT3DComponent().removeContainerListener(this.clstr);
    }

    @Override
    public void setLookPoint(double[] point) {
        if (this.getCine()) {
            return;
        }
        super.setLookPoint(point);
    }

    @Override
    public void setEyePoint(double[] point) {
        if (this.getCine()) {
            return;
        }
        super.setEyePoint(point);
    }

    @Override
    public void setUp(double[] vec) {
        if (this.getCine()) {
            return;
        }
        super.setUp(vec);
    }

    @Override
    public void setCamera(double[] eyepoint, double[] lookpoint, double[] up) {
        if (this.getCine()) {
            return;
        }
        super.setCamera(eyepoint, lookpoint, up);
    }

    @Override
    public void setViewClip(double[] clipOffsets) {
        if (this.getCine()) {
            return;
        }
        Fusion3DCapable fusionCap = (Fusion3DCapable)this.getCapable(Fusion3DCapable.class.getName());
        if (fusionCap != null && fusionCap.getNumVolumeLayers() > 1) {
            clipOffsets[0] = 0.0;
            clipOffsets[1] = 0.0;
        }
        super.setViewClip(clipOffsets);
    }

    @Override
    public void setViewHeight(double height) {
        if (this.getCine() && !this.cinePaused) {
            return;
        }
        double minFactor = Double.parseDouble(CvPropertiesManager.getProperty("cvf.j3d.minzoom", "0.1"));
        double maxFactor = Double.parseDouble(CvPropertiesManager.getProperty("cvf.j3d.maxzoom", "2.0"));
        double[] ulc = new double[3];
        double[] xside = new double[3];
        double[] yside = new double[3];
        double[] zside = new double[3];
        this.getWorldBounds(ulc, xside, yside, zside);
        double defdfov = J3DGeomUtils.getDefaultDFOV(ulc, xside, yside, zside, this.getLookPoint(null), this.getUp(null), this.getEyePoint(null));
        if (height < defdfov * minFactor) {
            height = minFactor * defdfov;
        } else if (height > defdfov * maxFactor) {
            height = maxFactor * defdfov;
        }
        super.setViewHeight(height);
    }

    @Override
    public int getNumFrames() {
        return this.viewCalculator != null ? this.viewCalculator.getNumFrames() : 0;
    }

    @Override
    public void setFrameIndex(int index) {
        if (this.getCine() && !this.isPaused()) {
            return;
        }
        if (this.currentView != null && this.currentView.is3DViewType()) {
            return;
        }
        this.setViewIndex(index);
    }

    @Override
    public int getFrameIndex() {
        return this.viewCalculator != null ? this.viewCalculator.getFrameIndex() : -1;
    }

    public ViewCalculator getViewCalculator() {
        return this.viewCalculator;
    }

    private void setViewIndex(int index) {
        if (this.viewCalculator == null) {
            return;
        }
        this.viewCalculator.setFrameIndex(index);
        this.refreshContents();
        if (!this.getT3DComponent().isRenderFinal()) {
            this.getT3DComponent().waitForIRE();
        }
    }

    @Override
    public void setSupportedViewTypes(String[] viewTypes) {
        ArrayList<String> list = new ArrayList<String>();
        for (String viewType : viewTypes) {
            if (!supportedViews.containsKey(viewType)) continue;
            list.add(viewType);
        }
        this.supportedViewTypes = list.toArray(new String[list.size()]);
    }

    @Override
    public String[] getSupportedViewTypes() {
        return this.supportedViewTypes;
    }

    @Override
    public void setViewType(String view) {
        if (this.getCine()) {
            return;
        }
        if (view == null || this.getViewType(view) == null) {
            return;
        }
        if (this.isViewTypeLocked()) {
            return;
        }
        if (this.currentView != null && this.currentView.getName().equals(view)) {
            this.currentView.reset();
            if (this.viewCalculator != null) {
                this.viewCalculator.setVolume(this.getVolume());
            }
            return;
        }
        String oldView = null;
        if (this.currentView != null) {
            oldView = this.currentView.getName();
            this.currentView.setPort(null);
        }
        this.currentView = this.getViewType(view);
        this.currentView.setPort(this);
        Component[] comps = this.getT3DComponent().getComponents();
        OrientationCubeVc orienVc = null;
        for (int i2 = 0; i2 < comps.length; ++i2) {
            if (!(comps[i2] instanceof OrientationCubeVc)) continue;
            orienVc = (OrientationCubeVc)comps[i2];
            break;
        }
        if (orienVc != null) {
            orienVc.setTrackballEnabled(this.currentView.isObliqueControllable());
        }
        if (this.viewCalculator != null) {
            this.viewCalculator.removePropertyChangeListener("FrameIndex", this.frameIndexListner);
            this.viewCalculator.setVolume(null);
        }
        this.viewCalculator = this.currentView.getViewCalculator();
        if (this.viewCalculator == null) {
            this.viewCalculator = new J3DDefaultPagingViewCalculator(this.getT3DComponent());
        }
        this.viewCalculator.addPropertyChangeListener("FrameIndex", this.frameIndexListner);
        this.viewCalculator.setT3DCapable(this.getT3DComponent());
        this.viewCalculator.setVolume(this.getVolume());
        this.firePropertyChange("viewType", oldView, view);
    }

    @Override
    public String getViewType() {
        return this.currentView != null ? this.currentView.getName() : null;
    }

    @Override
    public ViewTypeCapable.ViewTypeActor getViewType(String viewType) {
        ViewTypeCapable.ViewTypeActor vta = null;
        for (String view : this.views.keySet()) {
            ViewTypeCapable.ViewTypeActor v2;
            vta = this.views.get(view);
            if (view.equals(viewType)) {
                return vta;
            }
            if (vta == null || vta.getSubViewTypes() == null || (v2 = vta.getViewType(viewType)) == null) continue;
            return v2;
        }
        return null;
    }

    @Override
    public void lockViewType(boolean vlock) {
        this.vtypelock = vlock;
    }

    @Override
    public boolean isViewTypeLocked() {
        return this.vtypelock;
    }

    private ViewTypeCapable.ViewTypeActor createView(String view) {
        String name = supportedViews.get(view);
        if (name != null) {
            try {
                Class<?> c2 = Class.forName(name, true, this.getClass().getClassLoader());
                return (ViewTypeCapable.ViewTypeActor)c2.newInstance();
            }
            catch (ClassNotFoundException e2) {
                e2.printStackTrace();
            }
            catch (InstantiationException e3) {
                e3.printStackTrace();
            }
            catch (IllegalAccessException e4) {
                e4.printStackTrace();
            }
        }
        return null;
    }

    @Override
    public void setCine(boolean cine) {
        boolean prevCine = this.getCine();
        if (!prevCine && cine) {
            this.setAutoRepaint(false);
        }
        if (!cine) {
            this.setAutoRepaint(true);
            this.repaint();
        }
        this.currentcine = cine;
        this.firePropertyChange("Cine", prevCine, cine);
    }

    @Override
    public boolean getCine() {
        return this.currentcine;
    }

    @Override
    public void setCineRate(int rate) {
        int oldRate = this.getCineRate();
        if (rate == oldRate) {
            return;
        }
        this.firePropertyChange("CineRate", oldRate, rate);
        this.currentrate = rate;
    }

    @Override
    public int getCineRate() {
        return this.currentrate;
    }

    @Override
    public void setOffset(int offset) {
        final int idx = offset;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                J3DViewport.this.setViewIndex(idx);
            }
        });
    }

    @Override
    public void setEndOffset(int offset) {
        int len = this.getMaxFrame();
        if (offset >= 0 && offset >= this.startOffset && offset < len) {
            this.endOffset = offset;
        }
    }

    @Override
    public int getEndOffset() {
        return this.endOffset;
    }

    @Override
    public void setStartOffset(int offset) {
        int len = this.getMaxFrame();
        if (offset >= 0 && offset <= this.endOffset && offset < len) {
            this.startOffset = offset;
        }
    }

    @Override
    public int getStartOffset() {
        return this.startOffset;
    }

    @Override
    public int getOffset() {
        return this.getFrameIndex();
    }

    @Override
    public int getMaxFrame() {
        return this.getNumFrames();
    }

    @Override
    public int getNumberShown() {
        return 1;
    }

    @Override
    public int getCineSkip() {
        return this.cineSkip;
    }

    @Override
    public void setCineSkip(int cineSkip) {
        this.cineSkip = cineSkip;
    }

    @Override
    public int getCineMode() {
        return this.cineMode;
    }

    @Override
    public void setCineMode(int cineMode) {
        if (cineMode != this.cineMode) {
            int old = this.cineMode;
            this.cineMode = cineMode;
            this.firePropertyChange("CineMode", old, cineMode);
        }
    }

    @Override
    public void pauseCine() {
        if (this.getCine() && !this.cinePaused) {
            this.cinePaused = true;
            this.setAutoRepaint(true);
            this.repaint();
        }
    }

    @Override
    public void resumeCine() {
        if (this.getCine() && this.cinePaused) {
            this.cinePaused = false;
            this.setAutoRepaint(false);
        }
    }

    @Override
    public boolean isPaused() {
        return this.getCine() && this.cinePaused;
    }

    @Override
    public void add(RoiActor ra) {
        if (this.getCine() && !this.cinePaused) {
            return;
        }
        String renderstyle = this.getRenderStyle();
        double[] clip = new double[2];
        this.getViewClip(clip);
        double thickness = Math.abs(clip[0] - clip[1]);
        double minThickness = Math.abs(J3DGeomUtils.getMinSliceThickness(this.getVolume(), this.getLookPoint(null), this.getEyePoint(null), this.currentView.isObliqueControllable()));
        boolean addRoi = thickness <= minThickness || renderstyle.startsWith("REFORMAT");
        boolean bl = addRoi = addRoi && !"FULLBODY_MIP".equals(renderstyle) && !"FULLBODY_AVERAGE".equals(renderstyle) && !"FULLBODY_MINIP".equals(renderstyle) && !"VOLUME".equals(renderstyle);
        if (addRoi) {
            System.out.println("roi added");
            XpImageRoiVc rvc = (XpImageRoiVc)this.getRoiMap().get(ra);
            super.add(ra);
            System.out.println(rvc + " " + ra.getImage());
        }
    }

    @Override
    public void setColorMap(int[] map) {
        if (this.getCine() && !this.cinePaused) {
            return;
        }
        super.setColorMap(map);
        this.auto_repaint();
    }

    @Override
    public void setWinMinMax(double min, double max) {
        super.setWinMinMax(min, max);
        this.auto_repaint();
    }

    @Override
    public final void addImageOp(XpImageOp imageOp) {
        if (this.getCine() && !this.cinePaused) {
            return;
        }
        XpImageRenderAttributes kir = this.getImageRenderAttributes();
        kir.addImageOperation(imageOp);
        this.setImageRenderAttributes(kir);
        if (this.isAutoRepaint()) {
            this.repaint();
        }
        this.firePropertyChange("IMAGEOP_ADDED", null, imageOp);
    }

    @Override
    public final List getImageOps() {
        XpImageRenderAttributes kir = this.getImageRenderAttributes();
        return kir.getImageOperations();
    }

    @Override
    public final void clearImageOps() {
        XpImageRenderAttributes kir = this.getImageRenderAttributes();
        kir.clearImageOperations();
        this.setImageRenderAttributes(kir);
        if (this.isAutoRepaint()) {
            this.repaint();
        }
        this.firePropertyChange("IMAGEOPS_CLEARED", null, this);
    }

    public final void setCapable(String capableName, Capable implementation) {
        this.capableImplementations.put(capableName, implementation);
    }

    public final void removeCapable(String capableName, Capable implementation) {
        Capable cap = this.capableImplementations.get(capableName);
        if (cap != null && cap.equals(implementation)) {
            this.capableImplementations.remove(capableName);
        }
    }

    @Override
    public Capable getCapable(String capableName) {
        if (this.capableImplementations != null && this.capableImplementations.containsKey(capableName)) {
            return this.capableImplementations.get(capableName);
        }
        return super.getCapable(capableName);
    }

    private void setInitialWindowing() {
        XjVolumeInfo volume = this.getVolume();
        if (volume == null) {
            return;
        }
        String mod = DicomUtils.getModality(volume);
        if (mod == null && this.getVolumeModel() instanceof J3DVolumeModel) {
            J3DVolumeModel vol = (J3DVolumeModel)this.getVolumeModel();
            this.setWindowing(vol.getJVolume().initWW, vol.getJVolume().initWL);
        } else if (volume instanceof XjDynamicVolume && volume instanceof DynamicVolume && !((DynamicVolume)volume).isLoadingComplete()) {
            if (!"PT".equalsIgnoreCase(mod)) {
                double ww = DicomUtils.getWindowWidth(volume);
                double wl = DicomUtils.getWindowLevel(volume);
                this.setWindowing(ww, wl);
            }
        } else if (this.getVolumeModel() instanceof J3DVolumeModel) {
            if ("CT".equalsIgnoreCase(mod)) {
                J3DVolumeModel vol = (J3DVolumeModel)this.getVolumeModel();
                this.setWindowing(vol.getJVolume().initWW, vol.getJVolume().initWL);
            } else {
                short[] minmax = this.getVolumeMinMax();
                double rescaleSlope = XjVolumeUtils.calcVolumeRescaleSlope(volume);
                double rescaleIntercept = XjVolumeUtils.calcVolumeRescaleIntercept(volume);
                if ("MR".equalsIgnoreCase(mod)) {
                    this.setWinMinMax(minmax[0], minmax[1]);
                } else if ("PT".equalsIgnoreCase(mod)) {
                    double finmax = (double)minmax[1] * rescaleSlope * 0.4 + rescaleIntercept;
                    double min = 0.0;
                    double ww = finmax - min;
                    double wl = (finmax + min) * 0.5;
                    this.setWindowing(ww, wl);
                }
            }
        }
    }

    private short[] getVolumeMinMax() {
        if (this.getVolumeModel() instanceof J3DVolumeModel) {
            J3DVolumeModel volModel = (J3DVolumeModel)this.getVolumeModel();
            short max = Short.MIN_VALUE;
            short min = Short.MAX_VALUE;
            Object objMax = volModel.getClientProperty("MAX_VOXEL_VALUE");
            Object objMin = volModel.getClientProperty("MIN_VOXEL_VALUE");
            if (objMax instanceof Short && objMin instanceof Short) {
                max = (Short)objMax;
                min = (Short)objMin;
            } else {
                Object voldata = volModel.getVolumeData();
                if (voldata instanceof short[][]) {
                    short[][] shortdata = (short[][])voldata;
                    for (int i2 = 0; i2 < shortdata.length; ++i2) {
                        for (int j2 = 0; j2 < shortdata[i2].length; ++j2) {
                            if (shortdata[i2][j2] > max) {
                                max = shortdata[i2][j2];
                            }
                            if (shortdata[i2][j2] >= min) continue;
                            min = shortdata[i2][j2];
                        }
                    }
                    volModel.putClientProperty("MAX_VOXEL_VALUE", new Short(max));
                    volModel.putClientProperty("MIN_VOXEL_VALUE", new Short(min));
                } else if (voldata instanceof byte[][]) {
                    byte[][] bytdata = (byte[][])voldata;
                    for (int i3 = 0; i3 < bytdata.length; ++i3) {
                        for (int j3 = 0; j3 < bytdata[i3].length; ++j3) {
                            if (bytdata[i3][j3] > max) {
                                max = bytdata[i3][j3];
                            }
                            if (bytdata[i3][j3] >= min) continue;
                            min = bytdata[i3][j3];
                        }
                    }
                    volModel.putClientProperty("MAX_VOXEL_VALUE", new Short(max));
                    volModel.putClientProperty("MIN_VOXEL_VALUE", new Short(min));
                }
            }
            return new short[]{min, max};
        }
        return null;
    }

    @Override
    public void resetWindowing() {
        this.setInitialWindowing();
        XjVolumeModel model = this.getVolumeModel();
        String mod = DicomUtils.getModality(this.getVolume());
        if (model != null && "PT".equalsIgnoreCase(mod)) {
            if (!(model instanceof J3DVolumeModel)) {
                this.getT3DComponent().resetWindowing();
                double min = this.getT3DComponent().getWinMin();
                if (min < 0.0) {
                    this.getT3DComponent().setWinMin(0.0);
                }
            }
            this.setVideoInverted(true);
        }
    }

    @Override
    public void addTickMark(int orientation) {
        XpMedicalImage img = (XpMedicalImage)this.getFrame();
        if ("SSAVE".equals(DicomUtils.getImageType(img, false))) {
            return;
        }
        if (orientation == 1) {
            this.addHorTickMark();
        } else {
            this.addVerTickMark();
        }
        this.firePropertyChange("tick_mark_added_property", -1, orientation);
    }

    @Override
    public void removeTickMark(int orientation) {
        if (orientation == 1) {
            this.horTickMarkComp.setVisible(false);
        } else {
            this.verTickMarkComp.setVisible(false);
        }
        this.firePropertyChange("tick_mark_removed_property", -1, orientation);
    }

    private void addVerTickMark() {
        if (this.verTickMarkComp == null) {
            this.verTickMarkComp = new J3DTickMarkRuler(0);
            this.getT3DComponent().add(this.verTickMarkComp);
        }
        this.verTickMarkComp.setVisible(true);
        this.repaint();
        this.updateUI();
    }

    private void addHorTickMark() {
        if (this.horTickMarkComp == null) {
            this.horTickMarkComp = new J3DTickMarkRuler(1);
            this.getT3DComponent().add(this.horTickMarkComp);
        }
        this.horTickMarkComp.setVisible(true);
        this.repaint();
        this.updateUI();
    }

    public void setRotationAllowed(boolean rotate) {
        this.rotate = rotate;
    }

    public boolean getRotationAllowed() {
        return this.rotate;
    }

    @Override
    public XjDicomObject getDicomObject() {
        return this.getVolume();
    }

    @Override
    public void add(XpUserAnnotationModel m2) {
        if (this.getCine() && !this.cinePaused) {
            return;
        }
        super.add(m2);
    }

    static {
        J3DViewport.configureAnnotations();
        supportedViews.put("AXIAL", "com.ge.med.cse.cvf.j3d.OrthogonalViewType$AxialViewType");
        supportedViews.put("CORONAL", "com.ge.med.cse.cvf.j3d.OrthogonalViewType$CoronalViewType");
        supportedViews.put("SAGITTAL", "com.ge.med.cse.cvf.j3d.OrthogonalViewType$SagittalViewType");
        supportedViews.put("OBLIQUE", "com.ge.med.cse.cvf.j3d.ObliqueViewType");
        supportedViews.put("3D", "com.ge.med.cse.cvf.j3d.ThreeDViewType");
    }

    private static class CineController
    implements MouseListener {
        private J3DViewport _target;

        public CineController(J3DViewport target) {
            this._target = target;
        }

        @Override
        public void mouseClicked(MouseEvent e2) {
            this._target.setSelected(true);
        }

        @Override
        public void mouseEntered(MouseEvent e2) {
        }

        @Override
        public void mouseExited(MouseEvent e2) {
        }

        @Override
        public void mousePressed(MouseEvent e2) {
            if (this._target.getCine() && !this._target.isPaused()) {
                Container c2 = SwingUtilities.getAncestorOfClass(XPscreen.class, this._target);
                if (c2 != null && c2 instanceof XpCineCapable) {
                    ((XpCineCapable)((Object)c2)).pauseCine();
                } else {
                    this._target.pauseCine();
                }
            }
        }

        @Override
        public void mouseReleased(MouseEvent e2) {
            if (this._target.getCine() && this._target.isPaused()) {
                Container c2 = SwingUtilities.getAncestorOfClass(XPscreen.class, this._target);
                if (c2 != null && c2 instanceof XpCineCapable) {
                    ((XpCineCapable)((Object)c2)).resumeCine();
                } else {
                    this._target.resumeCine();
                }
            }
        }
    }

    private static class J3DComponent
    extends T3DComponent {
        private static final String noImageMessage = XpPropertiesManager.getProperty("jami.noimage.message");
        private static final String emptyFontName = XpPropertiesManager.getProperty("jami.noimage.fontname", "Monospaced");
        private static final int emptyFontSize = Integer.parseInt(XpPropertiesManager.getProperty("jami.noimage.fontsize", "16"));
        private static final Font emptyMsgFont = new Font(emptyFontName, 3, emptyFontSize);

        public J3DComponent() {
        }

        public J3DComponent(T3DRenderEngine engine) {
            super(engine);
        }

        private void paintEmptyMessage(Graphics g2) {
            if (noImageMessage != null) {
                g2.setColor(Color.WHITE);
                g2.setFont(emptyMsgFont);
                FontMetrics fntMetrics = g2.getFontMetrics();
                int iStrWidth = fntMetrics.stringWidth(noImageMessage);
                int iStartPos = this.getWidth() / 2 - iStrWidth / 2;
                if (iStartPos < 1) {
                    iStartPos = 1;
                }
                g2.drawString(noImageMessage, iStartPos, this.getHeight() / 2);
            }
        }

        @Override
        public void paintComponent(Graphics g2) {
            if (!this.isT3DReady() || this.getVolume() == null) {
                g2.setColor(this.getBackground());
                g2.fillRect(this.getX(), this.getY(), this.getWidth(), this.getHeight());
                this.paintEmptyMessage(g2);
                return;
            }
            super.paintComponent(g2);
        }
    }
}

