/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.j3d;

import com.ge.med.cse.cvf.idc.ViewTypeCapable;
import com.ge.med.cse.cvf.j3d.AbstractViewType;
import com.ge.med.cse.cvf.j3d.J3DRotateViewCalculator;
import com.ge.med.cse.cvf.j3d.ViewCalculator;
import com.ge.med.cse.cvf.util.CvUtils;
import com.ge.med.jnu.JnVector3d;

public class ThreeDViewType
extends AbstractViewType {
    private String name = "3D";
    private ViewCalculator viewCalculator = null;

    @Override
    protected void syncPort() {
        if (this.t3dport == null) {
            return;
        }
        this.reset();
        this.showTrackBall();
        this.t3dport.setMouseController(this.mouseController);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isObliqueControllable() {
        return true;
    }

    @Override
    public boolean is3DViewType() {
        return true;
    }

    @Override
    public boolean isVolumeLayersAllowed() {
        return false;
    }

    @Override
    public void reset() {
        if (this.t3dport == null) {
            return;
        }
        if (!(this.t3dport.getRenderStyle().equals(CvUtils.getT3DRenderStyle("FULLBODY_MINIP")) || this.t3dport.getRenderStyle().equals(CvUtils.getT3DRenderStyle("FULLBODY_MIP")) || this.t3dport.getRenderStyle().equals(CvUtils.getT3DRenderStyle("FULLBODY_AVERAGE")))) {
            CvUtils.setT3DRenderStyle(this.t3dport, "FULLBODY_MIP");
        }
        this.setCamera();
        super.reset();
    }

    @Override
    public ViewCalculator getViewCalculator() {
        if (this.viewCalculator == null) {
            this.viewCalculator = new J3DRotateViewCalculator();
        }
        return this.viewCalculator;
    }

    @Override
    public String[] getSubViewTypes() {
        return null;
    }

    @Override
    public ViewTypeCapable.ViewTypeActor getViewType(String viewType) {
        return null;
    }

    private void setCamera() {
        if (this.t3dport != null && this.t3dport.getVolume() != null) {
            double[] ulc = new double[3];
            double[] xside = new double[3];
            double[] yside = new double[3];
            double[] zside = new double[3];
            this.t3dport.getWorldBounds(ulc, xside, yside, zside);
            JnVector3d viewvctr = new JnVector3d();
            viewvctr.sub(this.t3dport.getLookPoint(null), this.t3dport.getEyePoint(null));
            JnVector3d look = new JnVector3d(ulc);
            JnVector3d eye = new JnVector3d();
            look.scaleAdd(0.5, xside);
            look.scaleAdd(0.5, yside);
            look.scaleAdd(0.5, zside);
            eye.sub(look, viewvctr);
            this.t3dport.setCamera(eye.toArray(), look.toArray(), this.t3dport.getUp(null));
        }
    }
}

