/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.j3d.action;

import com.ge.med.cse.cvf.base.BaseAction;
import com.ge.med.cse.cvf.idc.ViewTypeCapable;
import com.ge.med.cse.cvf.j3d.AbstractViewType;
import com.ge.med.cse.cvf.j3d.J3DViewport;
import com.ge.med.idc.Capable;
import com.ge.med.idc.Selectable;
import com.ge.med.terra.jami.XpViewport;
import com.ge.med.terra.jami.j3d.CubeTrackball;
import com.ge.med.terra.jami.j3d.T3DViewport;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.logging.Level;

public class J3DShowHideCubeTrackballAction
extends BaseAction {
    protected static final String showActionName = "J3D_SHOW_CUBETB";
    protected static final String hideActionName = "J3D_HIDE_CUBETB";
    protected static String actionName = "J3D_HIDE_CUBETB";
    protected boolean showCubeTrackball = true;
    PropertyChangeListener selListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            ViewTypeCapable ctCap;
            ViewTypeCapable.ViewTypeActor vtActor;
            if (evt.getNewValue().toString().equals("true") && evt.getSource() instanceof J3DViewport && evt.getSource() instanceof ViewTypeCapable && (vtActor = (ctCap = (ViewTypeCapable)((Capable)evt.getSource()).getCapable(ViewTypeCapable.class.getName())).getViewType(ctCap.getViewType())).isObliqueControllable()) {
                J3DShowHideCubeTrackballAction.this.reConfigure(J3DShowHideCubeTrackballAction.this.isTrackBallVisible((J3DViewport)evt.getSource()));
            }
        }
    };

    @Override
    protected String getName() {
        return actionName;
    }

    @Override
    public void actionPerformed(ActionEvent e2) {
        try {
            ViewTypeCapable ctCap;
            ViewTypeCapable.ViewTypeActor vtActor;
            XpViewport port = this.findSelectedViewportByClass(T3DViewport.class);
            if (port instanceof ViewTypeCapable && (vtActor = (ctCap = (ViewTypeCapable)port.getCapable(ViewTypeCapable.class.getName())).getViewType(ctCap.getViewType())).isObliqueControllable() && vtActor instanceof AbstractViewType) {
                AbstractViewType obType = (AbstractViewType)vtActor;
                if (!this.showCubeTrackball) {
                    obType.hideTrackBall();
                    this.reConfigure(false);
                } else {
                    obType.showTrackBall();
                    this.reConfigure(true);
                }
            }
        }
        catch (Exception exp) {
            this.getLogger().log(Level.WARNING, "Exception during show/hide orientation cube, stack trace {0}", new Object[]{exp});
        }
    }

    @Override
    public void setCapable(Capable cap) {
        super.setCapable(cap);
        XpViewport[] port = this.findViewportsByClass(T3DViewport.class);
        if (port != null) {
            for (int i2 = 0; i2 < port.length; ++i2) {
                if (!(port[i2] instanceof J3DViewport)) continue;
                Selectable selectable = (Selectable)((Object)port[i2].getCapable(Selectable.class.getName()));
                selectable.addPropertyChangeListener("COMPONENT_SELECTED", this.selListener);
            }
        }
    }

    private boolean isTrackBallVisible(J3DViewport t3dport) {
        if (t3dport == null) {
            return false;
        }
        Component[] comps = t3dport.getT3DComponent().getComponents();
        Component trackBall = null;
        for (int i2 = 0; i2 < comps.length; ++i2) {
            if (!(comps[i2] instanceof CubeTrackball)) continue;
            trackBall = (CubeTrackball)comps[i2];
            break;
        }
        if (trackBall == null) {
            return false;
        }
        return trackBall.isVisible();
    }

    protected void reConfigure(boolean bol) {
        this.showCubeTrackball = !bol;
        actionName = bol ? hideActionName : showActionName;
        super.configure();
    }
}

