/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.j3d.ui;

import com.ge.med.cse.cvf.j3d.ui.J3DThickScrollBar;
import com.ge.med.ptk.laf.CuiScrollBarUI;
import com.ge.med.terra.xpv.util.XPutil;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import javax.imageio.ImageIO;
import javax.swing.BoundedRangeModel;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.basic.BasicScrollBarUI;
import sun.swing.DefaultLookup;

public class J3DThickScrollBarUI
extends CuiScrollBarUI {
    protected static BufferedImage centerImage = null;
    protected static BufferedImage minBoundImage = null;
    protected static BufferedImage maxBoundImage = null;
    protected static BufferedImage markerImage = null;
    protected static final int boundCenterOverlap = 2;
    protected static final int verticalBorderGap = 1;
    protected static final int horizontalBorderGap = 1;
    protected static final int trackBorderWidth = 1;
    protected static final int trackBevelWidth = 2;
    protected static final String trackBorderColor = "P9";
    protected static final String trackBevelColor1 = "P10";
    protected static final String trackBevelColor2 = "P8";
    protected static final String trackInteriorColor1 = "P9";
    protected static final String trackInteriorColor2 = "P10";
    protected static final int frameMarkerWidth = 8;
    protected static final int frameMarkerHeight = 2;
    protected static final int frameMarkerStartX = 5;
    protected static final int centerWidth;
    protected static final int centerHeight;
    protected static final int halfCenterHeight;
    protected static final int boundHeight;
    protected static final int displayWidth;
    protected static final int totalCoreHeight;
    protected static final int halfTotalCoreHeight;
    private static final ImageIcon thicknessCursorIcon;
    public static final Cursor THICK_CURSOR;
    private static final ImageIcon sliceCursorIcon;
    private static final Cursor SLICE_CURSOR;
    protected Rectangle minThickRect = new Rectangle();
    protected Rectangle maxThickRect = new Rectangle();
    protected double[] markerLocations = null;
    protected ArrayList<Rectangle> markers = new ArrayList();
    boolean minThickRollover = false;
    boolean maxThickRollover = false;
    private boolean useCachedValue = false;
    private int scrollBarValue;

    @Override
    protected void paintThumb(Graphics g2, JComponent c2, Rectangle thumbBounds) {
        if (!c2.isEnabled()) {
            return;
        }
        g2.drawImage(centerImage, thumbBounds.x, thumbBounds.y, (int)thumbBounds.getWidth(), (int)thumbBounds.getHeight(), null);
    }

    protected void paintMinThick(Graphics g2, JComponent c2, Rectangle minThickBounds) {
        if (!c2.isEnabled()) {
            return;
        }
        g2.drawImage(minBoundImage, minThickBounds.x, minThickBounds.y, (int)minThickBounds.getWidth(), (int)minThickBounds.getHeight(), null);
    }

    protected void paintMaxThick(Graphics g2, JComponent c2, Rectangle maxThickBounds) {
        if (!c2.isEnabled()) {
            return;
        }
        g2.drawImage(maxBoundImage, maxThickBounds.x, maxThickBounds.y, (int)maxThickBounds.getWidth(), (int)maxThickBounds.getHeight(), null);
    }

    protected void fillThickArea(Graphics g2, JComponent c2, Rectangle minThickBounds, Rectangle maxThickBounds) {
        if (!c2.isEnabled()) {
            return;
        }
        Color color = g2.getColor();
        g2.setColor(UIManager.getColor("P10"));
        g2.fillRect(minThickBounds.x, minThickBounds.y, (int)minThickBounds.getWidth(), maxThickBounds.y - minThickBounds.y + (int)maxThickBounds.getHeight());
        g2.setColor(color);
    }

    @Override
    public void paint(Graphics g2, JComponent c2) {
        if (!c2.isEnabled() || !c2.isVisible()) {
            return;
        }
        this.paintTrack(g2, c2, this.getTrackBounds());
        Rectangle thumbBounds = this.getThumbBounds();
        Rectangle minThickBounds = this.getMinThickBounds();
        Rectangle maxThickBounds = this.getMaxThickBounds();
        this.fillThickArea(g2, c2, minThickBounds, maxThickBounds);
        int len = this.markers.size();
        Color color = g2.getColor();
        g2.setColor(Color.RED);
        for (int i2 = 0; i2 < len; ++i2) {
            Rectangle marker = this.markers.get(i2);
            if (!marker.intersects(g2.getClipBounds())) continue;
            g2.drawImage(markerImage, marker.x, marker.y, (int)marker.getWidth(), (int)marker.getHeight(), null);
        }
        g2.setColor(color);
        if (thumbBounds.intersects(g2.getClipBounds())) {
            this.paintThumb(g2, c2, thumbBounds);
        }
        if (minThickBounds.intersects(g2.getClipBounds())) {
            this.paintMinThick(g2, c2, minThickBounds);
        }
        if (maxThickBounds.intersects(g2.getClipBounds())) {
            this.paintMaxThick(g2, c2, maxThickBounds);
        }
    }

    protected Rectangle getMinThickBounds() {
        Rectangle r2 = new Rectangle(this.minThickRect);
        return r2;
    }

    protected Rectangle getMaxThickBounds() {
        Rectangle r2 = new Rectangle(this.maxThickRect);
        return r2;
    }

    protected void setMinThickBounds(int x2, int y2, int width, int height) {
        if (this.minThickRect.x == x2 && this.minThickRect.y == y2 && this.minThickRect.width == width && this.minThickRect.height == height) {
            return;
        }
        width = minBoundImage.getWidth();
        height = minBoundImage.getHeight();
        int minX = Math.min(x2, this.minThickRect.x);
        int minY = Math.min(y2, this.minThickRect.y);
        int maxX = Math.max(x2 + width, this.minThickRect.x + this.minThickRect.width);
        int maxY = Math.max(y2 + height, this.minThickRect.y + this.minThickRect.height);
        this.minThickRect.setBounds(x2, y2, width, height);
        this.scrollbar.repaint(minX, minY, maxX - minX, maxY - minY);
    }

    protected void setMaxThickBounds(int x2, int y2, int width, int height) {
        if (this.maxThickRect.x == x2 && this.maxThickRect.y == y2 && this.maxThickRect.width == width && this.maxThickRect.height == height) {
            return;
        }
        width = maxBoundImage.getWidth();
        height = maxBoundImage.getHeight();
        int minX = Math.min(x2, this.maxThickRect.x);
        int minY = Math.min(y2, this.maxThickRect.y);
        int maxX = Math.max(x2 + width, this.maxThickRect.x + this.maxThickRect.width);
        int maxY = Math.max(y2 + height, this.maxThickRect.y + this.maxThickRect.height);
        this.maxThickRect.setBounds(x2, y2, width, height);
        this.scrollbar.repaint(minX, minY, maxX - minX, maxY - minY);
    }

    protected void setMarkerBounds(int i2, int x2, int y2, int width, int height) {
        boolean exists = false;
        Rectangle r2 = null;
        if (this.markers.size() > i2) {
            r2 = this.markers.get(i2);
            exists = true;
            if (r2.x == x2 && r2.y == y2 && r2.width == width && r2.height == height) {
                return;
            }
        } else {
            r2 = new Rectangle();
            this.markers.add(i2, r2);
        }
        width = markerImage.getWidth();
        height = markerImage.getHeight();
        int minX = Math.min(x2, r2.x);
        int minY = Math.min(y2, r2.y);
        int maxX = Math.max(x2 + width, r2.x + r2.width);
        int maxY = Math.max(y2 + height, r2.y + r2.height);
        r2.setBounds(x2, y2, width, height);
        this.scrollbar.repaint(minX, minY, maxX - minX, maxY - minY);
    }

    protected boolean getMinThickBoundsRollover() {
        return this.minThickRollover;
    }

    protected boolean getMaxThickBoundsRollover() {
        return this.maxThickRollover;
    }

    protected void setMinThickBoundsRollover(boolean b2) {
        this.minThickRollover = b2;
    }

    protected void setMaxThickBoundsRollover(boolean b2) {
        this.maxThickRollover = b2;
    }

    private void updateMinThickBoundState(int x2, int y2) {
        Rectangle rect = this.getMinThickBounds();
        this.setMinThickBoundsRollover(rect.contains(x2, y2));
    }

    private void updateMaxThickBoundState(int x2, int y2) {
        Rectangle rect = this.getMaxThickBounds();
        this.setMaxThickBoundsRollover(rect.contains(x2, y2));
    }

    private void updateThumbState(int x2, int y2) {
        Rectangle rect = this.getThumbBounds();
        this.setThumbRollover(rect.contains(x2, y2));
    }

    private int getThumbValue(JScrollBar sb) {
        return sb.getValue();
    }

    private double getThicknessValue(JScrollBar sb) {
        if (!(sb instanceof J3DThickScrollBar)) {
            return 0.0;
        }
        return ((J3DThickScrollBar)sb).getThickness();
    }

    private double getMaxThicknessValue(JScrollBar sb) {
        if (!(sb instanceof J3DThickScrollBar)) {
            return 0.0;
        }
        return ((J3DThickScrollBar)sb).getMaxThickness();
    }

    private double[] getMarkerValues(JScrollBar sb) {
        if (!(sb instanceof J3DThickScrollBar)) {
            return null;
        }
        return ((J3DThickScrollBar)sb).getMarkerIndices();
    }

    @Override
    protected void layoutVScrollbar(JScrollBar sb) {
        if (!(sb instanceof J3DThickScrollBar)) {
            super.layoutVScrollbar(sb);
            return;
        }
        Dimension sbSize = sb.getSize();
        Insets sbInsets = sb.getInsets();
        int itemW = sbSize.width - (sbInsets.left + sbInsets.right);
        int itemX = sbInsets.left;
        boolean squareButtons = DefaultLookup.getBoolean(this.scrollbar, this, "ScrollBar.squareButtons", false);
        int decrButtonH = squareButtons ? itemW : this.decrButton.getPreferredSize().height;
        int decrButtonY = sbInsets.top;
        int incrButtonH = squareButtons ? itemW : this.incrButton.getPreferredSize().height;
        int incrButtonY = sbSize.height - (sbInsets.bottom + incrButtonH);
        int sbInsetsH = sbInsets.top + sbInsets.bottom;
        int sbButtonsH = decrButtonH + incrButtonH;
        float trackH = sbSize.height - (sbInsetsH + sbButtonsH);
        int sbAvailButtonH = sbSize.height - sbInsetsH;
        if (sbAvailButtonH < sbButtonsH) {
            incrButtonH = decrButtonH = sbAvailButtonH / 2;
            incrButtonY = sbSize.height - (sbInsets.bottom + incrButtonH);
        }
        this.decrButton.setBounds(itemX, decrButtonY, itemW, decrButtonH);
        this.incrButton.setBounds(itemX, incrButtonY, itemW, incrButtonH);
        int itrackY = decrButtonY + decrButtonH;
        int itrackH = incrButtonY - itrackY;
        this.trackRect.setBounds(itemX, itrackY, itemW, itrackH);
        float min = sb.getMinimum();
        float extent = sb.getVisibleAmount();
        float range = (float)sb.getMaximum() - min;
        float value = this.getThumbValue(sb);
        int thumbY = incrButtonY - centerHeight - boundHeight + 2;
        if (value < (float)(sb.getMaximum() - sb.getVisibleAmount())) {
            float thumbRange = trackH - (float)centerHeight - (float)boundHeight - (float)boundHeight + 4.0f;
            thumbY = (int)(0.5f + thumbRange * ((value - min) / (range - extent)));
            thumbY += decrButtonY + decrButtonH + boundHeight - 2;
        }
        int minThickY = 0;
        int maxThickY = 0;
        if (sb instanceof J3DThickScrollBar) {
            double thickness = this.getThicknessValue(sb);
            double maxThickness = this.getMaxThicknessValue(sb);
            double centerPoint = (double)thumbY + 0.5 * (double)centerHeight;
            double thicknessRange = 2.0 * maxThickness / (double)(trackH - (float)centerHeight - (float)(2 * boundHeight) + 4.0f);
            double thicknessDelta = thickness / thicknessRange + 0.5 * (double)centerHeight + (double)boundHeight - 2.0;
            minThickY = (int)(0.5 + centerPoint - thicknessDelta);
            maxThickY = (int)(0.5 + centerPoint + thicknessDelta - (double)boundHeight);
            if (minThickY < this.trackRect.y) {
                minThickY = this.trackRect.y;
            }
            if (maxThickY > this.trackRect.y + this.trackRect.height - boundHeight) {
                maxThickY = this.trackRect.y + this.trackRect.height - boundHeight;
            }
        }
        int markerHeight = markerImage.getHeight();
        this.markers.clear();
        this.markerLocations = this.getMarkerValues(sb);
        if (this.markerLocations != null) {
            for (int i2 = 0; i2 < this.markerLocations.length; ++i2) {
                float trackRange = trackH - (float)centerHeight - (float)boundHeight - (float)boundHeight + 4.0f;
                int markerY = (int)(-0.5 * (double)markerHeight + (double)boundHeight + (double)centerHeight + (0.5 + (double)trackRange * ((this.markerLocations[i2] - (double)min) / (double)(range - extent))));
                this.setMarkerBounds(i2, itemX, markerY, itemW, markerHeight);
            }
        }
        if (centerHeight >= (int)trackH) {
            this.setThumbBounds(0, 0, 0, 0);
        } else {
            if (thumbY + centerHeight > incrButtonY) {
                thumbY = incrButtonY - centerHeight;
            }
            if (thumbY < decrButtonY + decrButtonH) {
                thumbY = decrButtonY + decrButtonH + 1;
            }
            this.setThumbBounds(itemX, thumbY, itemW, centerHeight);
        }
        if (sb instanceof J3DThickScrollBar) {
            if (boundHeight >= (int)trackH) {
                this.setMinThickBounds(0, 0, 0, 0);
            } else {
                if (minThickY + boundHeight > incrButtonY) {
                    minThickY = incrButtonY - boundHeight;
                }
                if (minThickY < decrButtonY + decrButtonH) {
                    minThickY = decrButtonY + decrButtonH;
                }
                this.setMinThickBounds(itemX, minThickY, itemW, boundHeight);
            }
            if (boundHeight >= (int)trackH) {
                this.setMaxThickBounds(0, 0, 0, 0);
            } else {
                if (maxThickY + boundHeight > incrButtonY) {
                    maxThickY = incrButtonY - boundHeight;
                }
                if (maxThickY < decrButtonY + decrButtonH) {
                    maxThickY = decrButtonY + decrButtonH + 1;
                }
                this.setMaxThickBounds(itemX, maxThickY, itemW, boundHeight);
            }
        }
    }

    @Override
    protected BasicScrollBarUI.TrackListener createTrackListener() {
        if (this.scrollbar instanceof J3DThickScrollBar) {
            return new ThickTrackListener();
        }
        return super.createTrackListener();
    }

    static {
        URL centerImageFilepath = J3DThickScrollBarUI.class.getResource("scrollCenter.gif");
        try {
            centerImage = ImageIO.read(centerImageFilepath);
        }
        catch (IOException ex) {
            String msg = "Could not load scroll bar center image from \"" + centerImageFilepath + "\"";
            XPutil.getLogger().warning(msg);
        }
        URL minBoundImageFilepath = J3DThickScrollBarUI.class.getResource("scrollMinBound.gif");
        try {
            minBoundImage = ImageIO.read(minBoundImageFilepath);
        }
        catch (IOException ex) {
            String msg = "Could not load scroll bar min bound image from \"" + minBoundImageFilepath + "\"";
            XPutil.getLogger().warning(msg);
        }
        URL maxBoundImageFilepath = J3DThickScrollBarUI.class.getResource("scrollMaxBound.gif");
        try {
            maxBoundImage = ImageIO.read(maxBoundImageFilepath);
        }
        catch (IOException ex) {
            String msg = "Could not load scroll bar max bound image from \"" + maxBoundImageFilepath + "\"";
            XPutil.getLogger().warning(msg);
        }
        URL markerImageFilepath = J3DThickScrollBarUI.class.getResource("marker.gif");
        try {
            markerImage = ImageIO.read(markerImageFilepath);
        }
        catch (IOException ex) {
            String msg = "Could not load marker image from \"" + markerImageFilepath + "\"";
            XPutil.getLogger().warning(msg);
        }
        centerWidth = centerImage.getWidth();
        centerHeight = centerImage.getHeight();
        halfCenterHeight = centerHeight / 2;
        boundHeight = minBoundImage.getHeight();
        displayWidth = centerWidth + 2;
        totalCoreHeight = centerHeight + 2 * (boundHeight - 2);
        halfTotalCoreHeight = totalCoreHeight / 2;
        thicknessCursorIcon = new ImageIcon(J3DThickScrollBarUI.class.getClassLoader().getResource("com/ge/med/cse/cvf/j3d/ui/slicethickness1.png"));
        THICK_CURSOR = Toolkit.getDefaultToolkit().createCustomCursor(thicknessCursorIcon.getImage(), new Point(thicknessCursorIcon.getIconWidth() / 2, thicknessCursorIcon.getIconHeight() / 2), "ThicknessCursor");
        sliceCursorIcon = new ImageIcon(J3DThickScrollBarUI.class.getClassLoader().getResource("com/ge/med/cse/cvf/j3d/ui/modecine1.png"));
        SLICE_CURSOR = Toolkit.getDefaultToolkit().createCustomCursor(sliceCursorIcon.getImage(), new Point(sliceCursorIcon.getIconWidth() / 2, sliceCursorIcon.getIconHeight() / 2), "SliceCursor");
    }

    protected class ThickTrackListener
    extends BasicScrollBarUI.TrackListener {
        boolean isMaxThickDragging;
        boolean isMinThickDragging;
        boolean isThumbDragging;
        protected transient int offset;
        protected transient int minThickOffset;
        protected transient int maxThickOffset;
        protected transient int currentMouseX;
        protected transient int currentMouseY;
        private transient int direction;

        protected ThickTrackListener() {
            super(J3DThickScrollBarUI.this);
            this.isMaxThickDragging = false;
            this.isMinThickDragging = false;
            this.isThumbDragging = false;
            this.minThickOffset = 0;
            this.maxThickOffset = 0;
            this.direction = 1;
        }

        @Override
        public void mouseReleased(MouseEvent e2) {
            if (this.isThumbDragging) {
                J3DThickScrollBarUI.this.updateThumbState(e2.getX(), e2.getY());
            } else if (this.isMinThickDragging) {
                J3DThickScrollBarUI.this.updateMinThickBoundState(e2.getX(), e2.getY());
            } else if (this.isMaxThickDragging) {
                J3DThickScrollBarUI.this.updateMaxThickBoundState(e2.getX(), e2.getY());
            }
            if (SwingUtilities.isRightMouseButton(e2) || !J3DThickScrollBarUI.this.getSupportsAbsolutePositioning() && SwingUtilities.isMiddleMouseButton(e2)) {
                return;
            }
            if (!J3DThickScrollBarUI.this.scrollbar.isEnabled()) {
                return;
            }
            Rectangle r2 = J3DThickScrollBarUI.this.getTrackBounds();
            J3DThickScrollBarUI.this.scrollbar.repaint(r2.x, r2.y, r2.width, r2.height);
            J3DThickScrollBarUI.this.trackHighlight = 0;
            this.isThumbDragging = false;
            this.isMinThickDragging = false;
            this.isMaxThickDragging = false;
            this.offset = 0;
            J3DThickScrollBarUI.this.scrollTimer.stop();
            J3DThickScrollBarUI.this.useCachedValue = true;
            J3DThickScrollBarUI.this.scrollbar.setValueIsAdjusting(false);
        }

        @Override
        public void mousePressed(MouseEvent e2) {
            int thumbY;
            int scrollbarCenter;
            if (SwingUtilities.isRightMouseButton(e2) || !J3DThickScrollBarUI.this.getSupportsAbsolutePositioning() && SwingUtilities.isMiddleMouseButton(e2)) {
                return;
            }
            if (!J3DThickScrollBarUI.this.scrollbar.isEnabled()) {
                return;
            }
            if (!J3DThickScrollBarUI.this.scrollbar.hasFocus() && J3DThickScrollBarUI.this.scrollbar.isRequestFocusEnabled()) {
                J3DThickScrollBarUI.this.scrollbar.requestFocus();
            }
            J3DThickScrollBarUI.this.useCachedValue = true;
            J3DThickScrollBarUI.this.scrollbar.setValueIsAdjusting(true);
            this.currentMouseX = e2.getX();
            this.currentMouseY = e2.getY();
            boolean inThumb = J3DThickScrollBarUI.this.getThumbBounds().contains(this.currentMouseX, this.currentMouseY);
            boolean inMinThick = J3DThickScrollBarUI.this.getMinThickBounds().contains(this.currentMouseX, this.currentMouseY);
            boolean inMaxThick = J3DThickScrollBarUI.this.getMaxThickBounds().contains(this.currentMouseX, this.currentMouseY);
            boolean thicknessControlEnabled = ((J3DThickScrollBar)J3DThickScrollBarUI.this.scrollbar).isThicknessControlEnabled();
            if (inThumb || inMinThick || inMaxThick) {
                if (inThumb || !thicknessControlEnabled) {
                    this.offset = this.currentMouseY - ((J3DThickScrollBarUI)J3DThickScrollBarUI.this).getThumbBounds().y;
                    this.isThumbDragging = true;
                } else if (inMinThick) {
                    this.minThickOffset = this.currentMouseY - J3DThickScrollBarUI.this.getMinThickBounds().y;
                    this.isMinThickDragging = true;
                } else if (inMaxThick) {
                    this.maxThickOffset = this.currentMouseY - J3DThickScrollBarUI.this.getMaxThickBounds().y;
                    this.isMaxThickDragging = true;
                }
                return;
            }
            int markerLen = J3DThickScrollBarUI.this.markers.size();
            for (int i2 = 0; i2 < markerLen; ++i2) {
                Rectangle m2 = J3DThickScrollBarUI.this.markers.get(i2);
                if (!m2.contains(this.currentMouseX, this.currentMouseY)) continue;
                double loc = J3DThickScrollBarUI.this.markerLocations[i2];
                ((J3DThickScrollBar)J3DThickScrollBarUI.this.scrollbar).setDoubleValue(loc);
                return;
            }
            this.isThumbDragging = false;
            this.isMinThickDragging = false;
            this.isMaxThickDragging = false;
            Dimension sbSize = J3DThickScrollBarUI.this.scrollbar.getSize();
            this.direction = 1;
            this.direction = J3DThickScrollBarUI.this.getThumbBounds().isEmpty() ? (this.currentMouseY < (scrollbarCenter = sbSize.height / 2) ? -1 : 1) : (this.currentMouseY < (thumbY = ((J3DThickScrollBarUI)J3DThickScrollBarUI.this).getThumbBounds().y) ? -1 : 1);
            J3DThickScrollBarUI.this.scrollByBlock(this.direction);
            J3DThickScrollBarUI.this.scrollTimer.stop();
            J3DThickScrollBarUI.this.scrollListener.setDirection(this.direction);
            J3DThickScrollBarUI.this.scrollListener.setScrollByBlock(true);
            this.startScrollTimerIfNecessary();
        }

        @Override
        public void mouseDragged(MouseEvent e2) {
            if (SwingUtilities.isRightMouseButton(e2) || !J3DThickScrollBarUI.this.getSupportsAbsolutePositioning() && SwingUtilities.isMiddleMouseButton(e2)) {
                return;
            }
            if (!J3DThickScrollBarUI.this.scrollbar.isEnabled() || J3DThickScrollBarUI.this.getThumbBounds().isEmpty() || J3DThickScrollBarUI.this.getMinThickBounds().isEmpty() || J3DThickScrollBarUI.this.getMaxThickBounds().isEmpty()) {
                return;
            }
            if (this.isThumbDragging) {
                this.setThumbValueFrom(e2);
            } else if (this.isMinThickDragging) {
                this.setMinThickValueFrom(e2);
            } else if (this.isMaxThickDragging) {
                this.setMaxThickValueFrom(e2);
            } else {
                this.currentMouseX = e2.getX();
                this.currentMouseY = e2.getY();
                J3DThickScrollBarUI.this.updateThumbState(this.currentMouseX, this.currentMouseY);
                J3DThickScrollBarUI.this.updateMinThickBoundState(this.currentMouseX, this.currentMouseY);
                J3DThickScrollBarUI.this.updateMaxThickBoundState(this.currentMouseX, this.currentMouseY);
                this.startScrollTimerIfNecessary();
            }
        }

        private void setMaxThickValueFrom(MouseEvent e2) {
            double thicknessRange;
            boolean active = J3DThickScrollBarUI.this.getMinThickBoundsRollover();
            int maxThickMin = 0;
            int maxThickMax = 0;
            int maxThickPos = 0;
            Rectangle thumbR = J3DThickScrollBarUI.this.getThumbBounds();
            Rectangle maxThickR = J3DThickScrollBarUI.this.getMaxThickBounds();
            Rectangle minThickR = J3DThickScrollBarUI.this.getMinThickBounds();
            double centerPoint = (double)((J3DThickScrollBarUI)J3DThickScrollBarUI.this).thumbRect.y + 0.5 * (double)centerHeight;
            double maxThickness = J3DThickScrollBarUI.this.getMaxThicknessValue(J3DThickScrollBarUI.this.scrollbar);
            double thicknessDelta = maxThickness / (thicknessRange = 2.0 * maxThickness / (double)(((J3DThickScrollBarUI)J3DThickScrollBarUI.this).trackRect.height - centerHeight - 2 * boundHeight + 4)) + 0.5 * (double)centerHeight + (double)boundHeight - 2.0;
            maxThickMax = (int)(0.5 + centerPoint + thicknessDelta - (double)boundHeight);
            if (maxThickMax > ((J3DThickScrollBarUI)J3DThickScrollBarUI.this).trackRect.y + ((J3DThickScrollBarUI)J3DThickScrollBarUI.this).trackRect.height - boundHeight) {
                maxThickMax = ((J3DThickScrollBarUI)J3DThickScrollBarUI.this).trackRect.y + ((J3DThickScrollBarUI)J3DThickScrollBarUI.this).trackRect.height - boundHeight;
            }
            maxThickMin = thumbR.y + thumbR.height - 2;
            maxThickPos = Math.min(maxThickMax, Math.max(maxThickMin, e2.getY() - this.maxThickOffset));
            J3DThickScrollBarUI.this.setMaxThickBounds(maxThickR.x, maxThickPos, maxThickR.width, maxThickR.height);
            int minThickMin = ((J3DThickScrollBarUI)J3DThickScrollBarUI.this).trackRect.y;
            int minThickMax = thumbR.y - boundHeight + 2;
            int minThickPos = minThickMax - (maxThickPos - maxThickMin);
            minThickPos = Math.max(minThickMin, minThickPos);
            J3DThickScrollBarUI.this.setMinThickBounds(minThickR.x, minThickPos, minThickR.width, minThickR.height);
            double thicknessDisp = Math.abs((double)maxThickPos - centerPoint + (double)boundHeight);
            double value = thicknessRange * (thicknessDisp - (0.5 * (double)centerHeight + (double)boundHeight - 2.0));
            J3DThickScrollBarUI.this.useCachedValue = true;
            ((J3DThickScrollBar)J3DThickScrollBarUI.this.scrollbar).setThickness(value);
            J3DThickScrollBarUI.this.setMaxThickBoundsRollover(active);
        }

        private void setMinThickValueFrom(MouseEvent e2) {
            double thicknessRange;
            boolean active = J3DThickScrollBarUI.this.getMinThickBoundsRollover();
            int minThickMin = 0;
            int minThickMax = 0;
            int minThickPos = 0;
            Rectangle thumbR = J3DThickScrollBarUI.this.getThumbBounds();
            Rectangle minThickR = J3DThickScrollBarUI.this.getMinThickBounds();
            Rectangle maxThickR = J3DThickScrollBarUI.this.getMaxThickBounds();
            double centerPoint = (double)((J3DThickScrollBarUI)J3DThickScrollBarUI.this).thumbRect.y + 0.5 * (double)centerHeight;
            double maxThickness = J3DThickScrollBarUI.this.getMaxThicknessValue(J3DThickScrollBarUI.this.scrollbar);
            double thicknessDelta = maxThickness / (thicknessRange = 2.0 * maxThickness / (double)(((J3DThickScrollBarUI)J3DThickScrollBarUI.this).trackRect.height - centerHeight - 2 * boundHeight + 4)) + 0.5 * (double)centerHeight + (double)boundHeight - 2.0;
            minThickMin = (int)(0.5 + centerPoint - thicknessDelta);
            if (minThickMin < ((J3DThickScrollBarUI)J3DThickScrollBarUI.this).trackRect.y) {
                minThickMin = ((J3DThickScrollBarUI)J3DThickScrollBarUI.this).trackRect.y;
            }
            minThickMax = thumbR.y - boundHeight + 2;
            minThickPos = Math.min(minThickMax, Math.max(minThickMin, e2.getY() - this.minThickOffset));
            J3DThickScrollBarUI.this.setMinThickBounds(minThickR.x, minThickPos, minThickR.width, minThickR.height);
            int maxThickMin = thumbR.y + thumbR.height - 2;
            int maxThickMax = ((J3DThickScrollBarUI)J3DThickScrollBarUI.this).trackRect.y + ((J3DThickScrollBarUI)J3DThickScrollBarUI.this).trackRect.height - boundHeight;
            int maxThickPos = maxThickMin + (minThickMax - minThickPos);
            maxThickPos = Math.min(maxThickMax, maxThickPos);
            J3DThickScrollBarUI.this.setMaxThickBounds(maxThickR.x, maxThickPos, maxThickR.width, maxThickR.height);
            double thicknessDisp = Math.abs((double)minThickPos - centerPoint);
            double value = thicknessRange * (thicknessDisp - (0.5 * (double)centerHeight + (double)boundHeight - 2.0));
            J3DThickScrollBarUI.this.useCachedValue = true;
            ((J3DThickScrollBar)J3DThickScrollBarUI.this.scrollbar).setThickness(value);
            J3DThickScrollBarUI.this.setMinThickBoundsRollover(active);
        }

        private void setThumbValueFrom(MouseEvent e2) {
            boolean active = J3DThickScrollBarUI.this.isThumbRollover();
            BoundedRangeModel model = J3DThickScrollBarUI.this.scrollbar.getModel();
            Rectangle thumbR = J3DThickScrollBarUI.this.getThumbBounds();
            Rectangle minThickR = J3DThickScrollBarUI.this.getMinThickBounds();
            Rectangle maxThickR = J3DThickScrollBarUI.this.getMaxThickBounds();
            double centerPoint = (double)((J3DThickScrollBarUI)J3DThickScrollBarUI.this).thumbRect.y + 0.5 * (double)centerHeight;
            int thumbMin = 0;
            int thumbMax = 0;
            int thumbPos = 0;
            thumbMin = ((J3DThickScrollBarUI)J3DThickScrollBarUI.this).trackRect.y + boundHeight - 2;
            thumbMax = ((J3DThickScrollBarUI)J3DThickScrollBarUI.this).trackRect.y + ((J3DThickScrollBarUI)J3DThickScrollBarUI.this).trackRect.height - thumbR.height - boundHeight + 2;
            thumbPos = Math.min(thumbMax, Math.max(thumbMin, e2.getY() - this.offset));
            int delta = thumbR.y - thumbPos;
            J3DThickScrollBarUI.this.setThumbBounds(thumbR.x, thumbPos, thumbR.width, thumbR.height);
            double maxThickness = J3DThickScrollBarUI.this.getMaxThicknessValue(J3DThickScrollBarUI.this.scrollbar);
            double thicknessRange = 2.0 * maxThickness / (double)(((J3DThickScrollBarUI)J3DThickScrollBarUI.this).trackRect.height - centerHeight - 2 * boundHeight + 4);
            double thicknessDelta = J3DThickScrollBarUI.this.getThicknessValue(J3DThickScrollBarUI.this.scrollbar) / thicknessRange + 0.5 * (double)centerHeight + (double)boundHeight - 2.0;
            int absoluteMinPos = (int)(0.5 + centerPoint - thicknessDelta);
            int absoluteMaxPos = (int)(0.5 + centerPoint + thicknessDelta - (double)boundHeight);
            int minThickPos = minThickR.y;
            int minThickMin = ((J3DThickScrollBarUI)J3DThickScrollBarUI.this).trackRect.y;
            int minThickMax = thumbPos - boundHeight + 2;
            minThickPos -= delta;
            minThickPos = Math.min(minThickMax, Math.max(minThickMin, minThickPos));
            if (absoluteMinPos < minThickMin) {
                minThickPos = minThickMin;
            }
            J3DThickScrollBarUI.this.setMinThickBounds(minThickR.x, minThickPos, minThickR.width, minThickR.height);
            int maxThickPos = maxThickR.y;
            int maxThickMax = ((J3DThickScrollBarUI)J3DThickScrollBarUI.this).trackRect.y + ((J3DThickScrollBarUI)J3DThickScrollBarUI.this).trackRect.height - boundHeight;
            maxThickPos -= delta;
            maxThickPos = Math.min(maxThickMax, maxThickPos);
            if (absoluteMaxPos > maxThickMax) {
                maxThickPos = maxThickMax;
            }
            J3DThickScrollBarUI.this.setMaxThickBounds(maxThickR.x, maxThickPos, maxThickR.width, maxThickR.height);
            if (thumbPos == thumbMax) {
                J3DThickScrollBarUI.this.scrollbar.setValue(model.getMaximum() - model.getExtent());
            } else {
                float valueMax = model.getMaximum() - model.getExtent();
                float valueRange = valueMax - (float)model.getMinimum();
                float thumbValue = thumbPos - thumbMin;
                float thumbRange = thumbMax - thumbMin;
                int value = 0;
                value = (int)(0.5 + (double)(thumbValue / thumbRange * valueRange));
                J3DThickScrollBarUI.this.useCachedValue = true;
                J3DThickScrollBarUI.this.scrollBarValue = value + model.getMinimum();
                J3DThickScrollBarUI.this.scrollbar.setValue(J3DThickScrollBarUI.this.scrollBarValue);
            }
            J3DThickScrollBarUI.this.setThumbRollover(active);
        }

        private void startScrollTimerIfNecessary() {
            if (J3DThickScrollBarUI.this.scrollTimer.isRunning()) {
                return;
            }
            Rectangle tb = J3DThickScrollBarUI.this.getThumbBounds();
            if (this.direction > 0) {
                if (tb.y + tb.height < this.currentMouseY) {
                    J3DThickScrollBarUI.this.scrollTimer.start();
                }
            } else if (tb.y > this.currentMouseY) {
                J3DThickScrollBarUI.this.scrollTimer.start();
            }
        }

        @Override
        public void mouseMoved(MouseEvent e2) {
            if (!this.isThumbDragging) {
                J3DThickScrollBarUI.this.updateThumbState(e2.getX(), e2.getY());
            }
            if (!this.isMinThickDragging) {
                J3DThickScrollBarUI.this.updateMinThickBoundState(e2.getX(), e2.getY());
            }
            if (!this.isMaxThickDragging) {
                J3DThickScrollBarUI.this.updateMaxThickBoundState(e2.getX(), e2.getY());
            }
            if (J3DThickScrollBarUI.this.isThumbRollover()) {
                e2.getComponent().setCursor(SLICE_CURSOR);
            } else if (J3DThickScrollBarUI.this.minThickRollover || J3DThickScrollBarUI.this.maxThickRollover) {
                e2.getComponent().setCursor(THICK_CURSOR);
            } else {
                e2.getComponent().setCursor(Cursor.getPredefinedCursor(0));
            }
        }

        @Override
        public void mouseExited(MouseEvent e2) {
            if (!this.isThumbDragging) {
                J3DThickScrollBarUI.this.setThumbRollover(false);
            }
            if (!this.isMinThickDragging) {
                J3DThickScrollBarUI.this.setMinThickBoundsRollover(false);
            }
            if (!this.isMaxThickDragging) {
                J3DThickScrollBarUI.this.setMaxThickBoundsRollover(false);
            }
        }
    }
}

