/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.j3d.vav;

import com.ge.med.cse.cvf.j3d.utils.J3DGeomUtils;
import com.ge.med.cse.cvf.j3d.vav.VVBatchProtocol;
import com.ge.med.cse.cvf.j3d.vav.VavAutoEdge;
import com.ge.med.cse.cvf.j3d.vav.VavBatchJob;
import com.ge.med.cse.cvf.j3d.vav.VavRectPrismBatchModel;
import com.ge.med.cse.cvf.j3d.vav.jrl.JRL3DModel;
import com.ge.med.cse.cvf.j3d.vav.jrl.JRL3DRenderer;
import com.ge.med.cse.cvf.util.CvPropertiesManager;
import com.ge.med.cse.cvf.util.DicomUtils;
import com.ge.med.idc.T3DCapable;
import com.ge.med.idc.XjVolume;
import com.ge.med.idc.XjVolumeGeometry;
import com.ge.med.idc.XjVolumeInfo;
import com.ge.med.idc.XjVolumeModel;
import com.ge.med.jnu.JnVector3d;
import com.ge.med.terra.jami.CPoint;
import com.ge.med.terra.jami.XpSlice;
import com.ge.med.terra.jami.capable.T3DRenderer;
import com.ge.med.terra.jami.image.XpBufferedImage;
import com.ge.med.terra.jami.j3d.J3DVolumeModel;
import com.ge.med.terra.jami.j3d.T3DReformatter;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class VavBatchEngine {
    private static final int interval = Integer.parseInt(CvPropertiesManager.getProperty("vav.batchProcessing.interFrameDelay", "5"));
    protected final Logger logger = Logger.getLogger("com.ge.med.cse.cvf.j3d.vav");
    protected static boolean debugTrace = CvPropertiesManager.getProperty("vav.debug_trace") != null;
    private String t3dRendererClass = "com.ge.med.terra.jami.j3d.T3DReformatter";
    private T3DRenderer renderer = null;
    protected VavBatchJob activeJob = null;
    private XpBufferedImage image = null;
    private BufferedImage bufferedImage = null;
    private BufferedImage rgbbufferedImage = null;
    private Map imageMap = new HashMap();
    private double[] tempEye = new double[3];
    private double[] tempLook = new double[3];
    private double[] tempUp = new double[3];
    private double[] tempViewClip = new double[2];
    private XjVolumeGeometry edgeReducedBoundingBox = null;
    private CPoint ul = new CPoint(2);
    private CPoint ur = new CPoint(2);
    private CPoint br = new CPoint(2);
    private double[] lookPoint = new double[3];
    private double[] eyePoint = new double[3];
    private double[] upVector = new double[3];
    private JnVector3d v = new JnVector3d();
    private JnVector3d u = new JnVector3d();
    private JnVector3d r = new JnVector3d();

    public VavBatchEngine() {
        this.t3dRendererClass = CvPropertiesManager.getProperty("vav.t3dRendererClass", this.t3dRendererClass);
        this.init();
    }

    public VavBatchEngine(String t3dRendererClass) {
        this.t3dRendererClass = t3dRendererClass;
        this.logger.log(Level.FINE, "Overridding vav.t3dRendererClass property with \"" + t3dRendererClass + "\"");
        this.init();
    }

    protected void init() {
        this.renderer = null;
        try {
            Class<?> c2 = Class.forName(this.t3dRendererClass);
            this.renderer = (T3DRenderer)c2.newInstance();
        }
        catch (Exception ex) {
            if (debugTrace) {
                ex.printStackTrace();
            }
            String msg = "Error: could not instantiate T3DRenderer from \"" + this.t3dRendererClass + "\" as found in vav.t3dRendererClass property.";
            this.logger.log(Level.SEVERE, "{0} SEV6 " + msg, "TID=VAV_CONFIG");
        }
        if (this.renderer == null) {
            this.renderer = new T3DReformatter();
        }
    }

    public XjVolumeModel getVolumeModel() {
        return this.renderer.getVolumeModel();
    }

    public XjVolumeInfo getVolume() {
        return this.renderer.getVolume();
    }

    public void setVolumeModel(XjVolumeModel volumeModel) {
        this.renderer.setVolumeModel(volumeModel);
        this.edgeReducedBoundingBox = null;
        if (volumeModel != null) {
            this.edgeReducedBoundingBox = this.createEdgeReducedBoundingBox(volumeModel);
        }
    }

    public void setVolume(XjVolume volume) {
        this.renderer.setVolume(volume);
        this.edgeReducedBoundingBox = null;
        if (volume != null) {
            this.edgeReducedBoundingBox = this.createEdgeReducedBoundingBox(this.renderer.getVolumeModel());
        }
    }

    public void setVolumeModel(XjVolumeModel volumeModel, XjVolumeGeometry autoEdgeBoundingBox) {
        this.renderer.setVolumeModel(volumeModel);
        this.edgeReducedBoundingBox = autoEdgeBoundingBox;
        if (volumeModel != null && this.edgeReducedBoundingBox == null) {
            this.edgeReducedBoundingBox = this.createEdgeReducedBoundingBox(volumeModel);
        }
    }

    public XjVolumeGeometry getEdgeReducedBoundingBox() {
        return this.edgeReducedBoundingBox;
    }

    public void processBatch(VavBatchJob batchJob) {
        if (batchJob.getModel() instanceof VavRectPrismBatchModel && ((VavRectPrismBatchModel)batchJob.getModel()).isAutoEdgeEnabled()) {
            ((VavRectPrismBatchModel)batchJob.getModel()).setBoundingBox(this.edgeReducedBoundingBox);
        }
        this.activeJob = batchJob;
        this.startProcessing();
        this.activeJob = null;
    }

    private VavBatchJob.BatchFrame nextFrame() {
        return this.activeJob.nextFrame();
    }

    private void startProcessing() {
        try {
            VavBatchJob.BatchFrame frame = null;
            while ((frame = this.nextFrame()) != null) {
                block23: {
                    try {
                        this.checkFrame(frame);
                        this.renderer.setCamera(frame.getEyePoint(this.tempEye), frame.getLookPoint(this.tempLook), frame.getUp(this.tempUp));
                        this.renderer.setViewHeight(frame.getViewHeight());
                        this.renderer.setRenderStyle(frame.getRenderStyle());
                        this.renderer.setViewClip(frame.getViewClip(this.tempViewClip));
                        if (this.renderer.getRenderStyle() != "REFORMAT" && this.renderer.getRenderStyle() != "REFORMAT.TC" && this.renderer.getRenderStyle() != "REFORMAT.NN") break block23;
                        this.renderer.setViewClip(new double[]{0.0, 0.0});
                    }
                    catch (Exception ex) {
                        if (debugTrace) {
                            ex.printStackTrace();
                        }
                        this.logger.log(Level.SEVERE, "{0} SEV7 Error: Exception from renderer during batch processing.", new Object[]{"TID=VAV_RENDER_ENGINE", ex});
                        frame.reportProcessingError(ex);
                        break;
                    }
                }
                try {
                    if (this.image == null || frame.getWidth() != this.image.getPixelData().getWidth() || frame.getHeight() != this.image.getPixelData().getHeight()) {
                        this.bufferedImage = new BufferedImage(frame.getWidth(), frame.getHeight(), 11);
                        this.rgbbufferedImage = new BufferedImage(frame.getWidth(), frame.getHeight(), 1);
                        this.image = new XpBufferedImage(this.bufferedImage, this.imageMap);
                    }
                }
                catch (Exception ex) {
                    if (debugTrace) {
                        ex.printStackTrace();
                    }
                    this.logger.log(Level.SEVERE, "{0} SEV6 Error: Exception found during batch processing.", new Object[]{"TID=VAV_BATCH_ENGINE_THREAD", ex});
                    frame.reportProcessingError(ex);
                }
                try {
                    this.renderer.setOutput(this.bufferedImage, this.rgbbufferedImage);
                    this.renderer.sample();
                }
                catch (Exception ex) {
                    if (debugTrace) {
                        ex.printStackTrace();
                    }
                    this.logger.log(Level.SEVERE, "{0} SEV7 Error: Exception from renderer during batch processing.", new Object[]{"TID=VAV_RENDER_ENGINE", ex});
                    frame.reportProcessingError(ex);
                    break;
                }
                try {
                    this.updateSlice(this.image, frame);
                    this.image.setRescaleIntercept(this.renderer.getRescaleIntercept());
                    this.image.setRescaleSlope(this.renderer.getRescaleSlope());
                    HashMap<String, Double> valueMap = new HashMap<String, Double>();
                    String wlKey = "40,4176";
                    String wwKey = "40,4177";
                    double ww = 0.0;
                    double wl = 0.0;
                    if (this.getVolumeModel() instanceof J3DVolumeModel) {
                        wl = ((J3DVolumeModel)this.getVolumeModel()).getJVolume().initWL;
                        ww = ((J3DVolumeModel)this.getVolumeModel()).getJVolume().initWW;
                    } else if (this.getVolumeModel() instanceof JRL3DModel) {
                        int vidx = ((JRL3DRenderer)this.renderer).getViewIndex();
                        double[] wwwl = ((JRL3DModel)this.getVolumeModel()).getWWWL(vidx, null);
                        ww = wwwl[0];
                        wl = wwwl[1];
                    } else {
                        ww = DicomUtils.getWindowWidth(this.getVolume());
                        wl = DicomUtils.getWindowLevel(this.getVolume());
                    }
                    valueMap.put(wlKey, wl);
                    valueMap.put(wwKey, ww);
                    this.image.setPropertyTable(valueMap);
                }
                catch (Exception ex) {
                    if (debugTrace) {
                        ex.printStackTrace();
                    }
                    this.logger.log(Level.SEVERE, "{0} SEV6 Error: Exception found during batch processing.", new Object[]{"TID=VAV_BATCH_ENGINE_THREAD", ex});
                    frame.reportProcessingError(ex);
                }
                if (this.activeJob.isSavingToDB()) {
                    frame.saveFrame(this.image, this.getVolumeModel());
                }
                do {
                    this.sleep(interval);
                } while (this.activeJob.isPaused());
            }
        }
        catch (Exception ex) {
            if (debugTrace) {
                ex.printStackTrace();
            }
            this.logger.log(Level.SEVERE, "{0} SEV6 Error: Exception found during batch processing thread.", new Object[]{"TID=VAV_BATCH_ENGINE_THREAD", ex});
        }
    }

    private void sleep(int msec) {
        try {
            Thread.sleep(msec);
        }
        catch (InterruptedException ie) {
            ie.printStackTrace();
            this.logger.log(Level.WARNING, "Exception occurred during batch processing.", new Object[]{ie});
        }
    }

    protected void checkFrame(VavBatchJob.BatchFrame frame) {
        if (!("FULLBODY_MIP".equals(frame.getRenderStyle()) || "FULLBODY_MINIP".equals(frame.getRenderStyle()) || "FULLBODY_AVERAGE".equals(frame.getRenderStyle()))) {
            XjVolumeInfo volInfo = this.renderer.getVolume();
            double thk = J3DGeomUtils.getMinSliceThickness((XjVolumeGeometry)volInfo, frame.getLookPoint(null), frame.getEyePoint(null));
            frame.getViewClip(this.tempViewClip);
            if (thk >= Math.abs(this.tempViewClip[1] - this.tempViewClip[0]) && !"REFORMAT".equals(frame.getRenderStyle()) && !"REFORMAT.TC".equals(frame.getRenderStyle())) {
                String rstyle = VVBatchProtocol.defaultRenderingQuality() == 2 ? "REFORMAT.TC" : "REFORMAT";
                this.logger.log(Level.INFO, "Setting render mode to thin : \"" + rstyle);
                System.out.println("Setting render mode to thin : \"" + rstyle);
                frame.setRenderStyle(rstyle);
                this.activeJob.getModel().setRenderStyle(rstyle);
            }
        }
    }

    private void updateSlice(XpBufferedImage image, T3DCapable view) {
        XpSlice slice = image.getSlice();
        slice.width = image.getPixelData().getWidth();
        slice.height = image.getPixelData().getHeight();
        int w2 = slice.width;
        int h2 = slice.height;
        double viewWidth = view.getViewHeight() * view.getAspectRatio();
        double spx = viewWidth / (double)w2;
        double spy = view.getViewHeight() / (double)h2;
        if (view instanceof VavBatchJob.BatchFrame) {
            this.calc_cam(view.getEyePoint(this.eyePoint), ((VavBatchJob.BatchFrame)view).getActualLookPoint(this.lookPoint), view.getUp(this.upVector));
        } else {
            this.calc_cam(view.getEyePoint(this.eyePoint), view.getLookPoint(this.lookPoint), view.getUp(this.upVector));
        }
        this.ul.x = this.lookPoint[0] - (double)(w2 - 1) * 0.5 * this.r.x * spx - (double)(h2 - 1) * 0.5 * this.u.x * spy;
        this.ul.y = this.lookPoint[1] - (double)(w2 - 1) * 0.5 * this.r.y * spx - (double)(h2 - 1) * 0.5 * this.u.y * spy;
        this.ul.z = this.lookPoint[2] - (double)(w2 - 1) * 0.5 * this.r.z * spx - (double)(h2 - 1) * 0.5 * this.u.z * spy;
        this.ur.x = this.lookPoint[0] + (double)(w2 - 1) * 0.5 * this.r.x * spx - (double)(h2 - 1) * 0.5 * this.u.x * spy;
        this.ur.y = this.lookPoint[1] + (double)(w2 - 1) * 0.5 * this.r.y * spx - (double)(h2 - 1) * 0.5 * this.u.y * spy;
        this.ur.z = this.lookPoint[2] + (double)(w2 - 1) * 0.5 * this.r.z * spx - (double)(h2 - 1) * 0.5 * this.u.z * spy;
        this.br.x = this.lookPoint[0] + (double)(w2 - 1) * 0.5 * this.r.x * spx + (double)(h2 - 1) * 0.5 * this.u.x * spy;
        this.br.y = this.lookPoint[1] + (double)(w2 - 1) * 0.5 * this.r.y * spx + (double)(h2 - 1) * 0.5 * this.u.y * spy;
        this.br.z = this.lookPoint[2] + (double)(w2 - 1) * 0.5 * this.r.z * spx + (double)(h2 - 1) * 0.5 * this.u.z * spy;
        slice.pixelSizeX = spx;
        slice.pixelSizeY = spy;
        slice.setCorners(this.ul, this.ur, this.br);
    }

    private void calc_cam(double[] eyepoint, double[] lookpoint, double[] up) {
        this.v.set(lookpoint[0] - eyepoint[0], lookpoint[1] - eyepoint[1], lookpoint[2] - eyepoint[2]);
        this.v.normalize();
        this.u.set(-up[0], -up[1], -up[2]);
        this.u.normalize();
        JnVector3d.cross(this.u, this.v, this.r);
        this.r.normalize();
        JnVector3d.cross(this.v, this.r, this.u);
        this.u.normalize();
    }

    public XjVolumeGeometry createEdgeReducedBoundingBox(XjVolumeModel volumeModel) {
        if (volumeModel == null) {
            return null;
        }
        if (volumeModel instanceof JRL3DModel) {
            return ((JRL3DModel)volumeModel).getAutoEdgeBoundixBox();
        }
        VavAutoEdge edgeCreator = new VavAutoEdge(volumeModel);
        int[] minmax = VavAutoEdge.getMinMaxThreshold(DicomUtils.getModality(volumeModel.getVolume()));
        edgeCreator.setThresholding(minmax[0], minmax[1]);
        XjVolumeGeometry bbox = edgeCreator.getAutoEdgedBoundingBox();
        edgeCreator.setVolume(null);
        return bbox;
    }
}

