/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.j3d.vav;

import com.ge.med.cse.cvf.idc.ViewTypeCapable;
import com.ge.med.cse.cvf.j3d.utils.J3DGeomUtils;
import com.ge.med.cse.cvf.j3d.vav.VVBatchProtocol;
import com.ge.med.cse.cvf.j3d.vav.VavBatchModel;
import com.ge.med.cse.cvf.util.CvPropertiesManager;
import com.ge.med.idc.XjVolumeGeometry;
import com.ge.med.idc.XjVolumeModel;
import com.ge.med.jnu.JnVector3d;
import com.ge.med.jnu.geom.GeomUtils;
import com.ge.med.terra.jami.CPoint;
import com.ge.med.terra.jami.CTransform;
import com.ge.med.terra.jami.XpSlice;
import com.ge.med.terra.jami.j3d.T3DViewport;
import com.ge.med.terra.jami.j3d.XjVolumeUtils;
import java.awt.Dimension;
import java.util.Locale;
import java.util.logging.Level;

public class VavRectPrismBatchModel
extends VavBatchModel {
    public static final String CENTER_POINT_PROPERTY = "CENTER_POINT_PROPERTY";
    public static final String SPACING_PROPERTY = "SPACING_PROPERTY";
    public static final String NORMAL_VEC_PROPERTY = "NORMAL_VEC_PROPERTY";
    public static final String REFORMAT_DIRECTION_I_TO_S = "I_TO_S";
    public static final String REFORMAT_DIRECTION_S_TO_I = "S_TO_I";
    public static final String REFORMAT_DIRECTION_P_TO_A = "P_TO_A";
    public static final String REFORMAT_DIRECTION_A_TO_P = "A_TO_P";
    public static final String REFORMAT_DIRECTION_L_TO_R = "L_TO_R";
    public static final String REFORMAT_DIRECTION_R_TO_L = "R_TO_L";
    private final boolean useImageDims = CvPropertiesManager.getBoolean("vav.pixeldim.useinputimagedim", false);
    protected XjVolumeGeometry targetVolume = null;
    protected XjVolumeModel targetVolumeModel = null;
    protected T3DViewport targetViewport = null;
    protected boolean initalized_ = false;
    protected JnVector3d rasOrig = new JnVector3d();
    protected JnVector3d rside = new JnVector3d();
    protected JnVector3d aside = new JnVector3d();
    protected JnVector3d sside = new JnVector3d();
    protected CPoint volCenter = new CPoint(2);
    protected CTransform vox2ras = new CTransform();
    protected CTransform ras2vox = new CTransform();
    protected double tilt = 0.0;
    protected boolean zinterpolation = true;
    protected boolean alignedToZ = false;
    protected boolean alignedToVolume = true;
    protected double spacing = 0.0;
    protected int numImages = 0;
    protected CPoint center = null;
    protected CPoint normalVec = null;
    protected CPoint start = null;
    protected CPoint end = null;
    protected JnVector3d upVec = null;
    protected String reformatPlane = null;
    protected String reformatDirection = null;
    protected String refViewPlane = null;
    private CTransform vox2ras_ae = new CTransform();
    private CTransform ras2vox_ae = new CTransform();
    private CPoint ul = new CPoint(2);
    private CPoint ur = new CPoint(2);
    private CPoint br = new CPoint(2);

    public VavRectPrismBatchModel() {
    }

    public VavRectPrismBatchModel(CPoint start, CPoint end, double fov, double spacing, int numImages) {
        String msg;
        if (fov < 0.0) {
            msg = "Attempting to set invalid fov (" + fov + "). FOV must be greater than zero. Converting to a positive value.";
            this.logger.log(Level.WARNING, "{0} SEV6 " + msg, "TID=VAV_BATCH_PROTOCOL");
            fov = -fov;
        }
        this.fov = fov;
        if (spacing < 0.0) {
            msg = "Attempting to set invalid spacing (" + spacing + "). Spacing must be greater than zero. Converting to a positive value.";
            this.logger.log(Level.WARNING, "{0} SEV6 " + msg, "TID=VAV_BATCH_PROTOCOL");
            spacing = -spacing;
        }
        this.spacing = spacing;
        if (numImages < -1) {
            msg = "Attempting to set invalid number of images (" + numImages + "). Number of images must be greater than one. Converting to a positive value.";
            this.logger.log(Level.WARNING, "{0} SEV6 " + msg, "TID=VAV_BATCH_PROTOCOL");
            numImages = -numImages;
        }
        this.numImages = numImages;
        this.start = new CPoint(start);
        this.end = new CPoint(end);
        this.center = new CPoint(this.start);
        this.center.add(this.end);
        this.center.scale(0.5);
        this.normalVec = new CPoint(start);
        this.normalVec.sub(end);
        this.normalVec.normalize();
    }

    public VavRectPrismBatchModel(CPoint center, double fov, double spacing, int numImages, CPoint normal) {
        String msg;
        if (fov < 0.0) {
            msg = "Attempting to set invalid fov (" + fov + "). FOV must be greater than zero. Converting to a positive value.";
            this.logger.log(Level.WARNING, "{0} SEV6 " + msg, "TID=VAV_BATCH_PROTOCOL");
            fov = -fov;
        }
        this.fov = fov;
        if (spacing < 0.0) {
            msg = "Attempting to set invalid spacing (" + spacing + "). Spacing must be greater than zero. Converting to a positive value.";
            this.logger.log(Level.WARNING, "{0} SEV6 " + msg, "TID=VAV_BATCH_PROTOCOL");
            spacing = -spacing;
        }
        this.spacing = spacing;
        if (numImages < -1) {
            msg = "Attempting to set invalid number of images (" + numImages + "). Number of images must be greater than one. Converting to a positive value.";
            this.logger.log(Level.WARNING, "{0} SEV6 " + msg, "TID=VAV_BATCH_PROTOCOL");
            numImages = -numImages;
        }
        this.numImages = numImages;
        this.center = new CPoint(center);
        this.normalVec = new CPoint(normal);
        this.normalVec.normalize();
    }

    public VavRectPrismBatchModel(VVBatchProtocol protocol) {
        this.loadFromProtocol(protocol);
    }

    @Override
    public String getBatchType() {
        return "RectPrism";
    }

    @Override
    public void loadFromProtocol(VVBatchProtocol protocol) {
        if (!protocol.model.equals("Oblique")) {
            String msg = "Constructing an oblique model with a protocol of type " + protocol.model + ".";
            this.logger.log(Level.WARNING, "{0} SEV6 " + msg, "TID=VAV_BATCH_PROTOCOL");
        }
        this.seriesDescription = protocol.name;
        this.fov = protocol.fieldOfView * 10.0;
        if (this.fov < 0.0) {
            this.fov = -this.fov;
        }
        this.spacing = protocol.spacing;
        if (this.spacing < 0.0) {
            this.spacing = -this.spacing;
        }
        this.thickness = protocol.thickness;
        if (this.thickness < 0.0) {
            this.thickness = -this.thickness;
        }
        if (protocol.voxelSize > 0.0) {
            this.thickness *= protocol.voxelSize;
        }
        this.numImages = protocol.numberOfViews;
        if (this.numImages < 0) {
            this.numImages = -this.numImages;
        }
        this.renderStyle = protocol.getT3DRenderStyle();
        if (protocol.autoFilming != null && protocol.autoFilming.equalsIgnoreCase("On") || protocol.autoFilming == null || protocol.autoFilming.equalsIgnoreCase("Off")) {
            // empty if block
        }
        if (this.center == null) {
            this.center = new CPoint();
        }
        this.center.setPoint(protocol.centerX, protocol.centerY, 0.0, (byte)3);
        if (this.normalVec == null) {
            this.normalVec = new CPoint();
        }
        this.normalVec.setPoint(-protocol.vectorX, -protocol.vectorY, 0.0, (byte)1);
        if (protocol.viewName != null) {
            if (protocol.viewName.toLowerCase(Locale.ENGLISH).contains("Coronal".toLowerCase(Locale.ENGLISH))) {
                this.refViewPlane = "OB_CORONAL";
            } else if (protocol.viewName.toLowerCase(Locale.ENGLISH).contains("Sagittal".toLowerCase(Locale.ENGLISH))) {
                this.refViewPlane = "OB_SAGITTAL";
            } else if (protocol.viewName.toLowerCase(Locale.ENGLISH).contains("Axial".toLowerCase(Locale.ENGLISH))) {
                this.refViewPlane = "OB_AXIAL";
            }
        }
        this.start = null;
        this.end = null;
        this.logger.log(Level.INFO, "Protocol loaded with vaules\nDescription: " + protocol.name + "\n" + "View Name: " + protocol.viewName + "\n" + "Model: " + protocol.model + "\n" + "Rotation: " + protocol.rotation + "\n" + "NumberOfViews: " + protocol.numberOfViews + "\n" + "FieldOfView: " + protocol.fieldOfView + "\n" + "spacing: " + protocol.spacing + "\n" + "thickness: " + protocol.thickness + "\n" + "CenterX: " + protocol.centerX + "\n" + "centerY: " + protocol.centerY + "\n" + "vectorX: " + protocol.vectorX + "\n" + "vectorY: " + protocol.vectorY + "\n" + "voxelSize: " + protocol.voxelSize + "\n" + "renderMode: " + protocol.renderMode + "\n" + "End of Protocol");
        this.applyContrainingVolume();
    }

    @Override
    public void saveToProtocol(VVBatchProtocol protocol) {
        protocol.model = "Oblique";
        protocol.numberOfViews = this.getNumImages();
        protocol.spacing = this.getSpacing();
        protocol.thickness = this.getThickness();
        protocol.voxelSize = 1.0;
        protocol.fieldOfView = this.getFov() / 10.0;
        protocol.name = this.getSeriesDescription();
        protocol.renderMode = this.getRenderStyle();
        protocol.viewName = "";
        if (this.targetViewport != null) {
            ViewTypeCapable vtcap = (ViewTypeCapable)this.targetViewport.getCapable(ViewTypeCapable.class.getName());
            if (vtcap != null) {
                String vname = vtcap.getViewType();
                if ("AXIAL".equals(vname)) {
                    protocol.viewName = "Axial";
                } else if ("CORONAL".equals(vname)) {
                    protocol.viewName = "Coronal";
                } else if ("SAGITTAL".equals(vname)) {
                    protocol.viewName = "Sagittal";
                }
            }
            CPoint center = this.getCenter();
            this.targetViewport.getT3DComponent().getTransform((byte)2, (byte)1).transform(center);
            protocol.centerX = center.x / (double)this.targetViewport.getWidth();
            protocol.centerY = center.y / (double)this.targetViewport.getHeight();
            CPoint normal = this.getNormal();
            this.targetViewport.getT3DComponent().getTransform((byte)2, (byte)1).transform(normal);
            normal.normalize();
            protocol.vectorX = -normal.x;
            protocol.vectorY = -normal.y;
        }
    }

    @Override
    public boolean isTargetSet() {
        return this.initalized_;
    }

    @Override
    public void setTarget(XjVolumeGeometry volume) {
        if (volume != this.targetVolume) {
            this.targetVolume = volume;
            this.targetVolumeModel = null;
            this.targetViewport = null;
            this.rasOrig.set(0.0, 0.0, 0.0);
            this.rside.set(0.0, 0.0, 0.0);
            this.aside.set(0.0, 0.0, 0.0);
            this.sside.set(0.0, 0.0, 0.0);
            this.volCenter.set(0.0, 0.0, 0.0);
            this.vox2ras.loadIdentity();
            this.ras2vox.loadIdentity();
            this.boundingBox = null;
            this.initalized_ = false;
            if (this.targetVolume != null) {
                this.init();
                this.initalized_ = true;
                this.applyContrainingVolume();
            }
        }
    }

    @Override
    public void setTarget(T3DViewport port) {
        if (port == null) {
            this.targetViewport = null;
            this.targetVolume = null;
            this.targetVolumeModel = null;
            this.initalized_ = false;
            return;
        }
        if (port.getVolume() != this.targetVolume) {
            this.targetViewport = port;
            this.targetVolume = port.getVolume();
            this.targetVolumeModel = port.getVolumeModel();
            this.rasOrig.set(0.0, 0.0, 0.0);
            this.rside.set(0.0, 0.0, 0.0);
            this.aside.set(0.0, 0.0, 0.0);
            this.sside.set(0.0, 0.0, 0.0);
            this.rasOrig.set(0.0, 0.0, 0.0);
            this.vox2ras.loadIdentity();
            this.ras2vox.loadIdentity();
            this.boundingBox = null;
            this.init();
            this.initalized_ = true;
            this.applyContrainingVolume();
        } else if (port != this.targetViewport) {
            this.targetViewport = port;
            this.targetVolume = port.getVolume();
            this.targetVolumeModel = port.getVolumeModel();
            this.initalized_ = true;
            this.applyContrainingVolume();
        }
    }

    @Override
    public T3DViewport getTargetPort() {
        return this.targetViewport;
    }

    @Override
    public XjVolumeGeometry getTargetVolume() {
        return this.targetVolume;
    }

    @Override
    public void setTarget(XjVolumeModel volumeModel) {
        if (volumeModel == null) {
            this.targetViewport = null;
            this.targetVolume = null;
            this.targetVolumeModel = null;
            this.initalized_ = false;
            return;
        }
        if (volumeModel != this.targetVolumeModel) {
            this.targetVolumeModel = volumeModel;
            this.targetVolume = volumeModel.getVolume();
            this.targetViewport = null;
            this.rasOrig.set(0.0, 0.0, 0.0);
            this.rside.set(0.0, 0.0, 0.0);
            this.aside.set(0.0, 0.0, 0.0);
            this.sside.set(0.0, 0.0, 0.0);
            this.volCenter.set(0.0, 0.0, 0.0);
            this.vox2ras.loadIdentity();
            this.ras2vox.loadIdentity();
            this.boundingBox = null;
            this.init();
            this.initalized_ = true;
            this.applyContrainingVolume();
        }
    }

    @Override
    public XjVolumeModel getTargetVolumeModel() {
        return this.targetVolumeModel;
    }

    public synchronized void setTarget(JnVector3d parallelepipedOrigin, JnVector3d parallelepipedVector0, JnVector3d parallelepipedVector1, JnVector3d parallelepipedVector2) {
        this.targetVolume = new J3DGeomUtils.dummyVolume(parallelepipedOrigin.toArray(), parallelepipedVector0.toArray(), parallelepipedVector1.toArray(), parallelepipedVector2.toArray());
        this.targetViewport = null;
        this.targetVolumeModel = null;
        this.init();
        this.initalized_ = true;
        this.applyContrainingVolume();
    }

    private void init() {
        XjVolumeGeometry constraint;
        XjVolumeGeometry xjVolumeGeometry = this.targetVolume != null ? this.targetVolume : (this.targetViewport != null ? this.targetViewport.getVolume() : (constraint = this.targetVolumeModel != null ? this.targetVolumeModel.getVolume() : null));
        if (constraint != null) {
            J3DGeomUtils.calculateVoxelRASTransforms(constraint, this.vox2ras, this.ras2vox);
            J3DGeomUtils.alignVolumeToRAS(constraint, this.rasOrig, this.rside, this.aside, this.sside);
            this.tilt = XjVolumeUtils.calculateTilt(constraint);
            double[] center = XjVolumeUtils.getVolumeCenterRAS(constraint.getRASOfOrigin(null), constraint.getXDirectionRAS(null), constraint.getYDirectionRAS(null), constraint.getZDirectionRAS(null), constraint.getVolumeDimensions(null), null);
            this.volCenter.set(center);
        }
    }

    private synchronized void applyContrainingVolume() {
        if (!this.initalized_) {
            return;
        }
        int[] dims = this.targetVolume.getVolumeDimensions(null);
        if (this.useImageDims) {
            this.setPixelDimension(new Dimension(dims[0], dims[1]));
        }
        if (this.center == null || this.getCenterOnVolume() || this.getFitToVolume()) {
            if (this.center == null) {
                this.center = new CPoint();
            }
            this.center.setPoint(this.volCenter);
        }
        if (this.center.csystem != 2) {
            this.convertPointToRAS(this.center);
        }
        if (!J3DGeomUtils.isInVolume(this.center.generateArray(), dims, this.ras2vox)) {
            this.center.setPoint(this.volCenter);
        }
        if ((this.reformatPlane == null || "".equals(this.reformatPlane)) && this.normalVec == null) {
            this.reformatPlane = "OB_AXIAL";
            this.alignedToVolume = true;
        }
        if (this.normalVec == null) {
            double[] norm = this.calculateNormal();
            this.normalVec = new CPoint();
            if (norm != null) {
                this.normalVec.setPoint(norm[0], norm[1], norm[2], (byte)2);
            }
        }
        this.normalVec.normalize();
        if (this.normalVec.csystem != 2) {
            this.convertVectorToRAS(this.normalVec);
        }
        if (this.thickness == 0.0) {
            this.thickness = J3DGeomUtils.getMinSliceThickness(this.targetVolume, this.normalVec.toArray(), false);
        }
        if (this.spacing == 0.0) {
            this.spacing = this.thickness;
        }
        this.calculateSliceUpVector();
        double[] eye = new double[]{this.center.x + this.normalVec.x, this.center.y + this.normalVec.y, this.center.z + this.normalVec.z};
        double[] dfov = J3DGeomUtils.getBestFitDfov(this.targetVolume, this.center.toArray(), this.upVec.toArray(), eye);
        if (this.fov <= 0.0 || (this.getFitFovToVolume() || this.getFitToVolume()) && this.fov != Math.max(dfov[0], dfov[1])) {
            this.fov = Math.max(dfov[0], dfov[1]);
        }
        this.adjustStartEnd(true);
        this.alignedToZ = false;
        if (JnVector3d.cross(this.targetVolume.getZDirectionRAS(null), this.normalVec.toArray()).magnitude() <= 0.001) {
            this.alignedToZ = true;
        }
        this.pcs.firePropertyChange("BATCHMODEL_UPDATED_PROPERTY", false, true);
    }

    private double[] calculateNormal() {
        double[] normal = null;
        if (this.reformatPlane != null && !"".equals(this.reformatPlane)) {
            double[] direction = null;
            if ("AXIAL".equals(this.reformatPlane)) {
                direction = REFORMAT_DIRECTION_S_TO_I.equals(this.reformatDirection) ? new double[]{0.0, 0.0, -1.0} : new double[]{0.0, 0.0, 1.0};
            } else if ("CORONAL".equals(this.reformatPlane)) {
                direction = REFORMAT_DIRECTION_P_TO_A.equals(this.reformatDirection) ? new double[]{0.0, 1.0, 0.0} : new double[]{0.0, -1.0, 0.0};
            } else if ("SAGITTAL".equals(this.reformatPlane)) {
                direction = REFORMAT_DIRECTION_R_TO_L.equals(this.reformatDirection) ? new double[]{-1.0, 0.0, 0.0} : new double[]{1.0, 0.0, 0.0};
            } else if ("OB_AXIAL".equals(this.reformatPlane)) {
                direction = REFORMAT_DIRECTION_S_TO_I.equals(this.reformatDirection) || REFORMAT_DIRECTION_P_TO_A.equals(this.reformatDirection) || REFORMAT_DIRECTION_R_TO_L.equals(this.reformatDirection) ? new double[]{-this.sside.x, -this.sside.y, -this.sside.z} : new double[]{this.sside.x, this.sside.y, this.sside.z};
            } else if ("OB_CORONAL".equals(this.reformatPlane)) {
                direction = REFORMAT_DIRECTION_S_TO_I.equals(this.reformatDirection) || REFORMAT_DIRECTION_P_TO_A.equals(this.reformatDirection) || REFORMAT_DIRECTION_R_TO_L.equals(this.reformatDirection) ? new double[]{this.aside.x, this.aside.y, this.aside.z} : new double[]{-this.aside.x, -this.aside.y, -this.aside.z};
            } else if ("OB_SAGITTAL".equals(this.reformatPlane)) {
                direction = REFORMAT_DIRECTION_S_TO_I.equals(this.reformatDirection) || REFORMAT_DIRECTION_P_TO_A.equals(this.reformatDirection) || REFORMAT_DIRECTION_R_TO_L.equals(this.reformatDirection) ? new double[]{-this.rside.x, -this.rside.y, -this.rside.z} : new double[]{this.rside.x, this.rside.y, this.rside.z};
            }
            normal = new double[]{-direction[0], -direction[1], -direction[2]};
            JnVector3d.normalize(normal);
        }
        return normal;
    }

    private void calculateSliceUpVector() {
        short rfmtPlane;
        if (this.upVec == null) {
            this.upVec = new JnVector3d();
        }
        if ((rfmtPlane = J3DGeomUtils.getPlaneType(this.normalVec)) == 2 || rfmtPlane == 18) {
            if (this.alignedToVolume) {
                this.upVec.set(this.aside);
            } else {
                this.upVec.set(0.0, 1.0, 0.0);
            }
        } else if (rfmtPlane == 8 || rfmtPlane == 4 || rfmtPlane == 24 || rfmtPlane == 20) {
            if (this.alignedToVolume) {
                this.upVec.set(this.sside);
            } else {
                this.upVec.set(0.0, 0.0, 1.0);
            }
        }
        JnVector3d rightVec = new JnVector3d();
        JnVector3d.cross(this.upVec, this.normalVec, rightVec);
        JnVector3d.cross(this.normalVec, rightVec, this.upVec);
        this.upVec.normalize();
    }

    private void calculateStartEnd(boolean constraintToVolume) {
        if (!this.initalized_) {
            return;
        }
        if (this.start == null) {
            this.start = new CPoint(2);
        }
        if (this.end == null) {
            this.end = new CPoint(2);
        }
        if (this.numImages > 1) {
            this.start.setPoint(this.center);
            this.start.scaleAdd((double)(this.numImages - 1) * this.spacing * 0.5, this.normalVec);
            this.end.setPoint(this.center);
            this.end.scaleAdd((double)(-(this.numImages - 1)) * this.spacing * 0.5, this.normalVec);
        } else {
            JnVector3d temp = new JnVector3d();
            double diagonal = temp.sub(this.volCenter, this.rasOrig).magnitude() * 2.0;
            this.start.setPoint(this.center);
            this.end.setPoint(this.center);
            this.start.scaleAdd(diagonal, this.normalVec);
            this.end.scaleAdd(-diagonal, this.normalVec);
            constraintToVolume = true;
        }
        if (constraintToVolume) {
            this.constraintStartEnd();
        }
    }

    private void constraintStartEnd() {
        int[] dims;
        double[] intersectionTValues;
        JnVector3d axisVec = new JnVector3d();
        axisVec.sub(this.end, this.start);
        boolean autoedge = this.isAutoEdgeEnabled() && this.boundingBox != null;
        XjVolumeGeometry vol = autoedge ? this.boundingBox : this.targetVolume;
        CTransform v2ras = this.vox2ras;
        CTransform ras2v = this.ras2vox;
        if (autoedge) {
            J3DGeomUtils.calculateVoxelRASTransforms(vol, this.vox2ras_ae, this.ras2vox_ae);
            v2ras = this.vox2ras_ae;
            ras2v = this.ras2vox_ae;
        }
        JnVector3d ulc = new JnVector3d();
        JnVector3d xside = new JnVector3d();
        JnVector3d yside = new JnVector3d();
        JnVector3d zside = new JnVector3d();
        J3DGeomUtils.getWorldBounds(vol, ulc, xside, yside, zside);
        int axis = J3DGeomUtils.alignedToVolumeXYZ(this.ras2vox, axisVec);
        if (axis != -1) {
            double thk = this.getThickness();
            double[] dx = this.targetVolume.getXDirectionRAS(null);
            double[] dy = this.targetVolume.getYDirectionRAS(null);
            double[] dz = this.targetVolume.getZDirectionRAS(null);
            if (axis == 0 && thk > JnVector3d.length(dx)) {
                double s2 = thk / JnVector3d.length(dx);
                ulc.scaleAdd(s2 * 0.5, dx);
                xside.scaleAdd(-s2, dx);
            } else if (axis == 1 && thk > JnVector3d.length(dy)) {
                double s3 = thk / JnVector3d.length(dy);
                ulc.scaleAdd(s3 * 0.5, dy);
                yside.scaleAdd(-s3, dy);
            } else if (axis == 2 && thk > JnVector3d.length(dz)) {
                double s4 = thk / JnVector3d.length(dz);
                ulc.scaleAdd(-0.5, dz);
                ulc.scaleAdd(s4 * 0.5, dz);
                zside.scaleAdd(-s4, dz);
            }
        }
        if ((intersectionTValues = GeomUtils.lineParallelepipedIntersection(this.start, axisVec, ulc, xside, yside, zside)) == null || intersectionTValues[0] < 0.0 && intersectionTValues[1] < 0.0 || intersectionTValues[0] > 1.0 && intersectionTValues[1] > 1.0) {
            String msg = "Could not find intersection with constraining volume. Moving it to center of the constraining volume\n\tVolume Origin = " + ulc + "\n\tVolume Edge 0 = " + xside + "\n\tVolume Edge 1 = " + yside + "\n\tVolume Edge 2 = " + zside + "\n\tModel start = " + this.start + "\n\tModel end = " + this.end;
            this.logger.log(Level.WARNING, msg);
            CPoint center = new CPoint(this.volCenter);
            if (autoedge) {
                dims = vol.getVolumeDimensions(null);
                if (!J3DGeomUtils.isInVolume(center.generateArray(), dims, ras2v)) {
                    double[] c2 = XjVolumeUtils.getVolumeCenterRAS(vol.getRASOfOrigin(null), vol.getXDirectionRAS(null), vol.getYDirectionRAS(null), vol.getZDirectionRAS(null), dims, null);
                    center.set(c2);
                }
            }
            this.setCenter(center);
            return;
        }
        axisVec.sub(this.end, this.start);
        CPoint newStart = new CPoint(this.start);
        CPoint newEnd = new CPoint(this.end);
        if (intersectionTValues[0] > 0.0 && intersectionTValues[1] > 0.0) {
            double startT = intersectionTValues[0] < intersectionTValues[1] ? intersectionTValues[0] : intersectionTValues[1];
            newStart.scaleAdd(startT, axisVec);
        }
        if (intersectionTValues[0] < 1.0 && intersectionTValues[1] < 1.0) {
            double endT = intersectionTValues[0] > intersectionTValues[1] ? intersectionTValues[0] : intersectionTValues[1];
            newEnd.set(this.start);
            newEnd.scaleAdd(endT, axisVec);
        }
        this.start.setPoint(newStart);
        this.end.setPoint(newEnd);
        dims = vol.getVolumeDimensions(null);
        CPoint voxpt = new CPoint(5);
        ras2v.transform(this.start, voxpt);
        double d2 = voxpt.x < 0.0 ? (voxpt.x = 0.0) : (voxpt.x = voxpt.x > (double)(dims[0] - 1) ? (voxpt.x = (double)(dims[0] - 1)) : voxpt.x);
        double d3 = voxpt.y < 0.0 ? (voxpt.y = 0.0) : (voxpt.y = voxpt.y > (double)(dims[1] - 1) ? (voxpt.y = (double)(dims[1] - 1)) : voxpt.y);
        voxpt.z = voxpt.z < 0.0 ? (voxpt.z = 0.0) : (voxpt.z > (double)(dims[2] - 1) ? (voxpt.z = (double)(dims[2] - 1)) : voxpt.z);
        v2ras.transform(voxpt, this.start);
        ras2v.transform(this.end, voxpt);
        double d4 = voxpt.x < 0.0 ? (voxpt.x = 0.0) : (voxpt.x = voxpt.x > (double)(dims[0] - 1) ? (voxpt.x = (double)(dims[0] - 1)) : voxpt.x);
        double d5 = voxpt.y < 0.0 ? (voxpt.y = 0.0) : (voxpt.y = voxpt.y > (double)(dims[1] - 1) ? (voxpt.y = (double)(dims[1] - 1)) : voxpt.y);
        voxpt.z = voxpt.z < 0.0 ? (voxpt.z = 0.0) : (voxpt.z > (double)(dims[2] - 1) ? (voxpt.z = (double)(dims[2] - 1)) : voxpt.z);
        v2ras.transform(voxpt, this.end);
    }

    private void adjustStartEnd(boolean constraintToVolume) {
        if (this.initalized_) {
            int oldnumimgs = this.numImages;
            CPoint oldcenter = this.getCenter();
            this.calculateStartEnd(constraintToVolume || this.getFitToVolume());
            this.center.setPoint(this.start);
            this.center.add(this.end);
            this.center.scale(0.5);
            double centerLineMag = CPoint.distance(this.start.toArray(), this.end.toArray());
            int num = 1 + (int)Math.rint(centerLineMag / this.getSpacing());
            if (num <= 1) {
                num = 2;
            }
            this.numImages = num;
            this.calculateStartEnd(false);
            this.pcs.firePropertyChange("NUM_IMAGES_PROPERTY", oldnumimgs, this.numImages);
            this.pcs.firePropertyChange(CENTER_POINT_PROPERTY, oldcenter, new CPoint(this.center));
        }
    }

    @Override
    public synchronized double getFov() {
        return super.getFov();
    }

    @Override
    public synchronized void setFov(double fov) {
        if (this.initalized_ && (fov <= 0.0 || this.getFitFovToVolume() || this.getFitToVolume())) {
            double[] eye = new double[]{this.center.x + this.normalVec.x, this.center.y + this.normalVec.y, this.center.z + this.normalVec.z};
            double[] dfov = J3DGeomUtils.getBestFitDfov(this.targetVolume, this.center.toArray(), this.upVec.toArray(), eye);
            if (fov <= 0.0 || fov != Math.max(dfov[0], dfov[1])) {
                fov = Math.max(dfov[0], dfov[1]);
            }
        }
        super.setFov(fov);
    }

    @Override
    public synchronized void setFitFovToVolume(boolean fitFov) {
        super.setFitFovToVolume(fitFov);
        if (this.getFitFovToVolume()) {
            this.setFov(this.getFov());
        }
    }

    public synchronized CPoint getCenter() {
        return new CPoint(this.center);
    }

    public synchronized void setCenter(CPoint center) {
        CPoint oldcenter;
        CPoint cPoint = oldcenter = this.center == null ? null : new CPoint(this.center);
        if (this.center == null) {
            this.center = new CPoint();
        }
        if (this.initalized_ && (this.getCenterOnVolume() || this.getFitToVolume())) {
            this.center.setPoint(this.volCenter);
        } else {
            this.center.setPoint(center);
        }
        if (this.initalized_) {
            int[] dims = this.targetVolume.getVolumeDimensions(null);
            if (!J3DGeomUtils.isInVolume(this.center.generateArray(), dims, this.ras2vox)) {
                this.center.setPoint(this.volCenter);
            }
        }
        if (!this.center.equals(oldcenter)) {
            if (this.initalized_) {
                this.adjustStartEnd(this.getFitToVolume());
            } else {
                this.pcs.firePropertyChange(CENTER_POINT_PROPERTY, oldcenter, new CPoint(this.center));
            }
        }
    }

    @Override
    public synchronized void setCenterOnVolume(boolean center) {
        super.setCenterOnVolume(center);
        if (this.getCenterOnVolume()) {
            this.setCenter(this.getCenter());
        }
    }

    public synchronized void setCenterLine(CPoint start, CPoint end) {
        if (start.equals(end)) {
            String msg = "Attempting to set the center line with start == end.  Ignoring new start and end, but setting center to (" + start.x + "," + start.y + "," + start.z + ")";
            this.logger.log(Level.INFO, "{0} SEV6 " + msg, "TID=VAV_BATCH_PROTOCOL");
            this.setCenter(start);
            return;
        }
        this.center = new CPoint(start);
        this.center.add(end);
        this.center.scale(0.5);
        this.normalVec = new CPoint(start);
        this.normalVec.sub(end);
        this.normalVec.normalize();
        this.applyContrainingVolume();
    }

    @Override
    public synchronized void setFitToVolume(boolean fit2vol) {
        super.setFitToVolume(fit2vol);
        if (this.getFitToVolume()) {
            this.setCenter(this.getCenter());
            this.setFov(this.getFov());
            this.numImages = 0;
            this.adjustStartEnd(true);
        }
    }

    public synchronized double getSpacing() {
        return this.spacing;
    }

    public synchronized void setSpacing(double spacing) {
        this.setSpacing(spacing, true);
    }

    public synchronized void setSpacing(double spacing, boolean updateNumImages) {
        double oldSpacing = this.getSpacing();
        if (this.getSpacing() != spacing) {
            if (spacing < 0.0) {
                String msg = "Attempting to set invalid spacing (" + spacing + "). Spacing must be greater than zero. Converting to a positive value.";
                this.logger.log(Level.WARNING, "{0} SEV6 " + msg, "TID=VAV_BATCH_PROTOCOL");
                spacing = -spacing;
            }
            this.spacing = spacing;
            if (updateNumImages && this.start != null && this.end != null) {
                int oldnumimgs = this.numImages;
                double centerLineMag = CPoint.distance(this.start.toArray(), this.end.toArray());
                int num = 1 + (int)Math.rint(centerLineMag / this.getSpacing());
                if (num <= 1) {
                    num = 2;
                }
                this.numImages = num;
                this.pcs.firePropertyChange("NUM_IMAGES_PROPERTY", oldnumimgs, this.numImages);
            }
            this.calculateStartEnd(false);
            this.pcs.firePropertyChange(SPACING_PROPERTY, oldSpacing, this.spacing);
        }
    }

    @Override
    public synchronized int getNumImages() {
        return this.numImages;
    }

    public synchronized void setNumImages(int numImages) {
        this.setNumImages(numImages, true);
    }

    public synchronized void setNumImages(int numImages, boolean updateSpacing) {
        int oldNumImages = this.numImages;
        if (oldNumImages != numImages) {
            String msg;
            if (numImages < -1) {
                msg = "Attempting to set invalid number of images (" + numImages + "). Number of images must be greater than one. Converting to a positive value.";
                this.logger.log(Level.WARNING, "{0} SEV6 " + msg, "TID=VAV_BATCH_PROTOCOL");
                numImages = -numImages;
            } else if (numImages <= 1) {
                msg = "Attempting to set invalid number of images (" + numImages + "). Number of images must be greater than one. Reverting to previous number of images (" + this.numImages + ").";
                this.logger.log(Level.WARNING, "{0} SEV6 " + msg, "TID=VAV_BATCH_PROTOCOL");
                numImages = this.numImages;
            }
            this.numImages = numImages;
            if (updateSpacing && this.start != null && this.end != null) {
                double spc;
                double oldspc = this.spacing;
                double centerLineMag = CPoint.distance(this.start.toArray(), this.end.toArray());
                this.spacing = spc = centerLineMag / (double)(this.numImages - 1);
                this.pcs.firePropertyChange(SPACING_PROPERTY, oldspc, this.spacing);
            }
            this.calculateStartEnd(false);
            this.pcs.firePropertyChange("NUM_IMAGES_PROPERTY", oldNumImages, this.numImages);
        }
    }

    public synchronized CPoint getNormal() {
        return new CPoint(this.normalVec);
    }

    public synchronized void setNormal(CPoint normal) {
        if (normal != null && !normal.equals(this.normalVec)) {
            if (this.normalVec == null) {
                this.normalVec = new CPoint();
            }
            this.normalVec.setPoint(normal);
            this.reformatPlane = "";
            this.applyContrainingVolume();
            this.pcs.firePropertyChange(NORMAL_VEC_PROPERTY, null, this.normalVec.toArray());
        }
    }

    public synchronized String getReformatPlane() {
        return this.reformatPlane;
    }

    public synchronized void setReformatPlane(String reformatPlane) {
        if (reformatPlane != null && !"".equals(reformatPlane)) {
            this.reformatPlane = reformatPlane;
            if ("AXIAL".equals(this.reformatPlane) || "CORONAL".equals(this.reformatPlane) || "SAGITTAL".equals(this.reformatPlane)) {
                this.alignedToVolume = false;
            }
            this.normalVec = null;
            this.start = null;
            this.end = null;
            this.applyContrainingVolume();
        }
    }

    public synchronized void setReformatDirection(String reformatDirection) {
        if (reformatDirection != null) {
            this.reformatDirection = reformatDirection;
            this.applyContrainingVolume();
        }
    }

    public synchronized void setZInterpolation(boolean zinterpolation) {
        this.zinterpolation = zinterpolation;
    }

    public synchronized boolean getZInterpolation() {
        return this.zinterpolation;
    }

    @Override
    public double[] getSliceEyePoint(int i2, double[] eye_pt) {
        if (i2 >= 0 && i2 < this.getNumImages()) {
            eye_pt = this.getSliceLookPoint(i2, eye_pt);
            boolean flip = false;
            int majorComp = this.majorVectorComponent(this.normalVec);
            if (majorComp == 0 && this.normalVec.x > 0.0) {
                flip = true;
            } else if (majorComp == 1 && this.normalVec.y < 0.0) {
                flip = true;
            } else if (majorComp == 2 && this.normalVec.z > 0.0) {
                flip = true;
            }
            if (flip) {
                eye_pt[0] = eye_pt[0] - this.normalVec.x;
                eye_pt[1] = eye_pt[1] - this.normalVec.y;
                eye_pt[2] = eye_pt[2] - this.normalVec.z;
            } else {
                eye_pt[0] = eye_pt[0] + this.normalVec.x;
                eye_pt[1] = eye_pt[1] + this.normalVec.y;
                eye_pt[2] = eye_pt[2] + this.normalVec.z;
            }
            return eye_pt;
        }
        return null;
    }

    private synchronized boolean isAlignedToZ() {
        return this.alignedToZ;
    }

    @Override
    public double[] getSliceLookPoint(int i2, double[] look_pt) {
        if ((look_pt = this.getActualSliceLookPoint(i2, look_pt)) != null && this.isAlignedToZ() && !this.getZInterpolation()) {
            JnVector3d tmp = new JnVector3d(look_pt);
            this.ras2vox.transform(tmp);
            tmp.z = Math.rint(tmp.z);
            this.vox2ras.transform(tmp);
            look_pt[0] = tmp.x;
            look_pt[1] = tmp.y;
            look_pt[2] = tmp.z;
        }
        return look_pt;
    }

    public synchronized double[] getActualSliceLookPoint(int i2, double[] look_pt) {
        if (i2 >= 0 && i2 < this.getNumImages()) {
            if (look_pt == null) {
                look_pt = new double[3];
            }
            this.normalVec.normalize();
            look_pt[0] = this.start.x - this.normalVec.x * (double)i2 * this.spacing;
            look_pt[1] = this.start.y - this.normalVec.y * (double)i2 * this.spacing;
            look_pt[2] = this.start.z - this.normalVec.z * (double)i2 * this.spacing;
            return look_pt;
        }
        return null;
    }

    @Override
    public double[] getSliceUp(int i2, double[] up_vect) {
        if (i2 >= 0 && i2 < this.getNumImages()) {
            if (up_vect == null) {
                up_vect = new double[]{this.upVec.x, this.upVec.y, this.upVec.z};
            }
            return up_vect;
        }
        return null;
    }

    @Override
    public XpSlice getSlice(int i2) {
        int pw = this.getPixelWidth();
        int ph = this.getPixelHeight();
        double viewHeight = this.getFov();
        double[] lookPoint = this.getSliceLookPoint(i2, null);
        double[] eyePoint = this.getSliceEyePoint(i2, null);
        double aratio = pw / ph;
        double viewWidth = viewHeight * aratio;
        double spx = viewWidth / (double)pw;
        double spy = viewHeight / (double)ph;
        JnVector3d normV = new JnVector3d(eyePoint[0] - lookPoint[0], eyePoint[1] - lookPoint[1], eyePoint[2] - lookPoint[2]);
        JnVector3d rightVec = new JnVector3d();
        JnVector3d.cross(this.upVec, normV, rightVec);
        rightVec.normalize();
        this.ul.x = lookPoint[0] - (double)(pw - 1) * 0.5 * rightVec.x * spx + (double)(ph - 1) * 0.5 * this.upVec.x * spy;
        this.ul.y = lookPoint[1] - (double)(pw - 1) * 0.5 * rightVec.y * spx + (double)(ph - 1) * 0.5 * this.upVec.y * spy;
        this.ul.z = lookPoint[2] - (double)(pw - 1) * 0.5 * rightVec.z * spx + (double)(ph - 1) * 0.5 * this.upVec.z * spy;
        this.ur.x = lookPoint[0] + (double)(pw - 1) * 0.5 * rightVec.x * spx + (double)(ph - 1) * 0.5 * this.upVec.x * spy;
        this.ur.y = lookPoint[1] + (double)(pw - 1) * 0.5 * rightVec.y * spx + (double)(ph - 1) * 0.5 * this.upVec.y * spy;
        this.ur.z = lookPoint[2] + (double)(pw - 1) * 0.5 * rightVec.z * spx + (double)(ph - 1) * 0.5 * this.upVec.z * spy;
        this.br.x = lookPoint[0] + (double)(pw - 1) * 0.5 * rightVec.x * spx - (double)(ph - 1) * 0.5 * this.upVec.x * spy;
        this.br.y = lookPoint[1] + (double)(pw - 1) * 0.5 * rightVec.y * spx - (double)(ph - 1) * 0.5 * this.upVec.y * spy;
        this.br.z = lookPoint[2] + (double)(pw - 1) * 0.5 * rightVec.z * spx - (double)(ph - 1) * 0.5 * this.upVec.z * spy;
        return new XpSlice(this.ul, this.ur, this.br, pw, ph);
    }

    @Override
    public void setBoundingBox(XjVolumeGeometry boundingBox) {
        if (boundingBox == null || !this.initalized_) {
            this.logger.log(Level.INFO, "{0} Model not initialized yet with the constrainign volume", "TID=VAV_BATCH_PROTOCOL");
            return;
        }
        JnVector3d bvecx = new JnVector3d(boundingBox.getXDirectionRAS(null));
        JnVector3d vvecx = new JnVector3d(this.targetVolume.getXDirectionRAS(null));
        JnVector3d bvecy = new JnVector3d(boundingBox.getYDirectionRAS(null));
        JnVector3d vvecy = new JnVector3d(this.targetVolume.getYDirectionRAS(null));
        JnVector3d bvecz = new JnVector3d(boundingBox.getZDirectionRAS(null));
        JnVector3d vvecz = new JnVector3d(this.targetVolume.getZDirectionRAS(null));
        if (!(bvecx.equals(vvecx) && bvecy.equals(vvecy) && bvecz.equals(vvecz))) {
            String msg = "Bounding box direction vectors not same as target volume, so ignoring it\n\tBBox X direction vector = " + bvecx + "\n\tBBox Y direction vector = " + bvecy + "\n\tBBox Z direction vector = " + bvecz + "\n\tVolume X direction vector = " + vvecx + "\n\tVolume Y direction vector = " + vvecy + "\n\tVolume Z direction vector = " + vvecz;
            this.logger.log(Level.WARNING, "{0} Sev6 " + msg, "TID=VAV_BATCH_PROTOCOL");
            return;
        }
        int[] dims = boundingBox.getVolumeDimensions(null);
        if (dims[0] <= 0 || dims[1] <= 0 || dims[2] <= 0) {
            String msg = "One or more of the bounding box dimensions are zero, so ignoring it\n\tBBox X dimension = " + dims[0] + "\n\tBBox Y dimension = " + dims[1] + "\n\tBBox Z dimension = " + dims[2];
            this.logger.log(Level.WARNING, "{0} Sev6 " + msg, "TID=VAV_BATCH_PROTOCOL");
            return;
        }
        super.setBoundingBox(boundingBox);
        if (this.isAutoEdgeEnabled() && this.boundingBox != null) {
            this.init();
            this.applyContrainingVolume();
        }
    }

    @Override
    public void enableAutoEdge(boolean doAutoEdge) {
        super.enableAutoEdge(doAutoEdge);
        if (this.isAutoEdgeEnabled() && this.initalized_ && this.boundingBox != null) {
            this.applyContrainingVolume();
        }
    }

    private void convertPointToRAS(CPoint point) {
        if (!this.isTargetSet()) {
            return;
        }
        if (point.csystem != 2) {
            if (this.targetViewport != null) {
                if (point.csystem == 3) {
                    point.x *= (double)this.targetViewport.getWidth();
                    point.y *= (double)this.targetViewport.getHeight();
                    point.z = 0.0;
                    point.csystem = 1;
                }
                CPoint newPoint = this.targetViewport.getT3DComponent().transform(point, (byte)2);
                point.setPoint(newPoint);
            } else if (this.refViewPlane != null) {
                if (5 == point.csystem) {
                    CPoint pointras = new CPoint(2);
                    this.vox2ras.transform(point, pointras);
                    point.setPoint(pointras);
                } else if (1 == point.csystem || 3 == point.csystem) {
                    if (point.csystem == 3) {
                        point.x *= 512.0;
                        point.y *= 512.0;
                        point.z = 0.0;
                        point.csystem = 1;
                    }
                    CPoint c2 = new CPoint(this.volCenter);
                    double[] diff = new double[]{point.x - 256.0, point.y - 256.0, 0.0};
                    CPoint cvox = new CPoint(5);
                    this.ras2vox.transform(c2, cvox);
                    cvox.add(diff);
                    this.vox2ras.transform(cvox, c2);
                    point.setPoint(c2);
                }
            }
        }
    }

    private void convertVectorToRAS(CPoint vector) {
        if (!this.isTargetSet()) {
            return;
        }
        if (vector.csystem != 2) {
            if (this.targetViewport != null) {
                System.err.println(">>>>>>>>>>>>>>>>> " + Math.toDegrees(Math.atan2(vector.y, vector.x)));
                CPoint c2 = new CPoint((double)this.targetViewport.getWidth() * 0.5, (double)this.targetViewport.getHeight() * 0.5, 0.0, 1);
                CPoint cras = this.targetViewport.getT3DComponent().transform(c2, (byte)2);
                CPoint cvec = this.targetViewport.getT3DComponent().transform(c2, vector.csystem);
                cvec.add(vector);
                CPoint cras2 = this.targetViewport.getT3DComponent().transform(cvec, (byte)2);
                vector.setPoint(cras2);
                vector.sub(cras);
            } else if (5 == vector.csystem) {
                this.vox2ras.transform(vector);
                vector.csystem = (byte)2;
            } else if ((1 == vector.csystem || 3 == vector.csystem) && this.refViewPlane != null) {
                CPoint c3 = new CPoint(this.volCenter);
                CPoint normal = new CPoint(2);
                CPoint up = new CPoint(2);
                CPoint right = new CPoint(2);
                this.calculateSliceXYZVectors(this.refViewPlane, normal, up, right);
                c3.scaleAdd(vector.x, right);
                c3.scaleAdd(-vector.y, up);
                vector.setPoint(c3);
                vector.sub(this.volCenter);
            }
        }
    }

    private void calculateSliceXYZVectors(String refViewPlane, CPoint normal, CPoint up, CPoint right) {
        if (normal == null || up == null || right == null) {
            return;
        }
        if ("AXIAL".equals(refViewPlane)) {
            normal.set(0.0, 0.0, -1.0);
            up.set(0.0, 1.0, 0.0);
        } else if ("OB_AXIAL".equals(refViewPlane)) {
            normal.set(-this.sside.x, -this.sside.y, -this.sside.z);
            up.set(this.aside.x, this.aside.y, this.aside.z);
        } else if ("CORONAL".equals(refViewPlane)) {
            normal.set(0.0, 1.0, 0.0);
            up.set(0.0, 0.0, 1.0);
        } else if ("OB_CORONAL".equals(refViewPlane)) {
            normal.set(this.aside.x, this.aside.y, this.aside.z);
            up.set(this.sside.x, this.sside.y, this.sside.z);
        } else if ("SAGITTAL".equals(refViewPlane)) {
            normal.set(-1.0, 0.0, 0.0);
            up.set(0.0, 0.0, 1.0);
        } else if ("OB_SAGITTAL".equals(refViewPlane)) {
            normal.set(-this.rside.x, -this.rside.y, -this.rside.z);
            up.set(this.sside.x, this.sside.y, this.sside.z);
        }
        normal.normalize();
        JnVector3d.cross(up, normal, right);
        JnVector3d.cross(normal, right, up);
        up.normalize();
        right.normalize();
    }

    protected int majorVectorComponent(JnVector3d vec) {
        if (Math.abs(vec.z) >= Math.abs(vec.x) && Math.abs(vec.z) >= Math.abs(vec.y)) {
            return 2;
        }
        if (Math.abs(vec.x) >= Math.abs(vec.y)) {
            return 0;
        }
        return 1;
    }
}

