/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.log;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.management.ManagementFactory;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;

public class LogFormatter
extends Formatter {
    private final String newline_regex = "[\n]";
    private final String pid = "" + LogFormatter.getPid();

    @Override
    public synchronized String format(LogRecord record) {
        StringBuffer result = new StringBuffer();
        SimpleDateFormat sdf = new SimpleDateFormat("dd MMM yyyy HH:mm:ss:SSS", Locale.US);
        result.append(record.getLevel().getName());
        result.append(":");
        result.append(this.pid);
        result.append(":");
        result.append(sdf.format(new Date(record.getMillis())));
        result.append(" ");
        if (record.getSourceClassName() != null) {
            result.append(":");
            result.append(record.getSourceClassName());
        } else {
            result.append(";");
            result.append(record.getLoggerName());
        }
        if (record.getSourceMethodName() != null) {
            result.append(";");
            result.append(record.getSourceMethodName());
        }
        String message = this.formatMessage(record);
        result.append(";");
        result.append(message.replaceAll("[\n]", "\\n"));
        Object[] params = record.getParameters();
        for (int i2 = 0; params != null && i2 < params.length; ++i2) {
            if (!(params[i2] instanceof Throwable)) continue;
            result.append(" trace: ");
            try {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                ((Throwable)params[i2]).printStackTrace(pw);
                pw.close();
                result.append(sw.toString().replaceAll("[\n]", "\\n"));
                continue;
            }
            catch (Exception ex) {
                result.append("<error: " + ex.getMessage() + ">");
            }
        }
        if (record.getThrown() != null) {
            try {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                record.getThrown().printStackTrace(pw);
                pw.close();
                result.append(" trace: ");
                result.append(sw.toString().replaceAll("[\n]", "\\n"));
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        result.append('\n');
        return result.toString();
    }

    public static String toLoggableString(Object[] array) {
        if (array == null) {
            return "<null>";
        }
        if (array.length == 0) {
            return "{}";
        }
        StringBuffer buf = new StringBuffer("{");
        int len = array.length;
        if (len > 3) {
            len = 3;
        }
        for (int i2 = 0; i2 < len; ++i2) {
            Object arg = array[i2];
            if (arg instanceof Object[]) {
                buf.append(LogFormatter.toLoggableString((Object[])array[i2]));
            } else {
                buf.append(array[i2].toString());
            }
            buf.append(", ");
        }
        if (len < array.length) {
            buf.append("...");
        }
        buf.append('}');
        return buf.toString();
    }

    private static int getPid() {
        try {
            return Integer.parseInt(ManagementFactory.getRuntimeMXBean().getName().split("@")[1]);
        }
        catch (Exception ex) {
            return -1;
        }
    }
}

