/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.model;

import com.ge.med.cse.cvf.util.CvPropertiesManager;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.prefs.Preferences;

public class WWWLModel {
    public static final String CONTENT_CHANGED = "WWWLModel_changed";
    private static Preferences cvprefs = CvPropertiesManager.getUserPreferences();
    private static Map<String, WWWLModel> modalityMap = new HashMap<String, WWWLModel>();
    private String myModality = null;
    private PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private DecimalFormat format = new DecimalFormat("###0.#E0");
    private String defPreset = null;
    private String defKeys = null;
    private String defPresetValue = null;
    private String defPresetTitle = null;
    private static final String supportedMod = CvPropertiesManager.getProperty("cvf.modalities", "");
    private StringBuffer buf = new StringBuffer();

    public static WWWLModel getModel(String modality) {
        if (modality != null) {
            modality = modality.trim().toLowerCase(Locale.ENGLISH);
        }
        if (modality == null || !supportedMod.trim().contains(modality)) {
            modality = "default";
        }
        if (!modalityMap.containsKey(modality)) {
            modalityMap.put(modality, new WWWLModel(modality));
        }
        return modalityMap.get(modality);
    }

    private WWWLModel(String strmod) {
        this.myModality = strmod.trim().toLowerCase(Locale.ENGLISH);
        this.defPreset = CvPropertiesManager.getProperty("cvf.wwwlpresets." + this.myModality);
        if (this.defPreset == null) {
            this.defPreset = CvPropertiesManager.getProperty("cvf.wwwlpresets.default");
            this.defKeys = CvPropertiesManager.getProperty("cvf.wwwlpresets.default.keys");
            this.defPresetTitle = CvPropertiesManager.getProperty("cvf.wwwlpresets.default.title");
            this.defPresetValue = CvPropertiesManager.getProperty("cvf.wwwlpresets.default.value");
        } else {
            this.defPreset = CvPropertiesManager.getProperty("cvf.wwwlpresets." + this.myModality);
            this.defKeys = CvPropertiesManager.getProperty("cvf.wwwlpresets." + this.myModality + ".keys");
            this.defPresetTitle = CvPropertiesManager.getProperty("cvf.wwwlpresets." + this.myModality + ".title");
            this.defPresetValue = CvPropertiesManager.getProperty("cvf.wwwlpresets." + this.myModality + ".value");
        }
    }

    public String getModality() {
        return this.myModality;
    }

    public String[] getPresets() {
        String preset = cvprefs.get(this.myModality + "_presets", this.defPreset);
        if (preset != null) {
            return preset.split("#");
        }
        return null;
    }

    public String getPresetForKey(String strKey) {
        String shKey = cvprefs.get(this.myModality + "_keys", this.defKeys);
        String[] shKeys = null;
        if (shKey != null) {
            shKeys = shKey.split("#");
        }
        int count = 0;
        if (shKeys != null) {
            for (String strFnKey : shKeys) {
                if (strFnKey.trim().equalsIgnoreCase(strKey.trim())) break;
                ++count;
            }
        }
        return this.getPresets()[count];
    }

    public double[] getWWWL(String strkey) {
        String wwwlStr = cvprefs.get(this.myModality + "_presets_value", this.defPresetValue);
        String[] wwwl = null;
        if (wwwlStr != null) {
            wwwl = wwwlStr.trim().split("#");
        }
        if (wwwl != null && this.getIndex(strkey) >= 0 && this.getIndex(strkey) < wwwl.length) {
            String[] split = wwwl[this.getIndex(strkey)].split(",");
            double[] toReturn = new double[]{Double.parseDouble(split[0]), Double.parseDouble(split[1])};
            toReturn[0] = Double.parseDouble(this.format.format(toReturn[0]));
            toReturn[1] = Double.parseDouble(this.format.format(toReturn[1]));
            return toReturn;
        }
        return null;
    }

    public String getShortCutKey(String strKey) {
        if (strKey != null) {
            String shrtctKey = cvprefs.get(this.myModality + "_presets_keys", this.defKeys);
            String[] Keys = null;
            if (shrtctKey != null) {
                Keys = shrtctKey.split("#");
            }
            if (Keys != null && this.getIndex(strKey) >= 0 && this.getIndex(strKey) < Keys.length) {
                return Keys[this.getIndex(strKey)];
            }
            return null;
        }
        return null;
    }

    public String getTitle(String strKey) {
        String presetTitle = cvprefs.get(this.myModality + "_presets_title", this.defPresetTitle);
        String[] title = null;
        if (presetTitle != null) {
            title = presetTitle.split("#");
        }
        if (title != null && this.getIndex(strKey) >= 0 && this.getIndex(strKey) < title.length) {
            return title[this.getIndex(strKey)];
        }
        return null;
    }

    public void setTitle(String strKey, String strValue) {
        String[] title;
        if (strKey == null || strValue == null) {
            throw new IllegalArgumentException("Null key or value");
        }
        int indexToRep = this.getIndex(strKey);
        String toSet = this.replaceValue(indexToRep, title = cvprefs.get(this.myModality + "_presets_title", this.defPresetTitle).split("#"), strValue);
        if (toSet != null) {
            cvprefs.put(this.myModality + "_presets_title", toSet);
            this.fireChange();
        }
    }

    public void setWWWL(String strKey, double[] val) {
        String strValue;
        String toSet;
        if (strKey == null || val == null) {
            throw new IllegalArgumentException("Null key or value");
        }
        int indexToRep = this.getIndex(strKey);
        String titleStr = cvprefs.get(this.myModality + "_presets_value", this.defPresetValue);
        String[] title = null;
        if (titleStr != null) {
            title = titleStr.split("#");
        }
        if ((toSet = this.replaceValue(indexToRep, title, strValue = val[0] + "," + val[1])) != null) {
            cvprefs.put(this.myModality + "_presets_value", toSet);
            this.fireChange();
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener list) {
        this.pcs.addPropertyChangeListener(CONTENT_CHANGED, list);
    }

    public void removePropertyChangeListener(PropertyChangeListener list) {
        this.pcs.removePropertyChangeListener(CONTENT_CHANGED, list);
    }

    void fireChange() {
        try {
            cvprefs.sync();
            cvprefs.flush();
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        this.pcs.firePropertyChange(CONTENT_CHANGED, null, this);
    }

    private int getIndex(String strKey) {
        String[] presets = this.getPresets();
        if (presets != null && presets.length > 0) {
            for (int i2 = 0; i2 < presets.length; ++i2) {
                if (!presets[i2].trim().equalsIgnoreCase(strKey)) continue;
                return i2;
            }
        }
        return -1;
    }

    private String replaceValue(int index, String[] lookup, String strNewValue) {
        this.buf.delete(0, this.buf.length());
        if (index != -1 && lookup != null && lookup.length > 0 && strNewValue != null) {
            for (int i2 = 0; i2 < lookup.length; ++i2) {
                if (i2 == index) {
                    this.buf.append(strNewValue.trim());
                } else {
                    this.buf.append(lookup[i2]);
                }
                if (i2 == lookup.length - 1) continue;
                this.buf.append("#");
            }
            return this.buf.toString();
        }
        return null;
    }
}

