/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.print;

import com.ge.med.cse.cvf.print.DndPrint;
import com.ge.med.cse.cvf.print.ForcePrint;
import com.ge.med.cse.cvf.print.IOSPrinterJob;
import com.ge.med.cse.cvf.print.PrintRowColFormat;
import com.ge.med.cse.cvf.print.PrinterStatus;
import com.ge.med.terra.jfk.UMAIService;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.print.DocFlavor;
import javax.print.DocPrintJob;
import javax.print.MultiDocPrintService;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.ServiceUIFactory;
import javax.print.attribute.Attribute;
import javax.print.attribute.AttributeSet;
import javax.print.attribute.HashPrintServiceAttributeSet;
import javax.print.attribute.PrintServiceAttribute;
import javax.print.attribute.PrintServiceAttributeSet;
import javax.print.attribute.standard.PrinterName;
import javax.print.event.PrintServiceAttributeListener;

public class IOSPrintService
implements PrintService {
    public static DocFlavor IOS_PRINTABLE = new DocFlavor("application/x-java-IOS-printable-print-service", "java.awt.print.Printable");
    public static DocFlavor IOS_PAGEABLE = new DocFlavor("application/x-java-IOS-pageable-print-service", "java.awt.print.Pageable");
    public static String SERVICE_NAME = "IOSPrintservice";
    private String PRINTER_NAME = System.getProperty("FILMER_NAME");
    static IOSPrintService me = null;
    static IOSPrintServiceLookup mepsl = new IOSPrintServiceLookup();
    Logger logger = Logger.getLogger(this.getClass().getName());
    HashPrintServiceAttributeSet attrset = new HashPrintServiceAttributeSet();

    public IOSPrintService() {
        System.out.println("Printer Name=" + this.PRINTER_NAME);
        this.logger.log(Level.INFO, "IOSPrintService constructor called for Printer {0}", this.PRINTER_NAME);
        try {
            Class<?> caa = null;
            caa = Class.forName("com.ge.med.terra.jfk.JFilmer");
            if (UMAIService.getService((Object)this.PRINTER_NAME) == null) {
                throw new RuntimeException("Error creating UMAI Service");
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return;
        }
    }

    @Override
    public void addPrintServiceAttributeListener(PrintServiceAttributeListener listener) {
    }

    @Override
    public DocPrintJob createPrintJob() {
        this.logger.log(Level.INFO, "create printjob");
        return new IOSPrinterJob(this);
    }

    public String cancel() {
        UMAIService umais = UMAIService.getService((Object)this.PRINTER_NAME);
        if (umais != null) {
            try {
                umais.cancelPrint();
                return "OK";
            }
            catch (Exception e2) {
                return e2.getLocalizedMessage();
            }
        }
        return "ERROR";
    }

    public PrintServiceAttribute getAttribute(Class category) {
        if (category.equals(PrinterName.class)) {
            if (this.attrset.containsKey(PrinterName.class)) {
                return (PrintServiceAttribute)this.attrset.get(PrinterName.class);
            }
            PrinterName pn = new PrinterName(this.PRINTER_NAME, Locale.US);
            this.attrset.add(pn);
            return pn;
        }
        if (category.equals(PrinterStatus.class)) {
            this.logger.log(Level.INFO, "IOSPrintService Printer Status request");
            try {
                boolean isalive = false;
                UMAIService umais = UMAIService.getService();
                if (umais != null && (isalive = umais.isAlive(this.PRINTER_NAME))) {
                    return new PrinterStatus(isalive);
                }
            }
            catch (InterruptedException e2) {
                e2.printStackTrace();
            }
        }
        return null;
    }

    @Override
    public PrintServiceAttributeSet getAttributes() {
        HashPrintServiceAttributeSet hattrset = new HashPrintServiceAttributeSet();
        hattrset.add(this.getAttribute(PrinterStatus.class));
        hattrset.add(this.getAttribute(PrinterName.class));
        return hattrset;
    }

    public Object getDefaultAttributeValue(Class category) {
        if (category.equals(PrintRowColFormat.class)) {
            return new Integer[]{0, 0};
        }
        if (category.equals(PrinterName.class)) {
            return this.PRINTER_NAME;
        }
        return null;
    }

    @Override
    public String getName() {
        return SERVICE_NAME;
    }

    @Override
    public ServiceUIFactory getServiceUIFactory() {
        return null;
    }

    public Class[] getSupportedAttributeCategories() {
        return new Class[]{PrintRowColFormat.class, ForcePrint.class, DndPrint.class, PrinterName.class, PrinterStatus.class};
    }

    public String getSupportedAttributeValues(Class category, DocFlavor flavor, AttributeSet attributes) {
        if (PrintRowColFormat.class.equals((Object)category)) {
            UMAIService umais = UMAIService.getService((Object)this.PRINTER_NAME);
            String result = null;
            if (umais != null) {
                try {
                    result = umais.getPrinterInfo(this.PRINTER_NAME);
                }
                catch (Exception e2) {
                    // empty catch block
                }
            }
            return result;
        }
        return null;
    }

    @Override
    public DocFlavor[] getSupportedDocFlavors() {
        return new DocFlavor[]{DocFlavor.SERVICE_FORMATTED.PRINTABLE, DocFlavor.SERVICE_FORMATTED.PAGEABLE, IOS_PRINTABLE, IOS_PAGEABLE};
    }

    @Override
    public AttributeSet getUnsupportedAttributes(DocFlavor flavor, AttributeSet attributes) {
        return null;
    }

    public boolean isAttributeCategorySupported(Class category) {
        return false;
    }

    @Override
    public boolean isAttributeValueSupported(Attribute attrval, DocFlavor flavor, AttributeSet attributes) {
        return false;
    }

    @Override
    public boolean isDocFlavorSupported(DocFlavor flavor) {
        if (DocFlavor.SERVICE_FORMATTED.PRINTABLE == flavor) {
            return true;
        }
        if (DocFlavor.SERVICE_FORMATTED.PAGEABLE == flavor) {
            return true;
        }
        return flavor.getMimeType().equals(IOS_PRINTABLE.getMimeType()) || flavor.getMimeType().equals(IOS_PAGEABLE.getMimeType());
    }

    @Override
    public void removePrintServiceAttributeListener(PrintServiceAttributeListener listener) {
    }

    static {
        boolean ret = PrintServiceLookup.registerServiceProvider(mepsl);
        System.out.println("registration is=" + ret);
    }

    static class IOSPrintServiceLookup
    extends PrintServiceLookup {
        IOSPrintServiceLookup() {
        }

        @Override
        public PrintService getDefaultPrintService() {
            return me;
        }

        @Override
        public PrintService[] getPrintServices() {
            return new PrintService[]{me};
        }

        @Override
        public MultiDocPrintService[] getMultiDocPrintServices(DocFlavor[] flavors, AttributeSet attributes) {
            return null;
        }

        @Override
        public PrintService[] getPrintServices(DocFlavor flavor, AttributeSet attributes) {
            if (System.getProperty("os.name").startsWith("Windows")) {
                return null;
            }
            if (DocFlavor.SERVICE_FORMATTED.PRINTABLE == flavor || DocFlavor.SERVICE_FORMATTED.PAGEABLE == flavor || flavor.getMimeType().equals(IOS_PRINTABLE.getMimeType()) || flavor.getMimeType().equals(IOS_PAGEABLE.getMimeType())) {
                if (me == null) {
                    me = new IOSPrintService();
                }
                return new PrintService[]{me};
            }
            return null;
        }
    }
}

