/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.print;

import com.archimed.dicom.DicomObject;
import com.ge.med.cse.cvf.saveimage.XpSaveUtil;
import com.ge.med.terra.tap.util.dicom.DicomComposite;
import com.ge.med.terra.tap.util.dicom.UidGenerator;
import com.ge.med.terra.tap.util.dicom.WrapperStream;
import com.ge.med.terra.tap.util.dicom.dicomParser;
import com.ge.med.terra.tap.util.dicom.tagValue;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;

public class IOSPrintUtil {
    static dicomParser dp = new dicomParser();
    private static final Logger logger = Logger.getLogger(IOSPrintUtil.class.getName());

    private IOSPrintUtil() {
    }

    public static InputStream getSsaveStream(String imageName, BufferedImage image) {
        FileInputStream fileInStream = null;
        try {
            dp.clearFile();
            fileInStream = new FileInputStream(imageName);
            dp.setFile(fileInStream);
            tagValue[] tags = new tagValue[]{new tagValue(2, 1), new tagValue(2, 16), new tagValue(2, 18), new tagValue(2, 19), new tagValue(2, 22), new tagValue(8, 5), new tagValue(8, 32), new tagValue(8, 48), new tagValue(8, 80), new tagValue(8, 96), new tagValue(8, 112), new tagValue(8, 128), new tagValue(8, 129), new tagValue(8, 144), new tagValue(8, 4112), new tagValue(8, 4144), new tagValue(8, 4240), new tagValue(16, 16), new tagValue(16, 32), new tagValue(16, 48), new tagValue(16, 64), new tagValue(16, 4112), new tagValue(16, 4128), new tagValue(16, 4144), new tagValue(24, 16), new tagValue(24, 4144), new tagValue(24, 4160), new tagValue(24, 20736), new tagValue(32, 13), new tagValue(32, 16), new tagValue(32, 32), new tagValue(32, 96), new tagValue(40, 4178), new tagValue(40, 4179), new tagValue(40, 4180)};
            dp.fill(tags);
            DicomComposite obj = new DicomComposite();
            obj.setValue(2, 1, IOSPrintUtil.getValue(2, 1, tags));
            obj.setValue(2, 2, "1.2.840.10008.4.1.4.1.1.7");
            obj.setValue(2, 3, UidGenerator.newInstanceUID());
            obj.setValue(2, 16, IOSPrintUtil.getValue(2, 16, tags));
            obj.setValue(2, 18, IOSPrintUtil.getValue(2, 18, tags));
            obj.setValue(2, 19, IOSPrintUtil.getValue(2, 19, tags));
            obj.setValue(2, 22, IOSPrintUtil.getValue(2, 22, tags));
            String charSet = (String)IOSPrintUtil.getValue(8, 5, tags);
            if (charSet == null) {
                charSet = "ISO_IR 100";
            }
            obj.setValue(8, 5, charSet);
            String pName = (String)IOSPrintUtil.getValue(16, 16, tags);
            if (pName == null) {
                pName = "";
            }
            obj.setValue(16, 16, pName);
            String pId = (String)IOSPrintUtil.getValue(16, 32, tags);
            if (pId == null) {
                pId = "";
            }
            obj.setValue(16, 32, pId);
            String pBdate = (String)IOSPrintUtil.getValue(16, 48, tags);
            if (pBdate == null) {
                pBdate = "";
            }
            obj.setValue(16, 48, pBdate);
            String pSex = (String)IOSPrintUtil.getValue(16, 64, tags);
            if (pSex == null) {
                pSex = "";
            }
            obj.setValue(16, 64, pSex);
            obj.setValue(32, 13, IOSPrintUtil.getValue(32, 13, tags));
            String exDate = (String)IOSPrintUtil.getValue(8, 32, tags);
            if (exDate == null) {
                exDate = "";
            }
            obj.setValue(8, 32, exDate);
            String exTime = (String)IOSPrintUtil.getValue(8, 48, tags);
            if (exTime == null) {
                exTime = "";
            }
            obj.setValue(8, 48, exTime);
            String refPhy = (String)IOSPrintUtil.getValue(8, 144, tags);
            if (refPhy == null) {
                refPhy = "";
            }
            obj.setValue(8, 144, refPhy);
            String exId = (String)IOSPrintUtil.getValue(32, 16, tags);
            if (exId == null) {
                exId = "";
            }
            obj.setValue(32, 16, exId);
            String accessionNo = (String)IOSPrintUtil.getValue(8, 80, tags);
            if (accessionNo == null) {
                accessionNo = "";
            }
            obj.setValue(8, 80, accessionNo);
            String exDescpt = (String)IOSPrintUtil.getValue(8, 4144, tags);
            if (exDescpt == null) {
                exDescpt = "";
            }
            obj.setValue(8, 4144, exDescpt);
            String patAge = (String)IOSPrintUtil.getValue(16, 4112, tags);
            if (patAge == null) {
                patAge = "";
            }
            obj.setValue(16, 4112, patAge);
            String pat1 = (String)IOSPrintUtil.getValue(16, 4128, tags);
            if (pat1 == null) {
                pat1 = "";
            }
            obj.setValue(16, 4128, pat1);
            String patWeight = (String)IOSPrintUtil.getValue(16, 4144, tags);
            if (patWeight == null) {
                patWeight = "";
            }
            obj.setValue(16, 4144, patWeight);
            String modality = (String)IOSPrintUtil.getValue(8, 96, tags);
            if (modality == null) {
                modality = "";
            }
            obj.setValue(8, 96, modality);
            obj.setValue(32, 14, UidGenerator.newInstanceUID());
            obj.setValue(32, 17, Integer.toString(99));
            String laterality = (String)IOSPrintUtil.getValue(32, 96, tags);
            if (laterality == null) {
                laterality = "";
            }
            obj.setValue(32, 96, laterality);
            obj.setValue(8, 4158, "Screen Save");
            String patPos = (String)IOSPrintUtil.getValue(24, 20736, tags);
            if (patPos == null) {
                patPos = "";
            }
            obj.setValue(24, 20736, patPos);
            String Protocol_Name = (String)IOSPrintUtil.getValue(24, 4144, tags);
            if (Protocol_Name == null) {
                Protocol_Name = "";
            }
            obj.setValue(24, 4144, Protocol_Name);
            String Contrast_on_Screen_Save = (String)IOSPrintUtil.getValue(24, 16, tags);
            if (Contrast_on_Screen_Save == null) {
                Contrast_on_Screen_Save = "";
            }
            obj.setValue(24, 16, Contrast_on_Screen_Save);
            String unk1 = (String)IOSPrintUtil.getValue(24, 4160, tags);
            if (unk1 == null) {
                unk1 = "";
            }
            obj.setValue(24, 4160, unk1);
            String manuf = (String)IOSPrintUtil.getValue(8, 112, tags);
            if (manuf == null) {
                manuf = "";
            }
            obj.setValue(8, 112, manuf);
            String institutionName = (String)IOSPrintUtil.getValue(8, 128, tags);
            if (institutionName == null) {
                institutionName = "";
            }
            obj.setValue(8, 128, institutionName);
            String unk2 = (String)IOSPrintUtil.getValue(8, 129, tags);
            if (unk2 == null) {
                unk2 = "";
            }
            obj.setValue(8, 129, unk2);
            String stationName = (String)IOSPrintUtil.getValue(8, 4112, tags);
            if (stationName == null) {
                stationName = "";
            }
            obj.setValue(8, 4112, stationName);
            String manfmodel = (String)IOSPrintUtil.getValue(8, 4240, tags);
            if (manfmodel == null) {
                manfmodel = "";
            }
            obj.setValue(8, 4240, manfmodel);
            obj.setValue(8, 100, "WSD");
            obj.setValue(32, 19, new Integer(1));
            String unk3 = (String)IOSPrintUtil.getValue(32, 32, tags);
            if (unk3 == null) {
                unk3 = "";
            }
            obj.setValue(32, 32, unk3);
            String date = XpSaveUtil.DICOM_VR_DA_FORMAT.format(new Date());
            obj.setValue(8, 35, date);
            obj.setValue(8, 8, "DERIVED\\SECONDARY\\SCREEN SAVE");
            obj.setValue(40, 2, new Integer(3));
            obj.setValue(40, 4, "RGB");
            obj.setValue(40, 256, new Integer(8));
            obj.setValue(40, 257, new Integer(8));
            obj.setValue(40, 258, new Integer(7));
            obj.setValue(40, 16, new Integer(image.getWidth()));
            obj.setValue(40, 17, new Integer(image.getHeight()));
            obj.setValue(40, 259, new Integer(0));
            String unk4 = (String)IOSPrintUtil.getValue(40, 4178, tags);
            if (unk4 == null) {
                unk4 = "0";
            }
            obj.setValue(40, 4178, unk4);
            String unk5 = (String)IOSPrintUtil.getValue(40, 4179, tags);
            if (unk5 == null) {
                unk5 = "1";
            }
            obj.setValue(40, 4179, unk5);
            String unk6 = (String)IOSPrintUtil.getValue(40, 4180, tags);
            if (unk6 == null) {
                unk6 = "je ne sais pas";
            }
            obj.setValue(40, 4180, unk6);
            obj.setValue(8, 22, "1.2.840.10008.5.1.4.1.1.7");
            obj.setValue(2, 2, "1.2.840.10008.5.1.4.1.1.7");
            obj.setValue(8, 24, UidGenerator.newInstanceUID());
            obj.setValue(2, 3, UidGenerator.newInstanceUID());
            DataBufferByte dbi = (DataBufferByte)image.getRaster().getDataBuffer();
            byte[] bb = dbi.getData();
            for (int i2 = 0; i2 < bb.length; i2 += 3) {
                byte t2 = bb[i2];
                bb[i2] = bb[i2 + 2];
                bb[i2 + 2] = t2;
            }
            obj.setValue(32736, 16, bb);
            InputStream inputStream = obj.getInputStream(true, (String)IOSPrintUtil.getValue(2, 16, tags));
            return inputStream;
        }
        catch (FileNotFoundException ex) {
            logger.log(Level.WARNING, "screen save stream failed", ex);
            throw new IllegalArgumentException(ex.getMessage());
        }
        finally {
            if (fileInStream != null) {
                try {
                    fileInStream.close();
                }
                catch (IOException ioe) {
                    logger.log(Level.WARNING, "Unable to close the opened file stream", ioe.getLocalizedMessage());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InputStream getSS(BufferedImage image) {
        InputStream inStream = IOSPrintUtil.class.getResourceAsStream("/com/ge/med/terra/xpv/wf/print/resources/scImageFinal");
        try {
            DicomObject obj = new DicomObject();
            if (inStream != null) {
                obj.read(inStream);
                DataBufferByte dbi = (DataBufferByte)image.getRaster().getDataBuffer();
                byte[] bb = dbi.getData();
                for (int i2 = 0; i2 < bb.length; i2 += 3) {
                    byte t2 = bb[i2];
                    bb[i2] = bb[i2 + 2];
                    bb[i2 + 2] = t2;
                }
                obj.set_ge(32736, 16, bb);
                WrapperStream wrapperStream = new WrapperStream(obj);
                return wrapperStream;
            }
            InputStream inputStream = null;
            return inputStream;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            InputStream inputStream = null;
            return inputStream;
        }
        finally {
            if (inStream != null) {
                try {
                    inStream.close();
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
            }
        }
    }

    public static Object getValue(int g2, int e2, tagValue[] tags) {
        for (int i2 = 0; i2 < tags.length; ++i2) {
            tagValue tag2 = tags[i2];
            if (tag2.group != g2 || tag2.element != e2) continue;
            return tag2.value;
        }
        return null;
    }
}

