/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.roi;

import com.ge.med.cse.cvf.roi.DefaultROIUtils;
import com.ge.med.cse.cvf.util.CvPropertiesManager;
import com.ge.med.cse.cvf.util.CvUtils;
import com.ge.med.cse.cvf.util.DefaultHandleFactory;
import com.ge.med.cse.cvf.util.HandleFactory;
import com.ge.med.idc.ComponentCreator;
import com.ge.med.terra.jami.CPoint;
import com.ge.med.terra.jami.GSPSGraphic;
import com.ge.med.terra.jami.RoiActor;
import com.ge.med.terra.jami.XpAnchorable;
import com.ge.med.terra.jami.XpAppContext;
import com.ge.med.terra.jami.XpDicomElement;
import com.ge.med.terra.jami.XpDicomObject;
import com.ge.med.terra.jami.XpGeomUtils;
import com.ge.med.terra.jami.XpHandle;
import com.ge.med.terra.jami.XpImage;
import com.ge.med.terra.jami.XpMedicalImage;
import com.ge.med.terra.jami.XpPixelStatistics;
import com.ge.med.terra.jami.XpRoiComponentCreator;
import com.ge.med.terra.jami.XpVisualComponent;
import com.ge.med.terra.jami.roi.RoiShapeModel;
import com.ge.med.terra.jami.roi.RoiStatistics;
import com.ge.med.terra.jami.roi.XpRoiHandleContainer;
import com.ge.med.terra.jami.roi.XpStatisticsRoi;
import com.ge.med.terra.jami.roi.j3d.Jami3DRoiStatistics;
import com.ge.med.terra.jami.roi.j3d.T3DStatImage;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;

public class CvFreeHandRoi
extends XpStatisticsRoi
implements Serializable {
    private static final boolean debug = false;
    private static final int SUBSAMPLE = 20;
    private static Color SELECTED_COLOR = null;
    private static Color UNSELECTED_COLOR = null;
    private static Color HANDLE_COLOR = null;
    private static boolean handlefilled = false;
    private static Color ROILABEL_COLOR = null;
    private static int ROILABEL_X = 0;
    private static int ROILABEL_Y = 0;
    private static Boolean DRAG_BY_ROILABEL = false;
    protected static Shape CONTAINMENT_SHAPE = null;
    protected static Shape HANDLE_SHAPE = null;
    private transient XpHandle drawHandle = null;
    private transient XpHandle moveHandle = null;
    private transient Rectangle2D rect = null;
    private transient Rectangle2D drect = null;
    private double tx = 0.0;
    private double ty = 0.0;
    private transient GeneralPath debugContains = null;
    private transient GeneralPath drawShape = null;
    private transient GeneralPath modelShape = null;
    private transient Point2D tmpPoint1 = new Point2D.Double();
    private transient List mdList = new ArrayList(512);
    private static String DISTANCE_PREFIX = null;
    private static String DISTANCE_SUFFIX = null;
    private transient List containsList = new ArrayList(512);
    private int containsListLen = 0;
    private static final DecimalFormat dfe = new DecimalFormat("#.0");
    private RoiStatistics rstats = null;
    private XpDicomElement mod = new XpDicomElement(8, 96);
    private transient Point2D lastDrawPt = new Point2D.Double();
    private transient Point2D lastPt = new Point2D.Double();
    private transient Point2D startMouse = new Point2D.Double();
    private transient Point2D startTx = new Point2D.Double();

    public CvFreeHandRoi(double x2, double y2) {
        super(new GeneralPath());
        this.drawShape = new GeneralPath();
        this.modelShape = (GeneralPath)this.getModelShape();
        this.rect = new Rectangle2D.Double(x2, y2, 5.0, 5.0);
        this.drect = (Rectangle2D)this.rect.clone();
        this.lastPt.setLocation(x2, y2);
        this.createHandle();
        this.setHandlePolicy(1);
        this.setDragByRoiLabel(DRAG_BY_ROILABEL);
    }

    protected void createHandle() {
        this.moveHandle = new XpHandle((XpAnchorable)this, 0, 16);
        this.moveHandle.setShape(XpHandle.HANDLE_CROSSHAIR, CONTAINMENT_SHAPE);
        this.moveHandle.setFilled(false);
        this.add(this.moveHandle);
        this.moveHandle.setVisible(false);
        this.drawHandle = new XpHandle((XpAnchorable)this, 1, 16);
        this.drawHandle.setShape(HANDLE_SHAPE, CONTAINMENT_SHAPE);
        this.drawHandle.setFilled(handlefilled);
        this.drawHandle.setLocation(this.lastPt);
        this.add(this.drawHandle);
        XpHandle h2 = this.get(1);
    }

    @Override
    public RoiStatistics getRoiStatistics() {
        RoiStatistics rs = null;
        if (this.getImage() instanceof XpMedicalImage) {
            rs = super.getRoiStatistics();
        } else if (this.getImage() instanceof T3DStatImage) {
            if (this.rstats == null) {
                this.rstats = new Jami3DRoiStatisticsForOpenROIs();
                this.rstats.setImage(this.getImage());
            }
            return this.rstats;
        }
        return rs;
    }

    private void setRoiStatProperties() {
        XpImage img = this.getImage();
        String modality = null;
        if (img instanceof XpDicomObject) {
            ((XpDicomObject)((Object)img)).getValue(this.mod);
            if (this.mod.getStringValue() != null) {
                modality = this.mod.getStringValue();
            }
        }
        if (!(this.getRoiStatistics() instanceof Jami3DRoiStatistics)) {
            DefaultROIUtils.configureROIStat(img);
        }
        String modSuffix = modality != null ? "." + modality.toLowerCase() : "";
        DISTANCE_SUFFIX = CvPropertiesManager.getProperty("cvf.roi.distance.suffix" + modSuffix, "mm");
        DISTANCE_PREFIX = CvPropertiesManager.getProperty("cvf.roi.distance.prefix" + modSuffix, ": distance");
    }

    @Override
    public String createRoiStatLabel(XpPixelStatistics ps) {
        this.setRoiStatProperties();
        return this.getRoiLabel() + DISTANCE_PREFIX + " " + dfe.format(this.getLength()) + DISTANCE_SUFFIX;
    }

    @Override
    public Object clone() {
        CvFreeHandRoi ccr = new CvFreeHandRoi(0.0, 0.0);
        this.copyObject(ccr);
        return ccr;
    }

    private static void setFreeHandRoiProperties() {
        String val = CvPropertiesManager.getProperty("cvf.Handle.Factory");
        HandleFactory f2 = null;
        if (val != null) {
            f2 = CvUtils.createHandleFactory(val);
            if (f2 == null) {
                f2 = new DefaultHandleFactory();
            }
        } else {
            f2 = new DefaultHandleFactory();
        }
        CONTAINMENT_SHAPE = f2.getContainmentShape();
        val = CvPropertiesManager.getProperty("cvf.polygon.pointHandle.Style");
        if (val != null) {
            if (val.toUpperCase().equals("BOX")) {
                HANDLE_SHAPE = f2.getMoveHandleShape(HandleFactory.HandleStyle.BOX);
            } else if (val.toUpperCase().equals("CROSSHAIR")) {
                HANDLE_SHAPE = f2.getMoveHandleShape(HandleFactory.HandleStyle.CROSSHAIR);
            }
        }
        HANDLE_COLOR = f2.getHandleColor();
        SELECTED_COLOR = f2.getHandleSelectedColor();
        UNSELECTED_COLOR = f2.getHandleUnSelectedColor();
        val = CvPropertiesManager.getProperty("cvf.roi.roiLabel.Color");
        ROILABEL_COLOR = val != null ? CvUtils.getColor(val) : HANDLE_COLOR;
        val = CvPropertiesManager.getProperty("cvf.roi.roiLabel.x");
        if (val != null) {
            ROILABEL_X = Integer.parseInt(val);
        }
        if ((val = CvPropertiesManager.getProperty("cvf.roi.roiLabel.y")) != null) {
            ROILABEL_Y = Integer.parseInt(val);
        }
        if ((val = CvPropertiesManager.getProperty("cvf.roi.dragByRoiLabel", "false")) != null) {
            DRAG_BY_ROILABEL = Boolean.valueOf(val);
        }
        handlefilled = Boolean.valueOf(CvPropertiesManager.getProperty("cvf.freedraw.handle.filled", "false").trim());
    }

    public boolean addPoint(double x2, double y2) {
        XpImage img = this.getImage();
        GeneralPath gp = (GeneralPath)this.getModelShape();
        if (img != null && gp != null) {
            int w2 = img.getSlice().width;
            int h2 = img.getSlice().height;
            double X1 = 0.0;
            double Y1 = 0.0;
            double X2 = w2;
            double Y2 = h2;
            Rectangle2D domain = this.getDomain();
            if (domain != null) {
                X1 = domain.getX();
                Y1 = domain.getY();
                X2 = X1 + domain.getWidth();
                Y2 = Y1 + domain.getHeight();
            }
            byte type = 0;
            if (x2 >= X1 && y2 >= Y1 && x2 < X2 && y2 < Y2) {
                if (this.mdList.size() > 0) {
                    gp.lineTo((float)x2, (float)y2);
                    type = 1;
                } else {
                    gp.moveTo((float)x2, (float)y2);
                }
                this.addPoint(x2, y2, type);
            }
            return true;
        }
        return false;
    }

    @Override
    protected void copyObject(Object o2) {
        CvFreeHandRoi fh = (CvFreeHandRoi)o2;
        super.copyObject(fh);
        fh.rect = (Rectangle2D)this.rect.clone();
        fh.drect = (Rectangle2D)this.drect.clone();
        fh.tx = this.tx;
        fh.ty = this.ty;
        fh.drawShape = (GeneralPath)this.drawShape.clone();
        int idx = 0;
        float[] _reg = new float[2];
        fh.modelShape.reset();
        PathIterator pi = this.modelShape.getPathIterator(null, 1.0);
        while (!pi.isDone()) {
            pi.currentSegment(_reg);
            float x2 = _reg[0];
            float y2 = _reg[1];
            int segType = pi.getWindingRule();
            switch (segType) {
                case 0: {
                    fh.modelShape.moveTo(x2, y2);
                    break;
                }
                case 1: {
                    if (idx > 0) {
                        fh.modelShape.lineTo(x2, y2);
                        break;
                    }
                    fh.modelShape.moveTo(x2, y2);
                    break;
                }
            }
            ++idx;
            pi.next();
        }
        fh.drawHandle.setLocation(this.drawHandle.getX(), this.drawHandle.getY());
        fh.drawHandle.setFilled(this.drawHandle.isFilled());
        fh.lastDrawPt.setLocation(this.lastDrawPt);
        fh.lastPt.setLocation(this.lastPt);
        for (int i2 = 0; i2 < this.mdList.size(); ++i2) {
            DrawDescriptor dd = (DrawDescriptor)this.mdList.get(i2);
            DrawDescriptor ndd = new DrawDescriptor();
            ndd.type = dd.type;
            ndd.x = dd.x;
            ndd.y = dd.y;
            fh.mdList.add(ndd);
        }
        fh.setDragByRoiLabel(this.isDragByRoiLabel());
    }

    @Override
    public boolean containsROI(XpVisualComponent vc, int x2, int y2) {
        Rectangle2D bounds;
        if (this.isDragByRoiLabel() && (bounds = this.getRoiLabelBounds()) != null && bounds.contains(x2, y2)) {
            return true;
        }
        boolean bb = this.drect.contains(x2, y2);
        if (bb) {
            return this.containedDrawShape(x2, y2);
        }
        return false;
    }

    @Override
    public final Shape getDrawShape() {
        this.updateDrawShape();
        return this.drawShape;
    }

    @Override
    public void render(XpVisualComponent vc, Graphics2D g2) {
        super.render(vc, g2);
        this.drawRoiId(vc, g2, this.get(1));
    }

    @Override
    protected void drawRoiId(XpVisualComponent vc, Graphics2D g2, XpHandle h2) {
        Point2D.Double tmpPoint1 = new Point2D.Double();
        h2.getDisplayLocation(vc, tmpPoint1);
        double sx = ((Point2D)tmpPoint1).getX() - 10.0;
        double sy = ((Point2D)tmpPoint1).getY() - 5.0;
        this.drawRoiId(g2, sx, sy);
    }

    @Override
    protected void drawRoiId(Graphics2D g2, double x2, double y2) {
        Color c2 = g2.getColor();
        if (this.isGrayScaleMode()) {
            g2.setColor(Color.WHITE);
        } else {
            g2.setColor(ROILABEL_COLOR);
        }
        super.drawRoiId(g2, x2, y2, this.isGrayScaleMode());
        g2.setColor(c2);
    }

    @Override
    public void anchorDragged(MouseEvent e2, CPoint drag, Object source) {
        super.anchorDragged(e2, drag, source);
        XpHandle xph = (XpHandle)source;
        this.getImagePoint(e2.getX(), e2.getY(), this.tmpPoint1);
        double x2 = this.tmpPoint1.getX() - this.tx;
        double y2 = this.tmpPoint1.getY() - this.ty;
        GeneralPath gp = (GeneralPath)this.getModelShape();
        if (xph == this.drawHandle) {
            XpImage img = this.getImage();
            int w2 = img.getSlice().width;
            int h2 = img.getSlice().height;
            double X1 = 0.0;
            double Y1 = 0.0;
            double X2 = w2;
            double Y2 = h2;
            Rectangle2D domain = this.getDomain();
            if (domain != null) {
                X1 = domain.getX();
                Y1 = domain.getY();
                X2 = X1 + domain.getWidth();
                Y2 = Y1 + domain.getHeight();
            }
            if (x2 < X1) {
                x2 = X1;
            }
            if (y2 < Y1) {
                y2 = Y1;
            }
            if (x2 >= X2) {
                x2 = X2 - 1.0;
            }
            if (y2 >= Y2) {
                y2 = Y2 - 1.0;
            }
            gp.lineTo((float)x2, (float)y2);
            this.addPoint(x2, y2, (byte)1);
            this.syncModel();
        }
    }

    @Override
    public void anchorPressed(MouseEvent e2, Object source) {
        super.anchorPressed(e2, source);
        XpHandle xph = (XpHandle)source;
        this.getImagePoint(e2.getX(), e2.getY(), this.tmpPoint1);
        double x2 = this.tmpPoint1.getX() - this.tx;
        double y2 = this.tmpPoint1.getY() - this.ty;
        this.startMouse.setLocation(x2, y2);
        if (xph == this.drawHandle) {
            this.addPoint(x2, y2);
        }
    }

    @Override
    public void roiDragged(MouseEvent e2) {
        double transy;
        double transx;
        XpVisualComponent vc = (XpVisualComponent)e2.getSource();
        if (!this.isSelected()) {
            return;
        }
        int modifiers = e2.getModifiers();
        boolean mbutton1 = 0 != (modifiers & 0x10);
        boolean shift = 0 != (modifiers & 1);
        this.getImagePoint(e2.getX(), e2.getY(), this.tmpPoint1);
        double x2 = this.tmpPoint1.getX();
        double y2 = this.tmpPoint1.getY();
        double dx = x2 - this.startMouse.getX();
        double dy = y2 - this.startMouse.getY();
        if (mbutton1 && this.bbInside(transx = this.startTx.getX() + dx, transy = this.startTx.getY() + dy)) {
            this.tx = transx;
            this.ty = transy;
            this.drawHandle.setLocation(this.lastPt.getX() + this.tx, this.lastPt.getY() + this.ty);
            this.updateDrawRect();
            vc.repaint();
        }
        this.notifyDragged();
    }

    @Override
    public void roiPressed(MouseEvent e2) {
        super.roiPressed(e2);
        int modifiers = e2.getModifiers();
        boolean mbutton1 = 0 != (modifiers & 0x10);
        boolean shift = 0 != (modifiers & 1);
        this.getImagePoint(e2.getX(), e2.getY(), this.tmpPoint1);
        double x2 = this.tmpPoint1.getX();
        double y2 = this.tmpPoint1.getY();
        this.startTx.setLocation(this.tx, this.ty);
        this.startMouse.setLocation(x2, y2);
        this.notifyPressed();
    }

    private void addPoint(double x2, double y2, byte type) {
        DrawDescriptor dd = new DrawDescriptor();
        this.mdList.add(dd);
        dd.type = type;
        dd.x = x2;
        dd.y = y2;
        this.lastPt.setLocation(x2, y2);
        this.drawHandle.setLocation(this.lastPt.getX() + this.tx, this.lastPt.getY() + this.ty);
        double x1 = this.rect.getX();
        double y1 = this.rect.getY();
        double x22 = x1 + this.rect.getWidth();
        double y22 = y1 + this.rect.getHeight();
        if (x2 < x1) {
            x1 = x2;
        }
        if (x2 > x22) {
            x22 = x2;
        }
        if (y2 < y1) {
            y1 = y2;
        }
        if (y2 > y22) {
            y22 = y2;
        }
        double w2 = Math.abs(x1 - x22);
        double h2 = Math.abs(y1 - y22);
        this.rect.setFrame(x1, y1, w2, h2);
        this.updateDrawRect();
    }

    public static ComponentCreator getComponentCreator(int ccid) {
        if (ccid == 0) {
            return new FreeHandCreator();
        }
        return null;
    }

    private boolean bbInside(double transx, double transy) {
        double x1 = this.rect.getX() + transx;
        double y1 = this.rect.getY() + transy;
        double x2 = x1 + this.rect.getWidth();
        double y2 = y1 + this.rect.getHeight();
        XpImage img = this.getImage();
        int w2 = img.getSlice().width;
        int h2 = img.getSlice().height;
        double X1 = 0.0;
        double Y1 = 0.0;
        double X2 = w2;
        double Y2 = h2;
        Rectangle2D domain = this.getDomain();
        if (domain != null) {
            X1 = domain.getX();
            Y1 = domain.getY();
            X2 = X1 + domain.getWidth();
            Y2 = Y1 + domain.getHeight();
        }
        return x1 >= X1 && y1 >= Y1 && x1 < X2 && y1 < Y2 && x2 >= X1 && y2 >= Y1 && x2 < X2 && y2 < Y2;
    }

    private void updateDrawRect() {
        double x1 = this.rect.getX() + this.tx;
        double y1 = this.rect.getY() + this.ty;
        double w2 = this.rect.getWidth();
        double h2 = this.rect.getHeight();
        double x2 = x1 + w2;
        double y2 = y1 + h2;
        this.getDisplayPoint(x1, y1, this.tmpPoint1);
        x1 = this.tmpPoint1.getX();
        y1 = this.tmpPoint1.getY();
        this.getDisplayPoint(x2, y2, this.tmpPoint1);
        x2 = this.tmpPoint1.getX();
        y2 = this.tmpPoint1.getY();
        double x3 = x2 < x1 ? x2 : x1;
        double y3 = y2 < y1 ? y2 : y1;
        double nw = Math.abs(x2 - x1);
        double nh = Math.abs(y2 - y1);
        this.drect.setFrame(x3, y3, nw, nh);
    }

    private boolean containedDrawShape(int x2, int y2) {
        if (this.containsListLen > 1) {
            Point2D prev = (Point2D)this.containsList.get(0);
            for (int i2 = 1; i2 < this.containsListLen; ++i2) {
                Point2D p2 = (Point2D)this.containsList.get(i2);
                if (XpGeomUtils.containsCoord(x2, y2, prev, p2, 4)) {
                    return true;
                }
                prev = p2;
            }
        }
        return false;
    }

    private void addToContainmentList(float x2, float y2, int idx) {
        int len = this.containsList.size();
        Point2D p2 = null;
        if (idx < len) {
            p2 = (Point2D)this.containsList.get(idx);
        } else {
            int n2 = idx - len + 1;
            for (int i2 = 0; i2 < n2; ++i2) {
                p2 = new Point2D.Double();
                this.containsList.add(p2);
            }
        }
        if (p2 != null) {
            p2.setLocation(x2, y2);
        }
    }

    private void updateDrawShape() {
        int size = this.mdList.size();
        Shape rs = this.getModelShape();
        boolean moveTo = false;
        this.drawShape.reset();
        float prevX = -999999.0f;
        float prevY = -999999.0f;
        this.containsListLen = 0;
        if (size == 0) {
            double x2 = this.drawHandle.getX();
            double y2 = this.drawHandle.getY();
            this.getDisplayPoint(x2, y2, this.tmpPoint1);
            float xx = (float)this.tmpPoint1.getX();
            float yy = (float)this.tmpPoint1.getY();
            this.lastDrawPt.setLocation(xx, yy);
            return;
        }
        for (int i2 = 0; i2 < size; ++i2) {
            DrawDescriptor dd = (DrawDescriptor)this.mdList.get(i2);
            double x3 = dd.x + this.tx;
            double y3 = dd.y + this.ty;
            this.getDisplayPoint(x3, y3, this.tmpPoint1);
            float xx = (float)this.tmpPoint1.getX();
            float yy = (float)this.tmpPoint1.getY();
            this.lastDrawPt.setLocation(xx, yy);
            if (dd.type == 0) {
                this.drawShape.moveTo(xx, yy);
                this.addToContainmentList(xx, yy, this.containsListLen++);
                prevX = xx;
                prevY = yy;
                continue;
            }
            this.drawShape.lineTo(xx, yy);
            int manhattanDist = (int)(Math.abs(prevX - xx) + Math.abs(prevY - yy));
            if (manhattanDist <= 20 && this.containsListLen >= 10) continue;
            this.addToContainmentList(xx, yy, this.containsListLen++);
            prevX = xx;
            prevY = yy;
        }
    }

    @Override
    public final GSPSGraphic gspsDescription() {
        int len = this.mdList.size();
        Point2D[] pts = new Point2D[len];
        for (int i2 = 0; i2 < len; ++i2) {
            DrawDescriptor p2 = (DrawDescriptor)this.mdList.get(i2);
            pts[i2] = new Point2D.Double(p2.x, p2.y);
        }
        XpRoiHandleContainer.GraphicDescriptor description = new XpRoiHandleContainer.GraphicDescriptor("POLYLINE", pts);
        return description;
    }

    private void writeObject(ObjectOutputStream s2) throws IOException {
        s2.defaultWriteObject();
        try {
            s2.writeDouble(this.rect.getX());
            s2.writeDouble(this.rect.getY());
            s2.writeDouble(this.rect.getWidth());
            s2.writeDouble(this.rect.getHeight());
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    private void readObject(ObjectInputStream s2) throws IOException {
        try {
            s2.defaultReadObject();
            this.rect = new Rectangle2D.Double(s2.readDouble(), s2.readDouble(), s2.readDouble(), s2.readDouble());
            this.drect = (Rectangle2D)this.rect.clone();
            this.tmpPoint1 = new Point2D.Double();
            this.lastDrawPt = new Point2D.Double();
            this.lastPt = new Point2D.Double();
            this.startMouse = new Point2D.Double();
            this.startTx = new Point2D.Double();
            this.mdList = new ArrayList(512);
            this.containsList = new ArrayList(512);
            this.setRoiShapeModel(new RoiShapeModel(new GeneralPath()));
            this.drawShape = new GeneralPath();
            this.modelShape = (GeneralPath)this.getModelShape();
            this.lastPt.setLocation(this.rect.getX(), this.rect.getY());
            this.drawHandle = new XpHandle((XpAnchorable)this, 1, 16);
            this.drawHandle.setFilled(false);
            this.drawHandle.setLocation(this.lastPt);
            this.add(this.drawHandle);
            this.setHandlePolicy(1);
        }
        catch (ClassNotFoundException ex) {
            ex.printStackTrace();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    static {
        CvFreeHandRoi.setFreeHandRoiProperties();
        XpHandle.setHandleColor(HANDLE_COLOR);
        XpAppContext.setSelectedColor(SELECTED_COLOR);
        XpAppContext.setUnSelectedColor(UNSELECTED_COLOR);
        XpAppContext.setShadowed(true);
    }

    private class DrawDescriptor {
        public byte type;
        public double x;
        public double y;

        private DrawDescriptor() {
        }
    }

    private static class FreeHandCreator
    extends XpRoiComponentCreator {
        private CvFreeHandRoi tr = null;
        private CPoint dispPt = new CPoint(1);
        private CPoint imgPt = new CPoint(0);

        private FreeHandCreator() {
        }

        @Override
        public RoiActor getRoiActor(double x2, double y2) {
            this.tr = new CvFreeHandRoi(x2, y2);
            return this.tr;
        }

        @Override
        public void mousePressed(MouseEvent me) {
            XpVisualComponent vc = (XpVisualComponent)me.getSource();
            int modifiers = me.getModifiers();
            int mbutton1 = modifiers & 0x10;
            int x2 = me.getX();
            int y2 = me.getY();
            if (mbutton1 != 0) {
                if (this.tr == null) {
                    this.dropRoi(me);
                }
                if (this.tr != null) {
                    this.dispPt.set(x2, y2, 0.0);
                    this.imgPt = this.getImgPt(vc, x2, y2);
                    this.tr.addPoint(this.imgPt.x, this.imgPt.y);
                    this.tr.setSelected(true);
                }
                vc.repaint();
            }
        }

        @Override
        public void mouseDragged(MouseEvent me) {
            XpVisualComponent vc = (XpVisualComponent)me.getSource();
            int modifiers = me.getModifiers();
            int mbutton1 = modifiers & 0x10;
            int mbutton2 = modifiers & 8;
            int x2 = me.getX();
            int y2 = me.getY();
            if (mbutton1 != 0 && this.tr != null) {
                CPoint img_pt = this.getImgPt(vc, x2, y2);
                this.tr.anchorDragged(me, img_pt, this.tr.get(1));
                this.tr.syncModel();
                vc.repaint();
            }
        }
    }

    private static class Jami3DRoiStatisticsForOpenROIs
    extends Jami3DRoiStatistics {
        private static final XpPixelStatistics nullstats = new XpPixelStatistics();

        public Jami3DRoiStatisticsForOpenROIs() {
            nullstats.resetStatistics();
        }

        @Override
        public XpPixelStatistics getPixelStatistics(Shape s2, double angle) {
            return nullstats;
        }
    }
}

