/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.roi;

import com.ge.med.cse.cvf.idc.XpClipRoiActor;
import com.ge.med.cse.cvf.util.CvPropertiesManager;
import com.ge.med.cse.cvf.util.CvUtils;
import com.ge.med.cse.cvf.util.DefaultHandleFactory;
import com.ge.med.cse.cvf.util.HandleFactory;
import com.ge.med.idc.Selectable;
import com.ge.med.terra.jami.CPoint;
import com.ge.med.terra.jami.CTransform;
import com.ge.med.terra.jami.GSPSGraphic;
import com.ge.med.terra.jami.XpAnchorable;
import com.ge.med.terra.jami.XpAppContext;
import com.ge.med.terra.jami.XpGeomUtils;
import com.ge.med.terra.jami.XpHandle;
import com.ge.med.terra.jami.XpImage;
import com.ge.med.terra.jami.XpImageRoiVc;
import com.ge.med.terra.jami.XpVisualComponent;
import com.ge.med.terra.jami.capable.CTransformCapable;
import com.ge.med.terra.jami.capable.GrayScaleCapable;
import com.ge.med.terra.jami.capable.Replicable;
import com.ge.med.terra.jami.roi.XpRoiEvent;
import com.ge.med.terra.jami.roi.XpRoiEventListener;
import com.ge.med.terra.jami.roi.XpRoiHandleContainer;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.geom.RoundRectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;

public class CvImageMatte
extends XpRoiHandleContainer
implements Replicable,
Selectable,
Serializable,
XpClipRoiActor,
GrayScaleCapable {
    private transient RectangularShape rs = null;
    private transient RectangularShape drs = null;
    private transient GeneralPath gp = null;
    private List roiListener = new ArrayList();
    private transient XpImage theImage = null;
    private CPoint display_pt1 = new CPoint(1);
    private CPoint display_pt2 = new CPoint(1);
    private CPoint display_pt3 = new CPoint(1);
    private CPoint display_pt4 = new CPoint(1);
    private CPoint img_pt = new CPoint(0);
    private boolean selected = true;
    private transient XpGeomUtils gu = new XpGeomUtils();
    private transient Point2D cp = new Point2D.Double();
    private boolean displayborder = false;
    boolean debug = false;
    private Color matteColor = Color.black;
    private static Color HANDLE_COLOR = null;
    private static Color SELECTED_COLOR = null;
    private static Color UNSELECTED_COLOR = null;
    private static Shape MOVE_HANDLE = null;
    private static Shape RESIZE_HANDLE = null;
    private static Shape CONTAINMENT_SHAPE = null;
    private static boolean DRAW_BORDER = false;
    private static Cursor RESIZE_CURSOR = null;
    private static Cursor MOVE_CURSOR = null;
    private static boolean movehandlefilled = false;
    private static boolean resizehandlefilled = false;
    private boolean grayscaleMode = false;
    private Insets is = new Insets(0, 0, 0, 0);
    private Rectangle clipRectangle = new Rectangle();
    private CPoint display_pta = new CPoint(1);
    private CPoint display_ptb = new CPoint(1);
    private CPoint display_ptc = new CPoint(1);
    private float[] segment = new float[6];
    private transient Point pMouse = null;
    private CPoint _dragV = new CPoint();

    public CvImageMatte(RectangularShape rs) {
        this.rs = rs;
        this.drs = (RectangularShape)rs.clone();
        this.gp = new GeneralPath();
        this.displayborder = DRAW_BORDER;
        this.createHandles();
    }

    @Override
    public Object clone() {
        RectangularShape newrs = (RectangularShape)this.rs.clone();
        CvImageMatte ccr = new CvImageMatte(newrs);
        this.copyObject(ccr);
        return ccr;
    }

    private static void setImgMatteProperties() {
        String val = CvPropertiesManager.getProperty("cvf.Handle.Factory");
        HandleFactory f2 = null;
        if (val != null) {
            f2 = CvUtils.createHandleFactory(val);
            if (f2 == null) {
                f2 = new DefaultHandleFactory();
            }
        } else {
            f2 = new DefaultHandleFactory();
        }
        HANDLE_COLOR = f2.getHandleColor();
        SELECTED_COLOR = f2.getHandleSelectedColor();
        UNSELECTED_COLOR = f2.getHandleUnSelectedColor();
        val = CvPropertiesManager.getProperty("cvf.ImageMatte.moveHandle.Style");
        if (val != null) {
            if (val.toUpperCase().equals("BOX")) {
                MOVE_HANDLE = f2.getMoveHandleShape(HandleFactory.HandleStyle.BOX);
            } else if (val.toUpperCase().equals("CROSSHAIR")) {
                MOVE_HANDLE = f2.getMoveHandleShape(HandleFactory.HandleStyle.CROSSHAIR);
            }
        }
        if ((val = CvPropertiesManager.getProperty("cvf.roi.resizeHandle.Style", "BOX").trim()) != null) {
            if (val.toUpperCase().equals("BOX")) {
                RESIZE_HANDLE = f2.getMoveHandleShape(HandleFactory.HandleStyle.BOX);
            } else if (val.toUpperCase().equals("CROSSHAIR")) {
                RESIZE_HANDLE = f2.getMoveHandleShape(HandleFactory.HandleStyle.CROSSHAIR);
            }
        }
        CONTAINMENT_SHAPE = f2.getContainmentShape();
        RESIZE_CURSOR = f2.getResizeHandleCursor();
        MOVE_CURSOR = f2.getMoveHandleCursor();
        DRAW_BORDER = Boolean.valueOf(CvPropertiesManager.getProperty("cvf.ImageMatte.drawBorder", "false"));
        movehandlefilled = Boolean.valueOf(CvPropertiesManager.getProperty("cvf.ImageMatte.moveHandle.filled", "false").trim());
        resizehandlefilled = Boolean.valueOf(CvPropertiesManager.getProperty("cvf.ImageMatte.resizeHandle.filled", "false").trim());
    }

    protected void createHandles() {
        XpHandle h1 = new XpHandle((XpAnchorable)this, 0, 16);
        h1.setShape(MOVE_HANDLE, CONTAINMENT_SHAPE);
        this.add(h1);
        XpHandle h2 = new XpHandle((XpAnchorable)this, 1, 16);
        h1.setShape(RESIZE_HANDLE, CONTAINMENT_SHAPE);
        this.add(h2);
        h1.setFilled(movehandlefilled);
        h2.setFilled(resizehandlefilled);
        h1.setLocation(this.rs.getX(), this.rs.getY());
        h2.setLocation(this.rs.getX() + this.rs.getWidth(), this.rs.getY() + this.rs.getHeight());
        XpHandle panh = this.get(0);
        panh.setCursor(MOVE_CURSOR);
        XpHandle resizeh = this.get(1);
        resizeh.setCursor(RESIZE_CURSOR);
    }

    @Override
    protected void copyObject(Object o2) {
        CvImageMatte pr = (CvImageMatte)o2;
        pr.selected = this.selected;
        pr.matteColor = this.matteColor;
        pr.display_pt1 = (CPoint)this.display_pt1.clone();
        pr.display_pt2 = (CPoint)this.display_pt2.clone();
        pr.img_pt = (CPoint)this.img_pt.clone();
        pr.displayborder = this.displayborder;
        pr.cp = (Point2D)this.cp.clone();
    }

    @Override
    public void anchorDragged(MouseEvent e2, CPoint drag, Object source) {
        this.cp = e2.getPoint();
        XpHandle xph = (XpHandle)source;
        int idx = xph.getAnchorPointIndex();
        if (idx == 0) {
            this.drag(drag);
        }
        if (idx == 1) {
            XpVisualComponent vc = (XpVisualComponent)((XpImageRoiVc)e2.getSource()).getParent();
            if (e2.getX() > vc.getX() && e2.getX() < vc.getWidth() && e2.getY() > vc.getY() && e2.getY() < vc.getHeight()) {
                this.resize(drag);
            } else {
                return;
            }
        }
    }

    public void resize(CPoint drag) {
        double w2 = this.rs.getWidth();
        double h2 = this.rs.getHeight();
        double x2 = this.rs.getX();
        double y2 = this.rs.getY();
        this.setFrame(x2, y2, w2 += drag.x, h2 += drag.y);
        this.firePropertyChange("ROI_MODEL", this);
    }

    public void drag(CPoint drag) {
        double w2 = this.rs.getWidth();
        double h2 = this.rs.getHeight();
        double x2 = this.rs.getX();
        double y2 = this.rs.getY();
        this.setFrame(x2 + drag.x, y2 + drag.y, w2, h2);
        this.firePropertyChange("ROI_MODEL", this);
    }

    @Override
    public void anchorPressed(MouseEvent e2, Object source) {
        int len = this.roiListener.size();
        XpRoiEvent roiEvent = new XpRoiEvent(this);
        roiEvent.setHintMask(0);
        for (int i2 = 0; i2 < len; ++i2) {
            XpRoiEventListener rel = (XpRoiEventListener)this.roiListener.get(i2);
            rel.roiPressed(roiEvent);
        }
    }

    @Override
    public void anchorReleased(MouseEvent e2, Object source) {
        int len = this.roiListener.size();
        XpRoiEvent roiEvent = new XpRoiEvent(this);
        roiEvent.setHintMask(0);
        for (int i2 = 0; i2 < len; ++i2) {
            XpRoiEventListener rel = (XpRoiEventListener)this.roiListener.get(i2);
            rel.roiReleased(roiEvent);
        }
    }

    private void setFrame(double x2, double y2, double w2, double h2) {
        this.rs.setFrame(x2, y2, w2, h2);
        this.get(0).setLocation(x2, y2);
        this.get(1).setLocation(x2 + w2, y2 + h2);
    }

    public void setDisplayBorder(boolean displayborder_) {
        this.displayborder = displayborder_;
    }

    public boolean isBorderDisplayed() {
        return this.displayborder;
    }

    @Override
    public final void setSelected(boolean selection) {
        String val;
        if (this.debug) {
            System.out.println("setSelected: " + selection);
        }
        this.selected = selection;
        String string = val = this.selected ? "COMPONENT_SELECTED" : "COMPONENT_UNSELECTED";
        if (this.selected) {
            this.firePropertyChange(val, this);
        }
    }

    @Override
    public boolean isSelected() {
        return this.selected;
    }

    @Override
    public void paintShape(XpVisualComponent vc, Graphics2D g2) {
        Graphics2D g22 = g2;
        CTransform t2 = vc.getTransform((byte)0, (byte)1);
        this.drs.setFrame(this.rs.getFrame());
        if (this.rs.isEmpty()) {
            double h2;
            double x2 = this.rs.getX();
            double y2 = this.rs.getY();
            double w2 = this.rs.getWidth();
            if (w2 < 0.0) {
                x2 += w2;
            }
            if ((h2 = this.rs.getHeight()) < 0.0) {
                y2 += h2;
            }
            this.drs.setFrame(x2, y2, Math.abs(w2), Math.abs(h2));
        }
        PathIterator iterator = this.drs.getPathIterator(null);
        this.gp.reset();
        while (!iterator.isDone()) {
            int segmentType = iterator.currentSegment(this.segment);
            switch (segmentType) {
                case 0: {
                    this.img_pt.set(this.segment[0], this.segment[1], 0.0);
                    t2.transform(this.img_pt, this.display_pta);
                    this.gp.moveTo((float)this.display_pta.x, (float)this.display_pta.y);
                    break;
                }
                case 1: {
                    this.img_pt.set(this.segment[0], this.segment[1], 0.0);
                    t2.transform(this.img_pt, this.display_pta);
                    this.gp.lineTo((float)this.display_pta.x, (float)this.display_pta.y);
                    break;
                }
                case 2: {
                    this.img_pt.set(this.segment[0], this.segment[1], 0.0);
                    t2.transform(this.img_pt, this.display_pta);
                    this.img_pt.set(this.segment[2], this.segment[3], 0.0);
                    t2.transform(this.img_pt, this.display_ptb);
                    this.gp.quadTo((float)this.display_pta.x, (float)this.display_pta.y, (float)this.display_ptb.x, (float)this.display_ptb.y);
                    break;
                }
                case 3: {
                    this.img_pt.set(this.segment[0], this.segment[1], 0.0);
                    t2.transform(this.img_pt, this.display_pta);
                    this.img_pt.set(this.segment[2], this.segment[3], 0.0);
                    t2.transform(this.img_pt, this.display_ptb);
                    this.img_pt.set(this.segment[4], this.segment[5], 0.0);
                    t2.transform(this.img_pt, this.display_ptc);
                    this.gp.curveTo((float)this.display_pta.x, (float)this.display_pta.y, (float)this.display_ptb.x, (float)this.display_ptb.y, (float)this.display_ptc.x, (float)this.display_ptc.y);
                    break;
                }
                case 4: {
                    this.gp.closePath();
                }
            }
            iterator.next();
        }
        g22.setColor(this.matteColor);
        Shape cs = g22.getClip();
        Area area = new Area(cs);
        Area a2 = new Area(this.gp);
        area.subtract(a2);
        ((JComponent)vc.getParent()).getInsets(this.is);
        this.clipRectangle.setBounds(this.is.left, this.is.right, vc.getWidth() - this.is.left - this.is.right, vc.getHeight() - this.is.top - this.is.bottom);
        g22.clip(this.clipRectangle);
        g22.clip(area);
        g22.fillRect(0, 0, vc.getWidth(), vc.getHeight());
        g22.setClip(cs);
        if (this.selected) {
            if (this.isBorderDisplayed()) {
                if (this.isGrayScaleMode()) {
                    g2.setColor(Color.WHITE);
                } else {
                    g2.setColor(XpAppContext.getSelectedColor());
                }
            } else {
                g2.setColor(null);
            }
        } else if (this.isBorderDisplayed()) {
            if (this.isGrayScaleMode()) {
                g2.setColor(Color.WHITE);
            } else {
                g2.setColor(XpAppContext.getUnSelectedColor());
            }
        } else {
            g2.setColor(null);
        }
        g22.draw(this.gp);
    }

    @Override
    public boolean containsROI(XpVisualComponent vc, int x2, int y2) {
        return !this.gp.contains(x2, y2);
    }

    @Override
    public final GSPSGraphic gspsDescription() {
        return null;
    }

    @Override
    public void setImage(XpImage image) {
        this.theImage = image;
    }

    @Override
    public XpImage getImage() {
        return this.theImage;
    }

    public Object getRS() {
        return this.rs;
    }

    @Override
    public void roiClicked(MouseEvent e2) {
        System.out.println("WfXpImageMatte.roiClicked()  " + this.isSelected());
        this.setSelected(true);
    }

    @Override
    public void roiPressed(MouseEvent e2) {
        this.pMouse = e2.getPoint();
        int len = this.roiListener.size();
        XpRoiEvent roiEvent = new XpRoiEvent(this);
        roiEvent.setHintMask(0);
        for (int i2 = 0; i2 < len; ++i2) {
            XpRoiEventListener rel = (XpRoiEventListener)this.roiListener.get(i2);
            rel.roiPressed(roiEvent);
        }
    }

    @Override
    public void roiDragged(MouseEvent e2) {
        Object source = e2.getSource();
        if (source instanceof XpVisualComponent) {
            if (this.pMouse != null) {
                this.gu.calcDragVector(e2.getPoint(), this.pMouse, (byte)0, (CTransformCapable)((Object)e2.getComponent()), this._dragV);
                this.drag(this._dragV);
            }
            this.pMouse = e2.getPoint();
        }
    }

    @Override
    public void roiReleased(MouseEvent e2) {
        int len = this.roiListener.size();
        XpRoiEvent roiEvent = new XpRoiEvent(this);
        roiEvent.setHintMask(0);
        for (int i2 = 0; i2 < len; ++i2) {
            XpRoiEventListener rel = (XpRoiEventListener)this.roiListener.get(i2);
            rel.roiReleased(roiEvent);
        }
        this.pMouse = null;
    }

    @Override
    public void addRoiEventListener(XpRoiEventListener rel) {
        this.roiListener.add(rel);
    }

    @Override
    public void removeRoiEventListener(XpRoiEventListener rel) {
        this.roiListener.remove(rel);
    }

    public Color getMatteColor() {
        return this.matteColor;
    }

    public void setMatteColor(Color matteColor) {
        this.matteColor = matteColor;
    }

    private void writeObject(ObjectOutputStream s2) throws IOException {
        try {
            s2.defaultWriteObject();
            if (this.rs instanceof Rectangle2D.Double) {
                s2.writeObject(new String("Rectangle2D.Double"));
                s2.writeDouble(this.rs.getX());
                s2.writeDouble(this.rs.getY());
                s2.writeDouble(this.rs.getWidth());
                s2.writeDouble(this.rs.getHeight());
            } else if (this.rs instanceof Ellipse2D.Double) {
                s2.writeObject(new String("Ellipse2D.Double"));
                s2.writeDouble(this.rs.getX());
                s2.writeDouble(this.rs.getY());
                s2.writeDouble(this.rs.getWidth());
                s2.writeDouble(this.rs.getHeight());
            } else if (this.rs instanceof RoundRectangle2D.Double) {
                s2.writeObject(new String("RoundRectangle2D.Double"));
                RoundRectangle2D.Double rect = (RoundRectangle2D.Double)this.rs;
                s2.writeDouble(rect.getX());
                s2.writeDouble(rect.getY());
                s2.writeDouble(rect.getWidth());
                s2.writeDouble(rect.getHeight());
                s2.writeDouble(rect.getArcHeight());
                s2.writeDouble(rect.getArcWidth());
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    private void readObject(ObjectInputStream s2) throws IOException {
        try {
            s2.defaultReadObject();
            String shape = (String)s2.readObject();
            if (shape.compareTo("Rectangle2D.Double") == 0) {
                Rectangle2D.Double rect = null;
                rect = new Rectangle2D.Double(s2.readDouble(), s2.readDouble(), s2.readDouble(), s2.readDouble());
                this.rs = rect;
            } else if (shape.compareTo("Ellipse2D.Double") == 0) {
                Ellipse2D.Double ellipse = null;
                ellipse = new Ellipse2D.Double(s2.readDouble(), s2.readDouble(), s2.readDouble(), s2.readDouble());
                this.rs = ellipse;
            } else if (shape.compareTo("RoundRectangle2D.Double") == 0) {
                RoundRectangle2D.Double rrect = null;
                rrect = new RoundRectangle2D.Double(s2.readDouble(), s2.readDouble(), s2.readDouble(), s2.readDouble(), s2.readDouble(), s2.readDouble());
                this.rs = rrect;
            }
            this.gp = new GeneralPath();
            this.gu = new XpGeomUtils();
            this.cp = new Point2D.Double();
            this.createHandles();
        }
        catch (ClassNotFoundException ex) {
            ex.printStackTrace();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public final Shape getDisplayClip() {
        throw new UnsupportedOperationException("Matte shape in Display co-ordinate not supported");
    }

    @Override
    public Shape getImageClip() {
        return this.rs;
    }

    @Override
    public boolean isGrayScaleMode() {
        return this.grayscaleMode;
    }

    @Override
    public void setGrayScaleMode(boolean g2) {
        this.grayscaleMode = g2;
    }

    static {
        CvImageMatte.setImgMatteProperties();
        XpHandle.setHandleColor(HANDLE_COLOR);
        XpAppContext.setSelectedColor(SELECTED_COLOR);
        XpAppContext.setUnSelectedColor(UNSELECTED_COLOR);
        XpAppContext.setShadowed(true);
    }
}

