/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.screenbuilder.helper;

import com.ge.med.cse.cvf.idc.ViewTypeCapable;
import com.ge.med.cse.cvf.idc.VolumeDatasetCapable;
import com.ge.med.cse.cvf.j3d.J3DViewport;
import com.ge.med.cse.cvf.screenbuilder.helper.Helper;
import com.ge.med.cse.cvf.util.CvPropertiesManager;
import com.ge.med.idc.Capable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;

public class J3DViewportHelper
implements Helper {
    private static final String VIEWTYPE = ".viewType";
    private static final String SUPPORTED_VIEWTYPE = ".supportedViewTypes";
    private static final String CAPABLE = "Capable";
    private static final Logger logger = Logger.getLogger(J3DViewportHelper.class.getName());
    private J3DViewport viewport = null;

    @Override
    public void config(JComponent port, String portName, Properties prop) throws Exception {
        if (port == null || portName == null || portName == "" || prop == null) {
            logger.log(Level.WARNING, "Either viewport or its name or property is null");
            throw new Exception("Either viewport or its name or property is null");
        }
        String[] supportedViewTypes = prop.getProperty(portName + SUPPORTED_VIEWTYPE).split(",");
        String viewType = prop.getProperty(portName + VIEWTYPE);
        if (port instanceof ViewTypeCapable) {
            ((ViewTypeCapable)((Object)port)).setSupportedViewTypes(supportedViewTypes);
            ((ViewTypeCapable)((Object)port)).setViewType(viewType);
        }
        if (port instanceof J3DViewport) {
            this.viewport = (J3DViewport)port;
            int capableCount = Integer.parseInt(CvPropertiesManager.getProperty(CAPABLE, "0"));
            for (int j2 = 0; j2 < capableCount; ++j2) {
                String capableKeyVal = CvPropertiesManager.getProperty("Capable." + j2);
                Capable capable = this.createInstance(capableKeyVal);
                if (capable != null) {
                    this.viewport.setCapable(VolumeDatasetCapable.class.getName(), capable);
                    continue;
                }
                logger.log(Level.INFO, "Capable " + capableKeyVal + " is null.");
            }
        }
    }

    private Capable createInstance(String className) {
        Capable capable = null;
        try {
            Class<?> capableClass = Class.forName(className);
            Constructor<?> capableCons = capableClass.getConstructor(J3DViewport.class);
            capable = (Capable)capableCons.newInstance(this.viewport);
        }
        catch (ClassNotFoundException e2) {
            logger.log(Level.WARNING, "Class " + className + " is not found." + e2.getLocalizedMessage());
        }
        catch (IllegalArgumentException e3) {
            logger.log(Level.WARNING, "Illegal arguments passed for creating Class " + className + " " + e3.getLocalizedMessage());
        }
        catch (InstantiationException e4) {
            logger.log(Level.WARNING, "Unable to instantiate Class " + className + " " + e4.getLocalizedMessage());
        }
        catch (IllegalAccessException e5) {
            logger.log(Level.WARNING, "Illegal access to constructor of Class " + className + " " + e5.getLocalizedMessage());
        }
        catch (InvocationTargetException e6) {
            logger.log(Level.WARNING, "Unable to invoke constructor of Class " + className + " " + e6.getLocalizedMessage());
        }
        catch (SecurityException e7) {
            logger.log(Level.WARNING, "Illegal access to constructor of Class " + className + " " + e7.getLocalizedMessage());
        }
        catch (NoSuchMethodException e8) {
            logger.log(Level.WARNING, "Unable to find constructor of Class " + className + " " + e8.getLocalizedMessage());
        }
        return capable;
    }
}

