/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.textpage;

import com.ge.med.cse.cvf.textpage.ROIElement;
import java.text.DecimalFormat;
import javax.swing.table.AbstractTableModel;

public class ROITableModel
extends AbstractTableModel {
    private String[] columnLabels;
    ROIElement[] roiEleElements;
    private static final DecimalFormat rasf = new DecimalFormat("###0.00");

    ROITableModel(String[] colDetails, ROIElement[] roieleElements) {
        this.columnLabels = colDetails;
        this.roiEleElements = roieleElements;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        String returnValue = "";
        ROIElement element = this.roiEleElements[rowIndex];
        switch (columnIndex) {
            case 0: {
                returnValue = element.R;
                break;
            }
            case 1: {
                if (element.Mean == 0.0) {
                    returnValue = "";
                    break;
                }
                returnValue = Double.toString(ROITableModel.getRoundedValue(element.Mean));
                break;
            }
            case 2: {
                if (element.Sdv == 0.0) {
                    returnValue = "";
                    break;
                }
                returnValue = Double.toString(ROITableModel.getRoundedValue(element.Sdv));
                break;
            }
            case 3: {
                if (element.MinPxl < 0.0) {
                    returnValue = "";
                    break;
                }
                returnValue = Double.toString(ROITableModel.getRoundedValue(element.MinPxl));
                break;
            }
            case 4: {
                if (element.MaxPxl < 0.0) {
                    returnValue = "";
                    break;
                }
                returnValue = Double.toString(ROITableModel.getRoundedValue(element.MaxPxl));
                break;
            }
            case 5: {
                returnValue = element.Center;
                break;
            }
            case 6: {
                returnValue = element.Dim;
                break;
            }
            case 7: {
                if (element.Area == 0.0) {
                    returnValue = "";
                    break;
                }
                returnValue = rasf.format(element.Area);
                break;
            }
            case 8: {
                returnValue = Double.toString(ROITableModel.getRoundedValue(element.Ang));
                break;
            }
            case 9: {
                returnValue = element.Pxls == 0 ? "" : Integer.toString(element.Pxls);
            }
        }
        return returnValue;
    }

    public static double getRoundedValue(double toRound) {
        if (toRound > -1.0 && toRound < 1.0) {
            return (double)Math.round(toRound * Math.pow(10.0, 4.0)) / Math.pow(10.0, 4.0);
        }
        return (double)Math.round(toRound * Math.pow(10.0, 1.0)) / Math.pow(10.0, 1.0);
    }

    @Override
    public String getColumnName(int columnIndex) {
        return this.columnLabels[columnIndex];
    }

    @Override
    public int getColumnCount() {
        return this.columnLabels.length;
    }

    @Override
    public int getRowCount() {
        return this.roiEleElements.length;
    }
}

