/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.ui;

import com.ge.med.cse.cvf.base.CvSeriesDisplayer;
import com.ge.med.idc.Capable;
import com.ge.med.idc.CineCapable;
import com.ge.med.idc.FramePositioningCapable;
import com.ge.med.terra.xpv.onport.XPopPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.swing.BoundedRangeModel;
import javax.swing.JSlider;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class XpOnportPagingSlider
extends XPopPanel
implements ActionListener {
    public static final String NO_SKIP_MODE = "NO_SKIP_MODE";
    public static final String SCROLL_VALUE = "SCROLL_VALUE";
    public FramePositioningCapable port;
    private PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    boolean enabled = true;
    Timer adjustScrollBar = new Timer(100, this);
    JSlider frameCtl = new JSlider();
    private PropertyChangeListener viewPortListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName() == "FrameIndex") {
                XpOnportPagingSlider.this.updateSlider();
            }
        }
    };

    public XpOnportPagingSlider() {
        this.setName("XP_POP_SLIDER");
        try {
            this.jbInit();
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        this.adjustScrollBar.setRepeats(false);
        this.setStayOnMouseEnter(true);
    }

    private void jbInit() throws Exception {
        this.setLayout(new BorderLayout());
        this.frameCtl.setName("XP_Slider");
        this.frameCtl.setOrientation(1);
        this.frameCtl.setOpaque(false);
        this.add((Component)this.frameCtl, "Center");
        this.setPreferredSize(new Dimension(30, 300));
        this.setMinimumSize(new Dimension(20, 150));
        this.setOpaque(false);
        this.frameCtl.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e2) {
                if (e2.getSource() == XpOnportPagingSlider.this.frameCtl) {
                    XpOnportPagingSlider.this.updatePort();
                }
            }
        });
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.enabled = enabled;
    }

    @Override
    public void fire() {
        if (this.enabled) {
            super.fire();
        }
    }

    @Override
    public final void removePropertyChangeListener(String propName, PropertyChangeListener pcl) {
        this.pcs.removePropertyChangeListener(propName, pcl);
    }

    @Override
    public final void addPropertyChangeListener(String propName, PropertyChangeListener pcl) {
        this.pcs.addPropertyChangeListener(propName, pcl);
    }

    @Override
    public void setCapable(Capable capable) {
        CineCapable cine;
        if (capable instanceof FramePositioningCapable) {
            this.port = (FramePositioningCapable)capable;
            this.updateSlider();
            this.port.addPropertyChangeListener(this.viewPortListener);
        }
        if ((cine = (CineCapable)capable.getCapable("com.ge.med.idc.CineCapable")) != null) {
            cine.addPropertyChangeListener("Cine", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    XpOnportPagingSlider.this.setEnabled((Boolean)evt.getNewValue() == false);
                }
            });
        }
    }

    public void updateSlider() {
        if (this.port == null) {
            return;
        }
        int n2 = this.port.getNumFrames();
        BoundedRangeModel model = this.frameCtl.getModel();
        int newSliderValue = n2 - this.port.getFrameIndex();
        this.frameCtl.getModel().setRangeProperties(newSliderValue, 0, 1, n2, model.getValueIsAdjusting());
    }

    public void updatePort() {
        int id = this.port.getNumFrames() - this.frameCtl.getValue();
        if (id != this.port.getFrameIndex()) {
            this.port.setFrameIndex(id);
        }
    }

    @Override
    public boolean isSupported(Capable capable) {
        return capable instanceof FramePositioningCapable && capable instanceof CvSeriesDisplayer;
    }

    @Override
    public void actionPerformed(ActionEvent e2) {
        this.updateSlider();
        this.adjustScrollBar.stop();
        this.frameCtl.updateUI();
    }
}

