/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.util;

import com.ge.med.cse.cvf.util.CvDSAImageUtils;
import com.ge.med.cse.cvf.util.CvPropertiesManager;
import com.ge.med.cse.cvf.util.DSAImageOp;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferUShort;
import java.awt.image.RenderedImage;

public class AvgSubDSAImageOp
extends DSAImageOp {
    private int frameIndex = -1;
    public static final int DSA_MASK_PORTION_FRACTIONAL_BITS = 8;
    private static int frameOffset = Integer.parseInt(CvPropertiesManager.getProperty("cvf.dsa.frameoffset", "240"));
    private static double dsaLandmark = Double.parseDouble(CvPropertiesManager.getProperty("cvf.dsa.landmark", "0.625"));

    public AvgSubDSAImageOp(CvDSAImageUtils.MaskItem mask) {
        this(mask, -1);
    }

    public AvgSubDSAImageOp(CvDSAImageUtils.MaskItem mask, int frameIndex) {
        super(mask);
        this.frameIndex = frameIndex;
    }

    @Override
    public void execute(RenderedImage input, RenderedImage output) {
        CvDSAImageUtils.MaskItem mask = this.getMaskItem();
        BufferedImage res = (BufferedImage)input;
        if (this.frameIndex >= 0 && mask instanceof CvDSAImageUtils.AvgSubMaskItem && ((CvDSAImageUtils.AvgSubMaskItem)mask).getContrastFrameAveraging() > 1) {
            CvDSAImageUtils.AvgSubMaskItem avgmask = (CvDSAImageUtils.AvgSubMaskItem)mask;
            int cframes = avgmask.getContrastFrameAveraging();
            BufferedImage[] imgs = new BufferedImage[cframes];
            imgs[0] = (BufferedImage)input;
            int ctr = 1;
            for (int i2 = this.frameIndex + 1; i2 < this.frameIndex + cframes; ++i2) {
                imgs[ctr++] = avgmask.getContrastFrame(i2 + 1);
            }
            res = CvDSAImageUtils.average(imgs, null);
        }
        if (res != null) {
            short[] idata = ((DataBufferUShort)res.getData().getDataBuffer()).getData();
            short[] odata = ((DataBufferUShort)((BufferedImage)output).getRaster().getDataBuffer()).getData();
            short[] mdata = ((DataBufferUShort)mask.getMask().getData().getDataBuffer()).getData();
            this.weightedMaskSubtraction(idata, mdata, odata);
        }
    }

    @Override
    public String getImageOpName() {
        return "DSA_AVG_SUB";
    }

    public static final void setContrastFrameOffset(int offset) {
        if (offset < 0 || offset > Short.MAX_VALUE) {
            return;
        }
        frameOffset = offset;
    }

    public static final int getContrastFrameOffset() {
        return frameOffset;
    }

    public static final void setMaskFrameLandmark(double landmark) {
        if (landmark < 0.0 || landmark > 1.0) {
            return;
        }
        dsaLandmark = landmark;
    }

    public static final double getMaskFrameLandmark() {
        return dsaLandmark;
    }

    private void weightedMaskSubtraction(short[] idata, short[] mdata, short[] odata) {
        int maskPortionMultiplier = (int)(256.0 * dsaLandmark);
        int result = 0;
        int frameDataLcl = 0;
        int maskDataLcl = 0;
        for (int i2 = 0; i2 < idata.length; ++i2) {
            frameDataLcl = idata[i2] & 0xFFFF;
            maskDataLcl = mdata[i2] & 0xFFFF;
            maskDataLcl *= maskPortionMultiplier;
            result = (frameDataLcl += frameOffset) - (maskDataLcl >>= 8);
            if (result > Short.MAX_VALUE) {
                result = Short.MAX_VALUE;
            } else if (result < 0) {
                result = 0;
            }
            odata[i2] = (short)result;
        }
    }

    private void logMaskSubtraction(short[] idata, short[] mdata, short[] odata) {
        double newmax;
        double logMaks = 0.0;
        double logFrame = 0.0;
        int size = idata.length;
        double[] logdiffresult = new double[size];
        double maxdiff = Double.MIN_VALUE;
        double mindiff = Double.MIN_VALUE;
        double oldrange = 0.0;
        for (int i2 = 0; i2 < size; ++i2) {
            logMaks = Math.log(mdata[i2]);
            logFrame = Math.log(idata[i2]);
            logdiffresult[i2] = logFrame - 0.625 * logMaks;
            if (logdiffresult[i2] > maxdiff) {
                maxdiff = logdiffresult[i2];
            }
            if (!(logdiffresult[i2] < mindiff)) continue;
            mindiff = logdiffresult[i2];
        }
        oldrange = maxdiff - mindiff;
        double newrange = newmax = Math.log(2047.0);
        double scale = 0.0;
        for (int i3 = 0; i3 < size; ++i3) {
            scale = (logdiffresult[i3] - mindiff) / oldrange;
            logdiffresult[i3] = newrange * scale;
            odata[i3] = (short)Math.exp(logdiffresult[i3]);
        }
    }
}

